/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.dataviewers.charts.view;

import org.eclipse.birt.chart.model.Chart;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.linuxtools.dataviewers.charts.Activator;
import org.eclipse.linuxtools.dataviewers.charts.actions.SaveChartAction;
import org.eclipse.linuxtools.dataviewers.charts.actions.SaveXMLAction;
import org.eclipse.linuxtools.dataviewers.charts.viewer.ChartViewer;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class ChartView
extends ViewPart {
    public static final String VIEW_ID = "org.eclipse.linuxtools.dataviewers.charts.view";
    private static Integer SEC_ID = 0;
    private Canvas paintCanvas;
    private ChartViewer chartViewer;
    private SaveChartAction saveChartAction;
    private SaveXMLAction saveXMLAction;

    public static void createChartView(final Chart chart) {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Integer n = SEC_ID;
                    synchronized (n) {
                        IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        StringBuilder stringBuilder = new StringBuilder();
                        Integer n2 = SEC_ID;
                        SEC_ID = n2 + 1;
                        ChartView view = (ChartView)iWorkbenchPage.showView(ChartView.VIEW_ID, stringBuilder.append(n2).toString(), 1);
                        view.setChart(chart);
                    }
                }
                catch (PartInitException e) {
                    Status s = new Status(4, "org.eclipse.linuxtools.dataviewers.charts", 4, e.getMessage(), (Throwable)e);
                    Activator.getDefault().getLog().log((IStatus)s);
                }
            }
        });
    }

    public void createPartControl(Composite parent) {
        try {
            this.paintCanvas = new Canvas(parent, 0);
            this.paintCanvas.setLayoutData((Object)new GridData(1808));
            this.paintCanvas.setBackground(Display.getDefault().getSystemColor(1));
            this.chartViewer = new ChartViewer();
            this.paintCanvas.addPaintListener((PaintListener)this.chartViewer);
            this.paintCanvas.addControlListener((ControlListener)this.chartViewer);
            this.chartViewer.setViewer(this.paintCanvas);
            this.createActions(parent);
            IActionBars actionBars = this.getViewSite().getActionBars();
            this.initToolBar(actionBars.getToolBarManager());
        }
        catch (Throwable _) {
            Status s = new Status(4, "org.eclipse.linuxtools.dataviewers.charts", 4, "Error when creating AWT Frame...", _);
            Activator.getDefault().getLog().log((IStatus)s);
        }
    }

    protected void createActions(Composite parent) {
        this.saveChartAction = new SaveChartAction(this.getViewSite().getShell(), this);
        this.saveXMLAction = new SaveXMLAction(parent);
    }

    protected void initToolBar(IToolBarManager manager) {
        manager.add((IAction)this.saveChartAction);
        manager.add((IAction)this.saveXMLAction);
        manager.update(true);
    }

    public void setFocus() {
        if (this.paintCanvas != null) {
            this.paintCanvas.setFocus();
        } else {
            Status s = new Status(4, "org.eclipse.linuxtools.dataviewers.charts", "Error setting the focus to the chart view: main composite is not set!");
            Activator.getDefault().getLog().log((IStatus)s);
        }
    }

    public void closeView() {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().hideView((IViewPart)ChartView.this);
            }
        });
    }

    public void setChart(Chart chart) {
        if (chart != null) {
            this.chartViewer.renderModel(chart);
            this.saveChartAction.setChart(chart);
            this.saveChartAction.setBounds(this.chartViewer.getBounds());
            this.saveXMLAction.setChart(chart);
        } else {
            this.saveChartAction.setEnabled(false);
            Status s = new Status(4, "org.eclipse.linuxtools.dataviewers.charts", "Error adding the chart to the chart view: SWT is not set!");
            Activator.getDefault().getLog().log((IStatus)s);
        }
    }

    public ChartViewer getChartViewer() {
        return this.chartViewer;
    }

    public void setChartViewer(ChartViewer cv) {
        this.chartViewer = cv;
    }

    public void dispose() {
        super.dispose();
    }
}

