/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.ui.views.latency.model;

import java.util.Arrays;
import org.eclipse.linuxtools.tmf.ui.views.distribution.model.BaseDistributionData;

public class GraphScaledData {
    private int fWidth;
    private int fHeight;
    private int fBarWidth;
    private int[][] fData;
    private BaseDistributionData fHorDistributionData;
    private BaseDistributionData fVerDistributionData;
    private long fCurrentEventTime;

    public GraphScaledData(int width, int height, int barWidth) {
        this.fWidth = width;
        this.fHeight = height;
        this.fBarWidth = barWidth;
        int horNbBuckets = width / barWidth;
        int verNbBuckets = height / barWidth;
        int[][] nArray = this.fData = new int[horNbBuckets][verNbBuckets];
        int n = this.fData.length;
        int n2 = 0;
        while (n2 < n) {
            int[] row = nArray[n2];
            Arrays.fill(row, 0);
            ++n2;
        }
        this.fHorDistributionData = new BaseDistributionData(horNbBuckets);
        this.fHorDistributionData.clear();
        this.fVerDistributionData = new BaseDistributionData(verNbBuckets);
        this.fVerDistributionData.clear();
        this.fCurrentEventTime = -1L;
    }

    public int getWidth() {
        return this.fWidth;
    }

    public int getHeight() {
        return this.fHeight;
    }

    public int getBarWidth() {
        return this.fBarWidth;
    }

    public int[][] getData() {
        return this.fData;
    }

    public int getHorNbBuckets() {
        return this.fHorDistributionData.getNbBuckets();
    }

    public int getVerNbBuckets() {
        return this.fVerDistributionData.getNbBuckets();
    }

    public long getHorFirstBucketTime() {
        return this.fHorDistributionData.getFirstBucketTime();
    }

    public long getVerFirstBucketTime() {
        return this.fVerDistributionData.getFirstBucketTime();
    }

    public long getHorLastBucketTime() {
        return this.fHorDistributionData.getLastBucketTime();
    }

    public long getVerLastBucketTime() {
        return this.fVerDistributionData.getLastBucketTime();
    }

    public long getHorFirstEventTime() {
        return this.fHorDistributionData.getFirstEventTime();
    }

    public long getVerFirstEventTime() {
        return this.fVerDistributionData.getFirstEventTime();
    }

    public long getHorLastEventTime() {
        return this.fHorDistributionData.getLastEventTime();
    }

    public long getVerLastEventTime() {
        return this.fVerDistributionData.getLastEventTime();
    }

    public long getHorBucketDuration() {
        return this.fHorDistributionData.getBucketDuration();
    }

    public long getVerBucketDuration() {
        return this.fVerDistributionData.getBucketDuration();
    }

    public int getHorLastBucket() {
        return this.fHorDistributionData.getLastBucket();
    }

    public int getVerLastBucket() {
        return this.fVerDistributionData.getLastBucket();
    }

    public long getHorBucketStartTime(int index) {
        return this.fHorDistributionData.getBucketStartTime(index);
    }

    public long getHorBucketEndTime(int index) {
        return this.fHorDistributionData.getBucketEndTime(index);
    }

    public long getVerBucketStartTime(int index) {
        return this.fVerDistributionData.getBucketStartTime(index);
    }

    public long getVerBucketEndTime(int index) {
        return this.fVerDistributionData.getBucketEndTime(index);
    }

    public int getEventCount(int horIndex, int verIndex) {
        return this.fData[horIndex][verIndex];
    }

    public long getCurrentEventTime() {
        return this.fCurrentEventTime;
    }

    public boolean isCurrentEventTimeValid() {
        return this.fCurrentEventTime != -1L && this.fCurrentEventTime >= this.getHorFirstEventTime() && this.fCurrentEventTime <= this.getHorLastEventTime();
    }

    public int getHorBucketIndex(long time) {
        return this.fHorDistributionData.getIndex(time);
    }

    public int getVerBucketIndex(long time) {
        return this.fVerDistributionData.getIndex(time);
    }

    public boolean isHorIndexValid(int index) {
        return this.fHorDistributionData.isIndexValid(index);
    }

    public boolean isVerIndexValid(int index) {
        return this.fVerDistributionData.isIndexValid(index);
    }

    public void setWidth(int width) {
        this.fWidth = width;
    }

    public void setHeight(int height) {
        this.fHeight = height;
    }

    public void setBarWidth(int barWidth) {
        this.fBarWidth = barWidth;
    }

    public void setData(int[][] data) {
        this.fData = data;
    }

    public void setHorFirstBucketTime(long firstBucketTime) {
        this.fHorDistributionData.setFirstBucketTime(firstBucketTime);
    }

    public void setVerFirstBucketTime(long firstBucketTime) {
        this.fVerDistributionData.setFirstBucketTime(firstBucketTime);
    }

    public void setHorFirstEventTime(long firstEventTime) {
        this.fHorDistributionData.setFirstEventTime(firstEventTime);
    }

    public void setVerFirstEventTime(long firstEventTime) {
        this.fVerDistributionData.setFirstEventTime(firstEventTime);
    }

    public void setHorLastEventTime(long lastEventTime) {
        this.fHorDistributionData.setLastEventTime(lastEventTime);
    }

    public void setVerLastEventTime(long lastEventTime) {
        this.fVerDistributionData.setLastEventTime(lastEventTime);
    }

    public void setHorBucketDuration(long bucketDuration) {
        this.fHorDistributionData.setBucketDuration(bucketDuration);
    }

    public void setVerBucketDuration(long bucketDuration) {
        this.fVerDistributionData.setBucketDuration(bucketDuration);
    }

    public void setHorLastBucket(int lastBucket) {
        this.fHorDistributionData.setLastBucket(lastBucket);
    }

    public void setVerLastBucket(int lastBucket) {
        this.fVerDistributionData.setLastBucket(lastBucket);
    }

    public void setCurrentEventTime(long currentEventTime) {
        this.fCurrentEventTime = currentEventTime;
    }
}

