/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.cdt.autotools.ui.editors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.linuxtools.cdt.autotools.core.AutotoolsPlugin;
import org.eclipse.linuxtools.cdt.autotools.ui.editors.AutoconfEditor;
import org.eclipse.linuxtools.cdt.autotools.ui.editors.AutoconfIdentifierRule;
import org.eclipse.linuxtools.cdt.autotools.ui.editors.AutoconfM4WordDetector;
import org.eclipse.linuxtools.cdt.autotools.ui.editors.AutoconfMacroRule;
import org.eclipse.linuxtools.cdt.autotools.ui.editors.AutoconfMacroWordDetector;
import org.eclipse.linuxtools.cdt.autotools.ui.editors.AutoconfWhitespaceDetector;
import org.eclipse.linuxtools.cdt.autotools.ui.editors.AutoconfWordDetector;
import org.eclipse.linuxtools.cdt.autotools.ui.editors.InlineDataRule;
import org.eclipse.linuxtools.cdt.autotools.ui.editors.RecursiveSingleLineRule;
import org.eclipse.linuxtools.cdt.autotools.ui.editors.RestrictedEndOfLineRule;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.preferences.ColorManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public class AutoconfMacroCodeScanner
extends RuleBasedScanner {
    private Map<String, IToken> fTokenMap = new HashMap<String, IToken>();
    private String[] fPropertyNamesColor;
    private int quoteLevel;
    private String[] fPropertyNamesBold;
    private String[] fPropertyNamesItalic;
    private static String[] keywords = new String[]{"case", "do", "done", "esac", "if", "elif", "else", "fi", "for", "in", "then"};
    static final String[] fTokenProperties = new String[]{"org.eclipse.linuxtools.cdt.autotools.ui.autoconf.editor.comment", "org.eclipse.linuxtools.cdt.autotools.ui.autoconf.editor.keyword", "org.eclipse.linuxtools.cdt.autotools.ui.autoconf.editor.acmacro", "org.eclipse.linuxtools.cdt.autotools.ui.autoconf.editor.ammacro", "org.eclipse.linuxtools.cdt.autotools.ui.autoconf.editor.var_ref", "org.eclipse.linuxtools.cdt.autotools.ui.autoconf.editor.var_set", "org.eclipse.linuxtools.cdt.autotools.ui.autoconf.editor.codeseq", "org.eclipse.linuxtools.cdt.autotools.ui.autoconf.editor.default"};

    public AutoconfMacroCodeScanner() {
        this.initialize();
        Token other = this.getToken("org.eclipse.linuxtools.cdt.autotools.ui.autoconf.editor.default");
        Token keyword = this.getToken("org.eclipse.linuxtools.cdt.autotools.ui.autoconf.editor.keyword");
        Token comment = this.getToken("org.eclipse.linuxtools.cdt.autotools.ui.autoconf.editor.comment");
        Token string = this.getToken("org.eclipse.linuxtools.cdt.autotools.ui.autoconf.editor.default");
        Token varRef = this.getToken("org.eclipse.linuxtools.cdt.autotools.ui.autoconf.editor.var_ref");
        Token acmacro = this.getToken("org.eclipse.linuxtools.cdt.autotools.ui.autoconf.editor.acmacro");
        Token ammacro = this.getToken("org.eclipse.linuxtools.cdt.autotools.ui.autoconf.editor.ammacro");
        Token code = this.getToken("org.eclipse.linuxtools.cdt.autotools.ui.autoconf.editor.codeseq");
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add((Object)new RestrictedEndOfLineRule("dnl", "[]", (IToken)comment));
        rules.add((Object)new RestrictedEndOfLineRule("#", "[]", (IToken)comment, '\\'));
        RecursiveSingleLineRule stringRule = new RecursiveSingleLineRule("\"", "\"", (IToken)string, '\\');
        stringRule.addRule(new SingleLineRule("${", "}", (IToken)varRef));
        rules.add((Object)stringRule);
        rules.add(new SingleLineRule("${", "}", (IToken)varRef));
        rules.add(new SingleLineRule("\"", "\"", (IToken)string, '\\'));
        rules.add(new AutoconfMacroRule("AC_", new AutoconfMacroWordDetector(), (IToken)acmacro));
        rules.add(new AutoconfMacroRule("AM_", new AutoconfMacroWordDetector(), (IToken)ammacro));
        rules.add(new AutoconfMacroRule("m4_", new AutoconfM4WordDetector(), (IToken)acmacro));
        rules.add(new InlineDataRule((IToken)code));
        WordRule wordRule = new WordRule((IWordDetector)new AutoconfWordDetector(), (IToken)other);
        int i = 0;
        while (i < keywords.length) {
            wordRule.addWord(keywords[i], (IToken)keyword);
            ++i;
        }
        rules.add(wordRule);
        rules.add(new AutoconfIdentifierRule((IToken)other));
        rules.add(new SingleLineRule("\\#", null, Token.UNDEFINED));
        rules.add(new WhitespaceRule((IWhitespaceDetector)new AutoconfWhitespaceDetector()));
        IRule[] result = new IRule[rules.size()];
        rules.toArray(result);
        this.setRules(result);
    }

    public IToken nextToken() {
        int ch = this.read();
        if (ch == 91) {
            this.incQuoteLevel();
            return this.getToken("org.eclipse.linuxtools.cdt.autotools.ui.autoconf.editor.default");
        }
        if (ch == 93) {
            this.decQuoteLevel();
            return this.getToken("org.eclipse.linuxtools.cdt.autotools.ui.autoconf.editor.default");
        }
        this.unread();
        return super.nextToken();
    }

    protected Token getToken(String key) {
        return (Token)this.fTokenMap.get(key);
    }

    private void addToken(String colorKey, String boldKey, String italicKey) {
        this.fTokenMap.put(colorKey, (IToken)new Token((Object)this.createTextAttribute(colorKey, boldKey, italicKey)));
    }

    protected String[] getTokenProperties() {
        return fTokenProperties;
    }

    private int indexOf(String property) {
        if (property != null) {
            int length = this.fPropertyNamesColor.length;
            int i = 0;
            while (i < length) {
                if (property.equals(this.fPropertyNamesColor[i]) || property.equals(this.fPropertyNamesBold[i]) || property.equals(this.fPropertyNamesItalic[i])) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public void incQuoteLevel() {
        ++this.quoteLevel;
    }

    public void decQuoteLevel() {
        --this.quoteLevel;
    }

    public void resetQuoteLevel() {
        this.quoteLevel = 0;
    }

    public int getQuoteLevel() {
        return this.quoteLevel;
    }

    public boolean affectsBehavior(PropertyChangeEvent event) {
        return this.indexOf(event.getProperty()) >= 0;
    }

    public void adaptToPreferenceChange(PropertyChangeEvent event) {
        String p = event.getProperty();
        int index = this.indexOf(p);
        Token token = this.getToken(this.fPropertyNamesColor[index]);
        if (this.fPropertyNamesColor[index].equals(p)) {
            this.adaptToColorChange(event, token);
        } else if (this.fPropertyNamesBold[index].equals(p)) {
            this.adaptToStyleChange(event, token, 1);
        } else if (this.fPropertyNamesItalic[index].equals(p)) {
            this.adaptToStyleChange(event, token, 2);
        }
    }

    protected void adaptToColorChange(PropertyChangeEvent event, Token token) {
        RGB rgb = null;
        Object value = event.getNewValue();
        if (value instanceof RGB) {
            rgb = (RGB)value;
        } else if (value instanceof String) {
            rgb = StringConverter.asRGB((String)((String)value));
        }
        if (rgb != null) {
            TextAttribute attr = (TextAttribute)token.getData();
            token.setData((Object)new TextAttribute(ColorManager.getDefault().getColor(rgb), attr.getBackground(), attr.getStyle()));
        }
    }

    protected void adaptToStyleChange(PropertyChangeEvent event, Token token, int styleAttribute) {
        boolean activeValue;
        if (token == null) {
            return;
        }
        boolean eventValue = false;
        Object value = event.getNewValue();
        if (value instanceof Boolean) {
            eventValue = (Boolean)value;
        } else if ("true".equals(value)) {
            eventValue = true;
        }
        TextAttribute attr = (TextAttribute)token.getData();
        boolean bl = activeValue = (attr.getStyle() & styleAttribute) == styleAttribute;
        if (activeValue != eventValue) {
            token.setData((Object)new TextAttribute(attr.getForeground(), attr.getBackground(), eventValue ? attr.getStyle() | styleAttribute : attr.getStyle() & ~styleAttribute));
        }
    }

    protected TextAttribute createTextAttribute(String colorID, String boldKey, String italicKey) {
        IPreferenceStore store;
        int style;
        Color color = null;
        if (colorID != null) {
            color = AutoconfEditor.getPreferenceColor(colorID);
        }
        int n = style = (store = AutotoolsPlugin.getDefault().getPreferenceStore()).getBoolean(boldKey) ? 1 : 0;
        if (store.getBoolean(italicKey)) {
            style |= 2;
        }
        return new TextAttribute(color, null, style);
    }

    public final void initialize() {
        this.resetQuoteLevel();
        this.fPropertyNamesColor = this.getTokenProperties();
        int length = this.fPropertyNamesColor.length;
        this.fPropertyNamesBold = new String[length];
        this.fPropertyNamesItalic = new String[length];
        int i = 0;
        while (i < length) {
            this.fPropertyNamesBold[i] = String.valueOf(this.fPropertyNamesColor[i]) + "_bold";
            this.fPropertyNamesItalic[i] = String.valueOf(this.fPropertyNamesColor[i]) + "_italic";
            this.addToken(this.fPropertyNamesColor[i], this.fPropertyNamesBold[i], this.fPropertyNamesItalic[i]);
            ++i;
        }
    }

    public void unread() {
        --this.fOffset;
        this.fColumn = -1;
    }
}

