/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.ui.tracecontrol.model;

import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.linuxtools.lttng.core.tracecontrol.model.TraceResource;
import org.eclipse.linuxtools.lttng.ui.LTTngUiPlugin;
import org.eclipse.linuxtools.lttng.ui.tracecontrol.Messages;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.ui.SystemMenuManager;
import org.eclipse.rse.ui.view.AbstractSystemViewAdapter;
import org.eclipse.rse.ui.view.ISystemRemoteElementAdapter;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class TraceResourceAdapter
extends AbstractSystemViewAdapter
implements ISystemRemoteElementAdapter {
    public void addActions(SystemMenuManager menu, IStructuredSelection selection, Shell parent, String menuGroup) {
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return LTTngUiPlugin.getDefault().getImageDescriptor("ICON_ID_TRACE");
    }

    public String getText(Object element) {
        return ((TraceResource)element).getName();
    }

    public String getAbsoluteName(Object object) {
        TraceResource tar = (TraceResource)object;
        return tar.getName();
    }

    public String getType(Object element) {
        return Messages.Lttng_Resource_Trace;
    }

    public Object getParent(Object object) {
        return ((TraceResource)object).getParent();
    }

    public Object[] getChildren(IAdaptable element, IProgressMonitor monitor) {
        return null;
    }

    protected IPropertyDescriptor[] internalGetPropertyDescriptors() {
        TraceResource trace = (TraceResource)this.propertySourceInput;
        Map properties = trace.getPropertyInfo();
        PropertyDescriptor[] propertyDescriptors = new PropertyDescriptor[properties.size()];
        Set keys = properties.keySet();
        int i = 0;
        for (String key : keys) {
            TraceResource.PropertyInfo info = (TraceResource.PropertyInfo)properties.get(key);
            propertyDescriptors[i++] = TraceResourceAdapter.createSimplePropertyDescriptor((String)key, (String)info.getName(), (String)info.getDescription());
        }
        return propertyDescriptors;
    }

    protected Object internalGetPropertyValue(Object key) {
        TraceResource trace = (TraceResource)this.propertySourceInput;
        return trace.getProperty((String)key);
    }

    public boolean showDelete(Object element) {
        return false;
    }

    public boolean showRefresh(Object element) {
        return false;
    }

    public boolean showRename(Object element) {
        return false;
    }

    public boolean supportsDeferredQueries(ISubSystem subSys) {
        return false;
    }

    public String getAbsoluteParentName(Object element) {
        return Messages.Lttng_Resource_Root;
    }

    public String getSubSystemConfigurationId(Object element) {
        return "org.eclipse.linuxtools.lttng.rse.subsystems.factory";
    }

    public String getRemoteTypeCategory(Object element) {
        return "traces";
    }

    public String getRemoteType(Object element) {
        return "trace";
    }

    public String getRemoteSubType(Object element) {
        return null;
    }

    public boolean refreshRemoteObject(Object oldElement, Object newElement) {
        TraceResource oldDevr = (TraceResource)oldElement;
        TraceResource newDevr = (TraceResource)newElement;
        newDevr.setName(oldDevr.getName());
        return true;
    }

    public boolean supportsUserDefinedActions(Object object) {
        return true;
    }

    public Object getRemoteParent(Object element, IProgressMonitor monitor) throws Exception {
        return null;
    }

    public String[] getRemoteParentNamesInUse(Object element, IProgressMonitor monitor) throws Exception {
        return null;
    }

    public boolean hasChildren(IAdaptable arg0) {
        return false;
    }

    public boolean testAttribute(Object target, String name, String value) {
        if (target instanceof TraceResource) {
            TraceResource trace = (TraceResource)target;
            if (name.equals("canConfigure") && value.equals("yes")) {
                if (trace.getTraceState() != TraceResource.TraceState.STOPPED) {
                    return true;
                }
            } else if (name.equals("canStart") && value.equals("yes")) {
                if (trace.getTraceState() == TraceResource.TraceState.CONFIGURED || trace.getTraceState() == TraceResource.TraceState.PAUSED) {
                    return true;
                }
            } else if (name.equals("canPause") && value.equals("yes")) {
                if (trace.getTraceState() == TraceResource.TraceState.STARTED) {
                    return true;
                }
            } else if (name.equals("canStop") && value.equals("yes")) {
                if (trace.getTraceState() == TraceResource.TraceState.CREATED || trace.getTraceState() == TraceResource.TraceState.PAUSED || trace.getTraceState() == TraceResource.TraceState.CONFIGURED) {
                    return true;
                }
            } else if (name.equals("canBrowse") && value.equals("yes")) {
                if (trace.getTraceConfig() != null && trace.getTraceConfig().isNetworkTrace() && trace.getTraceState() == TraceResource.TraceState.STOPPED) {
                    return true;
                }
            } else if (name.equals("canDelete") && value.equals("yes")) {
                if (trace.getTraceState() == TraceResource.TraceState.STOPPED) {
                    return true;
                }
            } else if (name.equals("canImport") && value.equals("yes")) {
                if (trace.getTraceState() == TraceResource.TraceState.STOPPED) {
                    return true;
                }
                if (trace.getTraceState() != TraceResource.TraceState.CREATED && trace.getTraceConfig().isNetworkTrace()) {
                    return true;
                }
            }
        }
        return super.testAttribute(target, name, value);
    }
}

