/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.ui.project.dialogs;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.linuxtools.lttng.core.TraceHelper;
import org.eclipse.linuxtools.lttng.ui.project.dialogs.Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;

public class TraceLibraryPathPropertyPage
extends PropertyPage {
    private static final String LTTVTRACEREAD_LOADER_LIBNAME = "lttvtraceread_loader";
    private Button browsePathButton;
    private Text traceLibraryPath;

    protected Control createContents(Composite parent) {
        Composite client = new Composite(parent, 0);
        client.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        client.setLayout((Layout)layout);
        Label label = new Label(client, 0);
        label.setText(Messages.TraceLibraryPath_label);
        this.traceLibraryPath = new Text(client, 2048);
        this.traceLibraryPath.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.traceLibraryPath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TraceLibraryPathPropertyPage.this.setValid(TraceLibraryPathPropertyPage.this.validateInputs());
            }
        });
        this.browsePathButton = new Button(client, 8);
        this.browsePathButton.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.browsePathButton.setText(Messages.TraceLibraryPath_browseBtn);
        this.browsePathButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String dir = new DirectoryDialog(Display.getDefault().getActiveShell()).open();
                if (dir != null) {
                    TraceLibraryPathPropertyPage.this.traceLibraryPath.setText(dir);
                }
            }
        });
        Label noLabel = new Label(client, 0);
        noLabel.setLayoutData((Object)new GridData(131072, 128, false, false));
        Label descTextLabel = new Label(client, 64);
        descTextLabel.setText(Messages.TraceLibraryPathProperty_Message);
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.widthHint = 400;
        gd.horizontalSpan = 2;
        descTextLabel.setLayoutData((Object)gd);
        Label noteBoldLabel = new Label(client, 1);
        noteBoldLabel.setText(Messages.TraceLibraryPath_Note);
        noteBoldLabel.setLayoutData((Object)new GridData(131072, 128, false, false));
        Font font = noteBoldLabel.getFont();
        if (font.getFontData().length > 0) {
            noteBoldLabel.setFont(new Font((Device)client.getDisplay(), font.getFontData()[0].getName(), font.getFontData()[0].getHeight(), 1));
        }
        Label noteTextLabel = new Label(client, 64);
        noteTextLabel.setText(Messages.TraceLibraryPath_Message);
        gd = new GridData(4, 0x1000000, true, false);
        gd.widthHint = 400;
        gd.horizontalSpan = 2;
        noteTextLabel.setLayoutData((Object)gd);
        this.performDefaults();
        return client;
    }

    public boolean validateInputs() {
        String path = this.traceLibraryPath.getText();
        if (path != null && !path.trim().isEmpty()) {
            File file = new File(path);
            if (file.exists() && file.isDirectory()) {
                File loaderLib = new File(path, System.mapLibraryName(LTTVTRACEREAD_LOADER_LIBNAME));
                if (!loaderLib.exists()) {
                    this.setErrorMessage(Messages.TraceLibraryPathWizardPage_TraceLoaderLibrary_notExists);
                    return false;
                }
            } else {
                this.setErrorMessage(Messages.TraceLibraryPathWizardPage_SpecifiedTraceLibraryLocation_notExists);
                return false;
            }
        }
        this.setErrorMessage(null);
        return true;
    }

    protected void performDefaults() {
        String traceLibDir;
        IResource resource = (IResource)this.getElement().getAdapter(IResource.class);
        IProject project = resource.getProject();
        if (project != null && (traceLibDir = TraceHelper.getTraceLibDirFromProject((IProject)project)) != null) {
            this.traceLibraryPath.setText(traceLibDir);
        }
        super.performDefaults();
    }

    public boolean performOk() {
        IResource resource = (IResource)this.getElement().getAdapter(IResource.class);
        IProject project = resource.getProject();
        boolean ok = false;
        if (project != null) {
            String libPath = this.traceLibraryPath.getText();
            ok = libPath == null || libPath.trim().isEmpty() ? TraceHelper.removeProjectPreference((IProject)project, (String)"traceLibraryPath") : TraceHelper.setProjectPreference((IProject)project, (String)"traceLibraryPath", (String)this.traceLibraryPath.getText());
        }
        return ok && super.performOk();
    }
}

