/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.jni;

import java.util.HashMap;
import org.eclipse.linuxtools.lttng.jni.JniMarker;
import org.eclipse.linuxtools.lttng.jni.JniParser;
import org.eclipse.linuxtools.lttng.jni.JniTracefile;
import org.eclipse.linuxtools.lttng.jni.Jni_C_Common;
import org.eclipse.linuxtools.lttng.jni.common.JniTime;
import org.eclipse.linuxtools.lttng.jni.common.Jni_C_Pointer_And_Library_Id;
import org.eclipse.linuxtools.lttng.jni.exception.JniEventException;
import org.eclipse.linuxtools.lttng.jni.exception.JniException;
import org.eclipse.linuxtools.lttng.jni.exception.JniNoSuchEventException;

public abstract class JniEvent
extends Jni_C_Common
implements Comparable<JniEvent> {
    private int eventState = 1;
    private Jni_C_Pointer_And_Library_Id thisEventPtr = new Jni_C_Pointer_And_Library_Id();
    private JniTracefile parentTracefile = null;
    private HashMap<Integer, JniMarker> markersMap = null;
    private Jni_C_Pointer_And_Library_Id tracefilePtr = new Jni_C_Pointer_And_Library_Id();
    private JniTime eventTime = null;

    protected native int ltt_readNextEvent(int var1, long var2);

    protected native int ltt_seekEvent(int var1, long var2, JniTime var4);

    protected native int ltt_positionToFirstEvent(int var1, long var2);

    protected native long ltt_getTracefilePtr(int var1, long var2);

    protected native long ltt_getBlock(int var1, long var2);

    protected native long ltt_getOffset(int var1, long var2);

    protected native long ltt_getCurrentTimestampCounter(int var1, long var2);

    protected native long ltt_getTimestamp(int var1, long var2);

    protected native int ltt_getEventMarkerId(int var1, long var2);

    protected native long ltt_getNanosencondsTime(int var1, long var2);

    protected native void ltt_feedEventTime(int var1, long var2, JniTime var4);

    protected native long ltt_getEventDataSize(int var1, long var2);

    protected native long ltt_getEventSize(int var1, long var2);

    protected native int ltt_getCount(int var1, long var2);

    protected native long ltt_getOverflowNanoSeconds(int var1, long var2);

    protected native void ltt_getDataContent(int var1, long var2, long var4, byte[] var6);

    protected native void ltt_printEvent(int var1, long var2);

    protected JniEvent() {
    }

    public JniEvent(JniEvent oldEvent) {
        this.thisEventPtr = oldEvent.thisEventPtr;
        this.markersMap = oldEvent.markersMap;
        this.parentTracefile = oldEvent.parentTracefile;
        this.eventState = oldEvent.eventState;
        this.tracefilePtr = oldEvent.tracefilePtr;
        this.eventTime = oldEvent.eventTime;
    }

    public JniEvent(Jni_C_Pointer_And_Library_Id newEventPtr, HashMap<Integer, JniMarker> newMarkersMap, JniTracefile newParentTracefile) throws JniException {
        if (newEventPtr.getPointer() == 0L || newMarkersMap == null || newMarkersMap.size() == 0 || newParentTracefile == null) {
            throw new JniEventException("Null or empty value passed to constructor, object is invalid! (JniEvent)");
        }
        this.thisEventPtr = newEventPtr;
        this.tracefilePtr = newParentTracefile.getTracefilePtr();
        this.markersMap = newMarkersMap;
        this.parentTracefile = newParentTracefile;
        this.eventTime = new JniTime();
        this.eventState = this.positionToFirstEvent();
        if (this.eventState != 0) {
            throw new JniNoSuchEventException("Object not populated, unusable. There is probably no event of that type in the trace. (JniEvent)");
        }
        this.populateEventInformation();
    }

    public int readNextEvent() {
        this.eventState = this.ltt_readNextEvent(this.tracefilePtr.getLibraryId(), this.tracefilePtr.getPointer());
        if (this.eventState == 0) {
            this.populateEventInformation();
        }
        return this.eventState;
    }

    public int seekToTime(JniTime seekTime) {
        this.eventState = this.ltt_seekEvent(this.tracefilePtr.getLibraryId(), this.tracefilePtr.getPointer(), seekTime);
        if (this.eventState == 0) {
            this.populateEventInformation();
        }
        return this.eventState;
    }

    public int seekOrFallBack(JniTime seekTime) {
        JniTime oldTime = new JniTime(this.eventTime);
        int returnState = this.seekToTime(seekTime);
        if (returnState == 0) {
            this.populateEventInformation();
        } else {
            this.seekToTime(oldTime);
        }
        return returnState;
    }

    protected int positionToFirstEvent() {
        this.eventState = this.ltt_positionToFirstEvent(this.tracefilePtr.getLibraryId(), this.tracefilePtr.getPointer());
        return this.eventState;
    }

    public JniMarker requestEventMarker() {
        return this.markersMap.get(this.getEventMarkerId());
    }

    public byte[] requestEventContent() {
        byte[] dataContent = new byte[(int)this.getEventDataSize()];
        this.ltt_getDataContent(this.thisEventPtr.getLibraryId(), this.thisEventPtr.getPointer(), this.getEventDataSize(), dataContent);
        return dataContent;
    }

    public String requestEventSource() {
        return "Kernel Core";
    }

    public Object parseFieldById(int fieldId) {
        return JniParser.parseField(this, fieldId);
    }

    public Object parseFieldByName(String fieldName) {
        return JniParser.parseField(this, fieldName);
    }

    public HashMap<String, Object> parseAllFields() {
        return JniParser.parseAllFields(this);
    }

    private void populateEventInformation() {
        this.eventTime.setTime(this.ltt_getNanosencondsTime(this.thisEventPtr.getLibraryId(), this.thisEventPtr.getPointer()));
    }

    public JniTime getEventTime() {
        return this.eventTime;
    }

    public int getEventMarkerId() {
        return this.ltt_getEventMarkerId(this.thisEventPtr.getLibraryId(), this.thisEventPtr.getPointer());
    }

    public long getEventDataSize() {
        return this.ltt_getEventDataSize(this.thisEventPtr.getLibraryId(), this.thisEventPtr.getPointer());
    }

    public HashMap<Integer, JniMarker> getMarkersMap() {
        return this.markersMap;
    }

    public Jni_C_Pointer_And_Library_Id getTracefilePtr() {
        return new Jni_C_Pointer_And_Library_Id(this.thisEventPtr.getLibraryId(), this.ltt_getTracefilePtr(this.thisEventPtr.getLibraryId(), this.thisEventPtr.getPointer()));
    }

    public Jni_C_Pointer_And_Library_Id getEventPtr() {
        return this.thisEventPtr;
    }

    public int getEventState() {
        return this.eventState;
    }

    public JniTracefile getParentTracefile() {
        return this.parentTracefile;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.eventTime == null ? 0 : this.eventTime.hashCode());
        result = 31 * result + (this.parentTracefile == null ? 0 : this.parentTracefile.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JniEvent)) {
            return false;
        }
        JniEvent other = (JniEvent)obj;
        if (this.eventTime == null ? other.eventTime != null : !this.eventTime.equals(other.eventTime)) {
            return false;
        }
        return !(this.parentTracefile == null ? other.parentTracefile != null : !this.parentTracefile.equals(other.parentTracefile));
    }

    @Override
    public int compareTo(JniEvent other) {
        int eventComparaison = -1;
        if (other != null && (eventComparaison = this.getEventTime().compareTo(other.getEventTime())) == 0 && !this.parentTracefile.equals(other.parentTracefile)) {
            eventComparaison = 1;
        }
        return eventComparaison;
    }

    public void printEventInformation() {
        this.ltt_printEvent(this.thisEventPtr.getLibraryId(), this.thisEventPtr.getPointer());
    }

    public String toString() {
        String returnData = "";
        returnData = String.valueOf(returnData) + "tracefilePtr            : " + this.tracefilePtr + "\n";
        returnData = String.valueOf(returnData) + "eventMarkerId           : " + this.getEventMarkerId() + "\n";
        returnData = String.valueOf(returnData) + "eventTime               : " + this.eventTime.getReferenceToString() + "\n";
        returnData = String.valueOf(returnData) + "   seconds              : " + this.eventTime.getSeconds() + "\n";
        returnData = String.valueOf(returnData) + "   nanoSeconds          : " + this.eventTime.getNanoSeconds() + "\n";
        returnData = String.valueOf(returnData) + "eventDataSize           : " + this.getEventDataSize() + "\n";
        returnData = String.valueOf(returnData) + "markersMap              : " + this.markersMap.keySet() + "\n";
        return returnData;
    }
}

