/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.callgraph.launch;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.linuxtools.internal.callgraph.core.PluginConstants;
import org.eclipse.linuxtools.internal.callgraph.core.SystemTapUIErrorMessages;
import org.eclipse.linuxtools.internal.callgraph.launch.Messages;
import org.eclipse.linuxtools.internal.callgraph.launch.SystemTapLaunchShortcut;
import org.eclipse.ui.IEditorPart;

public class LaunchStapGraph
extends SystemTapLaunchShortcut {
    private String partialScriptPath;
    private String funcs = null;
    private ArrayList<String> exclusions = new ArrayList();
    private String projectName = null;
    protected static final String ATTR_PARSER = "org.eclipse.linuxtools.callgraph.graphparser";
    protected static final String ATTR_VIEWER = "org.eclipse.linuxtools.callgraph.callgraphview";

    public void launch(IEditorPart ed, String mode) {
        this.resourceToSearchFor = ed.getTitle();
        this.searchForResource = true;
        super.launch(ed, mode);
    }

    @Override
    public void launch(IBinary bin, String mode) {
        this.launch(bin, mode, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void launch(IBinary bin, String mode, ILaunchConfigurationWorkingCopy wc) {
        super.initialize();
        this.bin = bin;
        this.name = "SystemTapGraph";
        this.binName = this.getName(bin);
        this.partialScriptPath = String.valueOf(PluginConstants.getPluginLocation()) + "parse_function_partial.stp";
        this.viewID = ATTR_VIEWER;
        this.projectName = bin.getCProject().getElementName();
        try {
            if (wc == null) {
                wc = this.createConfiguration(bin, this.name);
            }
            this.arguments = this.binaryPath = bin.getResource().getLocation().toString();
            this.outputPath = PluginConstants.getDefaultIOPath();
            if (this.writeFunctionListToScript(this.resourceToSearchFor) == null) {
                return;
            }
            if (this.funcs == null) return;
            if (this.funcs.length() < 0) {
                return;
            }
            this.needToGenerate = true;
            this.finishLaunch(this.name, mode, wc);
            return;
        }
        catch (IOException e) {
            SystemTapUIErrorMessages mess = new SystemTapUIErrorMessages("LaunchShortcutScriptGen", Messages.getString("LaunchStapGraph.ScriptGenErr"), Messages.getString("LaunchStapGraph.ScriptGenErrMsg"));
            mess.schedule();
            e.printStackTrace();
            return;
        }
        catch (CoreException e1) {
            e1.printStackTrace();
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        finally {
            this.resourceToSearchFor = "";
            this.searchForResource = false;
        }
    }

    public void setFuncs(String val) {
        this.funcs = val;
    }

    private String generateProbe(String function) {
        String output = "probe process(@1).function(\"" + function + "\").call ? {\tif ( ! isinstr(probefunc(), \"___STAP_MARKER___\")) { callFunction(probefunc(),tid()) } \t}\tprobe process(@1).function(\"" + function + "\").return ? {\t\tif ( ! isinstr(probefunc(), \"___STAP_MARKER___\")) returnFunction(probefunc(),tid())\telse { printf(\"?%d,,%s\\n\", tid(), user_string(strtol(tokenize($$return, \"return=\"),16)))}}\n";
        return output;
    }

    public String writeFunctionListToScript(String resourceToSearchFor) throws IOException {
        String toWrite = this.getFunctionsFromBinary(this.bin, resourceToSearchFor);
        if (toWrite == null || toWrite.length() < 1) {
            return null;
        }
        StringBuffer output = new StringBuffer();
        String[] stringArray = toWrite.split(" ");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String func = stringArray[n2];
            if (func.length() > 0 && (this.exclusions == null || this.exclusions.size() < 1 || this.exclusions.contains(func))) {
                output.append(this.generateProbe(func));
            }
            ++n2;
        }
        this.funcs = output.toString();
        return this.funcs;
    }

    private String writeFromPartialScript(String projectName) throws IOException {
        String toWrite = "";
        String temp = "";
        toWrite = String.valueOf(toWrite) + "\nprobe begin{\nprintf(\"\\nPROBE_BEGIN\\n\")\nserial=1\nstartTime = 0;\nprintf(\"" + projectName + "\\n\")\n" + "}";
        File partialScript = new File(this.partialScriptPath);
        BufferedReader scriptReader = new BufferedReader(new FileReader(partialScript));
        while ((temp = scriptReader.readLine()) != null) {
            toWrite = String.valueOf(toWrite) + temp + "\n";
        }
        scriptReader.close();
        return toWrite;
    }

    public void setExclusions(ArrayList<String> e) {
        this.exclusions = e;
    }

    @Override
    public String generateScript() throws IOException {
        String scriptContents = "";
        scriptContents = String.valueOf(scriptContents) + this.funcs;
        scriptContents = String.valueOf(scriptContents) + this.writeFromPartialScript(this.projectName);
        return scriptContents;
    }

    public void setPartialScriptPath(String val) {
        this.partialScriptPath = val;
    }

    @Override
    public String setScriptPath() {
        this.scriptPath = String.valueOf(PluginConstants.getDefaultOutput()) + "callgraphGen.stp";
        return this.scriptPath;
    }

    @Override
    public String setParserID() {
        this.parserID = ATTR_PARSER;
        return this.parserID;
    }

    @Override
    public String setViewID() {
        return ATTR_VIEWER;
    }
}

