/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.ide.editors.c;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.linuxtools.systemtap.ui.editor.ColorManager;
import org.eclipse.linuxtools.systemtap.ui.editor.DoubleClickStrategy;
import org.eclipse.linuxtools.systemtap.ui.editor.NonRuleBasedDamagerRepairer;
import org.eclipse.linuxtools.systemtap.ui.ide.editors.c.CScanner;
import org.eclipse.linuxtools.systemtap.ui.ide.internal.IDEPlugin;
import org.eclipse.linuxtools.systemtap.ui.logging.LogManager;
import org.eclipse.swt.graphics.RGB;

public class CConfiguration
extends SourceViewerConfiguration {
    private DoubleClickStrategy doubleClickStrategy;
    private CScanner scanner;
    private ColorManager colorManager;

    public CConfiguration(ColorManager colorManager) {
        LogManager.logDebug((String)("Start/End CConfiguration: colorManager-" + colorManager), (Object)((Object)this));
        this.colorManager = colorManager;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        LogManager.logDebug((String)("Start/End getConfiguredContentTypes: sourceViewer-" + sourceViewer), (Object)((Object)this));
        return new String[]{"__dftl_partition_content_type", "__stp_comment"};
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        LogManager.logDebug((String)("Start getDoubleClickStrategy: sourceViewer-" + sourceViewer + ", contentType-" + contentType), (Object)((Object)this));
        if (this.doubleClickStrategy == null) {
            this.doubleClickStrategy = new DoubleClickStrategy();
        }
        LogManager.logDebug((String)("End getDoubleClickStrategy: returnVal-" + this.doubleClickStrategy), (Object)((Object)this));
        return this.doubleClickStrategy;
    }

    protected CScanner getCScanner() {
        LogManager.logDebug((String)"Start getCScanner:", (Object)((Object)this));
        if (this.scanner == null) {
            this.scanner = new CScanner(this.colorManager);
        }
        LogManager.logDebug((String)("End getCScanner: returnVal-" + (Object)((Object)this.scanner)), (Object)((Object)this));
        return this.scanner;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        LogManager.logDebug((String)("Start getPresentationReconciler: sourceViewer-" + sourceViewer), (Object)((Object)this));
        PresentationReconciler reconciler = new PresentationReconciler();
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.getCScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        IPreferenceStore store = IDEPlugin.getDefault().getPreferenceStore();
        RGB comment = PreferenceConverter.getColor((IPreferenceStore)store, (String)"cCommentColorPreference");
        NonRuleBasedDamagerRepairer ndr = new NonRuleBasedDamagerRepairer(new TextAttribute(this.colorManager.getColor(comment)));
        reconciler.setDamager((IPresentationDamager)ndr, "__stp_comment");
        reconciler.setRepairer((IPresentationRepairer)ndr, "__stp_comment");
        LogManager.logDebug((String)("End getPresentationReconciler: returnVal-" + reconciler), (Object)((Object)this));
        return reconciler;
    }
}

