/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.uml2sd.util;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.SDWidget;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.util.SDMessages;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.util.SDPrintDialogUI;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class SDPrintDialog
extends Dialog {
    protected SDWidget view;
    protected SDPrintDialogUI dialogUI;
    protected String errorMessage = null;
    protected Label messageLabel = null;
    protected boolean isPageComplete = true;

    public SDPrintDialog(Shell s, SDWidget v) {
        super(s);
        this.view = v;
        this.dialogUI = new SDPrintDialogUI(s, this.view);
        this.dialogUI.setParentDialog(this);
    }

    protected Control createDialogArea(Composite p) {
        p.getShell().setText(SDMessages._114);
        Composite parent = (Composite)super.createDialogArea(p);
        this.dialogUI.createDialogArea(parent);
        this.messageLabel = new Label(parent, 0);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 6;
        this.messageLabel.setLayoutData((Object)gridData);
        this.setErrorMessage(this.errorMessage);
        return parent;
    }

    protected void okPressed() {
        if (this.dialogUI.okPressed()) {
            super.okPressed();
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.createButton(parent, 1024, SDMessages._115, false);
        this.getButton(1024).addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SDPrintDialog.this.dialogUI.printButtonSelected();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.updateButtons();
    }

    public SDPrintDialogUI getDialogUI() {
        return this.dialogUI;
    }

    public void setErrorMessage(String message) {
        this.errorMessage = message;
        if (this.messageLabel != null) {
            if (this.errorMessage == null) {
                this.messageLabel.setText("");
            } else {
                this.messageLabel.setText(this.errorMessage);
            }
        }
    }

    public void setPageComplete(boolean complete) {
        this.isPageComplete = complete;
        this.updateButtons();
    }

    public void updateButtons() {
        Button okButton = this.getButton(0);
        if (this.isPageComplete) {
            if (okButton != null) {
                okButton.setEnabled(true);
            }
        } else if (okButton != null) {
            okButton.setEnabled(false);
        }
    }
}

