/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.core.runtime.Platform;

public class TmfUiTracer {
    private static String pluginID = "org.eclipse.linuxtools.tmf.ui";
    static Boolean ERROR = Boolean.FALSE;
    static Boolean WARNING = Boolean.FALSE;
    static Boolean INFO = Boolean.FALSE;
    static Boolean INDEX = Boolean.FALSE;
    static Boolean DISPLAY = Boolean.FALSE;
    static Boolean SORTING = Boolean.FALSE;
    private static String LOGNAME = "traceUI.log";
    private static BufferedWriter fTraceLog = null;

    private static BufferedWriter openLogFile(String filename) {
        BufferedWriter outfile = null;
        try {
            outfile = new BufferedWriter(new FileWriter(filename));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return outfile;
    }

    public static void init() {
        boolean isTracing = false;
        String traceKey = Platform.getDebugOption((String)(String.valueOf(pluginID) + "/error"));
        if (traceKey != null) {
            ERROR = (boolean)Boolean.valueOf(traceKey);
            isTracing |= ERROR.booleanValue();
        }
        if ((traceKey = Platform.getDebugOption((String)(String.valueOf(pluginID) + "/warning"))) != null) {
            WARNING = (boolean)Boolean.valueOf(traceKey);
            isTracing |= WARNING.booleanValue();
        }
        if ((traceKey = Platform.getDebugOption((String)(String.valueOf(pluginID) + "/info"))) != null) {
            INFO = (boolean)Boolean.valueOf(traceKey);
            isTracing |= INFO.booleanValue();
        }
        if ((traceKey = Platform.getDebugOption((String)(String.valueOf(pluginID) + "/updateindex"))) != null) {
            INDEX = (boolean)Boolean.valueOf(traceKey);
            isTracing |= INDEX.booleanValue();
        }
        if ((traceKey = Platform.getDebugOption((String)(String.valueOf(pluginID) + "/display"))) != null) {
            DISPLAY = (boolean)Boolean.valueOf(traceKey);
            isTracing |= DISPLAY.booleanValue();
        }
        if ((traceKey = Platform.getDebugOption((String)(String.valueOf(pluginID) + "/sorting"))) != null) {
            SORTING = (boolean)Boolean.valueOf(traceKey);
            isTracing |= SORTING.booleanValue();
        }
        if (isTracing) {
            fTraceLog = TmfUiTracer.openLogFile(LOGNAME);
        }
    }

    public static void stop() {
        if (fTraceLog == null) {
            return;
        }
        try {
            fTraceLog.close();
            fTraceLog = null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean isErrorTraced() {
        return ERROR;
    }

    public static boolean isIndexTraced() {
        return INDEX;
    }

    public static boolean isDisplayTraced() {
        return DISPLAY;
    }

    public static boolean isSortingTraced() {
        return SORTING;
    }

    public static void trace(String msg) {
        long currentTime = System.currentTimeMillis();
        StringBuilder message = new StringBuilder("[");
        message.append(currentTime / 1000L);
        message.append(".");
        message.append(String.format("%1$03d", currentTime % 1000L));
        message.append("] ");
        message.append(msg);
        if (fTraceLog != null) {
            try {
                fTraceLog.write(message.toString());
                fTraceLog.newLine();
                fTraceLog.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void traceIndex(String msg) {
        String message = "[INDEX] " + msg;
        TmfUiTracer.trace(message);
    }

    public static void traceDisplay(String msg) {
        String message = "[DISPLAY]" + msg;
        TmfUiTracer.trace(message);
    }

    public static void traceSorting(String msg) {
        String message = "[SORT] " + msg;
        TmfUiTracer.trace(message);
    }

    public static void traceError(String msg) {
        String message = "[ERR] Thread=" + Thread.currentThread().getId() + " " + msg;
        TmfUiTracer.trace(message);
    }

    public static void traceWarning(String msg) {
        String message = "[WARN] Thread=" + Thread.currentThread().getId() + " " + msg;
        TmfUiTracer.trace(message);
    }

    public static void traceInfo(String msg) {
        String message = "[INF] Thread=" + Thread.currentThread().getId() + " " + msg;
        TmfUiTracer.trace(message);
    }
}

