/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.prov.engine.phases;

import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.internal.prov.engine.EngineActivator;
import org.eclipse.equinox.internal.prov.engine.TouchpointManager;
import org.eclipse.equinox.prov.core.eventbus.ProvisioningEventBus;
import org.eclipse.equinox.prov.core.helpers.MultiStatus;
import org.eclipse.equinox.prov.core.helpers.ServiceHelper;
import org.eclipse.equinox.prov.engine.EngineSession;
import org.eclipse.equinox.prov.engine.ITouchpoint;
import org.eclipse.equinox.prov.engine.ITouchpointAction;
import org.eclipse.equinox.prov.engine.IUPhase;
import org.eclipse.equinox.prov.engine.InstallableUnitEvent;
import org.eclipse.equinox.prov.engine.Operand;
import org.eclipse.equinox.prov.engine.Profile;
import org.eclipse.equinox.prov.engine.phases.Messages;
import org.eclipse.equinox.prov.metadata.IResolvedInstallableUnit;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;

public class Uninstall
extends IUPhase {
    private static final String PHASE_ID = "uninstall";
    protected Map parameters = new HashMap();
    protected Set touchpoints = new HashSet();
    static /* synthetic */ Class class$0;

    public Uninstall(int weight) {
        super(PHASE_ID, weight, Messages.Engine_Uninstall_Phase);
    }

    protected void prePerform(MultiStatus status, Profile profile, Operand[] deltas, IProgressMonitor monitor) {
        int i = 0;
        while (i < deltas.length) {
            ITouchpoint touchpoint;
            IResolvedInstallableUnit unit = deltas[i].first();
            if (unit != null && !this.touchpoints.contains(touchpoint = TouchpointManager.getInstance().getTouchpoint(unit.getTouchpointType())) && touchpoint.supports(this.phaseId)) {
                this.touchpoints.add(touchpoint);
                touchpoint.init(profile, this.phaseId, this.parameters);
            }
            ++i;
        }
    }

    protected void postPerform(MultiStatus status, Profile profile, Operand[] deltas, IProgressMonitor monitor) {
        Iterator it = this.touchpoints.iterator();
        while (it.hasNext()) {
            ITouchpoint touchpoint = (ITouchpoint)it.next();
            touchpoint.finish(profile, this.phaseId, this.parameters);
        }
    }

    protected IStatus performOperand(EngineSession session, Profile profile, Operand operand, IProgressMonitor monitor) {
        IResolvedInstallableUnit unit = operand.first();
        monitor.subTask(NLS.bind((String)Messages.Engine_Uninstalling_IU, (Object)unit.getId()));
        ITouchpoint touchpoint = TouchpointManager.getInstance().getTouchpoint(unit.getTouchpointType());
        if (touchpoint.supports(PHASE_ID)) {
            BundleContext bundleContext = EngineActivator.getContext();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.equinox.prov.core.eventbus.ProvisioningEventBus");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ((ProvisioningEventBus)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())).publishEvent((EventObject)new InstallableUnitEvent(PHASE_ID, true, profile, operand, touchpoint));
        }
        ITouchpointAction[] actions = touchpoint.getActions(PHASE_ID, profile, operand);
        MultiStatus result = new MultiStatus();
        int i = 0;
        while (i < actions.length) {
            result.add(actions[i].execute(this.parameters));
            session.record(actions[i]);
            ++i;
        }
        BundleContext bundleContext = EngineActivator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.prov.core.eventbus.ProvisioningEventBus");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ((ProvisioningEventBus)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())).publishEvent((EventObject)new InstallableUnitEvent(PHASE_ID, false, profile, operand, touchpoint, (IStatus)result));
        return result;
    }

    protected boolean isApplicable(Operand op) {
        return op.first() != null;
    }
}

