/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.teststubs.osgi.service.event;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.virgo.teststubs.osgi.service.event.internal.EventUtils;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

public class StubEventAdmin
implements EventAdmin {
    private final List<Event> postedEvents = new ArrayList<Event>();
    private final List<Event> sentEvents = new ArrayList<Event>();
    private final Object monitor = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postEvent(Event event) {
        Object object = this.monitor;
        synchronized (object) {
            this.postedEvents.add(event);
            this.monitor.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendEvent(Event event) {
        Object object = this.monitor;
        synchronized (object) {
            this.sentEvents.add(event);
            this.monitor.notifyAll();
        }
    }

    public boolean awaitSendingOfEvent(Event event, long msTimeout) {
        return this.awaitEvent(event, this.sentEvents, msTimeout);
    }

    public boolean awaitPostingOfEvent(Event event, long msTimeout) {
        return this.awaitEvent(event, this.postedEvents, msTimeout);
    }

    public Event awaitSendingOfEvent(String topic, long msTimeout) {
        return this.awaitEventOnTopic(topic, this.sentEvents, msTimeout);
    }

    public Event awaitPostingOfEvent(String topic, long msTimeout) {
        return this.awaitEventOnTopic(topic, this.postedEvents, msTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean awaitEvent(Event event, List<Event> eventList, long timeout) {
        long endTime = System.currentTimeMillis() + timeout;
        Object object = this.monitor;
        synchronized (object) {
            try {
                while (true) {
                    if (this.removeEvent(event, eventList)) {
                        return true;
                    }
                    long waitTime = endTime - System.currentTimeMillis();
                    if (waitTime <= 0L) {
                        return false;
                    }
                    this.monitor.wait(waitTime);
                }
            }
            catch (InterruptedException interruptedException) {
                Thread.interrupted();
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Event awaitEventOnTopic(String topic, List<Event> eventList, long timeout) {
        long endTime = System.currentTimeMillis() + timeout;
        Object object = this.monitor;
        synchronized (object) {
            try {
                Event event = null;
                while (event == null) {
                    long waitTime = endTime - System.currentTimeMillis();
                    if (waitTime <= 0L) break;
                    this.monitor.wait(waitTime);
                    event = this.removeEventOnTopic(topic, eventList);
                }
                return event;
            }
            catch (InterruptedException interruptedException) {
                Thread.interrupted();
                return null;
            }
        }
    }

    private boolean removeEvent(Event event, List<Event> eventList) {
        Iterator<Event> candidates = eventList.iterator();
        while (candidates.hasNext()) {
            Event candidate = candidates.next();
            if (!EventUtils.eventsAreEqual(candidate, event)) continue;
            candidates.remove();
            return true;
        }
        return false;
    }

    private Event removeEventOnTopic(String topic, List<Event> eventList) {
        Iterator<Event> candidates = eventList.iterator();
        while (candidates.hasNext()) {
            Event candidate = candidates.next();
            if (!topic.equals(candidate.getTopic())) continue;
            candidates.remove();
            return candidate;
        }
        return null;
    }
}

