/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.teststubs.osgi.framework;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.teststubs.osgi.framework.StubBundle;
import org.eclipse.virgo.teststubs.osgi.framework.StubServiceReference;
import org.eclipse.virgo.teststubs.osgi.framework.StubServiceRegistration;
import org.eclipse.virgo.teststubs.osgi.framework.aspects.BundleEvents;
import org.eclipse.virgo.teststubs.osgi.framework.aspects.ServiceEvents;
import org.eclipse.virgo.teststubs.osgi.framework.aspects.ValidBundleContext;
import org.eclipse.virgo.teststubs.osgi.internal.Assert;
import org.eclipse.virgo.teststubs.osgi.internal.Duplicator;
import org.eclipse.virgo.teststubs.osgi.support.TrueFilter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.Version;

public final class StubBundleContext
implements BundleContext {
    private final StubBundle bundle;
    private final Object bundleMonitor = new Object();
    private final List<BundleListener> bundleListeners = new ArrayList<BundleListener>();
    private final Object bundleListenersMonitor = new Object();
    private final List<FrameworkListener> frameworkListeners = new ArrayList<FrameworkListener>();
    private final Object frameworkListenersMonitor = new Object();
    private final List<ServiceListener> serviceListeners = new ArrayList<ServiceListener>();
    private final Object serviceListenersMonitor = new Object();
    private volatile long installedBundleId = 2L;
    private final Map<Long, StubBundle> installedBundles = new HashMap<Long, StubBundle>();
    private final Object installedBundlesMonitor = new Object();
    private final List<StubServiceRegistration<Object>> serviceRegistrations = new ArrayList<StubServiceRegistration<Object>>();
    private final Map<StubServiceReference<Object>, Object> services = new HashMap<StubServiceReference<Object>, Object>();
    private final Object servicesMonitor = new Object();
    private final Map<String, File> dataFiles = new HashMap<String, File>();
    private final Object dataFilesMonitor = new Object();
    private final Map<String, String> properties = new HashMap<String, String>();
    private final Object propertiesMonitor = new Object();
    private final Map<String, Filter> filters = new HashMap<String, Filter>();
    private final Object filtersMonitor = new Object();
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public StubBundleContext() {
        this(new StubBundle());
    }

    public StubBundleContext(StubBundle bundle) {
        Assert.assertNotNull(bundle, "bundle");
        this.bundle = bundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBundleListener(BundleListener listener) {
        ValidBundleContext.aspectOf().ajc$before$org_eclipse_virgo_teststubs_osgi_framework_aspects_ValidBundleContext$1$a8fa122b(this);
        Object object = this.bundleListenersMonitor;
        synchronized (object) {
            this.bundleListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFrameworkListener(FrameworkListener listener) {
        ValidBundleContext.aspectOf().ajc$before$org_eclipse_virgo_teststubs_osgi_framework_aspects_ValidBundleContext$1$a8fa122b(this);
        Object object = this.frameworkListenersMonitor;
        synchronized (object) {
            this.frameworkListeners.add(listener);
        }
    }

    public void addServiceListener(ServiceListener listener) {
        ValidBundleContext.aspectOf().ajc$before$org_eclipse_virgo_teststubs_osgi_framework_aspects_ValidBundleContext$1$a8fa122b(this);
        try {
            this.addServiceListener(listener, null);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServiceListener(ServiceListener listener, String filter) throws InvalidSyntaxException {
        ValidBundleContext.aspectOf().ajc$before$org_eclipse_virgo_teststubs_osgi_framework_aspects_ValidBundleContext$1$a8fa122b(this);
        Object object = this.serviceListenersMonitor;
        synchronized (object) {
            this.serviceListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Filter createFilter(String filter) throws InvalidSyntaxException {
        ValidBundleContext.aspectOf().ajc$before$org_eclipse_virgo_teststubs_osgi_framework_aspects_ValidBundleContext$1$a8fa122b(this);
        Object object = this.filtersMonitor;
        synchronized (object) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (!this.filters.containsKey(filter)) {
                throw new InvalidSyntaxException(String.format("You must first add a filter mapping for '%s' with the addFilter(String, Filter) method", filter), filter);
            }
            return this.filters.get(filter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StubBundleContext addFilter(String filterString, Filter filter) {
        Object object = this.filtersMonitor;
        synchronized (object) {
            this.filters.put(filterString, filter);
            return this;
        }
    }

    public StubBundleContext addFilter(Filter ... filters) {
        Filter[] filterArray = filters;
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            Filter filter = filterArray[n2];
            this.addFilter(filter.toString(), filter);
            ++n2;
        }
        return this;
    }

    public ServiceReference<?>[] getAllServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
        ValidBundleContext.aspectOf().ajc$before$org_eclipse_virgo_teststubs_osgi_framework_aspects_ValidBundleContext$1$a8fa122b(this);
        return this.getServiceReferences(clazz, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bundle getBundle() {
        ValidBundleContext.aspectOf().ajc$before$org_eclipse_virgo_teststubs_osgi_framework_aspects_ValidBundleContext$1$a8fa122b(this);
        Object object = this.bundleMonitor;
        synchronized (object) {
            return this.bundle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bundle getBundle(long id) {
        ValidBundleContext.aspectOf().ajc$before$org_eclipse_virgo_teststubs_osgi_framework_aspects_ValidBundleContext$1$a8fa122b(this);
        Object object = this.installedBundlesMonitor;
        synchronized (object) {
            return this.installedBundles.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bundle[] getBundles() {
        ValidBundleContext.aspectOf().ajc$before$org_eclipse_virgo_teststubs_osgi_framework_aspects_ValidBundleContext$1$a8fa122b(this);
        Object object = this.installedBundlesMonitor;
        synchronized (object) {
            return this.installedBundles.values().toArray(new Bundle[this.installedBundles.values().size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StubBundleContext addInstalledBundle(StubBundle ... bundles) {
        Object object = this.installedBundlesMonitor;
        synchronized (object) {
            StubBundle[] stubBundleArray = bundles;
            int n = bundles.length;
            int n2 = 0;
            while (n2 < n) {
                StubBundle bundle = stubBundleArray[n2];
                this.installedBundles.put(bundle.getBundleId(), bundle);
                ++n2;
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getDataFile(String filename) {
        ValidBundleContext.aspectOf().ajc$before$org_eclipse_virgo_teststubs_osgi_framework_aspects_ValidBundleContext$1$a8fa122b(this);
        Object object = this.dataFilesMonitor;
        synchronized (object) {
            return this.dataFiles.get(filename);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StubBundleContext addDataFile(String filename, File file) {
        Object object = this.dataFilesMonitor;
        synchronized (object) {
            this.dataFiles.put(filename, file);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getProperty(String key) {
        ValidBundleContext.aspectOf().ajc$before$org_eclipse_virgo_teststubs_osgi_framework_aspects_ValidBundleContext$1$a8fa122b(this);
        Object object = this.propertiesMonitor;
        synchronized (object) {
            return this.properties.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StubBundleContext addProperty(String key, String value) {
        Object object = this.propertiesMonitor;
        synchronized (object) {
            this.properties.put(key, value);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S> S getService(ServiceReference<S> reference) {
        ValidBundleContext.aspectOf().ajc$before$org_eclipse_virgo_teststubs_osgi_framework_aspects_ValidBundleContext$1$a8fa122b(this);
        Object object = this.servicesMonitor;
        synchronized (object) {
            block4: {
                if (!this.serviceUnregistered(reference)) break block4;
                return null;
            }
            return (S)this.services.get(reference);
        }
    }

    public ServiceReference<?> getServiceReference(String clazz) {
        ValidBundleContext.aspectOf().ajc$before$org_eclipse_virgo_teststubs_osgi_framework_aspects_ValidBundleContext$1$a8fa122b(this);
        Object[] serviceReferences = null;
        try {
            serviceReferences = this.getServiceReferences(clazz, null);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        if (serviceReferences == null) {
            return null;
        }
        if (serviceReferences.length == 1) {
            return serviceReferences[0];
        }
        Arrays.sort(serviceReferences);
        return serviceReferences[serviceReferences.length - 1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceReference<?>[] getServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
        ValidBundleContext.aspectOf().ajc$before$org_eclipse_virgo_teststubs_osgi_framework_aspects_ValidBundleContext$1$a8fa122b(this);
        Object object = this.servicesMonitor;
        synchronized (object) {
            ArrayList<ServiceReference> candidateReferences;
            block5: {
                candidateReferences = new ArrayList<ServiceReference>();
                Filter f = this.getFilter(filter);
                for (ServiceReference serviceReference : this.services.keySet()) {
                    String[] objectClasses = (String[])serviceReference.getProperty("objectClass");
                    if (!f.match(serviceReference) || !this.matchesClass(clazz, objectClasses)) continue;
                    candidateReferences.add(serviceReference);
                }
                if (!candidateReferences.isEmpty()) break block5;
                return null;
            }
            return candidateReferences.toArray(new ServiceReference[candidateReferences.size()]);
        }
    }

    private Filter getFilter(String filter) throws InvalidSyntaxException {
        if (filter == null) {
            return new TrueFilter();
        }
        return this.createFilter(filter);
    }

    private boolean matchesClass(String clazz, String[] objectClasses) {
        if (clazz == null) {
            return true;
        }
        String[] stringArray = objectClasses;
        int n = objectClasses.length;
        int n2 = 0;
        while (n2 < n) {
            String objectClass = stringArray[n2];
            if (clazz.equals(objectClass)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public Bundle installBundle(String location) throws BundleException {
        ValidBundleContext.aspectOf().ajc$before$org_eclipse_virgo_teststubs_osgi_framework_aspects_ValidBundleContext$1$a8fa122b(this);
        StubBundle bundle = new StubBundle(this.installedBundleId++, location, Version.emptyVersion, location);
        int n = 2;
        StubBundle stubBundle = bundle;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)stubBundle, (Object)Conversions.intObject((int)n));
        try {
            stubBundle.setState(n);
        }
        finally {
            if (BundleEvents.ajc$if$6a7(this, stubBundle, joinPoint)) {
                BundleEvents.aspectOf().ajc$after$org_eclipse_virgo_teststubs_osgi_framework_aspects_BundleEvents$1$6e73bfc6(this, stubBundle);
            }
        }
        return bundle;
    }

    public Bundle installBundle(String location, InputStream input) throws BundleException {
        ValidBundleContext.aspectOf().ajc$before$org_eclipse_virgo_teststubs_osgi_framework_aspects_ValidBundleContext$1$a8fa122b(this);
        return this.installBundle(location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceRegistration<?> registerService(String[] clazzes, Object service, Dictionary<String, ?> properties) {
        StubServiceRegistration<Object> stubServiceRegistration;
        StubServiceRegistration<Object> stubServiceRegistration2;
        ValidBundleContext.aspectOf().ajc$before$org_eclipse_virgo_teststubs_osgi_framework_aspects_ValidBundleContext$1$a8fa122b(this);
        StubServiceRegistration<Object> serviceRegistration = this.createServiceRegistration(clazzes, properties);
        StubServiceReference<Object> serviceReference = this.createServiceReference(clazzes, service, serviceRegistration);
        Object object = this.servicesMonitor;
        synchronized (object) {
            this.serviceRegistrations.add(serviceRegistration);
            this.services.put(serviceReference, service);
        }
        StubServiceRegistration<Object> stubServiceRegistration3 = stubServiceRegistration2 = (stubServiceRegistration = serviceRegistration);
        ServiceEvents.aspectOf().ajc$afterReturning$org_eclipse_virgo_teststubs_osgi_framework_aspects_ServiceEvents$2$6a2bdc4b(this, stubServiceRegistration2);
        return stubServiceRegistration;
    }

    private StubServiceRegistration<Object> createServiceRegistration(String[] clazzes, Dictionary<String, ?> properties) {
        StubServiceRegistration<Object> serviceRegistration = new StubServiceRegistration<Object>(this, clazzes);
        serviceRegistration.setProperties(properties);
        return serviceRegistration;
    }

    private <S> StubServiceReference<S> createServiceReference(String[] clazzes, Object service, StubServiceRegistration<S> serviceRegistration) {
        StubServiceReference<S> serviceReference = new StubServiceReference<S>(serviceRegistration);
        serviceRegistration.setServiceReference(serviceReference);
        return serviceReference;
    }

    public ServiceRegistration<?> registerService(String clazz, Object service, Dictionary<String, ?> properties) {
        ValidBundleContext.aspectOf().ajc$before$org_eclipse_virgo_teststubs_osgi_framework_aspects_ValidBundleContext$1$a8fa122b(this);
        return this.registerService(new String[]{clazz}, service, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<StubServiceRegistration<Object>> getServiceRegistrations() {
        Object object = this.servicesMonitor;
        synchronized (object) {
            return Duplicator.shallowCopy(this.serviceRegistrations);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StubBundleContext removeRegisteredService(ServiceRegistration<?> ... serviceRegistrations) {
        Object object = this.servicesMonitor;
        synchronized (object) {
            this.serviceRegistrations.removeAll((Collection)Arrays.asList(serviceRegistrations));
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBundleListener(BundleListener listener) {
        ValidBundleContext.aspectOf().ajc$before$org_eclipse_virgo_teststubs_osgi_framework_aspects_ValidBundleContext$1$a8fa122b(this);
        Object object = this.bundleListenersMonitor;
        synchronized (object) {
            this.bundleListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFrameworkListener(FrameworkListener listener) {
        ValidBundleContext.aspectOf().ajc$before$org_eclipse_virgo_teststubs_osgi_framework_aspects_ValidBundleContext$1$a8fa122b(this);
        Object object = this.frameworkListenersMonitor;
        synchronized (object) {
            this.frameworkListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServiceListener(ServiceListener listener) {
        ValidBundleContext.aspectOf().ajc$before$org_eclipse_virgo_teststubs_osgi_framework_aspects_ValidBundleContext$1$a8fa122b(this);
        Object object = this.serviceListenersMonitor;
        synchronized (object) {
            this.serviceListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FrameworkListener> getFrameworkListeners() {
        Object object = this.frameworkListenersMonitor;
        synchronized (object) {
            return Duplicator.shallowCopy(this.frameworkListeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BundleListener> getBundleListeners() {
        Object object = this.bundleListenersMonitor;
        synchronized (object) {
            return Duplicator.shallowCopy(this.bundleListeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ServiceListener> getServiceListeners() {
        Object object = this.serviceListenersMonitor;
        synchronized (object) {
            return Duplicator.shallowCopy(this.serviceListeners);
        }
    }

    public boolean ungetService(ServiceReference<?> reference) {
        ValidBundleContext.aspectOf().ajc$before$org_eclipse_virgo_teststubs_osgi_framework_aspects_ValidBundleContext$1$a8fa122b(this);
        return !this.serviceUnregistered(reference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StubBundle getContextBundle() {
        Object object = this.bundleMonitor;
        synchronized (object) {
            return this.bundle;
        }
    }

    private boolean serviceUnregistered(ServiceReference<?> reference) {
        return ((StubServiceReference)reference).getServiceRegistration().getUnregistered();
    }

    public <S> ServiceRegistration<S> registerService(Class<S> clazz, S service, Dictionary<String, ?> properties) {
        ValidBundleContext.aspectOf().ajc$before$org_eclipse_virgo_teststubs_osgi_framework_aspects_ValidBundleContext$1$a8fa122b(this);
        return this.registerService(clazz.getName(), service, properties);
    }

    public <S> ServiceReference<S> getServiceReference(Class<S> clazz) {
        ValidBundleContext.aspectOf().ajc$before$org_eclipse_virgo_teststubs_osgi_framework_aspects_ValidBundleContext$1$a8fa122b(this);
        return this.getServiceReference(clazz.getName());
    }

    public <S> Collection<ServiceReference<S>> getServiceReferences(Class<S> clazz, String filter) throws InvalidSyntaxException {
        ValidBundleContext.aspectOf().ajc$before$org_eclipse_virgo_teststubs_osgi_framework_aspects_ValidBundleContext$1$a8fa122b(this);
        ArrayList<ServiceReference<S>> references = new ArrayList<ServiceReference<S>>();
        ServiceReference<?>[] matchingReferences = this.getServiceReferences(clazz.getName(), filter);
        if (matchingReferences != null) {
            ServiceReference<?>[] serviceReferenceArray = matchingReferences;
            int n = matchingReferences.length;
            int n2 = 0;
            while (n2 < n) {
                ServiceReference<?> reference = serviceReferenceArray[n2];
                references.add(reference);
                ++n2;
            }
        }
        return references;
    }

    public Bundle getBundle(String location) {
        ValidBundleContext.aspectOf().ajc$before$org_eclipse_virgo_teststubs_osgi_framework_aspects_ValidBundleContext$1$a8fa122b(this);
        return null;
    }

    static {
        Factory factory = new Factory("StubBundleContext.java", Class.forName("org.eclipse.virgo.teststubs.osgi.framework.StubBundleContext"));
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "setState", "org.eclipse.virgo.teststubs.osgi.framework.StubBundle", "int:", "state:", "", "org.eclipse.virgo.teststubs.osgi.framework.StubBundle"), 373);
    }
}

