/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.parser;

import org.antlr.runtime.tree.Tree;
import org.eclipse.core.runtime.Assert;

public abstract class JSVisitor {
    private int maxRecursionDeep;
    private int currentRecursionDeep;

    protected JSVisitor(int maxRecursionDeep) {
        this.maxRecursionDeep = maxRecursionDeep;
        this.currentRecursionDeep = 0;
    }

    protected final boolean visitNode(Tree node) {
        boolean accept = this.visit(node);
        if (!accept) {
            int i = 0;
            while (i < node.getChildCount()) {
                this.visitNode(node.getChild(i));
                ++i;
            }
        }
        return true;
    }

    protected boolean visit(Tree node) {
        Assert.isNotNull((Object)node);
        if (this.currentRecursionDeep > this.maxRecursionDeep) {
            throw new IllegalArgumentException("Too many AST deep");
        }
        ++this.currentRecursionDeep;
        try {
            switch (node.getType()) {
                case 17: 
                case 33: 
                case 34: 
                case 37: 
                case 38: 
                case 180: {
                    boolean bl = this.visitIdentifier(node);
                    return bl;
                }
                case 128: {
                    boolean bl = this.visitArguments(node);
                    return bl;
                }
                case 130: {
                    boolean bl = this.visitBlock(node);
                    return bl;
                }
                case 5: 
                case 6: {
                    boolean bl = this.visitBooleanLiteral(node);
                    return bl;
                }
                case 25: {
                    boolean bl = this.visitThis(node);
                    return bl;
                }
                case 186: {
                    boolean bl = this.visitDecimalLiteral(node);
                    return bl;
                }
                case 173: {
                    boolean bl = this.visitStringLiteral(node);
                    return bl;
                }
                case 131: {
                    boolean bl = this.visitByField(node);
                    return bl;
                }
                case 132: {
                    boolean bl = this.visitByIndex(node);
                    return bl;
                }
                case 137: {
                    boolean bl = this.visitExpression(node);
                    return bl;
                }
                case 135: {
                    boolean bl = this.visitCall(node);
                    return bl;
                }
                case 4: {
                    boolean bl = this.visitNull(node);
                    return bl;
                }
                case 20: 
                case 21: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 101: 
                case 102: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: {
                    boolean bl = this.visitBinaryOperation(node);
                    return bl;
                }
                case 91: 
                case 92: 
                case 99: 
                case 100: 
                case 147: 
                case 150: 
                case 151: 
                case 152: {
                    boolean bl = this.visitUnaryOperation(node);
                    return bl;
                }
                case 23: {
                    boolean bl = this.visitReturn(node);
                    return bl;
                }
                case 24: {
                    boolean bl = this.visitSwitch(node);
                    return bl;
                }
                case 11: {
                    boolean bl = this.visitDefault(node);
                    return bl;
                }
                case 8: {
                    boolean bl = this.visitCase(node);
                    return bl;
                }
                case 7: {
                    boolean bl = this.visitBreak(node);
                    return bl;
                }
                case 10: {
                    boolean bl = this.visitContinue(node);
                    return bl;
                }
                case 13: {
                    boolean bl = this.visitDoWhile(node);
                    return bl;
                }
                case 31: {
                    boolean bl = this.visitWhile(node);
                    return bl;
                }
                case 16: {
                    boolean bl = this.visitFor(node);
                    return bl;
                }
                case 148: {
                    boolean bl = this.visitObjectInitializer(node);
                    return bl;
                }
                case 146: {
                    boolean bl = this.visitPropertyInitializer(node);
                    return bl;
                }
                case 140: {
                    boolean bl = this.visitForEachInStatement(node);
                    return bl;
                }
                case 19: {
                    boolean bl = this.visitIf(node);
                    return bl;
                }
                case 103: {
                    boolean bl = this.visitConditional(node);
                    return bl;
                }
                case 149: {
                    boolean bl = this.visitParenthesizedExpression(node);
                    return bl;
                }
                case 27: {
                    boolean bl = this.visitTry(node);
                    return bl;
                }
                case 26: {
                    boolean bl = this.visitThrow(node);
                    return bl;
                }
                case 9: {
                    boolean bl = this.visitCatch(node);
                    return bl;
                }
                case 15: {
                    boolean bl = this.visitFinally(node);
                    return bl;
                }
                case 22: {
                    boolean bl = this.visitNew(node);
                    return bl;
                }
                case 129: {
                    boolean bl = this.visitArray(node);
                    return bl;
                }
                case 136: {
                    boolean bl = this.visitCommaExpression(node);
                    return bl;
                }
                case 182: {
                    boolean bl = this.visitRegExp(node);
                    return bl;
                }
                case 32: {
                    boolean bl = this.visitWith(node);
                    return bl;
                }
                case 145: {
                    boolean bl = this.visitLabelled(node);
                    return bl;
                }
                case 12: {
                    boolean bl = this.visitDelete(node);
                    return bl;
                }
                case 30: {
                    boolean bl = this.visitVoid(node);
                    return bl;
                }
                case 141: {
                    boolean bl = this.visitGet(node);
                    return bl;
                }
                case 142: {
                    boolean bl = this.visitSet(node);
                    return bl;
                }
                case 28: {
                    boolean bl = this.visitTypeOf(node);
                    return bl;
                }
                case 29: {
                    boolean bl = this.visitVarDeclaration(node);
                    return bl;
                }
                case 44: {
                    boolean bl = this.visitConst(node);
                    return bl;
                }
                case 0: {
                    boolean bl = this.visitScript(node);
                    return bl;
                }
                case 18: {
                    boolean bl = this.visitFunction(node);
                    return bl;
                }
                case 153: {
                    boolean bl = this.visitXmlLiteral(node);
                    return bl;
                }
                case 143: {
                    boolean bl = this.visitNamespace(node);
                    return bl;
                }
                case 174: {
                    boolean bl = this.visitXmlAttribute(node);
                    return bl;
                }
                case 133: {
                    boolean bl = this.visitGetAllChildren(node);
                    return bl;
                }
                case 134: {
                    boolean bl = this.visitGetLocalName(node);
                    return bl;
                }
                case 188: {
                    boolean bl = this.visitHexIntegerLiteral(node);
                    return bl;
                }
                case 187: {
                    boolean bl = this.visitOctalIntegerLiteral(node);
                    return bl;
                }
                case 35: {
                    boolean bl = this.visitYield(node);
                    return bl;
                }
            }
            throw new UnsupportedOperationException("Unknown token: " + node.getType());
        }
        finally {
            --this.currentRecursionDeep;
        }
    }

    protected abstract boolean visitScript(Tree var1);

    protected abstract boolean visitFunction(Tree var1);

    protected abstract boolean visitIdentifier(Tree var1);

    protected abstract boolean visitXmlLiteral(Tree var1);

    protected abstract boolean visitNamespace(Tree var1);

    protected abstract boolean visitXmlAttribute(Tree var1);

    protected abstract boolean visitGetAllChildren(Tree var1);

    protected abstract boolean visitGetLocalName(Tree var1);

    protected abstract boolean visitHexIntegerLiteral(Tree var1);

    protected abstract boolean visitOctalIntegerLiteral(Tree var1);

    protected abstract boolean visitYield(Tree var1);

    protected abstract boolean visitArguments(Tree var1);

    protected abstract boolean visitBlock(Tree var1);

    protected abstract boolean visitSwitch(Tree var1);

    protected abstract boolean visitDefault(Tree var1);

    protected abstract boolean visitCase(Tree var1);

    protected abstract boolean visitReturn(Tree var1);

    protected abstract boolean visitBooleanLiteral(Tree var1);

    protected abstract boolean visitDecimalLiteral(Tree var1);

    protected abstract boolean visitStringLiteral(Tree var1);

    protected abstract boolean visitBinaryOperation(Tree var1);

    protected abstract boolean visitUnaryOperation(Tree var1);

    protected abstract boolean visitBreak(Tree var1);

    protected abstract boolean visitCall(Tree var1);

    protected abstract boolean visitDoWhile(Tree var1);

    protected abstract boolean visitWhile(Tree var1);

    protected abstract boolean visitForEachInStatement(Tree var1);

    protected abstract boolean visitFor(Tree var1);

    protected abstract boolean visitExpression(Tree var1);

    protected abstract boolean visitContinue(Tree var1);

    protected abstract boolean visitVarDeclaration(Tree var1);

    protected abstract boolean visitObjectInitializer(Tree var1);

    protected abstract boolean visitPropertyInitializer(Tree var1);

    protected abstract boolean visitByField(Tree var1);

    protected abstract boolean visitByIndex(Tree var1);

    protected abstract boolean visitIf(Tree var1);

    protected abstract boolean visitConditional(Tree var1);

    protected abstract boolean visitParenthesizedExpression(Tree var1);

    protected abstract boolean visitTry(Tree var1);

    protected abstract boolean visitCatch(Tree var1);

    protected abstract boolean visitFinally(Tree var1);

    protected abstract boolean visitThrow(Tree var1);

    protected abstract boolean visitNew(Tree var1);

    protected abstract boolean visitArray(Tree var1);

    protected abstract boolean visitCommaExpression(Tree var1);

    protected abstract boolean visitRegExp(Tree var1);

    protected abstract boolean visitWith(Tree var1);

    protected abstract boolean visitThis(Tree var1);

    protected abstract boolean visitLabelled(Tree var1);

    protected abstract boolean visitDelete(Tree var1);

    protected abstract boolean visitGet(Tree var1);

    protected abstract boolean visitSet(Tree var1);

    protected abstract boolean visitNull(Tree var1);

    protected abstract boolean visitTypeOf(Tree var1);

    protected abstract boolean visitConst(Tree var1);

    protected abstract boolean visitVoid(Tree var1);
}

