/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.ast;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.javascript.ast.Expression;
import org.eclipse.dltk.javascript.ast.Keyword;
import org.eclipse.dltk.javascript.ast.Statement;

public class IfStatement
extends Statement {
    private Keyword ifKeyword;
    private Keyword elseKeyword;
    private Expression condition;
    private Statement thenStatement;
    private Statement elseStatement = null;
    private int LP = -1;
    private int RP = -1;

    public IfStatement(ASTNode parent) {
        super(parent);
    }

    public Expression getCondition() {
        return this.condition;
    }

    public void setCondition(Expression condition) {
        this.condition = condition;
    }

    public Statement getThenStatement() {
        return this.thenStatement;
    }

    public void setThenStatement(Statement thenStatement) {
        this.thenStatement = thenStatement;
    }

    public Statement getElseStatement() {
        return this.elseStatement;
    }

    public void setElseStatement(Statement elseStatement) {
        this.elseStatement = elseStatement;
    }

    public Keyword getIfKeyword() {
        return this.ifKeyword;
    }

    public void setIfKeyword(Keyword keyword) {
        this.ifKeyword = keyword;
    }

    public Keyword getElseKeyword() {
        return this.elseKeyword;
    }

    public void setElseKeyword(Keyword keyword) {
        this.elseKeyword = keyword;
    }

    public int getLP() {
        return this.LP;
    }

    public void setLP(int LP) {
        this.LP = LP;
    }

    public int getRP() {
        return this.RP;
    }

    public void setRP(int RP) {
        this.RP = RP;
    }

    public String toSourceString(String indentationString) {
        Assert.isTrue((this.sourceStart() >= 0 ? 1 : 0) != 0);
        Assert.isTrue((this.sourceEnd() > 0 ? 1 : 0) != 0);
        Assert.isTrue((this.LP > 0 ? 1 : 0) != 0);
        Assert.isTrue((this.RP > 0 ? 1 : 0) != 0);
        StringBuffer buffer = new StringBuffer();
        buffer.append(indentationString);
        buffer.append("if");
        buffer.append(" (");
        buffer.append(this.getCondition().toSourceString(indentationString));
        buffer.append(")\n");
        buffer.append(this.getThenStatement().toSourceString(this.getThenStatement().isBlock() ? indentationString : String.valueOf(indentationString) + "    "));
        if (this.getElseStatement() != null) {
            buffer.append(indentationString);
            buffer.append("else");
            buffer.append("\n");
            buffer.append(this.getElseStatement().toSourceString(this.getElseStatement().isBlock() ? indentationString : String.valueOf(indentationString) + "    "));
        }
        return buffer.toString();
    }

    public boolean isBlock() {
        return true;
    }
}

