/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.voicebrowser;

import org.eclipse.actf.visualization.internal.engines.voicebrowser.Context;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.DomUtil;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.IElementRenderer;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.MessageCollection;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.OutLoud;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.Packet;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.PacketCollection;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class StaticINPUTRenderer
implements IElementRenderer {
    public PacketCollection getPacketCollectionIn(Element element, Context context, String string, MessageCollection messageCollection) {
        try {
            this.setContextIn(element, context);
            NamedNodeMap namedNodeMap = element.getAttributes();
            String string2 = null;
            String string3 = null;
            Node node = namedNodeMap.getNamedItem("type");
            if (node != null) {
                string2 = node.getNodeValue();
                if (string2.length() > 0) {
                    if (string2.equals("image")) {
                        string3 = this.inputTypeImage(element, namedNodeMap, messageCollection, string);
                    } else if (string2.equals("text")) {
                        string3 = this.inputTypeText(element, namedNodeMap, messageCollection, string);
                    } else if (string2.equals("submit")) {
                        string3 = this.inputTypeSubmit(element, namedNodeMap, messageCollection, string);
                    } else if (string2.equals("reset")) {
                        string3 = this.inputTypeReset(element, namedNodeMap, messageCollection, string);
                    } else if (string2.equals("button")) {
                        string3 = this.inputTypeButton(element, namedNodeMap, messageCollection, string);
                    } else if (string2.equals("password")) {
                        string3 = this.inputTypePassword(element, namedNodeMap, messageCollection, string);
                    } else if (string2.equals("checkbox")) {
                        string3 = this.inputTypeCheckbox(element, namedNodeMap, messageCollection, string);
                    } else if (string2.equals("radio")) {
                        string3 = this.inputTypeRadio(element, namedNodeMap, messageCollection, string);
                    } else if (string2.equals("file")) {
                        string3 = this.inputTypeFile(element, namedNodeMap, messageCollection, string);
                    } else if (string2.equals("hidden")) {
                        string3 = this.inputTypeHidden(element, namedNodeMap, messageCollection, string);
                    } else if (string2.equals("range")) {
                        string3 = this.inputTypeRange(element, namedNodeMap, messageCollection, string);
                    } else if (string2.equals("tel") || string2.equals("search") || string2.equals("url") || string2.equals("email") || string2.equals("number")) {
                        string3 = this.inputTypeOther(element, namedNodeMap, messageCollection, string, string2);
                    } else if (string2.equals("date") || string2.equals("time") || string2.equals("color")) {
                        string3 = this.inputTypeText(element, namedNodeMap, messageCollection, string);
                    }
                }
            } else {
                string3 = this.inputTypeText(element, namedNodeMap, messageCollection, string);
            }
            if (OutLoud.jwat_mode == 2) {
                context.setLineDelimiter(true);
                context.setStartSelect(true);
            }
            if (string3 != null) {
                string3 = string3.trim();
                if (DomUtil.isDisabled(element)) {
                    string3 = "(disabled)" + string3;
                }
                return new PacketCollection(new Packet(element, string3, context, true));
            }
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    private String inputTypeImage(Element element, NamedNodeMap namedNodeMap, MessageCollection messageCollection, String string) {
        String string2 = null;
        String string3 = null;
        Node node = namedNodeMap.getNamedItem("alt");
        if (node != null && (string3 = node.getNodeValue()) != null && string3.length() > 0 && (string2 = OutLoud.buildResultString(messageCollection, string, element, "image", "hasstr", "name=str1", string3)) == null) {
            string2 = "[" + string3 + ": Image button.]";
        }
        if (string3 == null) {
            node = namedNodeMap.getNamedItem("src");
            if (node != null) {
                string3 = node.getNodeValue();
                int n = 0;
                int n2 = 0;
                while (n2 < string3.length()) {
                    if (string3.charAt(n2) == '/') {
                        ++n;
                    }
                    ++n2;
                }
                if (n >= 2) {
                    n2 = 0;
                    int n3 = 0;
                    while (n2 < string3.length()) {
                        if (string3.charAt(n2) == '/' && ++n3 == n - 1) {
                            string3 = string3.substring(n2 + 1, string3.length());
                        }
                        ++n2;
                    }
                }
            }
            if (string3 != null && string3.length() > 0) {
                string2 = OutLoud.buildResultString(messageCollection, string, element, "image", "hasstr", "name=str", string3);
                if (string2 == null) {
                    string2 = "[" + string3 + ": Image button.]";
                }
            } else {
                string2 = OutLoud.buildResultString(messageCollection, string, element, "image", "nostr");
                if (string2 == null) {
                    string2 = "[Image button.]";
                }
            }
        }
        return string2;
    }

    private String inputTypeText(Element element, NamedNodeMap namedNodeMap, MessageCollection messageCollection, String string) {
        String string2 = OutLoud.buildResultString(messageCollection, string, element, "text", null);
        if (string2 == null) {
            string2 = "[Text.]";
        }
        return string2;
    }

    private String inputTypeOther(Element element, NamedNodeMap namedNodeMap, MessageCollection messageCollection, String string, String string2) {
        String string3 = null;
        if (string3 == null) {
            string3 = "[" + string2 + ".]";
        }
        return string3;
    }

    private String inputTypeSubmit(Element element, NamedNodeMap namedNodeMap, MessageCollection messageCollection, String string) {
        String string2 = null;
        String string3 = null;
        Node node = namedNodeMap.getNamedItem("VALUE");
        if (node != null) {
            string3 = node.getNodeValue();
        }
        if (string3 != null && string3.length() > 0) {
            string2 = OutLoud.buildResultString(messageCollection, string, element, "submit", "hasstr", "name=str1", string3);
            if (string2 == null) {
                string2 = "[" + string3 + ": Submit button.]";
            }
        } else {
            string2 = OutLoud.buildResultString(messageCollection, string, element, "submit", "nostr");
            if (string2 == null) {
                string2 = "[Submit button.]";
            }
        }
        return string2;
    }

    private String inputTypeReset(Element element, NamedNodeMap namedNodeMap, MessageCollection messageCollection, String string) {
        String string2 = null;
        String string3 = null;
        Node node = namedNodeMap.getNamedItem("VALUE");
        if (node != null) {
            string3 = node.getNodeValue();
        }
        if (string3 != null && string3.length() > 0) {
            string2 = OutLoud.buildResultString(messageCollection, string, element, "reset", "hasstr", "name=str1", string3);
            if (string2 == null) {
                string2 = "[" + string3 + ": Reset button.]";
            }
        } else {
            string2 = OutLoud.buildResultString(messageCollection, string, element, "reset", "nostr");
            if (string2 == null) {
                string2 = "[Reset button.]";
            }
        }
        return string2;
    }

    private String inputTypeButton(Element element, NamedNodeMap namedNodeMap, MessageCollection messageCollection, String string) {
        String string2 = null;
        String string3 = null;
        Node node = namedNodeMap.getNamedItem("VALUE");
        if (node != null) {
            string3 = node.getNodeValue();
        }
        if (string3 != null && string3.length() > 0) {
            string2 = OutLoud.buildResultString(messageCollection, string, element, "button", "hasstr", "name=str1", string3);
            if (string2 == null) {
                string2 = "[" + string3 + ": Button.]";
            }
        } else {
            string2 = OutLoud.buildResultString(messageCollection, string, element, "button", "nostr");
            if (string2 == null) {
                string2 = "[Button.]";
            }
        }
        return string2;
    }

    private String inputTypePassword(Element element, NamedNodeMap namedNodeMap, MessageCollection messageCollection, String string) {
        String string2 = OutLoud.buildResultString(messageCollection, string, element, "password", null);
        if (string2 == null) {
            string2 = "[Password.]";
        }
        return string2;
    }

    private String inputTypeCheckbox(Element element, NamedNodeMap namedNodeMap, MessageCollection messageCollection, String string) {
        String string2 = null;
        Node node = namedNodeMap.getNamedItem("checked");
        if (node == null) {
            string2 = OutLoud.buildResultString(messageCollection, string, element, "checkbox", "off");
            if (string2 == null) {
                string2 = "[Not Checked.]";
            }
        } else {
            string2 = OutLoud.buildResultString(messageCollection, string, element, "checkbox", "on");
            if (string2 == null) {
                string2 = "[Checked.]";
            }
        }
        return string2;
    }

    private String inputTypeRadio(Element element, NamedNodeMap namedNodeMap, MessageCollection messageCollection, String string) {
        String string2 = null;
        Node node = namedNodeMap.getNamedItem("checked");
        if (node == null) {
            string2 = OutLoud.buildResultString(messageCollection, string, element, "radio", "off");
            if (string2 == null) {
                string2 = "[Not Pressed.]";
            }
        } else {
            string2 = OutLoud.buildResultString(messageCollection, string, element, "radio", "on");
            if (string2 == null) {
                string2 = "[Pressed.]";
            }
        }
        return string2;
    }

    private String inputTypeFile(Element element, NamedNodeMap namedNodeMap, MessageCollection messageCollection, String string) {
        String string2 = OutLoud.buildResultString(messageCollection, string, element, "file", null);
        if (string2 == null) {
            string2 = "[Browse button.]";
        }
        return string2;
    }

    private String inputTypeHidden(Element element, NamedNodeMap namedNodeMap, MessageCollection messageCollection, String string) {
        return null;
    }

    private String inputTypeRange(Element element, NamedNodeMap namedNodeMap, MessageCollection messageCollection, String string) {
        String string2 = null;
        String string3 = null;
        Node node = namedNodeMap.getNamedItem("VALUE");
        if (node != null) {
            string3 = node.getNodeValue();
        }
        if (string3 != null && string3.length() > 0) {
            try {
                double d = Double.parseDouble(string3);
                string2 = "[slider:" + d + "]";
            }
            catch (Exception exception) {}
        }
        if (string2 == null) {
            string2 = "[slider]";
        }
        return string2;
    }

    public PacketCollection getPacketCollectionOut(Element element, Context context, String string, MessageCollection messageCollection) {
        this.setContextOut(element, context);
        return null;
    }

    public void setContextIn(Element element, Context context) {
        context.setGoChild(true);
        try {
            NamedNodeMap namedNodeMap = element.getAttributes();
            String string = null;
            Node node = namedNodeMap.getNamedItem("type");
            if (node != null) {
                string = node.getNodeValue();
                if (string.length() > 0) {
                    if (string.equals("submit") || string.equals("reset")) {
                        context.setLineDelimiter(true);
                    } else {
                        context.setLineDelimiter(false);
                    }
                } else {
                    context.setLineDelimiter(false);
                }
            } else {
                context.setLineDelimiter(false);
            }
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
        context.setLinkTag(true);
    }

    public void setContextOut(Element element, Context context) {
        context.setGoChild(true);
        context.setLineDelimiter(true);
        context.setLinkTag(false);
    }
}

