/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.gui.ui.views;

import org.eclipse.actf.accservice.swtbridge.AccessibleObject;
import org.eclipse.actf.ai.voice.IVoice;
import org.eclipse.actf.ai.voice.IVoiceEventListener;
import org.eclipse.actf.ai.voice.VoiceUtil;
import org.eclipse.actf.visualization.gui.IGuiViewIDs;
import org.eclipse.actf.visualization.gui.internal.GuiPlugin;
import org.eclipse.actf.visualization.gui.internal.util.GuiImages;
import org.eclipse.actf.visualization.gui.internal.util.Messages;
import org.eclipse.actf.visualization.gui.internal.util.ScreenReaderRenderer;
import org.eclipse.actf.visualization.gui.internal.util.TextMap;
import org.eclipse.actf.visualization.gui.ui.actions.HideHtmlAction;
import org.eclipse.actf.visualization.gui.ui.actions.RefreshRootAction;
import org.eclipse.actf.visualization.gui.ui.actions.ShowOffscreenAction;
import org.eclipse.actf.visualization.gui.ui.views.AccessibleObjectSelectionProvider;
import org.eclipse.actf.visualization.gui.ui.views.IJAWSTextView;
import org.eclipse.actf.visualization.gui.ui.views.IMSAAOutlineView;
import org.eclipse.actf.visualization.gui.ui.views.MSAAViewRegistory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.part.ViewPart;

public class JAWSTextView
extends ViewPart
implements IJAWSTextView {
    private StyledText text;
    private RefreshRootAction refreshAction;
    private ShowOffscreenAction showOffscreenAction;
    private HideHtmlAction hideHtmlAction;
    private Action speakAction;
    private Action speakAllAction;
    private Action stopAction;
    private Action openPreferencesAction;
    private IPreferenceStore preferenceStore = GuiPlugin.getDefault().getPreferenceStore();
    private TextMap textMap = new TextMap();
    private Point lastSelection = null;
    private boolean ignoreSelection = false;

    public void createPartControl(Composite composite) {
        this.text = new StyledText(composite, 832){

            public void invokeAction(int n) {
                super.invokeAction(n);
            }
        };
        this.text.setEditable(false);
        this.text.setLayout((Layout)new GridLayout());
        this.text.setLayoutData((Object)new GridData());
        this.resetFont();
        this.preferenceStore.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("JAWSTextView_Font".equals(propertyChangeEvent.getProperty())) {
                    JAWSTextView.this.resetFont();
                }
            }
        });
        this.makeActions();
        this.hookContextMenu();
        this.contributeToActionBars();
        MSAAViewRegistory.findView(IGuiViewIDs.ID_OUTLINEVIEW);
        this.refresh();
        this.text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                ScreenReaderRenderer.setBusy(true);
            }

            public void keyReleased(KeyEvent keyEvent) {
                ScreenReaderRenderer.setBusy(true);
                if (13 == keyEvent.keyCode) {
                    JAWSTextView.this.doClick((TypedEvent)keyEvent);
                } else if (32 == keyEvent.keyCode) {
                    JAWSTextView.this.doSelect((TypedEvent)keyEvent);
                } else {
                    JAWSTextView.this.checkSelection((TypedEvent)keyEvent);
                }
            }
        });
        this.text.setDoubleClickEnabled(false);
        this.text.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent mouseEvent) {
                if (1 == mouseEvent.button) {
                    JAWSTextView.this.checkSelection((TypedEvent)mouseEvent);
                }
            }

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                if (1 == mouseEvent.button) {
                    JAWSTextView.this.doClick((TypedEvent)mouseEvent);
                }
            }
        });
        VoiceUtil.getVoice().setEventListener(new IVoiceEventListener(){

            public void indexReceived(final int n) {
                JAWSTextView.this.text.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        JAWSTextView.this.selectLine(n);
                    }
                });
            }
        });
    }

    private void checkSelection(TypedEvent typedEvent) {
        Point point = this.text.getSelection();
        if (!point.equals((Object)this.lastSelection)) {
            IMSAAOutlineView iMSAAOutlineView;
            this.lastSelection = point;
            AccessibleObject accessibleObject = this.textMap.getAccessibleObject(point);
            if (accessibleObject != null && (iMSAAOutlineView = (IMSAAOutlineView)MSAAViewRegistory.findView(IGuiViewIDs.ID_OUTLINEVIEW)) != null) {
                this.ignoreSelection = true;
                try {
                    iMSAAOutlineView.setSelection(accessibleObject);
                }
                finally {
                    this.ignoreSelection = false;
                }
            }
        }
    }

    private void doClick(TypedEvent typedEvent) {
        AccessibleObject accessibleObject = this.getSelectedItem();
        if (accessibleObject != null) {
            accessibleObject.doDefaultAction();
        }
    }

    private void doSelect(TypedEvent typedEvent) {
        AccessibleObject accessibleObject = this.getSelectedItem();
        if (accessibleObject != null) {
            accessibleObject.select(1);
        }
    }

    private AccessibleObject getSelectedItem() {
        return this.textMap.getAccessibleObject(this.text.getSelection());
    }

    private void resetFont() {
        FontData fontData = PreferenceConverter.getFontData((IPreferenceStore)this.preferenceStore, (String)"JAWSTextView_Font");
        this.text.setFont(new Font((Device)this.text.getDisplay(), fontData));
    }

    public void setFocus() {
        this.text.setFocus();
    }

    public void setSelection(AccessibleObject accessibleObject) {
        Point point;
        VoiceUtil.getVoice().stop();
        if (this.ignoreSelection) {
            return;
        }
        if ((accessibleObject = MSAAViewRegistory.adjustSelection(accessibleObject)) != null && (point = this.textMap.getPoint(accessibleObject)) != null) {
            if (point.x == point.y) {
                if (point.x > 0) {
                    --point.x;
                } else if (point.y < this.text.getCharCount()) {
                    ++point.y;
                }
            }
            this.text.setSelection(point.x, point.y);
        }
    }

    public void refresh() {
        AccessibleObject accessibleObject = MSAAViewRegistory.adjustSelection(null);
        VoiceUtil.getVoice().stop();
        if (accessibleObject == null) {
            this.setText(Messages.msaa_jaws_notarget, 16);
        } else {
            new ScreenReaderRenderer(this.text, this.textMap).renderAll(accessibleObject);
        }
    }

    private void setText(String string, int n) {
        this.text.setText(string);
        StyleRange styleRange = new StyleRange();
        styleRange.foreground = Display.getCurrent().getSystemColor(n);
        styleRange.start = 0;
        styleRange.length = this.text.getCharCount();
        this.text.setStyleRange(styleRange);
    }

    private void selectLine(int n) {
        if (-1 == n) {
            Point point = this.text.getSelection();
            if (point.x != point.y) {
                this.text.setSelection(point.y, point.y);
            }
            return;
        }
        int n2 = this.text.getOffsetAtLine(n);
        int n3 = n2 + this.text.getContent().getLine(n).length();
        this.text.setSelection(n2, n3);
    }

    private void hookContextMenu() {
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                JAWSTextView.this.fillContextMenu(iMenuManager);
            }
        });
        Menu menu = menuManager.createContextMenu((Control)this.text);
        this.text.setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)new AccessibleObjectSelectionProvider(){

            public Object getSelectedAccessibleObject() {
                return JAWSTextView.this.getSelectedItem();
            }
        });
    }

    private void contributeToActionBars() {
        IActionBars iActionBars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(iActionBars.getMenuManager());
        this.fillLocalToolBar(iActionBars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager iMenuManager) {
        iMenuManager.add((IAction)this.showOffscreenAction);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)this.hideHtmlAction);
        iMenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                JAWSTextView.this.showOffscreenAction.adjust();
                JAWSTextView.this.hideHtmlAction.adjust();
            }
        });
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)this.openPreferencesAction);
    }

    private void fillContextMenu(IMenuManager iMenuManager) {
        iMenuManager.add((IAction)this.speakAction);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)this.speakAllAction);
        iMenuManager.add((IAction)this.stopAction);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)this.refreshAction);
        iMenuManager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager iToolBarManager) {
        iToolBarManager.add((IAction)this.refreshAction);
        iToolBarManager.add((IAction)this.speakAllAction);
        iToolBarManager.add((IAction)this.stopAction);
    }

    private void makeActions() {
        this.refreshAction = new RefreshRootAction();
        this.showOffscreenAction = new ShowOffscreenAction();
        this.hideHtmlAction = new HideHtmlAction();
        this.speakAction = new Action(Messages.msaa_speak_here){

            public void run() {
                IVoice iVoice = VoiceUtil.getVoice();
                try {
                    int n;
                    iVoice.stop();
                    int n2 = JAWSTextView.this.text.getLineCount();
                    int n3 = ((JAWSTextView)JAWSTextView.this).text.getSelection().x;
                    int n4 = n = JAWSTextView.this.text.getLineAtOffset(n3);
                    while (n4 < n2) {
                        iVoice.speak(JAWSTextView.this.text.getContent().getLine(n4), false, n4);
                        ++n4;
                    }
                }
                catch (Exception exception) {}
            }
        };
        this.speakAllAction = new Action(Messages.msaa_speak){

            public void run() {
                JAWSTextView.this.text.setCaretOffset(0);
                JAWSTextView.this.speakAction.run();
            }
        };
        this.speakAllAction.setToolTipText(Messages.msaa_speak_tip);
        this.speakAllAction.setImageDescriptor(GuiImages.IMAGE_SPEAK);
        this.stopAction = new Action(Messages.msaa_stop){

            public void run() {
                VoiceUtil.getVoice().stop();
                JAWSTextView.this.selectLine(-1);
            }
        };
        this.stopAction.setToolTipText(Messages.msaa_stop_tip);
        this.stopAction.setImageDescriptor(GuiImages.IMAGE_STOP);
        final Shell shell = this.getViewSite().getShell();
        this.openPreferencesAction = new Action(Messages.msaa_preferences){

            public void run() {
                PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)"org.eclipse.actf.visualization.gui.preferences.GuiPreferencePage", null, null).open();
            }
        };
    }
}

