/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.registry;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.internal.registry.ConfigurationElement;
import org.eclipse.core.internal.registry.ConfigurationElementHandle;
import org.eclipse.core.internal.registry.ConfigurationElementMulti;
import org.eclipse.core.internal.registry.Contribution;
import org.eclipse.core.internal.registry.ExtensionHandle;
import org.eclipse.core.internal.registry.ExtensionPoint;
import org.eclipse.core.internal.registry.ExtensionPointHandle;
import org.eclipse.core.internal.registry.ExtensionRegistry;
import org.eclipse.core.internal.registry.KeyedElement;
import org.eclipse.core.internal.registry.KeyedHashSet;
import org.eclipse.core.internal.registry.OffsetTable;
import org.eclipse.core.internal.registry.RegistryIndexElement;
import org.eclipse.core.internal.registry.RegistryMessages;
import org.eclipse.core.internal.registry.RegistryObjectManager;
import org.eclipse.core.internal.registry.RegistryProperties;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.spi.RegistryContributor;

public class TableWriter {
    private static final byte fileError = 0;
    File mainDataFile;
    File extraDataFile;
    File tableFile;
    File contributionsFile;
    File contributorsFile;
    File namespacesFile;
    File orphansFile;
    DataOutputStream mainOutput;
    DataOutputStream extraOutput;
    FileOutputStream mainFileOutput = null;
    FileOutputStream extraFileOutput = null;
    private OffsetTable offsets;
    private final ExtensionRegistry registry;
    private RegistryObjectManager objectManager;

    void setMainDataFile(File main) {
        this.mainDataFile = main;
    }

    void setExtraDataFile(File extra) {
        this.extraDataFile = extra;
    }

    void setTableFile(File table) {
        this.tableFile = table;
    }

    void setContributionsFile(File fileName) {
        this.contributionsFile = fileName;
    }

    void setContributorsFile(File fileName) {
        this.contributorsFile = fileName;
    }

    void setNamespacesFile(File fileName) {
        this.namespacesFile = fileName;
    }

    void setOrphansFile(File orphan) {
        this.orphansFile = orphan;
    }

    public TableWriter(ExtensionRegistry registry) {
        this.registry = registry;
    }

    private int getExtraDataPosition() {
        return this.extraOutput.size();
    }

    public boolean saveCache(RegistryObjectManager objectManager, long timestamp) {
        this.objectManager = objectManager;
        try {
            if (!this.openFiles()) {
                return false;
            }
            try {
                this.saveExtensionRegistry(timestamp);
            }
            catch (IOException io) {
                this.log(new Status(4, "org.eclipse.equinox.registry", 0, RegistryMessages.meta_registryCacheWriteProblems, (Throwable)io));
                this.closeFiles();
                return false;
            }
        }
        finally {
            this.closeFiles();
        }
        return true;
    }

    private boolean openFiles() {
        try {
            this.mainFileOutput = new FileOutputStream(this.mainDataFile);
            this.mainOutput = new DataOutputStream(new BufferedOutputStream(this.mainFileOutput));
            this.extraFileOutput = new FileOutputStream(this.extraDataFile);
            this.extraOutput = new DataOutputStream(new BufferedOutputStream(this.extraFileOutput));
        }
        catch (FileNotFoundException e) {
            if (this.mainFileOutput != null) {
                try {
                    this.mainFileOutput.close();
                }
                catch (IOException iOException) {}
            }
            this.log(new Status(4, "org.eclipse.equinox.registry", 0, RegistryMessages.meta_unableToCreateCache, (Throwable)e));
            return false;
        }
        return true;
    }

    private void closeFiles() {
        try {
            if (this.mainOutput != null) {
                this.mainOutput.flush();
                if (this.mainFileOutput.getFD().valid()) {
                    this.mainFileOutput.getFD().sync();
                }
                this.mainOutput.close();
            }
        }
        catch (IOException e) {
            this.log(new Status(4, "org.eclipse.equinox.registry", 0, RegistryMessages.meta_registryCacheWriteProblems, (Throwable)e));
            e.printStackTrace();
        }
        try {
            if (this.extraOutput != null) {
                this.extraOutput.flush();
                if (this.extraFileOutput.getFD().valid()) {
                    this.extraFileOutput.getFD().sync();
                }
                this.extraOutput.close();
            }
        }
        catch (IOException e) {
            this.log(new Status(4, "org.eclipse.equinox.registry", 0, RegistryMessages.meta_registryCacheWriteProblems, (Throwable)e));
            e.printStackTrace();
        }
    }

    private void saveExtensionRegistry(long timestamp) throws IOException {
        ExtensionPointHandle[] points = this.objectManager.getExtensionPointsHandles();
        this.offsets = new OffsetTable(this.objectManager.getNextId());
        ExtensionPointHandle[] extensionPointHandleArray = points;
        int n = points.length;
        int n2 = 0;
        while (n2 < n) {
            ExtensionPointHandle point = extensionPointHandleArray[n2];
            this.saveExtensionPoint(point);
            ++n2;
        }
        this.saveOrphans();
        this.saveContributions(this.objectManager.getContributions());
        this.saveContributors(this.objectManager.getContributors());
        this.saveNamespaces(this.objectManager.getNamespacesIndex());
        this.closeFiles();
        this.saveTables(timestamp);
    }

    private void saveContributions(KeyedHashSet[] contributions) throws IOException {
        Contribution element;
        KeyedElement formerElement;
        KeyedElement newElement;
        FileOutputStream fosNamespace = new FileOutputStream(this.contributionsFile);
        DataOutputStream outputNamespace = new DataOutputStream(new BufferedOutputStream(fosNamespace));
        KeyedElement[] newElements = contributions[0].elements();
        KeyedElement[] formerElements = contributions[1].elements();
        int cacheSize = 0;
        KeyedElement[] keyedElementArray = newElements;
        int n = newElements.length;
        int n2 = 0;
        while (n2 < n) {
            newElement = keyedElementArray[n2];
            if (((Contribution)newElement).shouldPersist()) {
                ++cacheSize;
            }
            ++n2;
        }
        keyedElementArray = formerElements;
        n = formerElements.length;
        n2 = 0;
        while (n2 < n) {
            formerElement = keyedElementArray[n2];
            if (((Contribution)formerElement).shouldPersist()) {
                ++cacheSize;
            }
            ++n2;
        }
        outputNamespace.writeInt(cacheSize);
        keyedElementArray = newElements;
        n = newElements.length;
        n2 = 0;
        while (n2 < n) {
            newElement = keyedElementArray[n2];
            element = (Contribution)newElement;
            if (element.shouldPersist()) {
                this.writeStringOrNull(element.getContributorId(), outputNamespace);
                this.saveArray(this.filterContributionChildren(element), outputNamespace);
            }
            ++n2;
        }
        keyedElementArray = formerElements;
        n = formerElements.length;
        n2 = 0;
        while (n2 < n) {
            formerElement = keyedElementArray[n2];
            element = (Contribution)formerElement;
            if (element.shouldPersist()) {
                this.writeStringOrNull(element.getContributorId(), outputNamespace);
                this.saveArray(this.filterContributionChildren(element), outputNamespace);
            }
            ++n2;
        }
        outputNamespace.flush();
        fosNamespace.getFD().sync();
        outputNamespace.close();
    }

    private int[] filterContributionChildren(Contribution element) {
        int[] extensionPoints = this.filter(element.getExtensionPoints());
        int[] extensions = this.filter(element.getExtensions());
        int[] filteredRawChildren = new int[2 + extensionPoints.length + extensions.length];
        System.arraycopy(extensionPoints, 0, filteredRawChildren, 2, extensionPoints.length);
        System.arraycopy(extensions, 0, filteredRawChildren, 2 + extensionPoints.length, extensions.length);
        filteredRawChildren[0] = extensionPoints.length;
        filteredRawChildren[1] = extensions.length;
        return filteredRawChildren;
    }

    private void saveNamespaces(KeyedHashSet namespacesIndex) throws IOException {
        FileOutputStream fosNamespace = new FileOutputStream(this.namespacesFile);
        DataOutputStream outputNamespace = new DataOutputStream(new BufferedOutputStream(fosNamespace));
        KeyedElement[] elements = namespacesIndex.elements();
        KeyedElement[] cachedElements = new KeyedElement[elements.length];
        int cacheSize = 0;
        KeyedElement[] keyedElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            KeyedElement e = keyedElementArray[n2];
            RegistryIndexElement element = (RegistryIndexElement)e;
            int[] extensionPoints = this.filter(element.getExtensionPoints());
            int[] extensions = this.filter(element.getExtensions());
            if (extensionPoints.length != 0 || extensions.length != 0) {
                RegistryIndexElement cachedElement = new RegistryIndexElement((String)element.getKey(), extensionPoints, extensions);
                cachedElements[cacheSize] = cachedElement;
                ++cacheSize;
            }
            ++n2;
        }
        outputNamespace.writeInt(cacheSize);
        int i = 0;
        while (i < cacheSize) {
            RegistryIndexElement element = (RegistryIndexElement)cachedElements[i];
            this.writeStringOrNull((String)element.getKey(), outputNamespace);
            this.saveArray(element.getExtensionPoints(), outputNamespace);
            this.saveArray(element.getExtensions(), outputNamespace);
            ++i;
        }
        outputNamespace.flush();
        fosNamespace.getFD().sync();
        outputNamespace.close();
    }

    private void saveContributors(HashMap<?, ?> contributors) throws IOException {
        FileOutputStream fosContributors = new FileOutputStream(this.contributorsFile);
        DataOutputStream outputContributors = new DataOutputStream(new BufferedOutputStream(fosContributors));
        Collection<?> entries = contributors.values();
        outputContributors.writeInt(entries.size());
        for (Object entry : entries) {
            RegistryContributor contributor = (RegistryContributor)entry;
            this.writeStringOrNull(contributor.getActualId(), outputContributors);
            this.writeStringOrNull(contributor.getActualName(), outputContributors);
            this.writeStringOrNull(contributor.getId(), outputContributors);
            this.writeStringOrNull(contributor.getName(), outputContributors);
        }
        outputContributors.flush();
        fosContributors.getFD().sync();
        outputContributors.close();
    }

    private void saveTables(long registryTimeStamp) throws IOException {
        FileOutputStream fosTable = new FileOutputStream(this.tableFile);
        DataOutputStream outputTable = new DataOutputStream(new BufferedOutputStream(fosTable));
        this.writeCacheHeader(outputTable, registryTimeStamp);
        outputTable.writeInt(this.objectManager.getNextId());
        this.offsets.save(outputTable);
        this.objectManager.getExtensionPoints().save(outputTable, this.objectManager);
        outputTable.flush();
        fosTable.getFD().sync();
        outputTable.close();
    }

    private void writeCacheHeader(DataOutputStream output, long registryTimeStamp) throws IOException {
        output.writeInt(8);
        output.writeLong(this.registry.computeState());
        output.writeLong(registryTimeStamp);
        output.writeLong(this.mainDataFile.length());
        output.writeLong(this.extraDataFile.length());
        output.writeLong(this.contributionsFile.length());
        output.writeLong(this.contributorsFile.length());
        output.writeLong(this.namespacesFile.length());
        output.writeLong(this.orphansFile.length());
        output.writeUTF(RegistryProperties.getProperty("osgi.os", ""));
        output.writeUTF(RegistryProperties.getProperty("osgi.ws", ""));
        output.writeUTF(RegistryProperties.getProperty("osgi.nl", ""));
        output.writeBoolean(this.registry.isMultiLanguage());
    }

    private void saveArray(int[] array, DataOutputStream out) throws IOException {
        if (array == null) {
            out.writeInt(0);
            return;
        }
        out.writeInt(array.length);
        int[] nArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            int element = nArray[n2];
            out.writeInt(element);
            ++n2;
        }
    }

    private void saveExtensionPoint(ExtensionPointHandle xpt) throws IOException {
        if (!xpt.shouldPersist()) {
            return;
        }
        this.offsets.put(xpt.getId(), this.mainOutput.size());
        this.mainOutput.writeInt(xpt.getId());
        this.saveArray(this.filter(xpt.getObject().getRawChildren()), this.mainOutput);
        this.mainOutput.writeInt(this.getExtraDataPosition());
        this.saveExtensionPointData(xpt);
        this.saveExtensions(xpt.getExtensions(), this.mainOutput);
    }

    private void saveExtension(ExtensionHandle ext, DataOutputStream outputStream) throws IOException {
        if (!ext.shouldPersist()) {
            return;
        }
        this.offsets.put(ext.getId(), outputStream.size());
        outputStream.writeInt(ext.getId());
        this.writeStringOrNull(ext.getSimpleIdentifier(), outputStream);
        this.writeStringOrNull(ext.getNamespaceIdentifier(), outputStream);
        this.saveArray(this.filter(ext.getObject().getRawChildren()), outputStream);
        outputStream.writeInt(this.getExtraDataPosition());
        this.saveExtensionData(ext);
    }

    private void writeStringArray(String[] array, DataOutputStream outputStream) throws IOException {
        outputStream.writeInt(array == null ? 0 : array.length);
        int i = 0;
        while (i < (array == null ? 0 : array.length)) {
            this.writeStringOrNull(array[i], outputStream);
            ++i;
        }
    }

    private void writeStringArray(String[] array, int size, DataOutputStream outputStream) throws IOException {
        outputStream.writeInt(array == null ? 0 : size);
        if (array == null) {
            return;
        }
        int i = 0;
        while (i < size) {
            this.writeStringOrNull(array[i], outputStream);
            ++i;
        }
    }

    private void saveConfigurationElement(ConfigurationElementHandle element, DataOutputStream outputStream, DataOutputStream extraOutputStream, int depth) throws IOException {
        ConfigurationElementHandle[] childrenCEs;
        if (!element.shouldPersist()) {
            return;
        }
        DataOutputStream currentOutput = outputStream;
        if (depth > 2) {
            currentOutput = extraOutputStream;
        }
        this.offsets.put(element.getId(), currentOutput.size());
        currentOutput.writeInt(element.getId());
        ConfigurationElement actualCe = (ConfigurationElement)element.getObject();
        this.writeStringOrNull(actualCe.getContributorId(), currentOutput);
        this.writeStringOrNull(actualCe.getName(), currentOutput);
        currentOutput.writeInt(actualCe.parentId);
        currentOutput.writeByte(actualCe.parentType);
        currentOutput.writeInt(depth > 1 ? extraOutputStream.size() : -1);
        this.writeStringArray(actualCe.getPropertiesAndValue(), currentOutput);
        this.saveArray(this.filter(actualCe.getRawChildren()), currentOutput);
        if (actualCe instanceof ConfigurationElementMulti) {
            ConfigurationElementMulti multiCE = (ConfigurationElementMulti)actualCe;
            int NLs = multiCE.getNumCachedLocales();
            currentOutput.writeInt(NLs);
            if (NLs != 0) {
                this.writeStringArray(multiCE.getCachedLocales(), NLs, currentOutput);
                String[][] translated = multiCE.getCachedTranslations();
                int i = 0;
                while (i < NLs) {
                    this.writeStringArray(translated[i], currentOutput);
                    ++i;
                }
            }
        }
        ConfigurationElementHandle[] configurationElementHandleArray = childrenCEs = (ConfigurationElementHandle[])element.getChildren();
        int n = childrenCEs.length;
        int n2 = 0;
        while (n2 < n) {
            ConfigurationElementHandle childrenCE = configurationElementHandleArray[n2];
            this.saveConfigurationElement(childrenCE, outputStream, extraOutputStream, depth + 1);
            ++n2;
        }
    }

    private void saveExtensions(IExtension[] exts, DataOutputStream outputStream) throws IOException {
        IExtension ext;
        IExtension[] iExtensionArray = exts;
        int n = exts.length;
        int n2 = 0;
        while (n2 < n) {
            ext = iExtensionArray[n2];
            this.saveExtension((ExtensionHandle)ext, outputStream);
            ++n2;
        }
        iExtensionArray = exts;
        n = exts.length;
        n2 = 0;
        while (n2 < n) {
            ext = iExtensionArray[n2];
            if (((ExtensionHandle)ext).shouldPersist()) {
                IConfigurationElement[] ces = ext.getConfigurationElements();
                int countCElements = 0;
                boolean[] save = new boolean[ces.length];
                int j = 0;
                while (j < ces.length) {
                    if (((ConfigurationElementHandle)ces[j]).shouldPersist()) {
                        save[j] = true;
                        ++countCElements;
                    } else {
                        save[j] = false;
                    }
                    ++j;
                }
                outputStream.writeInt(countCElements);
                j = 0;
                while (j < ces.length) {
                    if (save[j]) {
                        this.saveConfigurationElement((ConfigurationElementHandle)ces[j], outputStream, this.extraOutput, 1);
                    }
                    ++j;
                }
            }
            ++n2;
        }
    }

    private void saveExtensionPointData(ExtensionPointHandle xpt) throws IOException {
        this.writeStringOrNull(xpt.getLabelAsIs(), this.extraOutput);
        this.writeStringOrNull(xpt.getSchemaReference(), this.extraOutput);
        this.writeStringOrNull(xpt.getUniqueIdentifier(), this.extraOutput);
        this.writeStringOrNull(xpt.getNamespaceIdentifier(), this.extraOutput);
        this.writeStringOrNull(((ExtensionPoint)xpt.getObject()).getContributorId(), this.extraOutput);
    }

    private void saveExtensionData(ExtensionHandle extension) throws IOException {
        this.writeStringOrNull(extension.getLabelAsIs(), this.extraOutput);
        this.writeStringOrNull(extension.getExtensionPointUniqueIdentifier(), this.extraOutput);
        this.writeStringOrNull(extension.getContributorId(), this.extraOutput);
    }

    private void writeStringOrNull(String string, DataOutputStream out) throws IOException {
        if (string == null) {
            out.writeByte(0);
        } else {
            byte[] data = string.getBytes(StandardCharsets.UTF_8);
            if (data.length > 65535) {
                out.writeByte(2);
                out.writeInt(data.length);
                out.write(data);
            } else {
                out.writeByte(1);
                out.writeUTF(string);
            }
        }
    }

    private void saveOrphans() throws IOException {
        Map<String, int[]> orphans = this.objectManager.getOrphanExtensions();
        HashMap<String, int[]> filteredOrphans = new HashMap<String, int[]>();
        for (Map.Entry<String, int[]> entry : orphans.entrySet()) {
            int[] filteredValue = this.filter(entry.getValue());
            if (filteredValue.length == 0) continue;
            filteredOrphans.put(entry.getKey(), filteredValue);
        }
        FileOutputStream fosOrphan = new FileOutputStream(this.orphansFile);
        DataOutputStream outputOrphan = new DataOutputStream(new BufferedOutputStream(fosOrphan));
        outputOrphan.writeInt(filteredOrphans.size());
        Set elements = filteredOrphans.entrySet();
        for (Map.Entry entry : elements) {
            outputOrphan.writeUTF((String)entry.getKey());
            this.saveArray((int[])entry.getValue(), outputOrphan);
        }
        for (Map.Entry entry : elements) {
            this.mainOutput.writeInt(((int[])entry.getValue()).length);
            this.saveExtensions((IExtension[])this.objectManager.getHandles((int[])entry.getValue(), (byte)2), this.mainOutput);
        }
        outputOrphan.flush();
        fosOrphan.getFD().sync();
        outputOrphan.close();
    }

    private void log(Status status) {
        this.registry.log((IStatus)status);
    }

    private int[] filter(int[] input) {
        boolean[] save = new boolean[input.length];
        int resultSize = 0;
        int i = 0;
        while (i < input.length) {
            if (this.objectManager.shouldPersist(input[i])) {
                save[i] = true;
                ++resultSize;
            } else {
                save[i] = false;
            }
            ++i;
        }
        int[] result = new int[resultSize];
        int pos = 0;
        int i2 = 0;
        while (i2 < input.length) {
            if (save[i2]) {
                result[pos] = input[i2];
                ++pos;
            }
            ++i2;
        }
        return result;
    }
}

