/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.sail.shacl.SourceConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ValidationSettings;
import org.eclipse.rdf4j.sail.shacl.ast.ShaclUnsupportedException;
import org.eclipse.rdf4j.sail.shacl.ast.SparqlFragment;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.ValidationApproach;
import org.eclipse.rdf4j.sail.shacl.ast.ValidationQuery;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.AbstractConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.paths.Path;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.AbstractBulkJoinPlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.AllTargetsPlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.BufferedPlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.BulkedExternalInnerJoin;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.EmptyNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.FilterPlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.InnerJoin;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeProvider;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ShiftToPropertyShape;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.UnBufferedPlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.UnionNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.Unique;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;
import org.eclipse.rdf4j.sail.shacl.ast.targets.EffectiveTarget;
import org.eclipse.rdf4j.sail.shacl.ast.targets.TargetChain;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.ConnectionsGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSimpleConstraintComponent
extends AbstractConstraintComponent {
    private static final Logger logger = LoggerFactory.getLogger(AbstractSimpleConstraintComponent.class);
    private Resource id;
    TargetChain targetChain;

    public AbstractSimpleConstraintComponent(Resource id) {
        this.id = id;
    }

    public AbstractSimpleConstraintComponent() {
    }

    @Override
    public Resource getId() {
        return this.id;
    }

    @Override
    public TargetChain getTargetChain() {
        return this.targetChain;
    }

    @Override
    public void setTargetChain(TargetChain targetChain) {
        this.targetChain = targetChain;
    }

    @Override
    public PlanNode generateTransactionalValidationPlan(ConnectionsGroup connectionsGroup, ValidationSettings validationSettings, PlanNodeProvider overrideTargetNode, ConstraintComponent.Scope scope) {
        boolean negatePlan = false;
        StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider = new StatementMatcher.StableRandomVariableProvider();
        EffectiveTarget effectiveTarget = this.targetChain.getEffectiveTarget(scope, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider);
        Optional<Path> path = this.targetChain.getPath();
        if (overrideTargetNode != null) {
            return this.getPlanNodeForOverrideTargetNode(connectionsGroup, validationSettings, overrideTargetNode, scope, negatePlan, stableRandomVariableProvider, effectiveTarget, path);
        }
        if (scope == ConstraintComponent.Scope.nodeShape) {
            return effectiveTarget.getPlanNode(connectionsGroup, validationSettings.getDataGraph(), scope, false, p -> this.getFilterAttacherWithNegation(negatePlan, (PlanNode)p, connectionsGroup));
        }
        PlanNode invalidValuesDirectOnPath = path.get().getAnyAdded(connectionsGroup, validationSettings.getDataGraph(), planNode -> this.getFilterAttacherWithNegation(negatePlan, (PlanNode)planNode, connectionsGroup));
        PlanNode addedTargets = effectiveTarget.getPlanNode(connectionsGroup, validationSettings.getDataGraph(), scope, false, null);
        InnerJoin innerJoin = new InnerJoin(addedTargets, invalidValuesDirectOnPath, connectionsGroup);
        if (connectionsGroup.getStats().wasEmptyBeforeTransaction()) {
            return innerJoin.getJoined(UnBufferedPlanNode.class);
        }
        PlanNode top = innerJoin.getJoined(BufferedPlanNode.class);
        PlanNode discardedRight = innerJoin.getDiscardedRight(BufferedPlanNode.class);
        PlanNode typeFilterPlan = effectiveTarget.getTargetFilter(connectionsGroup, validationSettings.getDataGraph(), discardedRight);
        typeFilterPlan = effectiveTarget.extend(typeFilterPlan, connectionsGroup, validationSettings.getDataGraph(), scope, EffectiveTarget.Extend.left, true, null);
        top = UnionNode.getInstance(connectionsGroup, top, typeFilterPlan);
        BulkedExternalInnerJoin bulkedExternalInnerJoin = new BulkedExternalInnerJoin(effectiveTarget.getPlanNode(connectionsGroup, validationSettings.getDataGraph(), scope, false, null), connectionsGroup.getBaseConnection(), validationSettings.getDataGraph(), path.get().getTargetQueryFragment(new StatementMatcher.Variable("a"), new StatementMatcher.Variable("c"), connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider, Set.of()), connectionsGroup.hasPreviousStateConnection(), connectionsGroup.getPreviousStateConnection(), b -> new ValidationTuple(b.getValue("a"), b.getValue("c"), scope, true, validationSettings.getDataGraph()), connectionsGroup, AbstractBulkJoinPlanNode.DEFAULT_VARS);
        top = UnionNode.getInstance(connectionsGroup, top, bulkedExternalInnerJoin);
        return this.getFilterAttacherWithNegation(negatePlan, top, connectionsGroup);
    }

    private PlanNode getPlanNodeForOverrideTargetNode(ConnectionsGroup connectionsGroup, ValidationSettings validationSettings, PlanNodeProvider overrideTargetNode, ConstraintComponent.Scope scope, boolean negatePlan, StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider, EffectiveTarget effectiveTarget, Optional<Path> path) {
        if (scope == ConstraintComponent.Scope.nodeShape) {
            PlanNode overrideTargetPlanNode = overrideTargetNode.getPlanNode();
            if (overrideTargetPlanNode instanceof AllTargetsPlanNode) {
                PlanNode allTargets = effectiveTarget.getAllTargets(connectionsGroup, validationSettings.getDataGraph(), scope);
                allTargets = this.getFilterAttacherWithNegation(negatePlan, allTargets, connectionsGroup);
                if (effectiveTarget.size() > 1) {
                    allTargets = Unique.getInstance(allTargets, true, connectionsGroup);
                }
                return allTargets;
            }
            PlanNode extend = effectiveTarget.extend(overrideTargetPlanNode, connectionsGroup, validationSettings.getDataGraph(), scope, EffectiveTarget.Extend.right, false, p -> this.getFilterAttacherWithNegation(negatePlan, (PlanNode)p, connectionsGroup));
            if (effectiveTarget.size() > 1) {
                extend = Unique.getInstance(extend, true, connectionsGroup);
            }
            return extend;
        }
        PlanNode overrideTargetPlanNode = overrideTargetNode.getPlanNode();
        if (overrideTargetPlanNode instanceof AllTargetsPlanNode) {
            PlanNode allTargets = this.targetChain.getEffectiveTarget(ConstraintComponent.Scope.nodeShape, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider).getAllTargets(connectionsGroup, validationSettings.getDataGraph(), ConstraintComponent.Scope.nodeShape);
            allTargets = new ShiftToPropertyShape(allTargets, connectionsGroup);
            allTargets = this.getFilterAttacherWithNegation(negatePlan, allTargets, connectionsGroup);
            if (effectiveTarget.size() > 1) {
                allTargets = Unique.getInstance(allTargets, true, connectionsGroup);
            }
            return allTargets;
        }
        overrideTargetPlanNode = effectiveTarget.extend(overrideTargetPlanNode, connectionsGroup, validationSettings.getDataGraph(), scope, EffectiveTarget.Extend.right, false, null);
        if (effectiveTarget.size() > 1) {
            overrideTargetPlanNode = Unique.getInstance(overrideTargetPlanNode, true, connectionsGroup);
        }
        PlanNode planNode = new BulkedExternalInnerJoin(overrideTargetPlanNode, connectionsGroup.getBaseConnection(), validationSettings.getDataGraph(), path.get().getTargetQueryFragment(new StatementMatcher.Variable("a"), new StatementMatcher.Variable("c"), connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider, Set.of()), false, null, BulkedExternalInnerJoin.getMapper("a", "c", scope, validationSettings.getDataGraph()), connectionsGroup, AbstractBulkJoinPlanNode.DEFAULT_VARS);
        planNode = connectionsGroup.getCachedNodeFor(planNode);
        return this.getFilterAttacherWithNegation(negatePlan, planNode, connectionsGroup);
    }

    @Override
    public ValidationQuery generateSparqlValidationQuery(ConnectionsGroup connectionsGroup, ValidationSettings validationSettings, boolean negatePlan, boolean negateChildren, ConstraintComponent.Scope scope) {
        StatementMatcher.Variable<Value> value;
        StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider = new StatementMatcher.StableRandomVariableProvider();
        EffectiveTarget effectiveTarget = this.targetChain.getEffectiveTarget(scope, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider);
        Object query = effectiveTarget.getQuery(false);
        if (scope == ConstraintComponent.Scope.nodeShape) {
            value = null;
            query = (String)query + "\n" + this.getSparqlFilter(negatePlan, effectiveTarget.getTargetVar(), stableRandomVariableProvider);
        } else {
            value = StatementMatcher.Variable.VALUE;
            Optional<SparqlFragment> sparqlFragment = this.targetChain.getPath().map(p -> p.getTargetQueryFragment(effectiveTarget.getTargetVar(), value, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider, Set.of()));
            String pathQuery = sparqlFragment.map(SparqlFragment::getFragment).orElseThrow(IllegalStateException::new);
            query = (String)query + "\n" + pathQuery;
            query = (String)query + "\n" + this.getSparqlFilter(negatePlan, value, stableRandomVariableProvider);
        }
        List<StatementMatcher.Variable<Value>> allTargetVariables = effectiveTarget.getAllTargetVariables();
        return new ValidationQuery(this.getTargetChain().getNamespaces(), (String)query, allTargetVariables, value, scope, this, null, null);
    }

    private String getSparqlFilter(boolean negatePlan, StatementMatcher.Variable<Value> variable, StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider) {
        assert (!negatePlan) : "This code has not been tested with negated plans! Should be still coalesce to true?";
        String tempVar = stableRandomVariableProvider.next().asSparqlVariable();
        return String.join((CharSequence)"\n", "BIND((" + this.getSparqlFilterExpression(variable, negatePlan) + ") as " + tempVar + ")", "FILTER(COALESCE(" + tempVar + ", true))");
    }

    abstract String getSparqlFilterExpression(StatementMatcher.Variable<Value> var1, boolean var2);

    private PlanNode getFilterAttacherWithNegation(boolean negatePlan, PlanNode allTargets, ConnectionsGroup connectionsGroup) {
        allTargets = negatePlan ? this.getFilterAttacher(connectionsGroup).apply(allTargets).getTrueNode(UnBufferedPlanNode.class) : this.getFilterAttacher(connectionsGroup).apply(allTargets).getFalseNode(UnBufferedPlanNode.class);
        return allTargets;
    }

    @Override
    public ValidationApproach getPreferredValidationApproach(ConnectionsGroup connectionsGroup) {
        return ValidationApproach.Transactional;
    }

    @Override
    public ValidationApproach getOptimalBulkValidationApproach() {
        return ValidationApproach.SPARQL;
    }

    @Override
    public SourceConstraintComponent getConstraintComponent() {
        throw new ShaclUnsupportedException(this.getClass().getSimpleName());
    }

    abstract Function<PlanNode, FilterPlanNode> getFilterAttacher(ConnectionsGroup var1);

    String literalToString(Literal literal) {
        IRI datatype = literal.getDatatype();
        if (datatype == null) {
            return "\"" + literal.stringValue() + "\"";
        }
        if (literal.getLanguage().isPresent()) {
            return "\"" + literal.stringValue() + "\"@" + (String)literal.getLanguage().get();
        }
        return "\"" + literal.stringValue() + "\"^^<" + datatype.stringValue() + ">";
    }

    @Override
    public PlanNode getAllTargetsPlan(ConnectionsGroup connectionsGroup, Resource[] dataGraph, ConstraintComponent.Scope scope, StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider, ValidationSettings validationSettings) {
        if (scope == ConstraintComponent.Scope.propertyShape) {
            EffectiveTarget effectiveTarget = this.getTargetChain().getEffectiveTarget(ConstraintComponent.Scope.nodeShape, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider);
            PlanNode allTargetsPlan = effectiveTarget.getPlanNode(connectionsGroup, dataGraph, ConstraintComponent.Scope.nodeShape, true, null);
            return Unique.getInstance(new ShiftToPropertyShape(allTargetsPlan, connectionsGroup), effectiveTarget.size() > 1, connectionsGroup);
        }
        return EmptyNode.getInstance();
    }
}

