/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.spin.function;

import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.vocabulary.SPL;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryPreparer;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.Function;
import org.eclipse.rdf4j.spin.function.AbstractSpinFunction;

public class ObjectFunction
extends AbstractSpinFunction
implements Function {
    public ObjectFunction() {
        super(SPL.OBJECT_FUNCTION.toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Value evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        QueryPreparer qp = this.getCurrentQueryPreparer();
        if (args.length != 2) {
            throw new ValueExprEvaluationException(String.format("%s requires 2 arguments, got %d", this.getURI(), args.length));
        }
        Value subj = args[0];
        if (!(subj instanceof Resource)) {
            throw new ValueExprEvaluationException("First argument must be a subject");
        }
        Value pred = args[1];
        if (!(pred instanceof IRI)) {
            throw new ValueExprEvaluationException("Second argument must be a predicate");
        }
        try (CloseableIteration<? extends Statement> stmts = qp.getTripleSource().getStatements((Resource)subj, (IRI)pred, null, new Resource[0]);){
            if (!stmts.hasNext()) throw new ValueExprEvaluationException("No value");
            Value value = ((Statement)stmts.next()).getObject();
            return value;
        }
        catch (QueryEvaluationException e) {
            throw new ValueExprEvaluationException(e);
        }
    }
}

