/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.Formatter;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.LoggingCloseableIteration;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeHelper;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationExecutionLogger;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;

public class SetFilterNode
implements PlanNode {
    private final Set<Value> targetNodeList;
    private final PlanNode parent;
    private final int index;
    private final boolean returnValid;
    private boolean printed;
    private ValidationExecutionLogger validationExecutionLogger;

    public SetFilterNode(Set<Value> targetNodeList, PlanNode parent, int index, boolean returnValid) {
        this.parent = PlanNodeHelper.handleSorting(this, parent);
        this.targetNodeList = targetNodeList;
        this.index = index;
        this.returnValid = returnValid;
    }

    @Override
    public CloseableIteration<? extends ValidationTuple> iterator() {
        return new LoggingCloseableIteration(this, this.validationExecutionLogger){
            private CloseableIteration<? extends ValidationTuple> parentIterator;
            ValidationTuple next;

            @Override
            protected void init() {
                this.parentIterator = SetFilterNode.this.parent.iterator();
            }

            private void calulateNext() {
                while (this.next == null && this.parentIterator.hasNext()) {
                    ValidationTuple temp = (ValidationTuple)this.parentIterator.next();
                    boolean contains = SetFilterNode.this.targetNodeList.contains(temp.getActiveTarget());
                    if (SetFilterNode.this.returnValid && contains) {
                        this.next = temp;
                        continue;
                    }
                    if (SetFilterNode.this.returnValid || contains) continue;
                    this.next = temp;
                }
            }

            @Override
            public void localClose() {
                if (this.parentIterator != null) {
                    this.parentIterator.close();
                }
            }

            @Override
            protected boolean localHasNext() {
                this.calulateNext();
                return this.next != null;
            }

            @Override
            protected ValidationTuple loggingNext() {
                this.calulateNext();
                ValidationTuple temp = this.next;
                this.next = null;
                return temp;
            }
        };
    }

    @Override
    public int depth() {
        return this.parent.depth() + 1;
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        if (this.printed) {
            return;
        }
        this.printed = true;
        stringBuilder.append(this.getId() + " [label=\"" + StringEscapeUtils.escapeJava((String)this.toString()) + "\"];").append("\n");
        stringBuilder.append(this.parent.getId() + " -> " + this.getId()).append("\n");
        this.parent.getPlanAsGraphvizDot(stringBuilder);
    }

    @Override
    public String getId() {
        return "" + System.identityHashCode(this);
    }

    public String toString() {
        return "SetFilterNode{targetNodeList=" + Arrays.toString(this.targetNodeList.stream().map(Formatter::prefix).toArray()) + ", index=" + this.index + ", returnValid=" + this.returnValid + "}";
    }

    @Override
    public void receiveLogger(ValidationExecutionLogger validationExecutionLogger) {
        this.validationExecutionLogger = validationExecutionLogger;
        this.parent.receiveLogger(validationExecutionLogger);
    }

    @Override
    public boolean producesSorted() {
        return this.parent.producesSorted();
    }

    @Override
    public boolean requiresSorted() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SetFilterNode that = (SetFilterNode)o;
        return this.index == that.index && this.returnValid == that.returnValid && this.targetNodeList.equals(that.targetNodeList) && this.parent.equals(that.parent);
    }

    public int hashCode() {
        return Objects.hash(this.targetNodeList, this.parent, this.index, this.returnValid);
    }
}

