/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.function.xsd;

import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.model.vocabulary.XSD;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.xsd.CastFunction;

public class DateTimeCast
extends CastFunction {
    @Override
    protected IRI getXsdDatatype() {
        return XSD.DATETIME;
    }

    @Override
    protected boolean isValidForDatatype(String lexicalValue) {
        return XMLDatatypeUtil.isValidDateTime(lexicalValue);
    }

    @Override
    protected Literal convert(ValueFactory vf, Value value) throws ValueExprEvaluationException {
        Literal literal;
        IRI datatype;
        if (value instanceof Literal && (datatype = (literal = (Literal)value).getDatatype()).equals(XSD.DATE)) {
            try {
                XMLGregorianCalendar calValue = literal.calendarValue();
                int year = calValue.getYear();
                int month = calValue.getMonth();
                int day = calValue.getDay();
                int timezoneOffset = calValue.getTimezone();
                if (Integer.MIN_VALUE != year && Integer.MIN_VALUE != month && Integer.MIN_VALUE != day) {
                    StringBuilder dtBuilder = new StringBuilder();
                    dtBuilder.append(year);
                    dtBuilder.append("-");
                    if (month < 10) {
                        dtBuilder.append("0");
                    }
                    dtBuilder.append(month);
                    dtBuilder.append("-");
                    if (day < 10) {
                        dtBuilder.append("0");
                    }
                    dtBuilder.append(day);
                    dtBuilder.append("T00:00:00");
                    if (Integer.MIN_VALUE != timezoneOffset) {
                        int minutes = Math.abs(timezoneOffset);
                        int hours = minutes / 60;
                        minutes -= hours * 60;
                        if (timezoneOffset > 0) {
                            dtBuilder.append("+");
                        } else {
                            dtBuilder.append("-");
                        }
                        if (hours < 10) {
                            dtBuilder.append("0");
                        }
                        dtBuilder.append(hours);
                        dtBuilder.append(":");
                        if (minutes < 10) {
                            dtBuilder.append("0");
                        }
                        dtBuilder.append(minutes);
                    }
                    return vf.createLiteral(dtBuilder.toString(), XSD.DATETIME);
                }
                throw this.typeError(literal, null);
            }
            catch (IllegalArgumentException e) {
                throw this.typeError(literal, e);
            }
        }
        throw this.typeError(value, null);
    }
}

