/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.compiler;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.core.xtend.AnonymousClass;
import org.eclipse.xtend.core.xtend.XtendField;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtend.core.xtend.XtendMember;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.util.IResourceScopeCache;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociations;

public class AnonymousClassCompilerHelper {
    @Inject
    private IResourceScopeCache cache;
    @Inject
    private IJvmModelAssociations associations;

    public boolean canCompileToJavaAnonymousClass(JvmType type) {
        return (Boolean)this.cache.get((Object)Tuples.pair((Object)"anonymousJava", (Object)type), type.eResource(), () -> {
            EObject sourceElement = this.associations.getPrimarySourceElement((EObject)type);
            if (sourceElement instanceof AnonymousClass && this.canCompileToJavaAnonymousClass((AnonymousClass)sourceElement)) {
                return true;
            }
            return false;
        });
    }

    public boolean canCompileToJavaAnonymousClass(AnonymousClass anonymousClass) {
        return (Boolean)this.cache.get((Object)Tuples.pair((Object)"anonymousJava", (Object)anonymousClass), anonymousClass.eResource(), () -> {
            for (XtendMember member : anonymousClass.getMembers()) {
                if (!(member instanceof XtendField) && (!(member instanceof XtendFunction) || ((XtendFunction)member).isOverride())) continue;
                return false;
            }
            return true;
        });
    }
}

