/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.xtext.builder.EclipseSourceFolderProvider;

public class JDTAwareSourceFolderProvider
implements EclipseSourceFolderProvider {
    static final Logger log = Logger.getLogger(JDTAwareSourceFolderProvider.class);

    @Override
    public List<? extends IContainer> getSourceFolders(IProject project) {
        IClasspathEntry[] classpath;
        ArrayList sourceFolders = Lists.newArrayList();
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (!javaProject.exists()) {
            return Collections.emptyList();
        }
        try {
            classpath = javaProject.getRawClasspath();
        }
        catch (JavaModelException e) {
            log.error((Object)("Error determining source folders for project " + project.getName()), (Throwable)e);
            return Collections.emptyList();
        }
        IClasspathEntry[] iClasspathEntryArray = classpath;
        int n = classpath.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.getEntryKind() == 3) {
                IPath path = entry.getPath();
                if (path.segmentCount() == 1) {
                    sourceFolders.add(project);
                } else {
                    sourceFolders.add(project.getWorkspace().getRoot().getFolder(entry.getPath()));
                }
            }
            ++n2;
        }
        return sourceFolders;
    }
}

