// --------------------------------------------------------
// Code generated by Papyrus C++
// --------------------------------------------------------

#define addClientCompdef_AddClient_BODY

/************************************************************
 AddClient class body
 ************************************************************/

// Include from Include stereotype (pre-body)
#include <iostream>
using namespace std;
// End of Include stereotype (pre-body)

// include associated header file
#include "addClientCompdef/AddClient.h"

// Derived includes directives
#include "addClientCompdef/AddClient_main.h"
#include "rclcpp/rclcpp.hpp"

namespace addClientCompdef {

// static attributes (if any)

/**
 * 
 */
void AddClient::fOnActivate() {
	RCLCPP_INFO(get_logger(), "on activate, call \"add\" in a new thread");
	std::thread { std::bind(&AddClient::fCallAdd, this) }.detach();
}

/**
 * 
 */
void AddClient::fCallAdd() {
	auto request = std::make_shared<simple::srv::AddServiceDef::Request>();
	request->x = 2;
	request->y = 3;

	RCLCPP_INFO(get_logger(), "doing request");

	// use a call in which the future is polled first
	auto result_future = useAdd_client_->async_send_request(request);

	if (result_future.wait_for(std::chrono::seconds(5s))
			!= std::future_status::ready) {
		RCLCPP_ERROR(get_logger(),
				"service call failed. This happens, since the call is executed within the periodic timer call");
	} else {
		auto result = result_future.get();
		RCLCPP_INFO(get_logger(), "result via polling = %d", result->sum);
	}

	// now make a call referencing a callback (by calling a member function, a lambda would have been
	// possible as well)
	useAdd_client_->async_send_request(request,
			std::bind(&AddClient::fResultCallback, this,
					std::placeholders::_1));
}

/**
 * 
 * @param future 
 */
void AddClient::fResultCallback(
		rclcpp::Client<simple::srv::AddServiceDef>::SharedFuture /*in*/future) {
	auto result = future.get();
	RCLCPP_INFO(get_logger(), "result via callback = %d", result->sum);
}

/**
 * 
 */
void AddClient::fPeriodic() {
	RCLCPP_INFO(get_logger(), "periodic, call \"add\" directly");
	fCallAdd();
	timer_->cancel();
}

/**
 * 
 * @param options 
 */
AddClient::AddClient(rclcpp::NodeOptions /*in*/options) :
		rclcpp_lifecycle::LifecycleNode("AddClient", options) {
	useAdd_client_ = create_client < simple::srv::AddServiceDef
			> ("AddServiceDef");

}

} // of namespace addClientCompdef

/************************************************************
 End of AddClient class body
 ************************************************************/
