/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.bt.animation.zmq.core;

import Serialization.BehaviorTree;
import Serialization.NodeStatus;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.robotics.bt.animation.core.rendering.AnimationKind;
import org.eclipse.papyrus.robotics.bt.animation.core.runnables.BehaviorTreeAnimator;
import org.eclipse.papyrus.robotics.bt.animation.zmq.core.ZMQBTReader;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityEdge;
import org.eclipse.uml2.uml.ActivityNode;
import org.zeromq.SocketType;
import org.zeromq.ZContext;
import org.zeromq.ZMQ;

public class ZMQBehaviorTreeAnimator
extends BehaviorTreeAnimator {
    protected ZContext _context = new ZContext(1);
    protected ZMQBTReader _treeReader = new ZMQBTReader(this._context);
    protected ZMQ.Socket _logSubscriber = this._context.createSocket(SocketType.SUB);
    protected ZMQ.Poller _poller;
    protected String BT_LOG_SUBSCRIBER_TCP = "tcp://*:1666";
    protected ByteBuffer bb;
    protected static final AnimationKind[] aks = new AnimationKind[]{AnimationKind.VISITED, AnimationKind.RUNNING, AnimationKind.SUCCESS, AnimationKind.FAILURE};
    protected boolean _node_status_update_required = true;

    protected void wrapByteArray(byte[] data, int offset, int length) {
        this.bb = ByteBuffer.wrap(data, offset, length);
        this.bb.order(ByteOrder.LITTLE_ENDIAN);
    }

    protected long getUnsignedInt(byte[] data, int offset) {
        this.wrapByteArray(data, offset, 4);
        return (long)this.bb.getInt() & 0xFFFFFFFFL;
    }

    protected long getUnsignedShort(byte[] data, int offset) {
        this.wrapByteArray(data, offset, 2);
        return (long)this.bb.getShort() & 0xFFFFFFFFL;
    }

    protected long getUnsignedChar(byte[] data, int offset) {
        this.wrapByteArray(data, offset, 1);
        return (long)this.bb.get() & 0xFFFFFFFFL;
    }

    protected AnimationKind toAnimationKind(int s) {
        return aks[s];
    }

    protected void animate() {
        ActivityEdge controlFlow;
        byte[] buffer = this._logSubscriber.recv();
        int header_size = (int)this.getUnsignedInt(buffer, 0);
        int num_transitions = (int)this.getUnsignedInt(buffer, 4 + header_size);
        System.out.print("\n\n");
        if (this._node_status_update_required) {
            int offset = 4;
            while (offset < header_size + 4) {
                short uid = (short)this.getUnsignedShort(buffer, offset);
                char status = (char)this.getUnsignedChar(buffer, offset + 2);
                ActivityNode treeNode = (ActivityNode)this._uid_to_node.get(uid);
                AnimationKind kind = this.toAnimationKind(status);
                if (treeNode != null) {
                    if (!this._renderer.hasMarker((EObject)treeNode, kind)) {
                        controlFlow = (ActivityEdge)this._uid_to_incomingedge.get(uid);
                        if (controlFlow != null) {
                            this._renderer.renderAs((EObject)controlFlow, kind);
                        }
                        this._renderer.renderAs((EObject)treeNode, kind);
                    }
                } else {
                    System.out.println("Found nullptr for uid " + uid + ".");
                }
                offset += 3;
            }
            this._node_status_update_required = false;
        }
        int t = 0;
        while (t < num_transitions) {
            ActivityNode treeNode;
            int offset = 8 + header_size + 12 * t;
            short uid = (short)this.getUnsignedShort(buffer, offset + 8);
            System.out.print("uid: " + uid);
            char prev_st = (char)this.getUnsignedChar(buffer, offset + 10);
            System.out.print(", " + NodeStatus.name(prev_st));
            char curr_st = (char)this.getUnsignedChar(buffer, offset + 11);
            System.out.println(" -> " + NodeStatus.name(curr_st));
            controlFlow = (ActivityEdge)this._uid_to_incomingedge.get(uid);
            if (controlFlow != null) {
                this._renderer.renderAs((EObject)controlFlow, this.toAnimationKind(curr_st));
            }
            if ((treeNode = (ActivityNode)this._uid_to_node.get(uid)) != null) {
                this._renderer.renderAs((EObject)treeNode, this.toAnimationKind(curr_st));
            } else {
                System.out.println("Found nullptr for uid " + uid + ". Recovering.");
                this._node_status_update_required = true;
            }
            ++t;
        }
    }

    public ZMQBehaviorTreeAnimator(Activity btr) throws Exception {
        super(btr);
        this._logSubscriber.connect(this.BT_LOG_SUBSCRIBER_TCP);
        this._logSubscriber.subscribe("".getBytes());
        this._poller = this._context.createPoller(1);
        this._poller.register(this._logSubscriber, 1);
    }

    public void run() {
        while (this._rm.animation_running) {
            ByteBuffer bb = null;
            try {
                bb = this._treeReader.waitForTree();
                if (bb == null) continue;
                BehaviorTree bt = BehaviorTree.getRootAsBehaviorTree(bb);
                int[] uids = new int[bt.nodesLength()];
                int i = 0;
                while (i < bt.nodesLength()) {
                    uids[i] = bt.nodes(i).uid();
                    ++i;
                }
                this.buildMaps(uids);
                this._uid_to_node.entrySet().forEach(entry -> System.out.println(entry.getKey() + ", " + ((ActivityNode)entry.getValue()).getName()));
                while (true) {
                    int rc;
                    boolean ec;
                    if ((ec = this._rm.animation_running) & (rc = this._poller.poll(5L)) == 0) {
                        continue;
                    }
                    if (!ec) break;
                    if (rc <= 0) continue;
                    this.animate();
                    if (this._node_status_update_required) break;
                }
                this.dispose();
            }
            catch (Exception e) {
                e.printStackTrace();
                break;
            }
        }
        this.stop();
    }

    public void stop() {
        super.stop();
        this._logSubscriber.close();
        this._poller.close();
        this._treeReader.close();
        this._context.close();
        System.out.println("[ZMQBehaviorTreeAnimator] done.");
    }
}

