/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.ros2.codegen.utils;

import com.google.common.base.Objects;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.papyrus.robotics.core.utils.FunctionUtils;
import org.eclipse.papyrus.robotics.profile.robotics.components.Activity;
import org.eclipse.papyrus.robotics.profile.robotics.components.ActivityPort;
import org.eclipse.papyrus.robotics.profile.robotics.components.ComponentDefinition;
import org.eclipse.papyrus.robotics.profile.robotics.components.PeriodicTimer;
import org.eclipse.papyrus.robotics.profile.robotics.functions.Function;
import org.eclipse.papyrus.robotics.profile.robotics.functions.FunctionKind;
import org.eclipse.papyrus.robotics.ros2.codegen.component.CodeSkeleton;
import org.eclipse.papyrus.uml.tools.utils.ConnectorUtil;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.util.UMLUtil;

public class ActivityUtils {
    public static List<Activity> getActivities(Class component) {
        ComponentDefinition cd = (ComponentDefinition)UMLUtil.getStereotypeApplication((Element)component, ComponentDefinition.class);
        return cd.getActivities();
    }

    public static ActivityPort getActivityForPort(Class component, Port componentPortUml) {
        Port activityPortUml = ActivityUtils.getActivityForPortUml(component, componentPortUml);
        if (activityPortUml != null) {
            return (ActivityPort)UMLUtil.getStereotypeApplication((Element)activityPortUml, ActivityPort.class);
        }
        return null;
    }

    public static Port getActivityForPortUml(Class component, Port componentPortUml) {
        List<Activity> _activities = ActivityUtils.getActivities(component);
        for (Activity activity : _activities) {
            Class activityCl = activity.getBase_Class();
            EList _ownedConnectors = component.getOwnedConnectors();
            for (Connector connector : _ownedConnectors) {
                boolean _connectsPort = ConnectorUtil.connectsPort((Connector)connector, (Port)componentPortUml);
                if (!_connectsPort) continue;
                ConnectorEnd end1 = (ConnectorEnd)connector.getEnds().get(0);
                ConnectorEnd end2 = (ConnectorEnd)connector.getEnds().get(1);
                Element _owner = end1.getRole().getOwner();
                boolean _equals = Objects.equal((Object)_owner, (Object)activityCl);
                if (_equals) {
                    ConnectableElement _role = end1.getRole();
                    return (Port)_role;
                }
                Element _owner_1 = end2.getRole().getOwner();
                boolean _equals_1 = Objects.equal((Object)_owner_1, (Object)activityCl);
                if (!_equals_1) continue;
                ConnectableElement _role_1 = end2.getRole();
                return (Port)_role_1;
            }
        }
        return null;
    }

    public static boolean hasExternalCode(Class component) {
        List<Activity> _activities = ActivityUtils.getActivities(component);
        for (Activity activity : _activities) {
            EList _functions = activity.getFunctions();
            for (Function function : _functions) {
                boolean _not;
                boolean _isCodeInModel = function.isCodeInModel();
                boolean bl = _not = !_isCodeInModel;
                if (!_not) continue;
                return true;
            }
        }
        return false;
    }

    public static String getPostfix(Class component) {
        boolean _hasExternalCode = ActivityUtils.hasExternalCode(component);
        if (_hasExternalCode) {
            return CodeSkeleton.POSTFIX;
        }
        return "";
    }

    public static UniqueEList<Activity> functionsToActivate(Class component) {
        UniqueEList list = new UniqueEList();
        List<Activity> _activities = ActivityUtils.getActivities(component);
        for (Activity activity : _activities) {
            if (FunctionUtils.getFunction((Activity)activity, (FunctionKind)FunctionKind.ON_ACTIVATE) == null && FunctionUtils.getFunction((Activity)activity, (FunctionKind)FunctionKind.PERIODIC) == null) continue;
            list.add((Object)activity);
        }
        return list;
    }

    public static boolean hasPeriodicActivities(Class component) {
        List<Activity> _activities = ActivityUtils.getActivities(component);
        for (Activity activity : _activities) {
            boolean _tripleNotEquals;
            Behavior _function = FunctionUtils.getFunction((Activity)activity, (FunctionKind)FunctionKind.PERIODIC);
            boolean bl = _tripleNotEquals = _function != null;
            if (!_tripleNotEquals) continue;
            return true;
        }
        return false;
    }

    public static UniqueEList<Activity> activitesToDeActivate(Class component) {
        UniqueEList list = new UniqueEList();
        List<Activity> _activities = ActivityUtils.getActivities(component);
        for (Activity activity : _activities) {
            boolean _tripleNotEquals;
            Behavior _function = FunctionUtils.getFunction((Activity)activity, (FunctionKind)FunctionKind.ON_DEACTIVATE);
            boolean bl = _tripleNotEquals = _function != null;
            if (!_tripleNotEquals) continue;
            list.add((Object)activity);
        }
        return list;
    }

    public static String getPeriod(Activity activity) {
        EList _nestedClassifiers = activity.getBase_Class().getNestedClassifiers();
        for (Classifier cl : _nestedClassifiers) {
            PeriodicTimer pt = (PeriodicTimer)UMLUtil.getStereotypeApplication((Element)cl, PeriodicTimer.class);
            if (pt == null) continue;
            return pt.getPeriod();
        }
        return null;
    }
}

