/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.library.advice;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.papyrus.infra.emf.gmf.command.EMFtoGMFCommandWrapper;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.robotics.core.commands.CancelCommand;
import org.eclipse.papyrus.robotics.core.menu.EnhancedPopupMenu;
import org.eclipse.papyrus.robotics.core.menu.MenuHelper;
import org.eclipse.papyrus.robotics.core.provider.EClassGraphicalContentProvider;
import org.eclipse.papyrus.robotics.core.provider.RoboticsContentProvider;
import org.eclipse.papyrus.robotics.library.advice.AdviceUtil;
import org.eclipse.papyrus.robotics.profile.robotics.commobject.CommunicationObject;
import org.eclipse.papyrus.robotics.profile.robotics.services.ServiceDefinition;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.ParameterableElement;
import org.eclipse.uml2.uml.TemplateBinding;
import org.eclipse.uml2.uml.TemplateParameter;
import org.eclipse.uml2.uml.TemplateParameterSubstitution;
import org.eclipse.uml2.uml.TemplateSignature;
import org.eclipse.uml2.uml.UMLPackage;

public class QueryCommPatternAdvice
extends AbstractEditHelperAdvice {
    public static final String QUERY_PATTERN = "robotics::commpatterns::Query";

    protected ICommand getAfterConfigureCommand(ConfigureRequest request) {
        DataType response;
        DataType _request;
        CompositeCommand compositeCommand = new CompositeCommand("Query pattern configuration command");
        EObject newElement = request.getElementToConfigure();
        if (!(newElement instanceof Classifier)) {
            return super.getAfterConfigureCommand(request);
        }
        final Classifier classifier = (Classifier)newElement;
        RoboticsContentProvider cp = new RoboticsContentProvider((EObject)classifier, (IStaticContentProvider)new EClassGraphicalContentProvider((EObject)classifier, UMLPackage.eINSTANCE.getDataType()), CommunicationObject.class, ".servicedef.uml");
        EnhancedPopupMenu popupMenuRequest = MenuHelper.createPopupMenu((IStaticContentProvider)cp, (String)"Choose CO for request", (boolean)false);
        Object menuResult = null;
        if (popupMenuRequest.show((Control)Display.getDefault().getActiveShell())) {
            menuResult = popupMenuRequest.getSubResult();
        }
        DataType dataType = _request = menuResult instanceof DataType ? (DataType)menuResult : null;
        if (_request == null) {
            return new CancelCommand((EObject)classifier);
        }
        EnhancedPopupMenu popupMenuResponse = MenuHelper.createPopupMenu((IStaticContentProvider)cp, (String)"Choose CO for response", (boolean)false);
        if (popupMenuResponse.show((Control)Display.getDefault().getActiveShell())) {
            menuResult = popupMenuResponse.getSubResult();
        }
        DataType dataType2 = response = menuResult instanceof DataType ? (DataType)menuResult : null;
        if (response == null) {
            return new CancelCommand((EObject)classifier);
        }
        RecordingCommand templateBinding = new RecordingCommand(TransactionUtil.getEditingDomain((EObject)newElement)){

            protected void doExecute() {
                Classifier queryCommPattern = AdviceUtil.getPattern((Element)classifier, QueryCommPatternAdvice.QUERY_PATTERN);
                if (queryCommPattern != null) {
                    TemplateSignature signature = queryCommPattern.getOwnedTemplateSignature();
                    TemplateBinding binding = classifier.createTemplateBinding(signature);
                    String name = "Query";
                    for (TemplateParameter parameter : signature.getOwnedParameters()) {
                        TemplateParameterSubstitution substitution = binding.createParameterSubstitution();
                        substitution.setFormal(parameter);
                        String formalName = ((NamedElement)parameter.getParameteredElement()).getName();
                        if (formalName.equals("Request")) {
                            substitution.setActual((ParameterableElement)_request);
                            name = String.valueOf(name) + "_" + _request.getName();
                            continue;
                        }
                        if (!formalName.equals("Response")) continue;
                        substitution.setActual((ParameterableElement)response);
                        name = String.valueOf(name) + "_" + response.getName();
                    }
                    classifier.setName(name);
                }
                StereotypeUtil.apply((Element)classifier, ServiceDefinition.class);
            }
        };
        compositeCommand.add((IUndoableOperation)EMFtoGMFCommandWrapper.wrap((Command)templateBinding));
        return compositeCommand.isEmpty() ? super.getAfterConfigureCommand(request) : compositeCommand;
    }
}

