/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.simplifiedui.ui;

import org.eclipse.papyrus.infra.architecture.ArchitectureDescriptionUtils;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.ui.editor.CoreMultiDiagramEditor;
import org.eclipse.papyrus.robotics.simplifiedui.Activator;
import org.eclipse.papyrus.robotics.simplifiedui.internal.ContextConfigurator;
import org.eclipse.papyrus.robotics.simplifiedui.internal.CreationMenuConfigurator;
import org.eclipse.papyrus.robotics.simplifiedui.internal.PreferenceManipulation;
import org.eclipse.papyrus.robotics.simplifiedui.preferences.RobMoSysUIPreferenceUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class RoboticsPartListener
implements IPartListener {
    boolean activate = false;

    public void partOpened(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partActivated(IWorkbenchPart part) {
        ServicesRegistry sr;
        IWorkbenchPage page = part.getSite().getPage();
        this.activate = false;
        if (page.getActiveEditor() instanceof CoreMultiDiagramEditor && (sr = ((CoreMultiDiagramEditor)page.getActiveEditor()).getServicesRegistry()) != null) {
            try {
                ModelSet set = (ModelSet)sr.getService(ModelSet.class);
                ArchitectureDescriptionUtils adUtils = new ArchitectureDescriptionUtils(set);
                this.activate = adUtils.getArchitectureContextId().equals("org.eclipse.papyrus.robotics.architecture");
            }
            catch (ServiceException e) {
                Activator.log.error((Throwable)e);
            }
        }
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (RoboticsPartListener.this.activate) {
                    RoboticsPartListener.this.activateRobMoSys();
                } else {
                    RoboticsPartListener.this.deactivateRobMoSys();
                }
            }
        });
    }

    protected void activateRobMoSys() {
        PreferenceManipulation.disablePopupBar();
        PreferenceManipulation.disableStdDrops();
        ContextConfigurator.showRobotics();
        boolean hideStd = RobMoSysUIPreferenceUtils.getHideStd();
        if (!hideStd) {
            CreationMenuConfigurator.showDefault();
            ContextConfigurator.showDefault();
        } else {
            CreationMenuConfigurator.hideDefault();
            ContextConfigurator.hideDefault();
        }
    }

    protected void deactivateRobMoSys() {
        PreferenceManipulation.enablePopupBar();
        PreferenceManipulation.enableStdDrops();
        ContextConfigurator.showDefault();
        CreationMenuConfigurator.showDefault();
        ContextConfigurator.hideRobotics();
    }
}

