/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.core.types.advice;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.papyrus.designer.languages.common.base.ElementUtils;
import org.eclipse.papyrus.infra.emf.gmf.command.EMFtoGMFCommandWrapper;
import org.eclipse.papyrus.uml.tools.commands.ApplyProfileCommand;
import org.eclipse.papyrus.uml.tools.utils.PackageUtil;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;

public abstract class AbstractApplyStereotypeEditHelperAdvice
extends AbstractEditHelperAdvice {
    protected abstract URI getProfileURI();

    protected abstract Class<? extends EObject> stereotypeToApply();

    protected String getSubProfileQName() {
        return null;
    }

    protected ICommand getBeforeConfigureCommand(ConfigureRequest request) {
        EObject newEObject = request.getElementToConfigure();
        CompositeCommand compositeCommand = new CompositeCommand("Apply profile");
        ICommand superCmd = super.getAfterConfigureCommand(request);
        if (superCmd != null) {
            compositeCommand.add((IUndoableOperation)superCmd);
        }
        if (newEObject instanceof Element) {
            NamedElement subProfile;
            final Element newElement = (Element)newEObject;
            Package root = PackageUtil.getRootPackage((Element)newElement);
            Package profile = PackageUtil.loadPackage((URI)this.getProfileURI(), (ResourceSet)newElement.eResource().getResourceSet());
            if (profile != null && this.getSubProfileQName() != null && (subProfile = ElementUtils.getQualifiedElement((Package)profile, (String)this.getSubProfileQName())) instanceof Profile) {
                profile = (Profile)subProfile;
            }
            if (profile instanceof Profile) {
                TransactionalEditingDomain ed = TransactionUtil.getEditingDomain((EObject)newElement);
                ApplyProfileCommand applyProfileCmd = new ApplyProfileCommand(root, (Profile)profile, ed, false);
                RecordingCommand applyStereoCmd = new RecordingCommand(ed){

                    protected void doExecute() {
                        StereotypeUtil.apply((Element)newElement, AbstractApplyStereotypeEditHelperAdvice.this.stereotypeToApply());
                    }
                };
                if (!newElement.getNearestPackage().isProfileApplied((Profile)profile)) {
                    compositeCommand.add((IUndoableOperation)EMFtoGMFCommandWrapper.wrap((Command)applyProfileCmd));
                }
                compositeCommand.add((IUndoableOperation)EMFtoGMFCommandWrapper.wrap((Command)applyStereoCmd));
            }
        }
        return compositeCommand;
    }
}

