/**
 * Copyright (c) 2018 CEA
 * 
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Jrmie Tatibouet (CEA) jeremie.tatibouet@cea.fr - Initial API and implementation
 *   Benoit Maggi (CEA) benoit.maggi@cea.fr - Initial API and implementation
 * 
 */
package  org.eclipse.papyrus.iotml.hardware.core;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

import org.eclipse.papyrus.MARTE.MARTE_Foundations.Alloc.AllocPackage;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.eclipse.papyrus.iotml.hardware.core.CoreFactory
 * @model kind="package"
 *        annotation="http://www.eclipse.org/uml2/2.0.0/UML originalName='Core'"
 * @generated
 */
public interface CorePackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "core";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://www.eclipse.org/papyrus/iotml/0.7/IoTML/Hardware/Core";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "Core";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	CorePackage eINSTANCE = org.eclipse.papyrus.iotml.hardware.core.impl.CorePackageImpl.init();

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.iotml.hardware.core.impl.AllocateResourceImpl <em>Allocate Resource</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.iotml.hardware.core.impl.AllocateResourceImpl
	 * @see org.eclipse.papyrus.iotml.hardware.core.impl.CorePackageImpl#getAllocateResource()
	 * @generated
	 */
	int ALLOCATE_RESOURCE = 0;

	/**
	 * The feature id for the '<em><b>Kind</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ALLOCATE_RESOURCE__KIND = AllocPackage.ALLOCATE__KIND;

	/**
	 * The feature id for the '<em><b>Nature</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ALLOCATE_RESOURCE__NATURE = AllocPackage.ALLOCATE__NATURE;

	/**
	 * The feature id for the '<em><b>Base Abstraction</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ALLOCATE_RESOURCE__BASE_ABSTRACTION = AllocPackage.ALLOCATE__BASE_ABSTRACTION;

	/**
	 * The feature id for the '<em><b>Implied Constraint</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ALLOCATE_RESOURCE__IMPLIED_CONSTRAINT = AllocPackage.ALLOCATE__IMPLIED_CONSTRAINT;

	/**
	 * The number of structural features of the '<em>Allocate Resource</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ALLOCATE_RESOURCE_FEATURE_COUNT = AllocPackage.ALLOCATE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.iotml.hardware.core.impl.HasServiceImpl <em>Has Service</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.iotml.hardware.core.impl.HasServiceImpl
	 * @see org.eclipse.papyrus.iotml.hardware.core.impl.CorePackageImpl#getHasService()
	 * @generated
	 */
	int HAS_SERVICE = 1;

	/**
	 * The feature id for the '<em><b>Base Association</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HAS_SERVICE__BASE_ASSOCIATION = 0;

	/**
	 * The number of structural features of the '<em>Has Service</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HAS_SERVICE_FEATURE_COUNT = 1;


	/**
	 * Returns the meta object for class '{@link org.eclipse.papyrus.iotml.hardware.core.AllocateResource <em>Allocate Resource</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Allocate Resource</em>'.
	 * @see org.eclipse.papyrus.iotml.hardware.core.AllocateResource
	 * @generated
	 */
	EClass getAllocateResource();

	/**
	 * Returns the meta object for class '{@link org.eclipse.papyrus.iotml.hardware.core.HasService <em>Has Service</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Has Service</em>'.
	 * @see org.eclipse.papyrus.iotml.hardware.core.HasService
	 * @generated
	 */
	EClass getHasService();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.papyrus.iotml.hardware.core.HasService#getBase_Association <em>Base Association</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Base Association</em>'.
	 * @see org.eclipse.papyrus.iotml.hardware.core.HasService#getBase_Association()
	 * @see #getHasService()
	 * @generated
	 */
	EReference getHasService_Base_Association();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	CoreFactory getCoreFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link org.eclipse.papyrus.iotml.hardware.core.impl.AllocateResourceImpl <em>Allocate Resource</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.papyrus.iotml.hardware.core.impl.AllocateResourceImpl
		 * @see org.eclipse.papyrus.iotml.hardware.core.impl.CorePackageImpl#getAllocateResource()
		 * @generated
		 */
		EClass ALLOCATE_RESOURCE = eINSTANCE.getAllocateResource();

		/**
		 * The meta object literal for the '{@link org.eclipse.papyrus.iotml.hardware.core.impl.HasServiceImpl <em>Has Service</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.papyrus.iotml.hardware.core.impl.HasServiceImpl
		 * @see org.eclipse.papyrus.iotml.hardware.core.impl.CorePackageImpl#getHasService()
		 * @generated
		 */
		EClass HAS_SERVICE = eINSTANCE.getHasService();

		/**
		 * The meta object literal for the '<em><b>Base Association</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference HAS_SERVICE__BASE_ASSOCIATION = eINSTANCE.getHasService_Base_Association();

	}

} //CorePackage
