/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast;

import java.util.Collections;
import java.util.List;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.internal.Utils;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.type.Type;

public class TypeArguments {
    public static final TypeArguments EMPTY = TypeArguments.withArguments(Collections.emptyList());
    private final List<Type> typeArguments;
    private final boolean usesDiamondOperator;

    private TypeArguments(List<Type> typeArguments, boolean usesDiamondOperator) {
        this.typeArguments = Utils.ensureNotNull(typeArguments);
        this.usesDiamondOperator = usesDiamondOperator;
    }

    public List<Type> getTypeArguments() {
        return Collections.unmodifiableList(this.typeArguments);
    }

    public boolean isUsingDiamondOperator() {
        return this.usesDiamondOperator;
    }

    public static TypeArguments withDiamondOperator() {
        return new TypeArguments(Collections.emptyList(), true);
    }

    public static TypeArguments withArguments(List<Type> typeArguments) {
        return new TypeArguments(typeArguments, false);
    }
}

