package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * Immutable implementation of {@link NetworkStats}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableNetworkStats.builder()}.
 */
@SuppressWarnings({"all"})
final class ImmutableNetworkStats implements NetworkStats {
  private final Long rxBytes;
  private final Long rxPackets;
  private final Long rxDropped;
  private final Long rxErrors;
  private final Long txBytes;
  private final Long txPackets;
  private final Long txDropped;
  private final Long txErrors;

  private ImmutableNetworkStats(
      Long rxBytes,
      Long rxPackets,
      Long rxDropped,
      Long rxErrors,
      Long txBytes,
      Long txPackets,
      Long txDropped,
      Long txErrors) {
    this.rxBytes = rxBytes;
    this.rxPackets = rxPackets;
    this.rxDropped = rxDropped;
    this.rxErrors = rxErrors;
    this.txBytes = txBytes;
    this.txPackets = txPackets;
    this.txDropped = txDropped;
    this.txErrors = txErrors;
  }

  /**
   * @return The value of the {@code rxBytes} attribute
   */
  @JsonProperty("rx_bytes")
  @Override
  public Long rxBytes() {
    return rxBytes;
  }

  /**
   * @return The value of the {@code rxPackets} attribute
   */
  @JsonProperty("rx_packets")
  @Override
  public Long rxPackets() {
    return rxPackets;
  }

  /**
   * @return The value of the {@code rxDropped} attribute
   */
  @JsonProperty("rx_dropped")
  @Override
  public Long rxDropped() {
    return rxDropped;
  }

  /**
   * @return The value of the {@code rxErrors} attribute
   */
  @JsonProperty("rx_errors")
  @Override
  public Long rxErrors() {
    return rxErrors;
  }

  /**
   * @return The value of the {@code txBytes} attribute
   */
  @JsonProperty("tx_bytes")
  @Override
  public Long txBytes() {
    return txBytes;
  }

  /**
   * @return The value of the {@code txPackets} attribute
   */
  @JsonProperty("tx_packets")
  @Override
  public Long txPackets() {
    return txPackets;
  }

  /**
   * @return The value of the {@code txDropped} attribute
   */
  @JsonProperty("tx_dropped")
  @Override
  public Long txDropped() {
    return txDropped;
  }

  /**
   * @return The value of the {@code txErrors} attribute
   */
  @JsonProperty("tx_errors")
  @Override
  public Long txErrors() {
    return txErrors;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NetworkStats#rxBytes() rxBytes} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for rxBytes
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNetworkStats withRxBytes(Long value) {
    Long newValue = Objects.requireNonNull(value, "rxBytes");
    if (this.rxBytes.equals(newValue)) return this;
    return new ImmutableNetworkStats(
        newValue,
        this.rxPackets,
        this.rxDropped,
        this.rxErrors,
        this.txBytes,
        this.txPackets,
        this.txDropped,
        this.txErrors);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NetworkStats#rxPackets() rxPackets} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for rxPackets
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNetworkStats withRxPackets(Long value) {
    Long newValue = Objects.requireNonNull(value, "rxPackets");
    if (this.rxPackets.equals(newValue)) return this;
    return new ImmutableNetworkStats(
        this.rxBytes,
        newValue,
        this.rxDropped,
        this.rxErrors,
        this.txBytes,
        this.txPackets,
        this.txDropped,
        this.txErrors);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NetworkStats#rxDropped() rxDropped} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for rxDropped
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNetworkStats withRxDropped(Long value) {
    Long newValue = Objects.requireNonNull(value, "rxDropped");
    if (this.rxDropped.equals(newValue)) return this;
    return new ImmutableNetworkStats(
        this.rxBytes,
        this.rxPackets,
        newValue,
        this.rxErrors,
        this.txBytes,
        this.txPackets,
        this.txDropped,
        this.txErrors);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NetworkStats#rxErrors() rxErrors} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for rxErrors
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNetworkStats withRxErrors(Long value) {
    Long newValue = Objects.requireNonNull(value, "rxErrors");
    if (this.rxErrors.equals(newValue)) return this;
    return new ImmutableNetworkStats(
        this.rxBytes,
        this.rxPackets,
        this.rxDropped,
        newValue,
        this.txBytes,
        this.txPackets,
        this.txDropped,
        this.txErrors);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NetworkStats#txBytes() txBytes} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for txBytes
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNetworkStats withTxBytes(Long value) {
    Long newValue = Objects.requireNonNull(value, "txBytes");
    if (this.txBytes.equals(newValue)) return this;
    return new ImmutableNetworkStats(
        this.rxBytes,
        this.rxPackets,
        this.rxDropped,
        this.rxErrors,
        newValue,
        this.txPackets,
        this.txDropped,
        this.txErrors);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NetworkStats#txPackets() txPackets} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for txPackets
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNetworkStats withTxPackets(Long value) {
    Long newValue = Objects.requireNonNull(value, "txPackets");
    if (this.txPackets.equals(newValue)) return this;
    return new ImmutableNetworkStats(
        this.rxBytes,
        this.rxPackets,
        this.rxDropped,
        this.rxErrors,
        this.txBytes,
        newValue,
        this.txDropped,
        this.txErrors);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NetworkStats#txDropped() txDropped} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for txDropped
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNetworkStats withTxDropped(Long value) {
    Long newValue = Objects.requireNonNull(value, "txDropped");
    if (this.txDropped.equals(newValue)) return this;
    return new ImmutableNetworkStats(
        this.rxBytes,
        this.rxPackets,
        this.rxDropped,
        this.rxErrors,
        this.txBytes,
        this.txPackets,
        newValue,
        this.txErrors);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NetworkStats#txErrors() txErrors} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for txErrors
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNetworkStats withTxErrors(Long value) {
    Long newValue = Objects.requireNonNull(value, "txErrors");
    if (this.txErrors.equals(newValue)) return this;
    return new ImmutableNetworkStats(
        this.rxBytes,
        this.rxPackets,
        this.rxDropped,
        this.rxErrors,
        this.txBytes,
        this.txPackets,
        this.txDropped,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableNetworkStats} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableNetworkStats
        && equalTo(0, (ImmutableNetworkStats) another);
  }

  private boolean equalTo(int synthetic, ImmutableNetworkStats another) {
    return rxBytes.equals(another.rxBytes)
        && rxPackets.equals(another.rxPackets)
        && rxDropped.equals(another.rxDropped)
        && rxErrors.equals(another.rxErrors)
        && txBytes.equals(another.txBytes)
        && txPackets.equals(another.txPackets)
        && txDropped.equals(another.txDropped)
        && txErrors.equals(another.txErrors);
  }

  /**
   * Computes a hash code from attributes: {@code rxBytes}, {@code rxPackets}, {@code rxDropped}, {@code rxErrors}, {@code txBytes}, {@code txPackets}, {@code txDropped}, {@code txErrors}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + rxBytes.hashCode();
    h += (h << 5) + rxPackets.hashCode();
    h += (h << 5) + rxDropped.hashCode();
    h += (h << 5) + rxErrors.hashCode();
    h += (h << 5) + txBytes.hashCode();
    h += (h << 5) + txPackets.hashCode();
    h += (h << 5) + txDropped.hashCode();
    h += (h << 5) + txErrors.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code NetworkStats} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "NetworkStats{"
        + "rxBytes=" + rxBytes
        + ", rxPackets=" + rxPackets
        + ", rxDropped=" + rxDropped
        + ", rxErrors=" + rxErrors
        + ", txBytes=" + txBytes
        + ", txPackets=" + txPackets
        + ", txDropped=" + txDropped
        + ", txErrors=" + txErrors
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link NetworkStats} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable NetworkStats instance
   */
  public static ImmutableNetworkStats copyOf(NetworkStats instance) {
    if (instance instanceof ImmutableNetworkStats) {
      return (ImmutableNetworkStats) instance;
    }
    return ImmutableNetworkStats.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableNetworkStats ImmutableNetworkStats}.
   * <pre>
   * ImmutableNetworkStats.builder()
   *    .rxBytes(Long) // required {@link NetworkStats#rxBytes() rxBytes}
   *    .rxPackets(Long) // required {@link NetworkStats#rxPackets() rxPackets}
   *    .rxDropped(Long) // required {@link NetworkStats#rxDropped() rxDropped}
   *    .rxErrors(Long) // required {@link NetworkStats#rxErrors() rxErrors}
   *    .txBytes(Long) // required {@link NetworkStats#txBytes() txBytes}
   *    .txPackets(Long) // required {@link NetworkStats#txPackets() txPackets}
   *    .txDropped(Long) // required {@link NetworkStats#txDropped() txDropped}
   *    .txErrors(Long) // required {@link NetworkStats#txErrors() txErrors}
   *    .build();
   * </pre>
   * @return A new ImmutableNetworkStats builder
   */
  public static ImmutableNetworkStats.Builder builder() {
    return new ImmutableNetworkStats.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableNetworkStats ImmutableNetworkStats}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  static final class Builder {
    private static final long INIT_BIT_RX_BYTES = 0x1L;
    private static final long INIT_BIT_RX_PACKETS = 0x2L;
    private static final long INIT_BIT_RX_DROPPED = 0x4L;
    private static final long INIT_BIT_RX_ERRORS = 0x8L;
    private static final long INIT_BIT_TX_BYTES = 0x10L;
    private static final long INIT_BIT_TX_PACKETS = 0x20L;
    private static final long INIT_BIT_TX_DROPPED = 0x40L;
    private static final long INIT_BIT_TX_ERRORS = 0x80L;
    private long initBits = 0xffL;

    private Long rxBytes;
    private Long rxPackets;
    private Long rxDropped;
    private Long rxErrors;
    private Long txBytes;
    private Long txPackets;
    private Long txDropped;
    private Long txErrors;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code NetworkStats} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(NetworkStats instance) {
      Objects.requireNonNull(instance, "instance");
      this.rxBytes(instance.rxBytes());
      this.rxPackets(instance.rxPackets());
      this.rxDropped(instance.rxDropped());
      this.rxErrors(instance.rxErrors());
      this.txBytes(instance.txBytes());
      this.txPackets(instance.txPackets());
      this.txDropped(instance.txDropped());
      this.txErrors(instance.txErrors());
      return this;
    }

    /**
     * Initializes the value for the {@link NetworkStats#rxBytes() rxBytes} attribute.
     * @param rxBytes The value for rxBytes 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("rx_bytes")
    public final Builder rxBytes(Long rxBytes) {
      this.rxBytes = Objects.requireNonNull(rxBytes, "rxBytes");
      initBits &= ~INIT_BIT_RX_BYTES;
      return this;
    }

    /**
     * Initializes the value for the {@link NetworkStats#rxPackets() rxPackets} attribute.
     * @param rxPackets The value for rxPackets 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("rx_packets")
    public final Builder rxPackets(Long rxPackets) {
      this.rxPackets = Objects.requireNonNull(rxPackets, "rxPackets");
      initBits &= ~INIT_BIT_RX_PACKETS;
      return this;
    }

    /**
     * Initializes the value for the {@link NetworkStats#rxDropped() rxDropped} attribute.
     * @param rxDropped The value for rxDropped 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("rx_dropped")
    public final Builder rxDropped(Long rxDropped) {
      this.rxDropped = Objects.requireNonNull(rxDropped, "rxDropped");
      initBits &= ~INIT_BIT_RX_DROPPED;
      return this;
    }

    /**
     * Initializes the value for the {@link NetworkStats#rxErrors() rxErrors} attribute.
     * @param rxErrors The value for rxErrors 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("rx_errors")
    public final Builder rxErrors(Long rxErrors) {
      this.rxErrors = Objects.requireNonNull(rxErrors, "rxErrors");
      initBits &= ~INIT_BIT_RX_ERRORS;
      return this;
    }

    /**
     * Initializes the value for the {@link NetworkStats#txBytes() txBytes} attribute.
     * @param txBytes The value for txBytes 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("tx_bytes")
    public final Builder txBytes(Long txBytes) {
      this.txBytes = Objects.requireNonNull(txBytes, "txBytes");
      initBits &= ~INIT_BIT_TX_BYTES;
      return this;
    }

    /**
     * Initializes the value for the {@link NetworkStats#txPackets() txPackets} attribute.
     * @param txPackets The value for txPackets 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("tx_packets")
    public final Builder txPackets(Long txPackets) {
      this.txPackets = Objects.requireNonNull(txPackets, "txPackets");
      initBits &= ~INIT_BIT_TX_PACKETS;
      return this;
    }

    /**
     * Initializes the value for the {@link NetworkStats#txDropped() txDropped} attribute.
     * @param txDropped The value for txDropped 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("tx_dropped")
    public final Builder txDropped(Long txDropped) {
      this.txDropped = Objects.requireNonNull(txDropped, "txDropped");
      initBits &= ~INIT_BIT_TX_DROPPED;
      return this;
    }

    /**
     * Initializes the value for the {@link NetworkStats#txErrors() txErrors} attribute.
     * @param txErrors The value for txErrors 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("tx_errors")
    public final Builder txErrors(Long txErrors) {
      this.txErrors = Objects.requireNonNull(txErrors, "txErrors");
      initBits &= ~INIT_BIT_TX_ERRORS;
      return this;
    }

    /**
     * Builds a new {@link ImmutableNetworkStats ImmutableNetworkStats}.
     * @return An immutable instance of NetworkStats
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableNetworkStats build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableNetworkStats(rxBytes, rxPackets, rxDropped, rxErrors, txBytes, txPackets, txDropped, txErrors);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_RX_BYTES) != 0) attributes.add("rxBytes");
      if ((initBits & INIT_BIT_RX_PACKETS) != 0) attributes.add("rxPackets");
      if ((initBits & INIT_BIT_RX_DROPPED) != 0) attributes.add("rxDropped");
      if ((initBits & INIT_BIT_RX_ERRORS) != 0) attributes.add("rxErrors");
      if ((initBits & INIT_BIT_TX_BYTES) != 0) attributes.add("txBytes");
      if ((initBits & INIT_BIT_TX_PACKETS) != 0) attributes.add("txPackets");
      if ((initBits & INIT_BIT_TX_DROPPED) != 0) attributes.add("txDropped");
      if ((initBits & INIT_BIT_TX_ERRORS) != 0) attributes.add("txErrors");
      return "Cannot build NetworkStats, some of required attributes are not set " + attributes;
    }
  }
}
