/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.immutables.value.Value;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.ImmutableDockerCredentialHelperAuth;
import org.mandas.docker.client.messages.RegistryAuth;

@JsonDeserialize(builder=ImmutableDockerCredentialHelperAuth.Builder.class)
@Value.Immutable
public interface DockerCredentialHelperAuth {
    @JsonProperty(value="Username")
    public String username();

    @JsonProperty(value="Secret")
    public String secret();

    @JsonProperty(value="ServerURL")
    @Nullable
    public String serverUrl();

    public static Builder builder() {
        return ImmutableDockerCredentialHelperAuth.builder();
    }

    @JsonIgnore
    @Value.Derived
    default public RegistryAuth toRegistryAuth() {
        return RegistryAuth.builder().username(this.username()).password(this.secret()).serverAddress(this.serverUrl()).build();
    }

    public static interface Builder {
        public Builder username(String var1);

        public Builder secret(String var1);

        public Builder serverUrl(String var1);

        public DockerCredentialHelperAuth build();
    }
}

