/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.gtile;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.sourceforge.plantuml.activitydiagram3.Branch;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.gtile.GConnection;
import net.sourceforge.plantuml.activitydiagram3.gtile.GConnectionHorizontalThenVerticalDown;
import net.sourceforge.plantuml.activitydiagram3.gtile.GConnectionVerticalDown;
import net.sourceforge.plantuml.activitydiagram3.gtile.GConnectionVerticalDownThenHorizontal;
import net.sourceforge.plantuml.activitydiagram3.gtile.Gtile;
import net.sourceforge.plantuml.activitydiagram3.gtile.GtileColumns;
import net.sourceforge.plantuml.activitydiagram3.gtile.GtileHexagonInside;
import net.sourceforge.plantuml.activitydiagram3.gtile.Gtiles;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.StyleSignatureBasic;

public class GtileIfHexagon
extends GtileColumns {
    private final Gtile shape1;
    private final List<Branch> branches;
    private final Gtile shape2;
    private final UTranslate positionShape1;
    private final UTranslate positionShape2;

    @Override
    public String toString() {
        return "GtileIfHexagon " + this.gtiles;
    }

    public static Gtile build(Swimlane swimlane, List<Gtile> gtiles, List<Branch> branches) {
        GtileIfHexagon result = new GtileIfHexagon(swimlane, gtiles, branches);
        return result;
    }

    private GtileIfHexagon(Swimlane swimlane, List<Gtile> gtiles, List<Branch> branches) {
        super(gtiles, swimlane, 20.0);
        double posShape;
        XDimension2D totalDim;
        this.branches = branches;
        this.shape1 = this.getShape1(swimlane);
        this.shape2 = Gtiles.diamondEmpty(swimlane, this.getStringBounder(), this.skinParam(), this.getDefaultStyleDefinitionDiamond(), branches.get(0).getColor());
        XDimension2D dimShape1 = this.shape1.calculateDimension(this.stringBounder);
        this.pushDown(dimShape1.getHeight());
        if (branches.size() == 2) {
            Gtile tile0 = branches.get(0).getGtile();
            Gtile tile1 = branches.get(1).getGtile();
            double northHook0 = tile0.getGPoint("NORTH_HOOK").getCoord().getDx();
            double width0 = tile0.calculateDimension(this.getStringBounder()).getWidth();
            double northHook1 = tile1.getGPoint("NORTH_HOOK").getCoord().getDx();
            double width1 = tile1.calculateDimension(this.getStringBounder()).getWidth();
            double shlen1 = this.shape1.calculateDimension(this.getStringBounder()).getWidth();
            double shlen = this.shape1.getGPoint("EAST_HOOK").getCoord().getDx() - this.shape1.getGPoint("WEST_HOOK").getCoord().getDx();
            System.err.println("shlen=" + shlen);
            System.err.println("northHook0=" + northHook0);
            System.err.println("width0=" + width0);
            System.err.println("northHook1=" + northHook1);
            System.err.println("width1=" + width1);
            double alpha = northHook0;
            double beta = width1 - northHook1;
            System.err.println("alpha=" + alpha);
            System.err.println("beta=" + beta);
            double wantedWidth = alpha + shlen + beta;
            System.err.println("wantedWidth=" + wantedWidth);
            double diff = wantedWidth - width0 - width1;
            if (diff < 0.0) {
                diff = 0.0;
            }
            System.err.println("diff=" + diff);
            this.setMargin(diff + 10.0);
            totalDim = this.calculateDimensionRaw(this.stringBounder);
            double p2 = totalDim.getWidth() - beta;
            posShape = (alpha + p2) / 2.0;
        } else {
            totalDim = this.calculateDimensionRaw(this.stringBounder);
            posShape = totalDim.getWidth() / 2.0;
        }
        this.positionShape1 = UTranslate.dx(posShape).compose(this.shape1.getCoord("NORTH_BORDER").reverse());
        this.positionShape2 = new UTranslate(posShape, totalDim.getHeight()).compose(this.shape2.getCoord("SOUTH_BORDER").reverse());
    }

    @Override
    protected UTranslate getCoordImpl(String name) {
        if (name.equals("NORTH_HOOK")) {
            return this.shape1.getCoord(name).compose(this.positionShape1);
        }
        if (name.equals("SOUTH_HOOK")) {
            return this.shape2.getCoord(name).compose(this.positionShape2);
        }
        return super.getCoordImpl(name);
    }

    private Gtile getShape1(Swimlane swimlane) {
        GtileHexagonInside tmp = Gtiles.hexagonInside(swimlane, this.getStringBounder(), this.skinParam(), this.getDefaultStyleDefinitionDiamond(), this.branches.get(0).getColor(), this.branches.get(0).getLabelTest());
        TextBlock tmp0 = this.branches.get(0).getTextBlockPositive();
        if (this.branches.size() == 1) {
            return Gtiles.withSouthMargin(tmp.withSouthLabel(tmp0), 10.0);
        }
        TextBlock tmp1 = this.branches.get(1).getTextBlockPositive();
        return Gtiles.withSouthMargin(tmp.withWestLabel(tmp0).withEastLabel(tmp1), 10.0);
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        XDimension2D rawDim = this.calculateDimensionRaw(stringBounder);
        if (this.branches.size() == 2) {
            XDimension2D shape1Dim = this.shape1.calculateDimension(stringBounder);
            double shape1max = this.positionShape1.getDx() + shape1Dim.getWidth();
            return rawDim.atLeast(shape1max, 0.0);
        }
        return rawDim;
    }

    private XDimension2D calculateDimensionRaw(StringBounder stringBounder) {
        double height2 = this.shape2.calculateDimension(stringBounder).getHeight();
        XDimension2D nude = super.calculateDimension(stringBounder);
        return nude.delta(0.0, height2 + 30.0);
    }

    public final StyleSignatureBasic getDefaultStyleDefinitionActivity() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.activityDiagram, SName.activity);
    }

    public final StyleSignatureBasic getDefaultStyleDefinitionDiamond() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.activityDiagram, SName.activity, SName.diamond);
    }

    public final StyleSignatureBasic getDefaultStyleDefinitionArrow() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.activityDiagram, SName.arrow);
    }

    @Override
    protected void drawUInternal(UGraphic ug) {
        super.drawUInternal(ug);
        ug.apply(this.positionShape1).draw(this.shape1);
        ug.apply(this.positionShape2).draw(this.shape2);
    }

    @Override
    public Collection<GConnection> getInnerConnections() {
        if (this.branches.size() == 1) {
            GConnectionVerticalDown arrow1 = new GConnectionVerticalDown(this.positionShape1, this.shape1.getGPoint("SOUTH_HOOK"), this.getPosition(0), ((Gtile)this.gtiles.get(0)).getGPoint("NORTH_HOOK"), TextBlockUtils.EMPTY_TEXT_BLOCK);
            GConnectionVerticalDown arrow2 = new GConnectionVerticalDown(this.getPosition(0), ((Gtile)this.gtiles.get(0)).getGPoint("SOUTH_HOOK"), this.positionShape2, this.shape2.getGPoint("NORTH_HOOK"), TextBlockUtils.EMPTY_TEXT_BLOCK);
            return Arrays.asList(arrow1, arrow2);
        }
        if (this.branches.size() == 2) {
            GConnectionHorizontalThenVerticalDown arrow1 = new GConnectionHorizontalThenVerticalDown(this.positionShape1, this.shape1.getGPoint("WEST_HOOK"), this.getPosition(0), ((Gtile)this.gtiles.get(0)).getGPoint("NORTH_HOOK"), TextBlockUtils.EMPTY_TEXT_BLOCK);
            GConnectionHorizontalThenVerticalDown arrow2 = new GConnectionHorizontalThenVerticalDown(this.positionShape1, this.shape1.getGPoint("EAST_HOOK"), this.getPosition(1), ((Gtile)this.gtiles.get(1)).getGPoint("NORTH_HOOK"), TextBlockUtils.EMPTY_TEXT_BLOCK);
            GConnectionVerticalDownThenHorizontal arrow3 = new GConnectionVerticalDownThenHorizontal(this.getPosition(0), ((Gtile)this.gtiles.get(0)).getGPoint("SOUTH_HOOK"), this.positionShape2, this.shape2.getGPoint("WEST_HOOK"), TextBlockUtils.EMPTY_TEXT_BLOCK);
            GConnectionVerticalDownThenHorizontal arrow4 = new GConnectionVerticalDownThenHorizontal(this.getPosition(1), ((Gtile)this.gtiles.get(1)).getGPoint("SOUTH_HOOK"), this.positionShape2, this.shape2.getGPoint("EAST_HOOK"), TextBlockUtils.EMPTY_TEXT_BLOCK);
            return Arrays.asList(arrow1, arrow2, arrow3, arrow4);
        }
        return super.getInnerConnections();
    }
}

