/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.dap.variables;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.epsilon.eol.dap.variables.IVariableReference;
import org.eclipse.epsilon.eol.dap.variables.IdentifiableReference;
import org.eclipse.epsilon.eol.dap.variables.SuspendedState;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.util.ReflectionUtil;

public class JavaObjectReference
extends IdentifiableReference<Object> {
    private static final Logger LOGGER = Logger.getLogger(JavaObjectReference.class.getCanonicalName());
    private final String[] METHOD_PREFIXES = new String[]{"get", "is"};
    private final String name;

    public JavaObjectReference(IEolContext context, String name, Object target) {
        super(context, target);
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getTypeName() {
        return String.format("Native('%s')", this.target.getClass().getName());
    }

    @Override
    public List<IVariableReference> getVariables(SuspendedState state) {
        ArrayList<IVariableReference> refs = new ArrayList<IVariableReference>();
        Set methodNames = ReflectionUtil.getMethodNames((Object)this.target, (boolean)true);
        for (String methodName : methodNames) {
            Method method;
            String propertyName = null;
            String[] stringArray = this.METHOD_PREFIXES;
            int n = this.METHOD_PREFIXES.length;
            int n2 = 0;
            while (n2 < n) {
                String suffix;
                String prefix = stringArray[n2];
                if (methodName.startsWith(prefix) && !(suffix = methodName.substring(prefix.length())).isEmpty()) {
                    if (suffix.length() >= 2 && Character.isUpperCase(suffix.charAt(0)) && Character.isUpperCase(suffix.charAt(1))) {
                        propertyName = suffix;
                        break;
                    }
                    propertyName = String.valueOf(suffix.substring(0, 1).toLowerCase()) + suffix.substring(1);
                    break;
                }
                ++n2;
            }
            if (propertyName == null || (method = ReflectionUtil.getMethodFor((Object)this.target, (String)methodName, (Object[])new Object[0], (boolean)true, (boolean)false)) == null || method.isVarArgs() || method.getReturnType() == Void.TYPE) continue;
            try {
                Object value = method.invoke(this.target, new Object[0]);
                refs.add(state.getValueReference(this.context, propertyName, value));
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
        return refs;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.name);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JavaObjectReference other = (JavaObjectReference)obj;
        return Objects.equals(this.name, other.name);
    }
}

