/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.specification.ext;

import java.io.File;
import org.eclipse.compare.IResourceProvider;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.diffmerge.ui.Messages;
import org.eclipse.emf.diffmerge.ui.specification.AbstractScopeDefinitionFactory;
import org.eclipse.emf.diffmerge.ui.specification.IModelScopeDefinition;
import org.eclipse.emf.diffmerge.ui.specification.ext.URIScopeDefinition;

public class URIScopeDefinitionFactory
extends AbstractScopeDefinitionFactory {
    protected boolean canConvertToURI(Object entrypoint_p) {
        return entrypoint_p instanceof IFile || entrypoint_p instanceof IResourceProvider || entrypoint_p instanceof String;
    }

    protected URI convertToURI(Object entrypoint_p) {
        URI result = null;
        if (entrypoint_p instanceof URI) {
            result = (URI)entrypoint_p;
        } else if (entrypoint_p instanceof IResourceProvider) {
            IResource wkResource = ((IResourceProvider)entrypoint_p).getResource();
            if (wkResource instanceof IFile) {
                result = this.toPlatformURI((IFile)wkResource);
            }
        } else if (entrypoint_p instanceof IFile) {
            result = this.toPlatformURI((IFile)entrypoint_p);
        } else if (entrypoint_p instanceof String) {
            result = this.toFileURI(entrypoint_p.toString());
        }
        return result;
    }

    @Override
    public IModelScopeDefinition createScopeDefinition(Object entrypoint_p, String label_p, boolean editable_p) {
        IModelScopeDefinition result = null;
        URI uri = this.convertToURI(entrypoint_p);
        if (uri != null) {
            String label = label_p != null ? label_p : this.getLabelFor(entrypoint_p);
            result = this.createScopeDefinitionFromURI(uri, label, editable_p);
        }
        return result;
    }

    protected IModelScopeDefinition createScopeDefinitionFromURI(URI uri_p, String label_p, boolean editable_p) {
        return new URIScopeDefinition(uri_p, label_p, editable_p);
    }

    protected String getFileExtension(Object entrypoint_p) {
        String location;
        int dotPosition;
        String result = null;
        if (entrypoint_p instanceof IFile) {
            result = ((IFile)entrypoint_p).getFileExtension();
        } else if (entrypoint_p instanceof URI) {
            result = ((URI)entrypoint_p).fileExtension();
        } else if (entrypoint_p instanceof String && (dotPosition = (location = (String)entrypoint_p).lastIndexOf(File.separator)) > -1 && dotPosition < location.length()) {
            result = location.substring(dotPosition + 1);
        }
        if (result != null) {
            result = result.toLowerCase();
        }
        return result;
    }

    @Override
    public String getLabel() {
        return Messages.FileScopeDefinitionFactory_Label;
    }

    protected String getLabelFor(Object entrypoint_p) {
        String result = null;
        if (entrypoint_p instanceof IFile) {
            result = this.getLabelForFile((IFile)entrypoint_p);
        }
        return result;
    }

    protected String getLabelForFile(IFile file_p) {
        String result = null;
        if (file_p != null && (result = file_p.getFullPath().toPortableString()).startsWith("/") && result.length() > 1) {
            result = result.substring(1);
        }
        return result;
    }

    @Override
    public boolean isApplicableTo(Object entrypoint_p) {
        return entrypoint_p instanceof URI || this.canConvertToURI(entrypoint_p);
    }

    protected URI toFileURI(String file_p) {
        URI result = null;
        if (file_p != null) {
            result = URI.createFileURI((String)file_p);
        }
        return result;
    }

    protected URI toPlatformURI(IFile file_p) {
        URI result = null;
        if (file_p != null) {
            result = URI.createPlatformResourceURI((String)file_p.getFullPath().toPortableString(), (boolean)true);
        }
        return result;
    }
}

