/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.shapes;

import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.draw3d.RenderContext;
import org.eclipse.draw3d.RenderFragment;
import org.eclipse.draw3d.geometry.IPosition3D;
import org.eclipse.draw3d.geometry.IVector2f;
import org.eclipse.draw3d.geometry.IVector3f;
import org.eclipse.draw3d.geometry.Math3D;
import org.eclipse.draw3d.geometry.Vector2fImpl;
import org.eclipse.draw3d.geometry.Vector3f;
import org.eclipse.draw3d.geometry.Vector3fImpl;
import org.eclipse.draw3d.graphics3d.DisplayListManager;
import org.eclipse.draw3d.graphics3d.Graphics3D;
import org.eclipse.draw3d.shapes.PositionableShape;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CuboidShape
extends PositionableShape {
    private static final String DL_FILL_FRONT = "fill_cube_front";
    private static final String DL_FILL_REST = "fill_cube_rest";
    private static final String DL_OUTLINE = "outline_cube";
    private static final String DL_TEXTURE = "cube_texture";
    private static final int[][] FACES = new int[6][4];
    private static final Logger log = Logger.getLogger(CuboidShape.class.getName());
    private static final IVector3f[] NORMALS = new IVector3f[6];
    private static final IVector2f[] TEX_COORDS = new IVector2f[4];
    private static final IVector3f[] VERTICES = new IVector3f[8];
    private int m_alpha = 255;
    private boolean m_fill = true;
    private Color m_fillColor = Display.getCurrent().getSystemColor(1);
    private boolean m_outline = true;
    private Color m_outlineColor = Display.getCurrent().getSystemColor(2);
    private boolean m_superimposed;
    private Integer m_textureId;

    static {
        int i = 0;
        while (i < 8) {
            int z = i & 1;
            int y = (i & 2) >> 1;
            int x = (i & 4) >> 2;
            CuboidShape.VERTICES[i] = new Vector3fImpl((float)x, (float)y, (float)z);
            ++i;
        }
        CuboidShape.FACES[0][0] = 2;
        CuboidShape.FACES[0][1] = 6;
        CuboidShape.FACES[0][2] = 4;
        CuboidShape.FACES[0][3] = 0;
        CuboidShape.NORMALS[0] = IVector3f.Z_AXIS_NEG;
        CuboidShape.FACES[1][0] = 5;
        CuboidShape.FACES[1][1] = 7;
        CuboidShape.FACES[1][2] = 3;
        CuboidShape.FACES[1][3] = 1;
        CuboidShape.NORMALS[1] = IVector3f.Z_AXIS;
        CuboidShape.FACES[2][0] = 1;
        CuboidShape.FACES[2][1] = 3;
        CuboidShape.FACES[2][2] = 2;
        CuboidShape.FACES[2][3] = 0;
        CuboidShape.NORMALS[2] = IVector3f.X_AXIS_NEG;
        CuboidShape.FACES[3][0] = 6;
        CuboidShape.FACES[3][1] = 7;
        CuboidShape.FACES[3][2] = 5;
        CuboidShape.FACES[3][3] = 4;
        CuboidShape.NORMALS[3] = IVector3f.X_AXIS;
        CuboidShape.FACES[4][0] = 4;
        CuboidShape.FACES[4][1] = 5;
        CuboidShape.FACES[4][2] = 1;
        CuboidShape.FACES[4][3] = 0;
        CuboidShape.NORMALS[4] = IVector3f.Y_AXIS_NEG;
        CuboidShape.FACES[5][0] = 3;
        CuboidShape.FACES[5][1] = 7;
        CuboidShape.FACES[5][2] = 6;
        CuboidShape.FACES[5][3] = 2;
        CuboidShape.NORMALS[5] = IVector3f.Y_AXIS;
        CuboidShape.TEX_COORDS[0] = new Vector2fImpl(0.0f, 0.0f);
        CuboidShape.TEX_COORDS[1] = new Vector2fImpl(1.0f, 0.0f);
        CuboidShape.TEX_COORDS[2] = new Vector2fImpl(1.0f, 1.0f);
        CuboidShape.TEX_COORDS[3] = new Vector2fImpl(0.0f, 1.0f);
    }

    public CuboidShape(IPosition3D i_position3D, boolean i_superimposed) {
        super(i_position3D);
        this.m_superimposed = i_superimposed;
    }

    @Override
    protected float doGetDistance(IVector3f i_rayOrigin, IVector3f i_rayDirection, Map<Object, Object> i_context) {
        Vector3f[] face = new Vector3f[4];
        int i = 0;
        while (i < FACES.length) {
            int j = 0;
            while (j < FACES[i].length) {
                face[j] = VERTICES[FACES[i][j]];
                ++j;
            }
            float distance = Math3D.rayIntersectsPolygon((IVector3f)i_rayOrigin, (IVector3f)i_rayDirection, (IVector3f[])face, (IVector3f)NORMALS[i], null);
            if (!Float.isNaN(distance)) {
                return distance;
            }
            ++i;
        }
        return Float.NaN;
    }

    @Override
    protected void doRender(RenderContext i_renderContext) {
        DisplayListManager displayListManager = i_renderContext.getGraphics3D().getDisplayListManager();
        Graphics3D g3d = i_renderContext.getGraphics3D();
        this.initDisplayLists(displayListManager, g3d);
        if (this.getRenderType() != RenderFragment.RenderType.TRANSPARENT) {
            if (this.m_fill) {
                this.renderFill(displayListManager, g3d);
            }
            if (this.m_outline) {
                this.renderOutline(displayListManager, g3d);
            }
        } else {
            if (this.m_outline) {
                this.renderOutline(displayListManager, g3d);
            }
            if (this.m_fill) {
                this.renderFill(displayListManager, g3d);
            }
        }
    }

    @Override
    public RenderFragment.RenderType getRenderType() {
        return RenderFragment.RenderType.getRenderType(this.m_alpha, this.m_superimposed);
    }

    private void initDisplayLists(DisplayListManager i_displayListManager, final Graphics3D g3d) {
        if (i_displayListManager.isDisplayList(new Object[]{DL_OUTLINE, DL_FILL_REST, DL_FILL_FRONT, DL_TEXTURE})) {
            return;
        }
        Runnable outline = new Runnable(){

            public void run() {
                g3d.glBegin(2);
                g3d.glVertex3f(0.0f, 0.0f, 0.0f);
                g3d.glVertex3f(1.0f, 0.0f, 0.0f);
                g3d.glVertex3f(1.0f, 0.0f, 1.0f);
                g3d.glVertex3f(0.0f, 0.0f, 1.0f);
                g3d.glEnd();
                g3d.glBegin(2);
                g3d.glVertex3f(0.0f, 1.0f, 0.0f);
                g3d.glVertex3f(1.0f, 1.0f, 0.0f);
                g3d.glVertex3f(1.0f, 1.0f, 1.0f);
                g3d.glVertex3f(0.0f, 1.0f, 1.0f);
                g3d.glEnd();
                g3d.glBegin(1);
                g3d.glVertex3f(0.0f, 0.0f, 0.0f);
                g3d.glVertex3f(0.0f, 1.0f, 0.0f);
                g3d.glVertex3f(1.0f, 0.0f, 0.0f);
                g3d.glVertex3f(1.0f, 1.0f, 0.0f);
                g3d.glVertex3f(0.0f, 0.0f, 1.0f);
                g3d.glVertex3f(0.0f, 1.0f, 1.0f);
                g3d.glVertex3f(1.0f, 0.0f, 1.0f);
                g3d.glVertex3f(1.0f, 1.0f, 1.0f);
                g3d.glEnd();
            }
        };
        Runnable front = new Runnable(){

            public void run() {
                g3d.glBegin(7);
                g3d.glNormal3f(NORMALS[0]);
                int i = 0;
                while (i < 4) {
                    g3d.glVertex3f(VERTICES[FACES[0][i]]);
                    ++i;
                }
                g3d.glEnd();
            }
        };
        Runnable texture = new Runnable(){

            public void run() {
                g3d.glBegin(7);
                g3d.glNormal3f(NORMALS[0]);
                int i = 0;
                while (i < 4) {
                    g3d.glTexCoord2f(TEX_COORDS[i]);
                    g3d.glVertex3f(VERTICES[FACES[0][i]]);
                    ++i;
                }
                g3d.glNormal3f(NORMALS[1]);
                i = 3;
                while (i >= 0) {
                    g3d.glTexCoord2f(TEX_COORDS[i]);
                    g3d.glVertex3f(VERTICES[FACES[0][i]]);
                    --i;
                }
                g3d.glEnd();
            }
        };
        Runnable rest = new Runnable(){

            public void run() {
                g3d.glBegin(7);
                int j = 1;
                while (j < FACES.length) {
                    g3d.glNormal3f(NORMALS[j]);
                    int i = 0;
                    while (i < 4) {
                        g3d.glVertex3f(VERTICES[FACES[j][i]]);
                        ++i;
                    }
                    ++j;
                }
                g3d.glEnd();
            }
        };
        i_displayListManager.interruptDisplayList();
        try {
            i_displayListManager.createDisplayList((Object)DL_OUTLINE, outline);
            i_displayListManager.createDisplayList((Object)DL_FILL_FRONT, front);
            i_displayListManager.createDisplayList((Object)DL_TEXTURE, texture);
            i_displayListManager.createDisplayList((Object)DL_FILL_REST, rest);
        }
        finally {
            i_displayListManager.resumeDisplayList();
        }
    }

    private void renderFill(DisplayListManager displayListManager, Graphics3D g3d) {
        g3d.glPolygonMode(1032, 6914);
        if (this.m_textureId != null) {
            g3d.glColor4f(0.0f, 0.0f, 0.0f, 0.0f);
            g3d.glBindTexture(3553, this.m_textureId.intValue());
            g3d.glTexEnvi(8960, 8704, 7681);
            displayListManager.executeDisplayList((Object)DL_TEXTURE);
            g3d.glBindTexture(3553, 0);
            g3d.glColor(this.m_fillColor, this.m_alpha);
        } else {
            g3d.glColor(this.m_fillColor, this.m_alpha);
            displayListManager.executeDisplayList((Object)DL_FILL_FRONT);
        }
        displayListManager.executeDisplayList((Object)DL_FILL_REST);
    }

    private void renderOutline(DisplayListManager displayListManager, Graphics3D g3d) {
        g3d.glColor(this.m_outlineColor, this.m_alpha);
        displayListManager.executeDisplayList((Object)DL_OUTLINE);
    }

    public void setAlpha(int i_alpha) {
        this.m_alpha = i_alpha;
    }

    public void setFill(boolean i_fill) {
        this.m_fill = i_fill;
    }

    public void setFillColor(Color i_color) {
        this.m_fillColor = i_color;
    }

    public void setOutline(boolean i_outline) {
        this.m_outline = i_outline;
    }

    public void setOutlineColor(Color i_color) {
        this.m_outlineColor = i_color;
    }

    public void setTextureId(Integer i_textureId) {
        this.m_textureId = i_textureId;
    }
}

