/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.geometry;

import org.eclipse.draw3d.geometry.BoundingBox;
import org.eclipse.draw3d.geometry.IBoundingBox;
import org.eclipse.draw3d.geometry.IMatrix4f;
import org.eclipse.draw3d.geometry.IVector3f;
import org.eclipse.draw3d.geometry.Math3D;
import org.eclipse.draw3d.geometry.Math3DCache;
import org.eclipse.draw3d.geometry.Vector3f;
import org.eclipse.draw3d.geometry.Vector3fImpl;
import org.eclipse.draw3d.geometry.Vector4fImpl;

public class BoundingBoxImpl
implements BoundingBox {
    public Vector3fImpl m_position;
    public Vector3fImpl m_size;

    public BoundingBoxImpl() {
        this.m_position = new Vector3fImpl();
        this.m_size = new Vector3fImpl();
    }

    public BoundingBoxImpl(boolean bCreateUnitBox) {
        this.m_position = new Vector3fImpl();
        this.m_size = new Vector3fImpl(1.0f, 1.0f, 1.0f);
    }

    public BoundingBoxImpl(IBoundingBox i_sourceBoundingBox) {
        this.m_position = new Vector3fImpl();
        this.m_size = new Vector3fImpl();
        i_sourceBoundingBox.getLocation(this.m_position);
        i_sourceBoundingBox.getSize(this.m_size);
    }

    public BoundingBoxImpl(IVector3f i_position, IVector3f i_size) {
        this.m_position = new Vector3fImpl(i_position);
        this.m_size = new Vector3fImpl(i_size);
    }

    public void expand(float i_iDelta) {
        float d = -0.5f * i_iDelta;
        Math3D.translate(this.m_position, d, d, d, this.m_position);
        Math3D.translate(this.m_size, i_iDelta, i_iDelta, i_iDelta, this.m_size);
    }

    public Vector3f getCenter(Vector3f o_resultVector3f) {
        Vector3f result = o_resultVector3f != null ? o_resultVector3f : new Vector3fImpl();
        result.setX(this.m_position.getX() + this.m_size.getX() / 2.0f);
        result.setY(this.m_position.getY() + this.m_size.getY() / 2.0f);
        result.setZ(this.m_position.getZ() + this.m_size.getZ() / 2.0f);
        return result;
    }

    public Vector3f getEnd(Vector3f o_resultVector3f) {
        Vector3f result = o_resultVector3f;
        if (result == null) {
            result = new Vector3fImpl();
        }
        Math3D.add(this.m_position, this.m_size, result);
        return result;
    }

    public Vector3f getLocation(Vector3f o_resultVector3f) {
        Vector3f result = o_resultVector3f != null ? o_resultVector3f : new Vector3fImpl();
        result.set(this.m_position);
        return result;
    }

    public Vector3f getSize(Vector3f o_resultVector3f) {
        Vector3f result = o_resultVector3f != null ? o_resultVector3f : new Vector3fImpl();
        result.set(this.m_size);
        return result;
    }

    public void resize(float i_dx, float i_dy, float i_dz) {
        Math3D.translate(this.m_size, i_dx, i_dy, i_dz, this.m_size);
    }

    public void resize(IVector3f i_deltaVector3f) {
        Math3D.translate(this.m_size, i_deltaVector3f.getX(), i_deltaVector3f.getY(), i_deltaVector3f.getZ(), this.m_size);
    }

    public void scale(float i_factor) {
        Math3D.scale(i_factor, (IVector3f)this.m_size, (Vector3f)this.m_size);
    }

    public void set(IBoundingBox i_sourceBoundingBox3f) {
        i_sourceBoundingBox3f.getLocation(this.m_position);
        i_sourceBoundingBox3f.getSize(this.m_size);
    }

    public void setEnd(IVector3f i_end) {
        Vector3f tmpEnd = Math3DCache.getVector3f();
        try {
            Math3D.max(this.getEnd(tmpEnd), i_end, tmpEnd);
            Math3D.min(this.m_position, i_end, this.m_position);
            Math3D.sub(tmpEnd, this.m_position, this.m_size);
        }
        catch (Throwable throwable) {
            Math3DCache.returnVector3f(tmpEnd);
            throw throwable;
        }
        Math3DCache.returnVector3f(tmpEnd);
    }

    public void setLocation(float i_x, float i_y, float i_z) {
        this.m_position.x = i_x;
        this.m_position.y = i_y;
        this.m_position.z = i_z;
    }

    public void setLocation(IVector3f i_location) {
        this.setLocation(i_location.getX(), i_location.getY(), i_location.getZ());
    }

    public void setSize(float i_width, float i_height, float i_depth) {
        this.m_size.x = i_width;
        this.m_size.y = i_height;
        this.m_size.z = i_depth;
    }

    public void setSize(IVector3f i_newSize) {
        this.m_size.x = i_newSize.getX();
        this.m_size.y = i_newSize.getY();
        this.m_size.z = i_newSize.getZ();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("BoundingBoxImpl[ Size: ");
        sb.append(this.m_size.toString());
        sb.append(" Position: ");
        sb.append(this.m_position.toString());
        sb.append("]\n");
        return sb.toString();
    }

    public void transform(IMatrix4f i_transformationMatrix4f) {
        float x = this.m_position.getX();
        float y = this.m_position.getY();
        float z = this.m_position.getZ();
        Vector4fImpl tmp = new Vector4fImpl(x, y, z, 1.0f);
        Math3D.transform(tmp, i_transformationMatrix4f, tmp);
        float w = tmp.getW();
        x = tmp.getX() / w;
        y = tmp.getY() / w;
        z = tmp.getZ() / w;
        this.setLocation(x, y, z);
    }

    public void translate(float i_dx, float i_dy, float i_dz) {
        Math3D.translate(this.m_position, i_dx, i_dy, i_dz, this.m_position);
    }

    public void translate(IVector3f i_sourceVector3f) {
        Math3D.translate(this.m_position, i_sourceVector3f.getX(), i_sourceVector3f.getY(), i_sourceVector3f.getZ(), this.m_position);
    }
}

