#!/usr/bin/env python3
#-*- coding:utf-8 -*-

# ##### BEGIN GPL LICENSE BLOCK #####
#
#  This program is free software; you can redistribute it and/or
#  modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 3
#  of the License, or (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software Foundation,
#  Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
#
# ##### END GPL LICENSE BLOCK #####

# <pep8 compliant>

# This script was developed with financial support from the Foundation for
# Science and Technology of Portugal, under the grant SFRH/BD/66452/2009.


skeleton_url = "http://mocap.cs.cmu.edu:8080/subjects/{0:02d}/{0:02d}.asf"
motion_url = "http://mocap.cs.cmu.edu:8080/subjects/{0:02d}/{0:02d}_{1:02d}."
search_url = "http://mocap.cs.cmu.edu/search.php?subjectnumber=%&motion=%"

# Carnegie Mellon University Mocap Library - http://mocap.cs.cmu.edu

subjects = {1: {'desc': 'climb, swing, hang on playground equipment',
     'motions': {1: {'desc': 'playground - forward jumps, turn around',
                     'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                     'fps': 120},
                 2: {'desc': 'playground - climb',
                     'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                     'fps': 120},
                 3: {'desc': 'playground - climb, hang, swing',
                     'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                     'fps': 120},
                 4: {'desc': 'playground - climb',
                     'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                     'fps': 120},
                 5: {'desc': 'playground - climb, go under',
                     'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                     'fps': 120},
                 6: {'desc': 'playground - climb, sit, dangle legs, descend',
                     'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                     'fps': 120},
                 7: {'desc': 'playground - climb, sit, dangle legs, jump down',
                     'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                     'fps': 120},
                 8: {'desc': 'playground - climb, sit, dangle legs, rock back, lower self to ground',
                     'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                     'fps': 120},
                 9: {'desc': 'playground - climb, hang, hold self up with arms straight, swing, drop, sit, dangle legs, go under',
                     'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                     'fps': 120},
                 10: {'desc': 'playground - climb, swing, lean back, drop',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                 11: {'desc': 'playground - climb, hang, lean over, jump down',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                 12: {'desc': 'playground - climb, pull up, dangle, sit, lower self to ground',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                 13: {'desc': 'playground - climb, go under, jump down',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                 14: {'desc': 'playground - climb, jump down, dangle, legs push off against',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120}}},
 2: {'desc': 'various expressions and human behaviors',
     'motions': {1: {'desc': 'walk',
                     'files': ['tvd', 'c3d', 'amc', 'avi'],
                     'fps': 120},
                 2: {'desc': 'walk',
                     'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                     'fps': 120},
                 3: {'desc': 'run/jog',
                     'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                     'fps': 120},
                 4: {'desc': 'jump, balance',
                     'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                     'fps': 120},
                 5: {'desc': 'punch/strike',
                     'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                     'fps': 120},
                 6: {'desc': 'bend over, scoop up, rise, lift arm',
                     'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                     'fps': 120},
                 7: {'desc': 'swordplay',
                     'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                     'fps': 120},
                 8: {'desc': 'swordplay',
                     'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                     'fps': 120},
                 9: {'desc': 'swordplay',
                     'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                     'fps': 120},
                 10: {'desc': 'wash self',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120}}},
 3: {'desc': 'walk on uneven terrain',
     'motions': {1: {'desc': 'walk on uneven terrain',
                     'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                     'fps': 120},
                 2: {'desc': 'walk on uneven terrain',
                     'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                     'fps': 120},
                 3: {'desc': 'walk on uneven terrain',
                     'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                     'fps': 120},
                 4: {'desc': 'walk on uneven terrain',
                     'files': ['c3d', 'amc', 'avi'],
                     'fps': 120}}},
 5: {'desc': 'modern dance',
     'motions': {1: {'desc': 'walk',
                     'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                     'fps': 120},
                 2: {'desc': 'dance - expressive arms, pirouette',
                     'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                     'fps': 120},
                 3: {'desc': 'dance - sideways arabesque, turn step, folding arms',
                     'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                     'fps': 120},
                 4: {'desc': 'dance - sideways arabesque, folding arms, bending back',
                     'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                     'fps': 120},
                 5: {'desc': 'dance - quasi-cou-de-pied, raised leg above hip-height, jete en tourant',
                     'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                     'fps': 120},
                 6: {'desc': 'dance - cartwheel-like start, pirouettes, jete',
                     'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                     'fps': 120},
                 7: {'desc': 'dance - small jetes, attitude/arabesque, shifted-axis pirouette, turn',
                     'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                     'fps': 120},
                 8: {'desc': 'dance - rond de jambe in the air, jete, turn',
                     'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                     'fps': 120},
                 9: {'desc': 'dance - glissade devant, glissade derriere, attitude/arabesque',
                     'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                     'fps': 120},
                 10: {'desc': 'dance - glissade devant, glissade derriere, attitude/arabesque',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                 11: {'desc': 'dance - sideways steps, pirouette',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                 12: {'desc': 'dance - arms held high, pointe tendue a terre, upper body rotation',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                 13: {'desc': 'dance - small jetes, pirouette',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                 14: {'desc': 'dance - retire derriere, attitude/arabesque',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                 15: {'desc': 'dance - retire derriere, attitude/arabesque',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                 16: {'desc': 'dance - coupe dessous, jete en tourant',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                 17: {'desc': 'dance - coupe dessous, grand jete en tourant',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                 18: {'desc': 'dance - attitude/arabesque, jete en tourant, bending back',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                 19: {'desc': 'dance - attitude/arabesque, jete en tourant, bending back',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                 20: {'desc': 'dance - attitude/arabesque, jete en tourant, bending back',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120}}},
 6: {'desc': 'dribble, shoot basketball',
     'motions': {1: {'desc': 'walk',
                     'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                     'fps': 120},
                 2: {'desc': 'basketball - forward dribble',
                     'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                     'fps': 120},
                 3: {'desc': 'basketball - forward dribble',
                     'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                     'fps': 120},
                 4: {'desc': 'basketball - forward dribble',
                     'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                     'fps': 120},
                 5: {'desc': 'basketball - forward dribble',
                     'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                     'fps': 120},
                 6: {'desc': 'basketball - backward dribble',
                     'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                     'fps': 120},
                 7: {'desc': 'basketball - backward dribble',
                     'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                     'fps': 120},
                 8: {'desc': 'basketball - sideways dribble',
                     'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                     'fps': 120},
                 9: {'desc': 'basketball - sideways dribble',
                     'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                     'fps': 120},
                 10: {'desc': 'basketball - forward dribble, 90-degree left turns',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                 11: {'desc': 'basketball - forward dribble, 90-degree right turns',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                 12: {'desc': 'basketball - forward dribble, 90-degree right turns, crossover dribble',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                 13: {'desc': 'basketball - low, fast free style dribble, dribble through legs',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                 14: {'desc': 'basketball - crossover dribble, shoot',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                 15: {'desc': 'basketball - dribble, shoot',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120}}},
 7: {'desc': 'walk',
     'motions': {1: {'desc': 'walk',
                     'files': ['tvd', 'c3d', 'amc', 'avi'],
                     'fps': 120},
                 2: {'desc': 'walk',
                     'files': ['tvd', 'c3d', 'amc', 'avi'],
                     'fps': 120},
                 3: {'desc': 'walk',
                     'files': ['c3d', 'amc', 'avi'],
                     'fps': 120},
                 4: {'desc': 'slow walk',
                     'files': ['tvd', 'c3d', 'amc', 'avi'],
                     'fps': 120},
                 5: {'desc': 'slow walk',
                     'files': ['tvd', 'c3d', 'amc', 'avi'],
                     'fps': 120},
                 6: {'desc': 'walk',
                     'files': ['tvd', 'c3d', 'amc', 'avi'],
                     'fps': 120},
                 7: {'desc': 'walk',
                     'files': ['tvd', 'c3d', 'amc', 'avi'],
                     'fps': 120},
                 8: {'desc': 'walk',
                     'files': ['tvd', 'c3d', 'amc', 'avi'],
                     'fps': 120},
                 9: {'desc': 'walk',
                     'files': ['tvd', 'c3d', 'amc', 'avi'],
                     'fps': 120},
                 10: {'desc': 'walk',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                 11: {'desc': 'walk',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                 12: {'desc': 'brisk walk',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120}}},
 8: {'desc': 'walk',
     'motions': {1: {'desc': 'walk',
                     'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                     'fps': 120},
                 2: {'desc': 'walk',
                     'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                     'fps': 120},
                 3: {'desc': 'walk',
                     'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                     'fps': 120},
                 4: {'desc': 'slow walk',
                     'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                     'fps': 120},
                 5: {'desc': 'walk/stride',
                     'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                     'fps': 120},
                 6: {'desc': 'walk',
                     'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                     'fps': 120},
                 7: {'desc': 'walk, exaggerated stride',
                     'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                     'fps': 120},
                 8: {'desc': 'walk',
                     'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                     'fps': 120},
                 9: {'desc': 'walk',
                     'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                     'fps': 120},
                 10: {'desc': 'walk',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                 11: {'desc': 'slow walk/stride',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120}}},
 9: {'desc': 'run',
     'motions': {1: {'desc': 'run',
                     'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                     'fps': 120},
                 2: {'desc': 'run',
                     'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                     'fps': 120},
                 3: {'desc': 'run',
                     'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                     'fps': 120},
                 4: {'desc': 'run',
                     'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                     'fps': 120},
                 5: {'desc': 'run',
                     'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                     'fps': 120},
                 6: {'desc': 'run',
                     'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                     'fps': 120},
                 7: {'desc': 'run',
                     'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                     'fps': 120},
                 8: {'desc': 'run',
                     'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                     'fps': 120},
                 9: {'desc': 'run',
                     'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                     'fps': 120},
                 10: {'desc': 'run',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                 11: {'desc': 'run',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                 12: {'desc': 'navigate - walk forward, backward, sideways',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120}}},
 10: {'desc': 'kick soccer ball',
      'motions': {1: {'desc': 'soccer - kick ball',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  2: {'desc': 'soccer - kick ball',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  3: {'desc': 'soccer - kick ball',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  4: {'desc': 'walk',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  5: {'desc': 'soccer - kick ball',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  6: {'desc': 'soccer - kick ball',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120}}},
 11: {'desc': 'kick soccer ball',
      'motions': {1: {'desc': 'soccer - kick ball',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120}}},
 12: {'desc': 'tai chi, walk',
      'motions': {1: {'desc': 'walk',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  2: {'desc': 'walk',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  3: {'desc': 'walk',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  4: {'desc': 'tai chi',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120}}},
 13: {'desc': 'various everyday behaviors',
      'motions': {1: {'desc': 'sit on high stool, stand up',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  2: {'desc': 'sit on high stool, stand up',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  3: {'desc': 'sit on high stool, stand up',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  4: {'desc': 'sit on stepstool, chin in hand',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  5: {'desc': 'sit on stepstool, hands against chin, fidget, stand up',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  6: {'desc': 'sit on stepstool, hands against chin, elbow out, stand up',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  7: {'desc': 'unscrew bottlecap, drink soda',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  8: {'desc': 'unscrew bottlecap, drink soda, screw on bottlecap',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  9: {'desc': 'drink soda',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  10: {'desc': 'jump up to grab, reach for, tiptoe',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  11: {'desc': 'forward jump',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  12: {'desc': 'jump up to grab, reach for, tiptoe',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  13: {'desc': 'forward jump',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  14: {'desc': 'laugh',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  15: {'desc': 'laugh',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  16: {'desc': 'laugh',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  17: {'desc': 'boxing',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  18: {'desc': 'boxing',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  19: {'desc': 'forward jump',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  20: {'desc': 'wash windows',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  21: {'desc': 'wash windows',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  22: {'desc': 'wash windows',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  23: {'desc': 'sweep floor',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  24: {'desc': 'sweep floor',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  25: {'desc': 'sweep floor',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  26: {'desc': 'direct traffic, wave',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  27: {'desc': 'direct traffic, wave, point',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  28: {'desc': 'direct traffic, wave, point',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  29: {'desc': 'jumping jacks, side twists, bend over, squats',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  30: {'desc': 'jumping jacks, side twists, squats, jog',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  31: {'desc': 'jumping jacks, side twists, bend over, jog',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  32: {'desc': 'forward jump',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  33: {'desc': 'climb ladder',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  34: {'desc': 'climb ladder',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  35: {'desc': 'climb 3 steps',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  36: {'desc': 'climb 3 steps',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  37: {'desc': 'climb 3 steps',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  38: {'desc': 'climb 3 steps',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  39: {'desc': 'jump',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  40: {'desc': 'jump',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  41: {'desc': 'jump',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  42: {'desc': 'jump',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120}}},
 14: {'desc': 'various everyday behaviors',
      'motions': {1: {'desc': 'boxing',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  2: {'desc': 'boxing',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  3: {'desc': 'boxing',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  4: {'desc': 'drink soda, screw on bottlecap',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  5: {'desc': 'unscrew bottlecap, drink soda',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  6: {'desc': 'jumping jacks, jog, squats, side twists, stretches',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  7: {'desc': 'jump up to grab, reach for, tiptoe',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  8: {'desc': 'jump up to grab, reach for, tiptoe',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  9: {'desc': 'jump up to grab, reach for, tiptoe',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  10: {'desc': 'wash windows',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  11: {'desc': 'wash windows',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  12: {'desc': 'wash windows',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  13: {'desc': 'mop floor',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  14: {'desc': 'jumping jacks, jog, squats, side twists, stretches',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  15: {'desc': 'mop floor',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  16: {'desc': 'sweep floor',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  17: {'desc': 'laugh',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  18: {'desc': 'laugh',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  19: {'desc': 'laugh',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  20: {'desc': 'jumping jacks, side twists, reach up, bend over',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  21: {'desc': 'climb 3 steps',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  22: {'desc': 'climb 3 steps',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  23: {'desc': 'climb 3 steps',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  24: {'desc': 'direct traffic, wave, point',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  25: {'desc': 'direct traffic, wave, point',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  26: {'desc': 'direct traffic, wave, point',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  27: {'desc': 'sit on high stool, stand up',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  28: {'desc': 'sit on high stool, stand up',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  29: {'desc': 'sit on stepstool, stand up, swing legs',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  30: {'desc': 'sit on stepstool, ankle on other knee, hand on chin',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  31: {'desc': 'sit on stepstool, stand up',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  32: {'desc': 'sit on stepstool, stand up',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  33: {'desc': 'climb ladder',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  34: {'desc': 'climb ladder',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  35: {'desc': 'climb ladder',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  36: {'desc': 'sit on stepstool, stand up',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  37: {'desc': 'drink soda',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120}}},
 15: {'desc': 'various everyday behaviors, dance moves',
      'motions': {1: {'desc': 'walk/wander',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  2: {'desc': 'climb, step over, sit on, stand on stepstool',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  3: {'desc': 'walk/wander',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  4: {'desc': 'wash windows, paint; hand signals; dance - Egyptian walk, the Dive, the Twist, the Cabbage Patch; boxing',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  5: {'desc': 'wash windows, paint; hand signals; dance - Egyptian walk, the Dive, the Twist, the Cabbage Patch; boxing',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  6: {'desc': 'lean forward, reach for',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  7: {'desc': 'lean forward, tiptoe, reach for',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  8: {'desc': 'hand signals - horizontally revolve forearms',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  9: {'desc': 'walk/wander',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  10: {'desc': 'sit on high stool, stand up',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  11: {'desc': 'wash windows, paint figure eights; hand signals',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  12: {'desc': 'wash windows; basketball - dribble, lay-up shot, pass; throw ball; dance - Egyptian walk, the Dive, the Twist; strew',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  13: {'desc': 'boxing',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  14: {'desc': 'walk/wander',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120}}},
 16: {'desc': 'run, jump, walk',
      'motions': {1: {'desc': 'jump',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  2: {'desc': 'jump',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  3: {'desc': 'high jump',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  4: {'desc': 'high jump',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  5: {'desc': 'forward jump',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  6: {'desc': 'forward jump',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  7: {'desc': 'forward jump',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  8: {'desc': 'run/jog, sudden stop',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  9: {'desc': 'forward jump',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  10: {'desc': 'forward jump',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  11: {'desc': 'walk, veer left',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  12: {'desc': 'walk, veer left',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  13: {'desc': 'walk, veer right',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  14: {'desc': 'walk, veer right',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  15: {'desc': 'walk',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  16: {'desc': 'walk',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  17: {'desc': 'walk, 90-degree left turn',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  18: {'desc': 'walk, 90-degree left turn',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  19: {'desc': 'walk, 90-degree right turn',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  20: {'desc': 'walk, 90-degree right turn',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  21: {'desc': 'walk',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  22: {'desc': 'walk',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  23: {'desc': 'walk, veer left',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  24: {'desc': 'walk, veer left',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  25: {'desc': 'walk, veer right',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  26: {'desc': 'walk, veer right',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  27: {'desc': 'walk, 90-degree left turn',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  28: {'desc': 'walk, 90-degree left turn',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  29: {'desc': 'walk, 90-degree right turn',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  30: {'desc': 'walk, 90-degree right turn',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  31: {'desc': 'walk',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  32: {'desc': 'walk',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  33: {'desc': 'slow walk, stop',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  34: {'desc': 'slow walk, stop',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  35: {'desc': 'run/jog',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  36: {'desc': 'run/jog',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  37: {'desc': 'run/jog, veer left',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  38: {'desc': 'run/jog, veer left',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  39: {'desc': 'run/jog, veer right',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  40: {'desc': 'run/jog, veer right',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  41: {'desc': 'run/jog, 90-degree left turn',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  42: {'desc': 'run/jog, 90-degree left turn',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  43: {'desc': 'run/jog, 90-degree right turn',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  44: {'desc': 'run/jog, 90-degree right turn',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  45: {'desc': 'run/jog',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  46: {'desc': 'run/jog',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  47: {'desc': 'walk',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  48: {'desc': 'run, veer left',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  49: {'desc': 'run, veer right',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  50: {'desc': 'run, veer right',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  51: {'desc': 'run, 90-degree left turn',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  52: {'desc': 'run, 90-degree left turn',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  53: {'desc': 'run, 90-degree right turn',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  54: {'desc': 'run, 90-degree right turn',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  55: {'desc': 'run',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  56: {'desc': 'run/jog',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  57: {'desc': 'run/jog, sudden stop',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  58: {'desc': 'walk',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120}}},
 17: {'desc': 'different walking styles',
      'motions': {1: {'desc': 'walk with anger, frustration',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  2: {'desc': 'walk with anger, frustration',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  3: {'desc': 'walk stealthily',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  4: {'desc': 'walk stealthily',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  5: {'desc': 'walk/hobble',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  6: {'desc': 'whistle, walk jauntily',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  7: {'desc': 'whistle, walk jauntily',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  8: {'desc': "muscular, heavyset person's walk",
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  9: {'desc': "muscular, heavyset person's walk",
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  10: {'desc': 'boxing',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120}}},
 18: {'desc': 'human interaction and communication (2 subjects - subject A)',
      'motions': {1: {'desc': 'walk, shake hands (2 subjects - subject A)',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  2: {'desc': 'walk, shake hands (2 subjects - subject A)',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  3: {'desc': 'A pulls B; B resists (2 subjects - subject A)',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  4: {'desc': 'A pulls B; B resists (2 subjects - subject A)',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  5: {'desc': 'A pulls B by the elbow; B resists (2 subjects - subject A)',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  6: {'desc': 'A pulls B by the elbow; B resists (2 subjects - subject A)',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  7: {'desc': 'navigate busy sidewalk; A leads the way, takes B by the arm (2 subjects - subject A)',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  8: {'desc': 'conversation - explain with hand gestures (2 subjects - subject A)',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  9: {'desc': 'conversation - explain with hand gestures, walk (2 subjects - subject A)',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  10: {'desc': 'quarrel - angry hand gestures (2 subjects - subject A)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  11: {'desc': 'quarrel - angry hand gestures (2 subjects - subject A)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  12: {'desc': 'friends meet, hang out; A sits, B joins A (2 subjects - subject A)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  13: {'desc': 'run, scramble for last seat (2 subjects - subject A)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  14: {'desc': 'run, scramble for last seat (2 subjects - subject A)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  15: {'desc': 'chicken dance (2 subjects - subject A)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120}}},
 19: {'desc': 'human interaction and communication (2 subjects - subject B)',
      'motions': {1: {'desc': 'walk, shake hands (2 subjects - subject B)',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  2: {'desc': 'walk, shake hands (2 subjects - subject B)',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  3: {'desc': 'A pulls B; B resists (2 subjects - subject B)',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  4: {'desc': 'A pulls B; B resists (2 subjects - subject B)',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  5: {'desc': 'A pulls B by the elbow; B resists (2 subjects - subject B)',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  6: {'desc': 'A pulls B by the elbow; B resists (2 subjects - subject B)',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  7: {'desc': 'navigate busy sidewalk; A leads the way, takes B by the arm (2 subjects - subject B)',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  8: {'desc': 'conversation - explain with hand gestures (2 subjects - subject B)',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  9: {'desc': 'conversation - explain with hand gestures, walk (2 subjects - subject B)',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  10: {'desc': 'quarrel - angry hand gestures (2 subjects - subject B)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  11: {'desc': 'quarrel - angry hand gestures (2 subjects - subject B)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  12: {'desc': 'friends meet, hang out; A sits, B joins A (2 subjects - subject B)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  13: {'desc': 'run, scramble for last seat (2 subjects - subject B)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  14: {'desc': 'run, scramble for last seat (2 subjects - subject B)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  15: {'desc': 'chicken dance (2 subjects - subject B)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120}}},
 20: {'desc': 'human interaction - at play, formations (2 subjects - subject A)',
      'motions': {1: {'desc': 'chicken dance (2 subjects - subject A)',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  2: {'desc': 'link arms, walk (2 subjects - subject A)',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  3: {'desc': 'link arms, walk (2 subjects - subject A)',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  4: {'desc': 'synchronized walk (2 subjects - subject A)',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  5: {'desc': 'synchronized walk (2 subjects - subject A)',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  6: {'desc': 'soldiers march (2 subjects - subject A)',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  7: {'desc': 'soldiers march (2 subjects - subject A)',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  8: {'desc': 'zombie march (2 subjects - subject A)',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  9: {'desc': 'nursery rhyme - ring around the rosey (2 subjects - subject A)',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  10: {'desc': '360-degree two-person whip (2 subjects - subject A)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  11: {'desc': 'high-five, walk (2 subjects - subject A)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  12: {'desc': 'low-five, walk (2 subjects - subject A)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  13: {'desc': "blind man's bluff (blindfold tag) (2 subjects - subject A)",
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120}}},
 21: {'desc': 'human interaction - at play, formations (2 subjects - subject B)',
      'motions': {1: {'desc': 'chicken dance (2 subjects - subject B)',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  2: {'desc': 'link arms, walk (2 subjects - subject B)',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  3: {'desc': 'link arms, walk (2 subjects - subject B)',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  4: {'desc': 'synchronized walk (2 subjects - subject B)',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  5: {'desc': 'synchronized walk (2 subjects - subject B)',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  6: {'desc': 'soldiers march (2 subjects - subject B)',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  7: {'desc': 'soldiers march (2 subjects - subject B)',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  8: {'desc': 'zombie march (2 subjects - subject B)',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  9: {'desc': 'nursery rhyme - ring around the rosey (2 subjects - subject B)',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  10: {'desc': '360-degree two-person whip (2 subjects - subject B)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  11: {'desc': 'high-five, walk (2 subjects - subject B)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  12: {'desc': 'low-five, walk (2 subjects - subject B)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  13: {'desc': "blind man's bluff (blindfold tag) (2 subjects - subject B)",
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120}}},
 22: {'desc': 'human interaction (2 subjects - subject A)',
      'motions': {1: {'desc': 'B sits; A pulls up B (2 subjects - subject A)',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  2: {'desc': 'A sits; B pulls up A (2 subjects - subject A)',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  3: {'desc': 'A sits, holds face in hands; B kneels, comforts A (2 subjects - subject A)',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  4: {'desc': "B comforts A, puts one hand on A's shoulder (2 subjects - subject A)",
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  5: {'desc': "A comforts B, puts both hands on B's shoulders (2 subjects - subject A)",
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  6: {'desc': "B comforts A, puts both hands on A's shoulders (2 subjects - subject A)",
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  7: {'desc': "A comforts B, puts one hand on B's shoulder (2 subjects - subject A)",
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  8: {'desc': 'hold hands, swing arms, walk (2 subjects - subject A)',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  9: {'desc': 'A gives B a shoulder rub; B sits, A stands (2 subjects - subject A)',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  10: {'desc': 'A shelters B, a younger child, from harm (2 subjects - subject A)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  11: {'desc': 'B shelters A, a younger child, from harm (2 subjects - subject A)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  12: {'desc': 'A stumbles into B (2 subjects - subject A)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  13: {'desc': 'A passes soda to B; both drink (2 subjects - subject A)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  14: {'desc': 'alternating squats (2 subjects - subject A)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  15: {'desc': 'alternating jumping jacks (2 subjects - subject A)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  16: {'desc': 'synchronized jumping jacks (2 subjects - subject A)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  17: {'desc': 'rush up, arm wrestle (2 subjects - subject A)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  18: {'desc': 'A stares down B, leans with hands on high stool (2 subjects - subject A)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  19: {'desc': 'B stares down A, leans with hands on high stool (2 subjects - subject A)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  20: {'desc': 'violence - A picks up high stool, threatens to strike B (2 subjects - subject A)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  21: {'desc': 'conversation - B pounds high stool, points at A (2 subjects - subject A)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  22: {'desc': 'walk; B catches keys thrown by A (2 subjects - subject A)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  23: {'desc': 'walk; A catches keys thrown by B (2 subjects - subject A)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  24: {'desc': 'walk; B catches wallet thrown by A (2 subjects - subject A)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  25: {'desc': 'walk; A catches wallet thrown by B (2 subjects - subject A)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120}}},
 23: {'desc': 'human interaction (2 subjects - subject B)',
      'motions': {1: {'desc': 'B sits; A pulls up B (subjects - subject B)',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  2: {'desc': 'A sits; B pulls up A (subjects - subject B)',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  3: {'desc': 'A sits, holds face in hands; B kneels, comforts A (2 subjects - subject B)',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  4: {'desc': "B comforts A, puts one hand on A's shoulder (2 subjects - subject B)",
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  5: {'desc': "A comforts B, puts both hands on B's shoulders (2 subjects - subject B)",
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  6: {'desc': "B comforts A, puts both hands on A's shoulders (2 subjects - subject B)",
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  7: {'desc': "A comforts B, puts one hand on B's shoulder (2 subjects - subject B)",
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  8: {'desc': 'hold hands, swing arms, walk (2 subjects - subject B)',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  9: {'desc': 'A gives B a shoulder rub; B sits, A stands (subjects - subject B)',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  10: {'desc': 'A shelters B, a younger child, from harm (2 subjects - subject B)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  11: {'desc': 'B shelters A, a younger child, from harm (2 subjects - subject B)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  12: {'desc': 'A stumbles into B (2 subjects - subject B)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  13: {'desc': 'A passes soda to B; both drink (2 subjects - subject B)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  14: {'desc': 'alternating squats (2 subjects - subject B)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  15: {'desc': 'alternating jumping jacks (2 subjects - subject B)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  16: {'desc': 'synchronized jumping jacks (2 subjects - subject B)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  17: {'desc': 'rush up, arm wrestle (2 subjects - subject B)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  18: {'desc': 'A stares down B, leans with hands on high stool (2 subjects - subject B)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  19: {'desc': 'B stares down A, leans with hands on high stool (2 subjects - subject B)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  20: {'desc': 'violence - A picks up high stool, threatens to strike B (2 subjects - subject B)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  21: {'desc': 'conversation - B pounds high stool, points at A (2 subjects - subject B)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  22: {'desc': 'walk; B catches keys thrown by A (2 subjects - subject B)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  23: {'desc': 'walk; A catches keys thrown by B (2 subjects - subject B)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  24: {'desc': 'walk; B catches wallet thrown by A (2 subjects - subject B)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  25: {'desc': 'walk; A catches wallet thrown by B (2 subjects - subject B)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120}}},
 24: {'desc': 'nursery rhymes',
      'motions': {1: {'desc': 'nursery rhyme - "I\'m a little teapot..."',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120}}},
 25: {'desc': 'nursery rhymes',
      'motions': {1: {'desc': 'nursery rhyme - "I\'m a little teapot..."',
                      'files': ['tvd', 'c3d', 'amc', 'mpg'],
                      'fps': 120}}},
 26: {'desc': 'nursery rhymes, basketball, bending',
      'motions': {1: {'desc': 'walk',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  2: {'desc': 'basketball signals',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  3: {'desc': 'nursery rhyme - "I\'m a little teapot..."',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  4: {'desc': 'nursery rhyme - "I\'m a little teapot..."',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  5: {'desc': 'Alaska vacation',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  6: {'desc': 'Alaska vacation',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  7: {'desc': 'nursery rhyme - Cock Robin',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  8: {'desc': 'nursery rhyme - Cock Robin',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  9: {'desc': 'bend, pick up',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  10: {'desc': 'bend, lift',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  11: {'desc': 'bend, lift',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120}}},
 27: {'desc': 'recreation, nursery rhymes',
      'motions': {1: {'desc': 'walk',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  2: {'desc': 'basketball signals',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  3: {'desc': 'nursery rhyme - "I\'m a little teapot..."',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  4: {'desc': 'Alaskan vacation',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  5: {'desc': 'nursery rhyme - Cock Robin',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  6: {'desc': 'basketball signals',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  7: {'desc': 'nursery rhyme - "I\'m a little teapot..."',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  8: {'desc': 'Alaskan vacation',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  9: {'desc': 'Alaskan vacation',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  10: {'desc': 'nursery rhyme - Cock Robin',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  11: {'desc': 'prairie dog (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120}}},
 28: {'desc': 'recreation, nursery rhymes, animal behaviors (pantomime - human subject)',
      'motions': {1: {'desc': 'basketball signals',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  2: {'desc': 'nursery rhyme - "I\'m a little teapot..."',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  3: {'desc': 'Alaskan vacation',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  4: {'desc': 'nursery rhyme - Cock Robin',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  5: {'desc': 'basketball signals',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  6: {'desc': 'nursery rhyme - "I\'m a little teapot..."',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  7: {'desc': 'Alaskan vacation',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  8: {'desc': 'nursery rhyme - Cock Robin',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  9: {'desc': 'prairie dog (human subject)',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  10: {'desc': 'whale (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  11: {'desc': 'bear (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  12: {'desc': 'dog (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  13: {'desc': 'snake (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  14: {'desc': 'chicken (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  15: {'desc': 'monkey (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  16: {'desc': 'mouse (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  17: {'desc': 'cat (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  18: {'desc': 'elephant (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  19: {'desc': 'dinosaur (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120}}},
 29: {'desc': 'recreation, nursery rhymes, animal behaviors (pantomime - human subject)',
      'motions': {1: {'desc': 'walk',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  2: {'desc': 'basketball signals',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  3: {'desc': 'nursery rhyme - "I\'m a little teapot..."',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  4: {'desc': 'Alaskan vacation',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  5: {'desc': 'Alaskan vacation',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  6: {'desc': 'nursery rhyme - Cock Robin',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  7: {'desc': 'basketball signals',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  8: {'desc': 'nursery rhyme - "I\'m a little teapot..."',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  9: {'desc': 'Alaskan vacation',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  10: {'desc': 'nursery rhyme - Cock Robin',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  11: {'desc': 'Alaskan vacation',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  12: {'desc': 'Alaskan vacation',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  13: {'desc': 'Alaskan vacation',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  14: {'desc': 'prairie dog (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  15: {'desc': 'whale (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  16: {'desc': 'bear (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  17: {'desc': 'dog (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  18: {'desc': 'cat (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  19: {'desc': 'fish (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  20: {'desc': 'elephant (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  21: {'desc': 'mouse (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  22: {'desc': 'chicken (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  23: {'desc': 'dinosaur (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  24: {'desc': 'snake (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  25: {'desc': 'monkey (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120}}},
 30: {'desc': 'recreation, nursery rhymes, animal behaviors (pantomime - human subject)',
      'motions': {1: {'desc': 'basketball signals',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  2: {'desc': 'nursery rhyme - "I\'m a little teapot..."',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  3: {'desc': 'Alaskan vacation',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  4: {'desc': 'Alaskan vacation',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  5: {'desc': 'nursery rhyme - Cock Robin',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  6: {'desc': 'nursery rhyme - Cock Robin',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  7: {'desc': 'basketball signals',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  8: {'desc': 'nursery rhyme - "I\'m a little teapot..."',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  9: {'desc': 'Alaskan vacation',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  10: {'desc': 'nursery rhyme - Cock Robin',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  11: {'desc': 'Alaskan vacation',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  12: {'desc': 'Alaskan vacation',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  13: {'desc': 'prairie dog (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  14: {'desc': 'whale (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  15: {'desc': 'bear (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  16: {'desc': 'dog (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  17: {'desc': 'cat (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  18: {'desc': 'elephant (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  19: {'desc': 'mouse (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  20: {'desc': 'chicken (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  21: {'desc': 'snake (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  22: {'desc': 'Tyrannosaurus rex (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  23: {'desc': 'monkey (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120}}},
 31: {'desc': 'recreation, nursery rhymes, animal behaviors (pantomime - human subject)',
      'motions': {1: {'desc': 'basketball signals',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  2: {'desc': 'nursery rhyme - "I\'m a little teapot..."',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  3: {'desc': 'Alaskan vacation',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  4: {'desc': 'nursery rhyme - Cock Robin',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  5: {'desc': 'basketball signals',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  6: {'desc': 'nursery rhyme - "I\'m a little teapot..."',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  7: {'desc': 'Alaskan vacation',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  8: {'desc': 'nursery rhyme - Cock Robin',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  9: {'desc': 'Alaskan vacation',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  10: {'desc': 'Alaskan vacation',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  11: {'desc': 'prairie dog (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  12: {'desc': 'whale (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  13: {'desc': 'bear (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  14: {'desc': 'dog (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  15: {'desc': 'cat (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  16: {'desc': 'elephant (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  17: {'desc': 'Tyrannosaurus rex (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  18: {'desc': 'mouse (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  19: {'desc': 'chicken (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  20: {'desc': 'snake (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  21: {'desc': 'monkey (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120}}},
 32: {'desc': 'recreation, nursery rhymes, animal behaviors (pantomime - human subject)',
      'motions': {1: {'desc': 'walk',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  2: {'desc': 'walk',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  3: {'desc': 'basketball signals',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  4: {'desc': 'nursery rhyme - "I\'m a little teapot..."',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  5: {'desc': 'Alaskan vacation',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  6: {'desc': 'nursery rhyme - Cock Robin',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  7: {'desc': 'basketball signals',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  8: {'desc': 'nursery rhyme - "I\'m a little teapot..."',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  9: {'desc': 'Alaskan vacation',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  10: {'desc': 'nursery rhyme - Cock Robin',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  11: {'desc': 'Alaskan vacation',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  12: {'desc': 'Alaskan vacation',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  13: {'desc': 'prairie dog (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  14: {'desc': 'bear (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  15: {'desc': 'dog (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  16: {'desc': 'cat (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  17: {'desc': 'elephant (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  18: {'desc': 'mouse (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  19: {'desc': 'chicken (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  20: {'desc': 'Tyrannosaurus rex (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  21: {'desc': 'snake (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  22: {'desc': 'monkey (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120}}},
 33: {'desc': 'throw and catch football (2 subjects - subject A)',
      'motions': {1: {'desc': 'football - throw, catch (2 subjects - subject A)',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 60},
                  2: {'desc': 'football - throw, catch, jump around (2 subjects - subject A)',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 60}}},
 34: {'desc': 'throw and catch football (2 subjects - subject B)',
      'motions': {1: {'desc': 'football - throw, catch (2 subjects - subject B)',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 60},
                  2: {'desc': 'football - throw, catch, jump around (2 subjects - subject B)',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 60}}},
 35: {'desc': 'walk, run',
      'motions': {1: {'desc': 'walk',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  2: {'desc': 'walk',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  3: {'desc': 'walk',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  4: {'desc': 'walk',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  5: {'desc': 'walk',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  6: {'desc': 'walk',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  7: {'desc': 'walk',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  8: {'desc': 'walk',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  9: {'desc': 'walk',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  10: {'desc': 'walk',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  11: {'desc': 'walk',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  12: {'desc': 'walk',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  13: {'desc': 'walk',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  14: {'desc': 'walk',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  15: {'desc': 'walk',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  16: {'desc': 'walk',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  17: {'desc': 'run/jog',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  18: {'desc': 'run/jog',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  19: {'desc': 'run/jog',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  20: {'desc': 'run/jog',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  21: {'desc': 'run/jog',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  22: {'desc': 'run/jog',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  23: {'desc': 'run/jog',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  24: {'desc': 'run/jog',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  25: {'desc': 'run/jog',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  26: {'desc': 'run/jog',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  27: {'desc': 'navigate around obstacles',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  28: {'desc': 'walk',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  29: {'desc': 'walk',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  30: {'desc': 'walk',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  31: {'desc': 'walk',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  32: {'desc': 'walk',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  33: {'desc': 'walk',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  34: {'desc': 'walk',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120}}},
 36: {'desc': 'walk on uneven terrain',
      'motions': {1: {'desc': 'walk on uneven terrain',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  2: {'desc': 'walk forward, turn around, walk back',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  3: {'desc': 'walk forward, turn around, walk back',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  4: {'desc': 'walk on uneven terrain',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  5: {'desc': 'walk on uneven terrain',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  6: {'desc': 'walk on uneven terrain',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  7: {'desc': 'walk on uneven terrain',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  8: {'desc': 'walk on uneven terrain',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  9: {'desc': 'walk forward, turn around, walk back',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  10: {'desc': 'walk on uneven terrain',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  11: {'desc': 'walk on uneven terrain',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  12: {'desc': 'walk on uneven terrain',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  13: {'desc': 'walk on uneven terrain',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  14: {'desc': 'walk on uneven terrain',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  15: {'desc': 'walk on uneven terrain',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  16: {'desc': 'walk on uneven terrain',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  17: {'desc': 'walk on uneven terrain',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  18: {'desc': 'walk on uneven terrain',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  19: {'desc': 'walk on uneven terrain',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  20: {'desc': 'walk on uneven terrain',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  21: {'desc': 'walk on uneven terrain',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  22: {'desc': 'walk on uneven terrain',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  23: {'desc': 'walk on uneven terrain',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  24: {'desc': 'walk on uneven terrain',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  25: {'desc': 'walk on uneven terrain',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  26: {'desc': 'walk on uneven terrain',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  27: {'desc': 'walk on uneven terrain',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  28: {'desc': 'walk on uneven terrain',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  29: {'desc': 'walk on uneven terrain',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  30: {'desc': 'walk on uneven terrain',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  31: {'desc': 'walk on uneven terrain',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  32: {'desc': 'walk on uneven terrain',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  33: {'desc': 'walk on uneven terrain',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  34: {'desc': 'walk on uneven terrain',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  35: {'desc': 'walk on uneven terrain',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  36: {'desc': 'walk on uneven terrain',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  37: {'desc': 'jump/hop on uneven terrain',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120}}},
 37: {'desc': 'walk',
      'motions': {1: {'desc': 'slow walk',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120}}},
 38: {'desc': 'walk, run',
      'motions': {1: {'desc': 'walk',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  2: {'desc': 'walk',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  3: {'desc': 'run around in a circle',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  4: {'desc': 'walk around, frequent turns, cyclic walk along a line',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120}}},
 39: {'desc': 'climb, swing, hang on playground equipment',
      'motions': {1: {'desc': 'walk',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  2: {'desc': 'walk',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  3: {'desc': 'walk',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  4: {'desc': 'walk',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  5: {'desc': 'walk',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  6: {'desc': 'walk',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  7: {'desc': 'walk',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  8: {'desc': 'walk',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  9: {'desc': 'walk',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  10: {'desc': 'walk',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  11: {'desc': 'walk forward, turn around, walk back',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  12: {'desc': 'walk',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  13: {'desc': 'walk',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  14: {'desc': 'walk',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120}}},
 40: {'desc': 'navigate from corner to corner, interact with stepstool',
      'motions': {2: {'desc': 'navigate - walk forward, backward, on a diagonal',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  3: {'desc': 'navigate - walk forward, backward, on a diagonal',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  4: {'desc': 'navigate - walk forward, backward, on a diagonal',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  5: {'desc': 'navigate - walk forward, backward, on a diagonal',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  6: {'desc': 'climb, step over, sit on, jump over stepstool',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  7: {'desc': 'climb, step over, jump over stepstool',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  8: {'desc': 'climb, step over, jump over stepstool',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  9: {'desc': 'climb, step over, jump over stepstool',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  10: {'desc': 'wait for bus',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  11: {'desc': 'wait for bus',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  12: {'desc': 'basketball signals',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120}}},
 41: {'desc': 'navigate from corner to corner, interact with stepstool',
      'motions': {2: {'desc': 'navigate - walk forward, backward, sideways, on a diagonal',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  3: {'desc': 'navigate - walk forward, backward, sideways, on a diagonal',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  4: {'desc': 'navigate - walk forward, backward, on a diagonal',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  5: {'desc': 'navigate - walk forward, backward, on a diagonal',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  6: {'desc': 'navigate - walk forward, backward, on a diagonal',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  7: {'desc': 'climb, step over, jump over, navigate around stepstool',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  8: {'desc': 'climb, step over, jump over, navigate around stepstool',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  9: {'desc': 'climb, step over, jump over, navigate around stepstool',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  10: {'desc': 'basketball signals',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  11: {'desc': 'basketball signals',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120}}},
 42: {'desc': 'stretch',
      'motions': {1: {'desc': 'stretch - rotate head, shoulders, arms, legs',
                      'files': ['tvd', 'c3d', 'amc'],
                      'fps': 60}}},
 43: {'desc': 'swing on playground equipment',
      'motions': {1: {'desc': 'walk',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  2: {'desc': 'playground - grip bar, swing body',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  3: {'desc': 'playground - grip bar, swing body',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120}}},
 45: {'desc': 'walk',
      'motions': {1: {'desc': 'walk',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120}}},
 46: {'desc': 'walk',
      'motions': {1: {'desc': 'walk',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120}}},
 47: {'desc': 'walk',
      'motions': {1: {'desc': 'walk forward, turn around, walk back',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120}}},
 49: {'desc': 'modern dance, gymnastics',
      'motions': {1: {'desc': 'walk',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  2: {'desc': 'jump up and down, hop on one foot',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  3: {'desc': 'jump up and down, hop on one foot',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  4: {'desc': 'run, leap',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  5: {'desc': 'run, leap',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  6: {'desc': 'cartwheel',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  7: {'desc': 'cartwheel',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  8: {'desc': 'cartwheels',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  9: {'desc': 'dance - arms held high, side arabesque',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  10: {'desc': 'dance - fold in from side arabesque, curl inwards',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  11: {'desc': 'dance - fold in from side arabesque, curl inwards',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  12: {'desc': 'dance - lean forward, bring back leg forward, arching arms',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  13: {'desc': 'dance - fold in from side arabesque, curl inwards',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  14: {'desc': 'dance - lean forward, bring back leg forward, arching arms',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  15: {'desc': 'static dance pose - folded in, head lowered, leg bent',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  16: {'desc': 'dance - fold in from side arabesque, curl inwards',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  17: {'desc': 'dance - lean forward, bring back leg forward, arching arms',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  18: {'desc': 'balance on one leg, outstretched arms',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  19: {'desc': 'balance on one leg, outstretched arms',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  20: {'desc': 'balance on one leg, outstretched arms',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  21: {'desc': 'acrobatics - spin/twirl, hang on ropes',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  22: {'desc': 'dance - lean back on bent leg, balance, bend elbow by ear',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120}}},
 54: {'desc': 'animal behaviors (pantomime - human subject)',
      'motions': {1: {'desc': 'monkey (human subject)',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  2: {'desc': 'bear (human subject)',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  3: {'desc': 'penguin (human subject)',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  4: {'desc': 'pterosaur (human subject)',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  5: {'desc': 'pterosaur (human subject)',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  6: {'desc': 'pterosaur (human subject)',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  7: {'desc': 'prairie dog (human subject)',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  8: {'desc': 'roadrunner (human subject)',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  9: {'desc': 'insect/praying mantis (human subject)',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  10: {'desc': 'ghost (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  11: {'desc': 'penguin (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  12: {'desc': 'dragon (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  13: {'desc': 'dragon (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  14: {'desc': 'monkey (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  15: {'desc': 'prairie dog (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  16: {'desc': 'superhero',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  17: {'desc': 'squirrel (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  18: {'desc': 'squirrel (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  19: {'desc': 'squirrel - robotic like motion (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  20: {'desc': 'follow path, walk around obstacles',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  21: {'desc': 'follow path, walk around obstacles',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  22: {'desc': 'follow path, walk around obstacles',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  23: {'desc': 'monkey (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  24: {'desc': 'hummingbird (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  25: {'desc': 'chicken (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  26: {'desc': 'chicken (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  27: {'desc': 'chicken (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120}}},
 55: {'desc': 'animal behaviors (pantomime - human subject)',
      'motions': {1: {'desc': 'dance, whirl',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  2: {'desc': 'lambada dance',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  3: {'desc': 'genie (human subject)',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  4: {'desc': 'walk',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  5: {'desc': 'hummingbird (human subject)',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  6: {'desc': 'chicken (human subject)',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  7: {'desc': 'chicken (human subject)',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  8: {'desc': 'monkey (human subject)',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  9: {'desc': 'monkey (human subject)',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  10: {'desc': 'hummingbird (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  11: {'desc': 'animal (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  12: {'desc': 'dancing bear (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  13: {'desc': 'insect/praying mantis (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  14: {'desc': 'prairie dog (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  15: {'desc': 'roadrunner (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  16: {'desc': 'panda (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  17: {'desc': 'ghost (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  18: {'desc': 'penguin (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  19: {'desc': 'dragon (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  20: {'desc': 'hippo ballerina (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  21: {'desc': 'pterosaur (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  22: {'desc': 'superhero',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  23: {'desc': 'devil',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  24: {'desc': 'various animals (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  25: {'desc': 'dancing animal (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  26: {'desc': 'monkey (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  27: {'desc': 'dancing ant (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  28: {'desc': 'monkey/bear (human subject)',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120}}},
 56: {'desc': 'vignettes - locomotion, upper-body motions (focus: motion transitions)',
      'motions': {1: {'desc': 'walk around',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  2: {'desc': 'vignettes - fists up, wipe window, yawn, stretch, angrily grab, smash against wall',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  3: {'desc': 'vignettes - fists up, wipe window, yawn, stretch, angrily grab, smash against wall, lift open window, throw punches, skip',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  4: {'desc': 'vignettes - fists up, wipe window, grab, lift open window, throw punches, yawn, stretch, walk, jump',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  5: {'desc': 'vignettes - walk, drink water, run/jog, jump, wipe window, lift open window, throw punches, yawn, stretch',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  6: {'desc': 'vignettes - throw punches, grab, skip, yawn, stretch, leap, lift open window, walk, jump/bound',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  7: {'desc': 'vignettes - yawn, stretch, walk, run/jog, angrily grab, jump, skip, halt',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  8: {'desc': 'vignettes - lift open window, smash against wall, hop, walk, run/jog, yawn, stretch',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120}}},
 60: {'desc': 'salsa',
      'motions': {1: {'desc': 'salsa dance',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 60},
                  2: {'desc': 'salsa dance',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 60},
                  3: {'desc': 'salsa dance',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 60},
                  4: {'desc': 'salsa dance',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 60},
                  5: {'desc': 'salsa dance',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 60},
                  6: {'desc': 'salsa dance',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 60},
                  7: {'desc': 'salsa dance',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 60},
                  8: {'desc': 'salsa dance',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 60},
                  9: {'desc': 'salsa dance',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 60},
                  10: {'desc': 'salsa dance',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 60},
                  11: {'desc': 'salsa dance',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 60},
                  12: {'desc': 'salsa dance',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 60},
                  13: {'desc': 'salsa dance',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 60},
                  14: {'desc': 'salsa dance',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 60},
                  15: {'desc': 'salsa dance',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 60}}},
 61: {'desc': 'salsa',
      'motions': {1: {'desc': 'salsa dance',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 60},
                  2: {'desc': 'salsa dance',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 60},
                  3: {'desc': 'salsa dance',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 60},
                  4: {'desc': 'salsa dance',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 60},
                  5: {'desc': 'salsa dance',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 60},
                  6: {'desc': 'salsa dance',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 60},
                  7: {'desc': 'salsa dance',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 60},
                  8: {'desc': 'salsa dance',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 60},
                  9: {'desc': 'salsa dance',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 60},
                  10: {'desc': 'salsa dance',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 60},
                  11: {'desc': 'salsa dance',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 60},
                  12: {'desc': 'salsa dance',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 60},
                  13: {'desc': 'salsa dance',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 60},
                  14: {'desc': 'salsa dance',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 60},
                  15: {'desc': 'salsa dance',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 60}}},
 62: {'desc': 'construction work, random motions',
      'motions': {1: {'desc': 'bolt loosening, wrench',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 60},
                  2: {'desc': 'bolt tightening, wrench',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 60},
                  3: {'desc': 'sawing, hand saw',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 60},
                  4: {'desc': 'screwing',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 60},
                  5: {'desc': 'screwing',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 60},
                  6: {'desc': 'unscrewing',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 60},
                  7: {'desc': 'hammering a nail',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 60},
                  8: {'desc': 'hammering a nail',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 60},
                  9: {'desc': 'pulling a nail',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 60},
                  10: {'desc': 'hammering sequence',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  11: {'desc': 'cleaning up',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  12: {'desc': 'hard days drink',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  13: {'desc': 'moving a stool',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  14: {'desc': 'opening umbrella',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  15: {'desc': 'opening umbrella',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  16: {'desc': 'closing umbrella',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  17: {'desc': 'opening and closing umbrella',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  18: {'desc': 'closing a box',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  19: {'desc': 'opening a box',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  20: {'desc': 'closing, moving and opening a box',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  21: {'desc': 'coiling a rope',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  22: {'desc': 'dynamic calibration',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  23: {'desc': 'bolt tightening',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  24: {'desc': 'bolt tightening, with putting bolt in',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  25: {'desc': 'bolt loosening, wrench',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60}}},
 63: {'desc': 'golf',
      'motions': {1: {'desc': 'Swing',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120}}},
 64: {'desc': 'golf',
      'motions': {1: {'desc': 'Swing',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  2: {'desc': 'Swing',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  3: {'desc': 'Swing',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  4: {'desc': 'Swing',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  5: {'desc': 'Swing',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  6: {'desc': 'Swing',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  7: {'desc': 'Swing',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  8: {'desc': 'Swing',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  9: {'desc': 'Swing',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 120},
                  10: {'desc': 'Swing',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  11: {'desc': 'Putt',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  12: {'desc': 'Putt',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  13: {'desc': 'Putt',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  14: {'desc': 'Putt',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  15: {'desc': 'Putt',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  16: {'desc': 'Placing Tee',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  17: {'desc': 'Placing Tee',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  18: {'desc': 'Placing Tee',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  19: {'desc': 'Placing Tee',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  20: {'desc': 'Placing Tee',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  21: {'desc': 'Placing Ball',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  22: {'desc': 'Placing Ball',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  23: {'desc': 'Placing Ball',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  24: {'desc': 'Placing Ball',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  25: {'desc': 'Placing Ball',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  26: {'desc': 'Picking up Ball',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  27: {'desc': 'Picking up Ball',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  28: {'desc': 'Picking up Ball',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  29: {'desc': 'Picking up Ball',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120},
                  30: {'desc': 'Picking up Ball',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 120}}},
 69: {'desc': 'walking',
      'motions': {1: {'desc': 'walk forward',
                      'files': ['amc', 'avi'],
                      'fps': 120},
                  2: {'desc': 'walk forward',
                      'files': ['amc', 'avi'],
                      'fps': 120},
                  3: {'desc': 'walk forward',
                      'files': ['amc', 'avi'],
                      'fps': 120},
                  4: {'desc': 'walk forward',
                      'files': ['amc', 'avi'],
                      'fps': 120},
                  5: {'desc': 'walk forward',
                      'files': ['amc', 'avi'],
                      'fps': 120},
                  6: {'desc': 'walk and turn (repeated)',
                      'files': ['amc', 'avi'],
                      'fps': 120},
                  7: {'desc': 'walk and turn (repeated)',
                      'files': ['amc', 'avi'],
                      'fps': 120},
                  8: {'desc': 'walk and turn (repeated)',
                      'files': ['amc', 'avi'],
                      'fps': 120},
                  9: {'desc': 'walk and turn (repeated)',
                      'files': ['amc', 'avi'],
                      'fps': 120},
                  10: {'desc': 'walk and turn (repeated)',
                       'files': ['amc', 'avi'],
                       'fps': 120},
                  11: {'desc': 'walk and turn (repeated)',
                       'files': ['amc', 'avi'],
                       'fps': 120},
                  12: {'desc': 'walk and turn both directions (repeated)',
                       'files': ['amc', 'avi'],
                       'fps': 120},
                  13: {'desc': 'walk, turn in place (repeated)',
                       'files': ['amc', 'avi'],
                       'fps': 120},
                  14: {'desc': 'walk, turn in place (repeated)',
                       'files': ['amc', 'avi'],
                       'fps': 120},
                  15: {'desc': 'walk, turn in place (repeated)',
                       'files': ['amc', 'avi'],
                       'fps': 120},
                  16: {'desc': 'turn in place',
                       'files': ['amc', 'avi'],
                       'fps': 120},
                  17: {'desc': 'turn in place',
                       'files': ['amc', 'avi'],
                       'fps': 120},
                  18: {'desc': 'turn in place (opposite direction)',
                       'files': ['amc', 'avi'],
                       'fps': 120},
                  19: {'desc': 'turn in place (opposite direction)',
                       'files': ['amc', 'avi'],
                       'fps': 120},
                  20: {'desc': 'walk forward 90 degree right turn',
                       'files': ['amc', 'avi'],
                       'fps': 120},
                  21: {'desc': 'walk forward 90 degree right turn',
                       'files': ['amc', 'avi'],
                       'fps': 120},
                  22: {'desc': 'walk forward 90 degree right turn',
                       'files': ['amc', 'avi'],
                       'fps': 120},
                  23: {'desc': 'walk forward 90 degree right turn',
                       'files': ['amc', 'avi'],
                       'fps': 120},
                  24: {'desc': 'walk forward 90 degree left turn',
                       'files': ['amc', 'avi'],
                       'fps': 120},
                  25: {'desc': 'walk forward 90 degree left turn',
                       'files': ['amc', 'avi'],
                       'fps': 120},
                  26: {'desc': 'walk forward 90 degree left turn',
                       'files': ['amc', 'avi'],
                       'fps': 120},
                  27: {'desc': 'walk forward 90 degree left turn',
                       'files': ['amc', 'avi'],
                       'fps': 120},
                  28: {'desc': 'walk forward 90 degree smooth right turn',
                       'files': ['amc', 'avi'],
                       'fps': 120},
                  29: {'desc': 'walk forward 90 degree smooth right turn',
                       'files': ['amc', 'avi'],
                       'fps': 120},
                  30: {'desc': 'walk forward 90 degree smooth right turn',
                       'files': ['amc', 'avi'],
                       'fps': 120},
                  31: {'desc': 'walk forward 90 degree smooth left turn',
                       'files': ['amc', 'avi'],
                       'fps': 120},
                  32: {'desc': 'walk forward 90 degree smooth left turn',
                       'files': ['amc', 'avi'],
                       'fps': 120},
                  33: {'desc': 'walk forward 90 degree smooth left turn',
                       'files': ['amc', 'avi'],
                       'fps': 120},
                  34: {'desc': 'walk backwards and turn',
                       'files': ['amc', 'avi'],
                       'fps': 120},
                  35: {'desc': 'walk backwards and turn',
                       'files': ['amc', 'avi'],
                       'fps': 120},
                  36: {'desc': 'walk backwards and turn',
                       'files': ['amc', 'avi'],
                       'fps': 120},
                  37: {'desc': 'walk backwards and turn',
                       'files': ['amc', 'avi'],
                       'fps': 120},
                  38: {'desc': 'walk backwards and turn (repeated)',
                       'files': ['amc', 'avi'],
                       'fps': 120},
                  39: {'desc': 'walk backward, turn in place',
                       'files': ['amc', 'avi'],
                       'fps': 120},
                  40: {'desc': 'walk backward, turn in place',
                       'files': ['amc', 'avi'],
                       'fps': 120},
                  41: {'desc': 'walk backward, turn in place',
                       'files': ['amc', 'avi'],
                       'fps': 120},
                  42: {'desc': 'walk sideways and turn (repeated)',
                       'files': ['amc', 'avi'],
                       'fps': 120},
                  43: {'desc': 'walk sideways and turn (repeated)',
                       'files': ['amc', 'avi'],
                       'fps': 120},
                  44: {'desc': 'walk sideways and turn (repeated)',
                       'files': ['amc', 'avi'],
                       'fps': 120},
                  45: {'desc': 'walk sideways and turn (repeated)',
                       'files': ['amc', 'avi'],
                       'fps': 120},
                  46: {'desc': 'walk sideways and turn (repeated)',
                       'files': ['amc', 'avi'],
                       'fps': 120},
                  47: {'desc': 'walk sideways and turn (repeated)',
                       'files': ['amc', 'avi'],
                       'fps': 120},
                  48: {'desc': 'walk sideways and turn (opposite direction)',
                       'files': ['amc', 'avi'],
                       'fps': 120},
                  49: {'desc': 'walk sideways and turn (opposite direction)',
                       'files': ['amc', 'avi'],
                       'fps': 120},
                  50: {'desc': 'walk sideways and backwards',
                       'files': ['amc', 'avi'],
                       'fps': 120},
                  51: {'desc': 'walk backwards and turn',
                       'files': ['amc', 'avi'],
                       'fps': 120},
                  52: {'desc': 'walk backwards and turn',
                       'files': ['amc', 'avi'],
                       'fps': 120},
                  53: {'desc': 'walk backwards and turn',
                       'files': ['amc', 'avi'],
                       'fps': 120},
                  54: {'desc': 'walk backwards and turn',
                       'files': ['amc', 'avi'],
                       'fps': 120},
                  55: {'desc': 'walk backwards and turn',
                       'files': ['amc', 'avi'],
                       'fps': 120},
                  56: {'desc': 'walk sideways and turn (opposite direction)',
                       'files': ['amc', 'avi'],
                       'fps': 120},
                  57: {'desc': 'walk sideways and turn (opposite direction)',
                       'files': ['amc', 'avi'],
                       'fps': 120},
                  58: {'desc': 'walk sideways and turn (opposite direction)',
                       'files': ['amc', 'avi'],
                       'fps': 120},
                  59: {'desc': 'walk sideways and turn',
                       'files': ['amc', 'avi'],
                       'fps': 120},
                  60: {'desc': 'walk sideways and turn',
                       'files': ['amc', 'avi'],
                       'fps': 120},
                  61: {'desc': 'walk sideways and turn',
                       'files': ['amc', 'avi'],
                       'fps': 120},
                  62: {'desc': 'walk sideways and turn (opposite direction)',
                       'files': ['amc', 'avi'],
                       'fps': 120},
                  63: {'desc': 'walk sideways and turn (opposite direction)',
                       'files': ['amc', 'avi'],
                       'fps': 120},
                  64: {'desc': 'walk sideways and turn (opposite direction)',
                       'files': ['amc', 'avi'],
                       'fps': 120},
                  65: {'desc': 'walk sideways and turn',
                       'files': ['amc', 'avi'],
                       'fps': 120},
                  66: {'desc': 'walk sideways and turn',
                       'files': ['amc', 'avi'],
                       'fps': 120},
                  67: {'desc': 'walk sideways and turn',
                       'files': ['amc', 'avi'],
                       'fps': 120},
                  68: {'desc': 'walk forward and pick up object, set down object',
                       'files': ['amc', 'avi'],
                       'fps': 120},
                  69: {'desc': 'walk forward and pick up object, carry back object',
                       'files': ['amc', 'avi'],
                       'fps': 120},
                  70: {'desc': 'walk up to object, squat, pick up object, set down in another place.',
                       'files': ['amc', 'avi'],
                       'fps': 120},
                  71: {'desc': 'walk up to object, squat, pick up object, set down in another place',
                       'files': ['amc', 'avi'],
                       'fps': 120},
                  72: {'desc': 'walk up to object, pick up object, set down in another place',
                       'files': ['amc', 'avi'],
                       'fps': 120},
                  73: {'desc': 'walk up to object, lean over, pick up object, set down in another place',
                       'files': ['amc', 'avi'],
                       'fps': 120},
                  74: {'desc': 'walk up to object, lean over, pick up object, set down in another place',
                       'files': ['amc', 'avi'],
                       'fps': 120},
                  75: {'desc': 'walk up to object, squat, pick up object, set down in another place',
                       'files': ['amc', 'avi'],
                       'fps': 120}}},
 70: {'desc': 'suitcase',
      'motions': {1: {'desc': 'carry 5.5lb suitcase',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  2: {'desc': 'carry 5.5lb suitcase',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  3: {'desc': 'carry 19.5lb suitcase',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  4: {'desc': 'carry 19.5lb suitcase',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  5: {'desc': 'carry 19.5lb suitcase',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  6: {'desc': 'carry 19.5lb suitcase',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  7: {'desc': 'carry 19.5lb suitcase',
                      'files': ['amc', 'avi'],
                      'fps': 120},
                  8: {'desc': 'carry 19.5lb suitcase',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  9: {'desc': 'carry 19.5lb suitcase',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  10: {'desc': 'carry 12.5lb suitcase',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  11: {'desc': 'carry 12.5lb suitcase',
                       'files': ['amc', 'avi'],
                       'fps': 120},
                  12: {'desc': 'carry 12.5lb suitcase',
                       'files': ['amc', 'avi'],
                       'fps': 120},
                  13: {'desc': 'carry 12.5lb suitcase',
                       'files': ['amc', 'avi'],
                       'fps': 120}}},
 74: {'desc': 'kicks and walking on slopes',
      'motions': {1: {'desc': 'stiff walk',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 60},
                  2: {'desc': 'stiff walk',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 60},
                  3: {'desc': 'kick',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 60},
                  4: {'desc': 'kick',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 60},
                  5: {'desc': 'kick',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 60},
                  6: {'desc': 'kick',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 60},
                  7: {'desc': 'lifting up',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 60},
                  8: {'desc': 'lifting up',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 60},
                  9: {'desc': '',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 60},
                  10: {'desc': 'peeping',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 60},
                  11: {'desc': 'peeping',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 60},
                  12: {'desc': 'thinker',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 60},
                  13: {'desc': 'Range of motion',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 60},
                  14: {'desc': 'slope 1',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 60},
                  15: {'desc': 'slope1',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 60},
                  16: {'desc': 'slope 2',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 60},
                  17: {'desc': 'slope 2',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 60},
                  18: {'desc': 'slope 3',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 60},
                  19: {'desc': 'slope 3',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 60},
                  20: {'desc': 'stiff walk',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 60}}},
 75: {'desc': 'jumps; hopscotch; sits',
      'motions': {1: {'desc': 'run jump',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 60},
                  2: {'desc': 'run jump',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 60},
                  3: {'desc': 'run jump',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 60},
                  4: {'desc': 'wide leg run',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 60},
                  5: {'desc': 'cross leg run',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 60},
                  6: {'desc': '180 jump',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 60},
                  7: {'desc': 'angle jumps',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 60},
                  8: {'desc': '360 jumps',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 60},
                  9: {'desc': '360 jump',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 60},
                  10: {'desc': '2 jump',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  11: {'desc': '2 jump',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  12: {'desc': 'box jump',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  13: {'desc': 'hopscotch',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  14: {'desc': 'hopscotch',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  15: {'desc': 'long jumps',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  16: {'desc': 'jump kick',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  17: {'desc': 'medium sit',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  18: {'desc': 'high sit',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  19: {'desc': 'medium sit',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  20: {'desc': 'low sit',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60}}},
 76: {'desc': 'avoidance',
      'motions': {1: {'desc': 'walk backwards then attack with a punch',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  2: {'desc': 'walk backwards, feign a few attacks, then attack',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  3: {'desc': 'avoid attacker',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  4: {'desc': 'defensive guard pose',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  5: {'desc': 'swatting at pesky bug',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  6: {'desc': 'avoid stepping on something',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  8: {'desc': 'careful stepping over things',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  9: {'desc': 'walking backwards',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  10: {'desc': 'turning',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  11: {'desc': 'quick large steps backwards',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120}}},
 77: {'desc': 'careful actions',
      'motions': {1: {'desc': 'looking around',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 60},
                  2: {'desc': 'standing',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 60},
                  3: {'desc': 'ready stance',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 60},
                  4: {'desc': 'Looking around',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 60},
                  5: {'desc': 'look around with flashlight',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 60},
                  6: {'desc': 'searching ground',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 60},
                  7: {'desc': 'poking ground',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 60},
                  8: {'desc': 'investigating thing on ground with two hands',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 60},
                  9: {'desc': 'duck to avoid flying object',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 60},
                  10: {'desc': 'careful run',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 60},
                  11: {'desc': 'careful run',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 60},
                  12: {'desc': 'careful run in circle',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 60},
                  13: {'desc': 'careful run in figure eight',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 60},
                  14: {'desc': 'careful creeping',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 60},
                  15: {'desc': 'careful creeping',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 60},
                  16: {'desc': 'laying down, getting up, careful ready pose',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 60},
                  17: {'desc': 'laying down, getting up, careful ready pose',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 60},
                  18: {'desc': 'laying down on back, getting up, careful ready pose',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 60},
                  19: {'desc': 'limping, hurt right leg',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 60},
                  20: {'desc': 'limping, hurt right leg',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 60},
                  21: {'desc': 'stretching',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 60},
                  22: {'desc': 'limping, hurt right leg',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 60},
                  23: {'desc': 'limping, hurt right leg',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 60},
                  24: {'desc': 'limping, hurt right leg',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 60},
                  25: {'desc': 'careful walk and search',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 60},
                  26: {'desc': 'careful walk and search',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 60},
                  27: {'desc': 'careful walk and search',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 60},
                  28: {'desc': 'careful walk',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 60},
                  29: {'desc': 'creeping walk',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 60},
                  30: {'desc': 'creeping walk',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 60},
                  31: {'desc': 'silent walk',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 60},
                  32: {'desc': 'creeping walk',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 60},
                  33: {'desc': 'creeping with limp',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 60},
                  34: {'desc': 'creep and pause, repeat',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 60}}},
 78: {'desc': 'walking',
      'motions': {1: {'desc': 'LeftTightTurn         CleanedGRS',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  2: {'desc': 'RightWideTurn            CleanedGRS',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  3: {'desc': 'LeftWideTurn     CleanedGRS',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  4: {'desc': 'SuperTightLeft        CleanedGRS',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  5: {'desc': 'SuperTightRight         CleanedGRS',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  6: {'desc': 'RunningStraight       CleanedGRS',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  7: {'desc': 'RunningWideRight       CleanedGRS',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  8: {'desc': 'RunningWideLeft      CleanedGRS',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  9: {'desc': 'RunningTigherLeft      CleanedGRS',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  10: {'desc': 'RunningTighterRight      CleanedGRS',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  11: {'desc': 'calibration',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  12: {'desc': 'RunningNoBall     CleanedGRS',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  13: {'desc': 'OffensiveMoveSpinLeft            CleanedGRS',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  14: {'desc': 'OffensiveMoveSpinLeft      CleanedGRS',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  15: {'desc': 'OffensiveMoveGoRight     CleanedGRS',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  16: {'desc': 'OffensiveMoveGoLeft         CleanedGRs',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  17: {'desc': 'OffensiveMoveSpinRight             CleanedGRS',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  18: {'desc': 'WalkEvasiveLeft      CleanedGRS',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  19: {'desc': 'WalkEvasiveRight              CleanedGRS',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  20: {'desc': 'FeintLeftMoveRight            CleanedGRS',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  21: {'desc': 'FeintRightMoveLeft      CleanedGRS',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  22: {'desc': 'FakeShotBreakRight     CleanedGRs',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  23: {'desc': 'FakeShotBreakLeft            CleanedGRS',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  24: {'desc': 'DefensiveStraightNoStop          CleanedGRS',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  25: {'desc': 'DefensiveStraightWithStop          CleanedGRS',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  26: {'desc': 'DefensiveRightStopToStop           CleanedGRS',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  27: {'desc': 'DefensiveLeftStopToStop              CleanedGRS',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  28: {'desc': 'DefensiveMoveZigZag           CleanedGRS',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  29: {'desc': 'DefensiveMoveSideToSide           CleanedGRS',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  30: {'desc': 'DefensiveMoveSideToSide           CleanedGRS',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  31: {'desc': 'Pivoting     CleanedGRS',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  32: {'desc': 'SraightDriveFromStop          Cleaned GRS',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  33: {'desc': 'RightDrive (left then right)    Cleaned GRS',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  34: {'desc': 'LeftDrive (right then left)    Cleaned GRS',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  35: {'desc': 'RightTightTurn    CleanedGRS',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120}}},
 79: {'desc': 'actor everyday activities',
      'motions': {1: {'desc': 'chopping wood',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 60},
                  2: {'desc': 'swimming',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 60},
                  3: {'desc': 'swimming',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 60},
                  4: {'desc': 'digging',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 60},
                  5: {'desc': 'sewing',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 60},
                  6: {'desc': 'hand shake',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 60},
                  7: {'desc': 'lost marker',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 60},
                  8: {'desc': 'boxing',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 60},
                  9: {'desc': 'slicing bread',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 60},
                  10: {'desc': 'chopping onions',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  11: {'desc': 'Subject calibration',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  12: {'desc': 'eating dinner',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  13: {'desc': 'mixing batter',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  14: {'desc': 'making dough',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  15: {'desc': 'eating a sandwich',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  16: {'desc': 'buying something',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  17: {'desc': 'playing violin',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  18: {'desc': 'playing drums',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  19: {'desc': 'playing piano',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  20: {'desc': 'hanging a picture',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  21: {'desc': 'putting on a pull over',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  22: {'desc': 'range of motion',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  23: {'desc': 'putting on a jacket',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  24: {'desc': 'putting on button up sweater',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  25: {'desc': 'moving heavy box',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  26: {'desc': 'planting a tree',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  27: {'desc': 'planting a plant',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  28: {'desc': 'putting on a ball cap',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  29: {'desc': 'putting on a dress',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  30: {'desc': 'pushing a swing',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  31: {'desc': 'writing on a chalkboard',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  32: {'desc': 'writing on a chalkboard',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  33: {'desc': 'chug a beer',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  34: {'desc': 'fishing',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  35: {'desc': 'fishing',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  36: {'desc': 'answering the phone',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  37: {'desc': 'dialing phone',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  38: {'desc': 'drinking water',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  39: {'desc': 'sipping martinee',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  40: {'desc': 'drinking a soda',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  41: {'desc': 'sipping coffee',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  42: {'desc': 'eating soup',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  43: {'desc': 'painting',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  44: {'desc': 'washing a window',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  45: {'desc': 'bear',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  46: {'desc': 'bear',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  47: {'desc': 'chicken',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  48: {'desc': 'elephant',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  49: {'desc': 'monkey',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  50: {'desc': 'mouse',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  51: {'desc': 'chipmunk',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  52: {'desc': 'prairie dog',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  53: {'desc': 'dog',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  54: {'desc': 'snake',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  55: {'desc': 'sweeping',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  56: {'desc': 'T-rex',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  57: {'desc': 'fish',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  58: {'desc': 'bird',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  59: {'desc': 'cat',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  60: {'desc': 'chicken',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  61: {'desc': 'cow',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  62: {'desc': 'chicken',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  63: {'desc': 'tiger',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  64: {'desc': 'penguin',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  65: {'desc': 'horse',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  66: {'desc': 'movie and trial dont match',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  67: {'desc': 'no movie',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 60},
                  68: {'desc': 'cold',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  69: {'desc': 'very happy',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  70: {'desc': 'laughing',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  71: {'desc': 'sad',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  72: {'desc': 'crying',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  73: {'desc': 'scared',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  74: {'desc': 'upset',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  75: {'desc': 'channel surfing',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  76: {'desc': 'driving',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  77: {'desc': 'vacuuming',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  78: {'desc': 'taking a movie',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  79: {'desc': 'putting on headphones',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  80: {'desc': 'using a palm pilot',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  81: {'desc': 'brushing teeth',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  82: {'desc': 'putting on deoderant',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  83: {'desc': 'shaving',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  84: {'desc': 'combing hair',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  85: {'desc': 'typing on a laptop',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  86: {'desc': 'shooting bow and arrow',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  87: {'desc': 'raking',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  88: {'desc': 'swatting at a fly',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  89: {'desc': 'holding a baby',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  90: {'desc': 'washing',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  91: {'desc': 'football',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  92: {'desc': 'frisbee',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  93: {'desc': 'weight lifting',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  94: {'desc': 'flexing',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  95: {'desc': 'rowing',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  96: {'desc': 'shooting a gun',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60}}},
 80: {'desc': 'assorted motions',
      'motions': {1: {'desc': 'shaking hands',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 60},
                  2: {'desc': 'chopping onions',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 60},
                  3: {'desc': 'shooting a gun',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 60},
                  4: {'desc': 'sewing',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 60},
                  5: {'desc': 'digging a hole',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 60},
                  6: {'desc': 'paying for something',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 60},
                  7: {'desc': 'hanging picture',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 60},
                  8: {'desc': 'picking up something',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 60},
                  9: {'desc': 'planting a flower',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 60},
                  10: {'desc': 'boxing',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  11: {'desc': 'putting on a sweater',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  12: {'desc': 'fishing',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  13: {'desc': 'drumming',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  14: {'desc': 'teaching',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  15: {'desc': 'putting on a coat',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  16: {'desc': 'mixing batter',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  17: {'desc': 'hand mixing dough',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  18: {'desc': 'vacuuming',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  19: {'desc': 'pushing broom',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  20: {'desc': 'planting',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  21: {'desc': 'pushing swing',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  22: {'desc': 'putting on a hat',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  23: {'desc': 'putting on a skirt',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  24: {'desc': 'eating',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  25: {'desc': 'answering a phone',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  26: {'desc': 'dialing phone',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  27: {'desc': 'setting glass of water',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  28: {'desc': 'drinking and smoking',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  29: {'desc': 'chugging',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  30: {'desc': 'range of motion',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  31: {'desc': 'making coffee',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  32: {'desc': 'slicing',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  33: {'desc': 'eating soup',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  34: {'desc': 'rake leaves',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  35: {'desc': 'putting on headphones',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  36: {'desc': 'violin',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  37: {'desc': 'TV',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  38: {'desc': 'driving',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  39: {'desc': '',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  40: {'desc': 'drinking from bottle',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  41: {'desc': 'freezing',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  42: {'desc': 'freezing',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  43: {'desc': 'happy',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  44: {'desc': 'laughing',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  45: {'desc': 'crying',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  46: {'desc': 'crying',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  47: {'desc': '',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  48: {'desc': 'arguing',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  49: {'desc': 'gorilla',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  50: {'desc': 'cleaning window',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  51: {'desc': 'chicken',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  52: {'desc': 'dog',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  53: {'desc': 'elephant',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  54: {'desc': 'monkey',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  55: {'desc': 'mouse',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  56: {'desc': 'chip monk',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  57: {'desc': 'prairie dog',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  58: {'desc': 'snake',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  59: {'desc': 'panther',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  60: {'desc': '',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  61: {'desc': 'sweeping',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  62: {'desc': 'bird',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  63: {'desc': 'chicken',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  64: {'desc': 'cat',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  65: {'desc': 'fish',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  66: {'desc': '',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  67: {'desc': '',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  68: {'desc': '',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  69: {'desc': 'painting',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  70: {'desc': 'piano',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  71: {'desc': 'chopping wood',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  72: {'desc': 'swimming',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  73: {'desc': 'shaking hands',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60}}},
 81: {'desc': 'pushing a box; jumping off a ledge; walks',
      'motions': {1: {'desc': 'fix hair and walk forward',
                      'files': ['tvd', 'amc', 'avi'],
                      'fps': 120},
                  2: {'desc': 'walk forward',
                      'files': ['tvd', 'amc', 'avi'],
                      'fps': 120},
                  3: {'desc': 'walk',
                      'files': ['tvd', 'amc', 'avi'],
                      'fps': 120},
                  4: {'desc': 'walk at a brisk pace',
                      'files': ['tvd', 'amc', 'avi'],
                      'fps': 120},
                  5: {'desc': 'push heavy object',
                      'files': ['tvd', 'amc', 'avi'],
                      'fps': 120},
                  6: {'desc': 'push heavy box',
                      'files': ['tvd', 'amc', 'avi'],
                      'fps': 120},
                  7: {'desc': 'pull heavy object',
                      'files': ['tvd', 'amc', 'avi'],
                      'fps': 120},
                  8: {'desc': 'drag heavy object',
                      'files': ['tvd', 'amc', 'avi'],
                      'fps': 120},
                  9: {'desc': 'drag heavy object',
                      'files': ['tvd', 'amc', 'avi'],
                      'fps': 120},
                  10: {'desc': 'push object that is high in air',
                       'files': ['tvd', 'amc', 'avi'],
                       'fps': 120},
                  11: {'desc': 'push object that is high in air',
                       'files': ['tvd', 'amc', 'avi'],
                       'fps': 120},
                  12: {'desc': 'jump backwards off ledge',
                       'files': ['tvd', 'amc', 'avi'],
                       'fps': 120},
                  13: {'desc': 'jump backwards off ledge',
                       'files': ['tvd', 'amc', 'avi'],
                       'fps': 120},
                  14: {'desc': 'climb backwards off ledge',
                       'files': ['tvd', 'amc', 'avi'],
                       'fps': 120},
                  15: {'desc': 'climb backwards off ledge',
                       'files': ['tvd', 'amc', 'avi'],
                       'fps': 120},
                  17: {'desc': 'walk forward',
                       'files': ['tvd', 'amc', 'avi'],
                       'fps': 120},
                  18: {'desc': 'adjust hair walk forward',
                       'files': ['tvd', 'amc', 'avi'],
                       'fps': 120}}},
 82: {'desc': 'jumping; pushing; emotional walks',
      'motions': {1: {'desc': 'Static pose',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  2: {'desc': 'Jump off ledge',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  3: {'desc': 'Jump off ledge',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  4: {'desc': 'Jump off ledge',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  5: {'desc': 'sitting on ground relaxing',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  6: {'desc': 'Pushing on heavy object',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  7: {'desc': 'Pushing on heavy object',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  8: {'desc': 'stand still; casual walk forward',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  9: {'desc': 'confident walk forward',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  10: {'desc': 'sad walk forward',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  11: {'desc': 'normal walk forward',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  12: {'desc': 'happy or fast walk forward',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  13: {'desc': 'normal walk forward',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  14: {'desc': 'walk forward and slow down',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  15: {'desc': 'walk forward and turn sideways',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  16: {'desc': 'bang on high object',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  17: {'desc': 'bang on high object',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  18: {'desc': 'static pose',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120}}},
 83: {'desc': 'steps',
      'motions': {1: {'desc': 'large sidestep to right',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  2: {'desc': 'sidestep to the right and up a ledge',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  3: {'desc': 'large step to a short ledge',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  4: {'desc': 'large sidestep to right',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  5: {'desc': 'very large sidestep to right',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  6: {'desc': 'very large sidestep to right and down',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  7: {'desc': 'short sidestep to right and down',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  8: {'desc': 'medium step forward and down',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  9: {'desc': 'short step forward and down',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  10: {'desc': 'medium step forward and down',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  11: {'desc': 'static pose',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  12: {'desc': 'medium sidestep to right and down',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  13: {'desc': 'large sidestep to right',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  14: {'desc': 'short sidestep to left and down',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  15: {'desc': 'short step forward',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  16: {'desc': 'medium sidestep to left and down',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  17: {'desc': 'medium step to left and down',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  18: {'desc': 'short step to left and forward',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  19: {'desc': 'medium sidestep to left',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  20: {'desc': 'medium step forward',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  21: {'desc': 'large step to left and forward',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  22: {'desc': 'stretching',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  23: {'desc': 'short sidestep to left and up',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  24: {'desc': 'medium step to left and up',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  25: {'desc': 'short step forward and up',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  26: {'desc': 'medium step to left, forward, and up',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  27: {'desc': 'walk forward stepping up stairs',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  28: {'desc': 'walk forward stepping up stairs',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  29: {'desc': 'walk forward stepping up stairs',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  30: {'desc': 'walk forward stepping up stairs',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  31: {'desc': 'walk forward stepping up stairs',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  32: {'desc': 'walk forward stepping up stairs',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  33: {'desc': 'sidestep to right then back to left',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  34: {'desc': 'walk forward and up stairs',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  35: {'desc': 'walk forward and stepping up stairs',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  36: {'desc': 'walk forward turn 90 degrees left walk forward',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  37: {'desc': 'walk forward turn 90 degrees right walk forward',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  38: {'desc': 'walk forward turn 90 degrees left walk forward',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  39: {'desc': 'walk forward turn 90 degrees right walk forward',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  40: {'desc': 'hop forward',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  41: {'desc': 'hop forward',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  42: {'desc': 'long jump forward',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  43: {'desc': 'long jump forward',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  44: {'desc': 'medium step forward',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  45: {'desc': 'hop forward',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  46: {'desc': 'medium hop forward',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  47: {'desc': 'long jump forward',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  48: {'desc': 'short hop forward',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  49: {'desc': 'medium hop forward',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  50: {'desc': 'long jump forward',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  51: {'desc': 'hop turn 90 degrees left in air',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  52: {'desc': 'hop turn 90 degrees left in air',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  53: {'desc': 'hop turn 90 degrees left in air',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  54: {'desc': 'hop turn 180 degrees left in air',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  55: {'desc': 'medium sidestep to right',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  56: {'desc': 'hop turn left 180 degrees in air',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  57: {'desc': 'hop turn left 180 degrees in air',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  58: {'desc': 'hop turn left 270 degrees in air',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  59: {'desc': 'hop turn left 270 degrees in air',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  60: {'desc': 'hop turn left 270 degrees in air',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  61: {'desc': 'hop turn 360 degrees left in air',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  62: {'desc': 'hop turn left 360 degrees in air',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  63: {'desc': 'large sidestep to right and forward',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  64: {'desc': 'hop and turn right 360 degrees in air',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  65: {'desc': 'hop and turn right 360 degrees in air',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  66: {'desc': 'short sidestep to right',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  67: {'desc': 'short sidestep to the right',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  68: {'desc': 'medium sidestep to right',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120}}},
 85: {'desc': 'jumps; flips; breakdance',
      'motions': {1: {'desc': 'JumpTwist',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  2: {'desc': 'JumpTwist',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  3: {'desc': 'UpRightSequence',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  4: {'desc': 'FancyFootWork',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  5: {'desc': 'HandStandKicks',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  6: {'desc': 'KickFlip',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  7: {'desc': 'KickFlipStumble',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  8: {'desc': 'Helicopter',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  9: {'desc': 'motorcycle pose',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  10: {'desc': 'EndofBreakDance',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  11: {'desc': 'UpRightSequence',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  12: {'desc': 'LongSequenceGood',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  13: {'desc': 'BadStartSequnce',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  14: {'desc': 'BreakSequencewithFlips',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  15: {'desc': '90TwistsFall',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120}}},
 86: {'desc': 'sports and various activities',
      'motions': {1: {'desc': 'jumps kicks and punches',
                      'files': ['c3d', 'amc', 'avi'],
                      'fps': 120},
                  2: {'desc': 'walk, squats, run, stretch, jumps, punches, and drinking',
                      'files': ['c3d', 'amc', 'avi'],
                      'fps': 120},
                  3: {'desc': 'walking, running, jumping, kicking, and stretching',
                      'files': ['c3d', 'amc', 'avi'],
                      'fps': 120},
                  4: {'desc': 'walking, stretching, punching, chopping, and drinking',
                      'files': ['c3d', 'amc', 'avi'],
                      'fps': 120},
                  5: {'desc': 'walking, jumping, jumping jacks,  jumping on one foot, punching, chopping,',
                      'files': ['c3d', 'amc', 'avi'],
                      'fps': 120},
                  6: {'desc': 'walking, running, kicking, punching, knee kicking, and stretching',
                      'files': ['c3d', 'amc', 'avi'],
                      'fps': 120},
                  7: {'desc': 'walking, swinging arms, stretching, jumping on one leg, and jumping',
                      'files': ['c3d', 'amc', 'avi'],
                      'fps': 120},
                  8: {'desc': 'walking, squats, stretching, kicking, and punching',
                      'files': ['c3d', 'amc', 'avi'],
                      'fps': 120},
                  9: {'desc': 'walking, sitting, looking, stand up',
                      'files': ['c3d', 'amc', 'avi'],
                      'fps': 120},
                  10: {'desc': 'walk around, sit, stand up, and running',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                  11: {'desc': 'walking, stretching, walking and turning',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                  12: {'desc': 'walking, dragging, sweeping, dustpan, wipe window, and wipe mirror',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                  13: {'desc': 'walking around, walk up ladder, step down ladder',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                  14: {'desc': 'bouncing basketball, shooting basketball, dribble basketball, two handed dribble',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                  15: {'desc': 'walking, sitting, hand motions',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120}}},
 87: {'desc': 'acrobatics',
      'motions': {1: {'desc': 'Jump with kick and spin',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 60},
                  2: {'desc': 'T-Pose',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 60},
                  3: {'desc': 'Backflip',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 60},
                  4: {'desc': 'backflip',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 60},
                  5: {'desc': 'cartwheels',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 60}}},
 88: {'desc': 'acrobatics',
      'motions': {1: {'desc': 'backflip',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 60},
                  2: {'desc': 'backflips, jump onto platform, handstands, vertical pushups',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 60},
                  3: {'desc': 'motorcycle pose',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 60},
                  4: {'desc': 'stretches, cartwheels, flips, spin kicks, spins, and fall',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 60},
                  5: {'desc': 'cartwheel into backflip',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 60},
                  6: {'desc': 'jump and spin kick',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 60},
                  7: {'desc': 'cartwheel',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 60},
                  8: {'desc': 'crouch and flip backward on hands',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 60},
                  9: {'desc': 'stretch and cartwheel',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 60},
                  10: {'desc': 'stretch and spin',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60},
                  11: {'desc': 'stretches and jumps',
                       'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                       'fps': 60}}},
 89: {'desc': 'acrobatics',
      'motions': {1: {'desc': 'balance object on forehead',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 60},
                  2: {'desc': 'motorcycle pose',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 60},
                  3: {'desc': 'flip and stand on one hand',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 60},
                  4: {'desc': 'spins, flips, stand on one hand',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 60},
                  5: {'desc': 'spin upside down, handstand, flips',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 60},
                  6: {'desc': 'balance beam',
                      'files': ['tvd', 'c3d', 'amc', 'mpg', 'avi'],
                      'fps': 60}}},
 90: {'desc': 'cartwheels; acrobatics; dances',
      'motions': {1: {'desc': 'bkwd summersult',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  2: {'desc': 'cartwheel',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  3: {'desc': 'cartwheel',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  4: {'desc': 'cartwheel',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  5: {'desc': 'jump kick',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  6: {'desc': 'jump kick',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  7: {'desc': 'jump kick',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  8: {'desc': 'side flip',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  9: {'desc': 'Flip forward onto hands and back again',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  10: {'desc': '',
                       'files': ['tvd', 'c3d', 'amc'],
                       'fps': 120},
                  11: {'desc': 'hand spring',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  12: {'desc': 'bck flp twst fall',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  13: {'desc': 'bck flp twst fall',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  14: {'desc': 'front hand flip',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  15: {'desc': 'front hand flip',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  16: {'desc': 'fall on face',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  17: {'desc': 'BannanaPeelSlip',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  18: {'desc': 'RugPullFall',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  19: {'desc': 'monkey backflip',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  20: {'desc': 'monkey sequence',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  21: {'desc': 'monkey sequence',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  22: {'desc': 'straight walk',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  23: {'desc': 'straight walk',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  24: {'desc': 'ball mount',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  25: {'desc': 'fwd ball walk',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  26: {'desc': 'fwd ball walk',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  27: {'desc': 'bwk ball walk',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  28: {'desc': 'breakdance',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  29: {'desc': 'sequesnce',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  30: {'desc': 'russian dance',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  31: {'desc': 'russian dance',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  32: {'desc': 'moonwalk',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  33: {'desc': 'arm up wide leg roll',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  34: {'desc': 'wide leg roll',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  35: {'desc': 'wide leg roll',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  36: {'desc': 'wide leg roll',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120}}},
 91: {'desc': 'walks and turns',
      'motions': {1: {'desc': 'Walk digital figure eight',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  2: {'desc': 'WalkStraight',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  3: {'desc': 'Walk figure eight',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  4: {'desc': 'Walking',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  5: {'desc': 'Mummy Walk',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  6: {'desc': 'Motorcycle Pose',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  7: {'desc': 'mummy8',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  8: {'desc': 'mummyDigital8',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  9: {'desc': 'DrunkWalk',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  10: {'desc': 'SlowWalk',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  11: {'desc': 'LavishWalk',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  12: {'desc': 'TooCoolWalk',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  13: {'desc': 'SadWalk',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  14: {'desc': 'DepressedWalk',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  15: {'desc': 'ClumsyWalk',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  16: {'desc': 'Limp',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  17: {'desc': 'QuickWalk',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  18: {'desc': 'CarefulWalk LookingAround',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  19: {'desc': 'March',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  20: {'desc': 'ShyWalk',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  21: {'desc': 'acheyWalk',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  22: {'desc': 'CasualQuickWalk',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  23: {'desc': 'CoolWalk',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  24: {'desc': 'HurtLegWalk',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  25: {'desc': 'DragBadLegWalk',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  26: {'desc': 'HurtStomachWalk',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  27: {'desc': 'SlowWalk',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  28: {'desc': 'GhettoWalk',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  29: {'desc': 'NormalWalk',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  30: {'desc': 'SexyWalk',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  31: {'desc': 'NormalWalk',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  32: {'desc': 'ScaredWalk',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  33: {'desc': 'MachoWalk',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  34: {'desc': 'NormalWalk',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  35: {'desc': 'TrafficWalk',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  36: {'desc': 'WalkStraight',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  37: {'desc': 'Forward',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  38: {'desc': 'SmallForward',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  39: {'desc': 'JumpForward',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  40: {'desc': 'JumpForward',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  41: {'desc': 'JumpForward',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  42: {'desc': 'JumpForward',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  43: {'desc': 'JumpSmallForward',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  44: {'desc': 'JumpSmallForward',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  45: {'desc': 'JumpForward',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  46: {'desc': 'Jump Turn',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  47: {'desc': 'Jump Turn',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  48: {'desc': 'JumpTurn',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  49: {'desc': 'Jump Turn',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  50: {'desc': 'JumpTurn',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  51: {'desc': 'FurtherJumpTurn',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  52: {'desc': 'SmallJumpTurn',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  53: {'desc': '180 degree jump',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  54: {'desc': '180',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  55: {'desc': '180',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  56: {'desc': '90',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  57: {'desc': 'WalkForward',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  58: {'desc': '270',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  59: {'desc': '360 smallStumble',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  60: {'desc': '360',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  61: {'desc': '360',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                  62: {'desc': 'walkFigure8',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120}}},
 93: {'desc': 'Charleston Dance',
      'motions': {1: {'desc': 'Motorcycle Pose',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  2: {'desc': 'rangeOfMotion',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  3: {'desc': 'charleston_01',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  4: {'desc': 'charleston_side_by_side_female',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  5: {'desc': 'charleston_side_by_side_male',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  6: {'desc': 'lindyHop2',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  7: {'desc': 'Casual Walk',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120},
                  8: {'desc': 'xtra fancY charleston',
                      'files': ['tvd', 'c3d', 'amc', 'avi'],
                      'fps': 120}}},
 94: {'desc': 'indian dance',
      'motions': {1: {'desc': '',
                      'files': ['c3d', 'amc', 'avi'],
                      'fps': 120},
                  2: {'desc': '',
                      'files': ['c3d', 'amc', 'avi'],
                      'fps': 120},
                  3: {'desc': '',
                      'files': ['c3d', 'amc', 'avi'],
                      'fps': 120},
                  4: {'desc': '',
                      'files': ['c3d', 'amc', 'avi'],
                      'fps': 120},
                  5: {'desc': '',
                      'files': ['c3d', 'amc', 'avi'],
                      'fps': 120},
                  6: {'desc': '',
                      'files': ['c3d', 'amc', 'avi'],
                      'fps': 120},
                  7: {'desc': '',
                      'files': ['c3d', 'amc', 'avi'],
                      'fps': 120},
                  8: {'desc': '',
                      'files': ['c3d', 'amc', 'avi'],
                      'fps': 120},
                  9: {'desc': '',
                      'files': ['c3d', 'amc', 'avi'],
                      'fps': 120},
                  10: {'desc': '',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                  11: {'desc': '',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                  12: {'desc': '',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                  13: {'desc': '',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                  14: {'desc': '',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                  15: {'desc': '',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                  16: {'desc': '',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120}}},
 102: {'desc': 'Basketball',
       'motions': {1: {'desc': 'RightWideTurn',
                       'files': ['tvd', 'c3d', 'amc'],
                       'fps': 120},
                   2: {'desc': 'LeftWideTurn',
                       'files': ['tvd', 'c3d', 'amc'],
                       'fps': 120},
                   3: {'desc': 'SuperTightLeft',
                       'files': ['tvd', 'c3d', 'amc'],
                       'fps': 120},
                   4: {'desc': 'SuperTightRight',
                       'files': ['tvd', 'c3d', 'amc'],
                       'fps': 120},
                   5: {'desc': 'RunningStraight',
                       'files': ['tvd', 'c3d', 'amc'],
                       'fps': 120},
                   6: {'desc': 'RunningWideRight',
                       'files': ['tvd', 'c3d', 'amc'],
                       'fps': 120},
                   7: {'desc': 'RunningWideLeft',
                       'files': ['tvd', 'c3d', 'amc'],
                       'fps': 120},
                   8: {'desc': 'RunningTighterRight',
                       'files': ['tvd', 'c3d', 'amc'],
                       'fps': 120},
                   9: {'desc': 'calibration',
                       'files': ['tvd', 'c3d', 'amc'],
                       'fps': 120},
                   10: {'desc': 'RunningNoBall',
                        'files': ['tvd', 'c3d', 'amc'],
                        'fps': 120},
                   11: {'desc': 'OffensiveMoveSpinLeft',
                        'files': ['tvd', 'c3d', 'amc'],
                        'fps': 120},
                   12: {'desc': 'OffensiveMoveSpinLeft',
                        'files': ['tvd', 'c3d', 'amc'],
                        'fps': 120},
                   13: {'desc': 'OffensiveMoveGoRight',
                        'files': ['tvd', 'c3d', 'amc'],
                        'fps': 120},
                   14: {'desc': 'OffensiveMoveGoLeft',
                        'files': ['tvd', 'c3d', 'amc'],
                        'fps': 120},
                   15: {'desc': 'OffensiveMoveSpinRight',
                        'files': ['tvd', 'c3d', 'amc'],
                        'fps': 120},
                   16: {'desc': 'WalkEvasiveLeft',
                        'files': ['tvd', 'c3d', 'amc'],
                        'fps': 120},
                   17: {'desc': 'WalkEvasiveRight',
                        'files': ['tvd', 'c3d', 'amc'],
                        'fps': 120},
                   18: {'desc': 'FeintLeftMoveRight',
                        'files': ['tvd', 'c3d', 'amc'],
                        'fps': 120},
                   19: {'desc': 'FeintRightMoveLeft',
                        'files': ['tvd', 'c3d', 'amc'],
                        'fps': 120},
                   20: {'desc': 'FakeShotBreakRight',
                        'files': ['tvd', 'c3d', 'amc'],
                        'fps': 120},
                   21: {'desc': 'FakeShotBreakLeft',
                        'files': ['tvd', 'c3d', 'amc'],
                        'fps': 120},
                   22: {'desc': 'DefensiveStraightNoStop',
                        'files': ['tvd', 'c3d', 'amc'],
                        'fps': 120},
                   23: {'desc': 'DefensiveStraightWithStop',
                        'files': ['tvd', 'c3d', 'amc'],
                        'fps': 120},
                   24: {'desc': 'DefensiveRightStopToStop',
                        'files': ['tvd', 'c3d', 'amc'],
                        'fps': 120},
                   25: {'desc': 'DefensiveLeftStopToStop',
                        'files': ['tvd', 'c3d', 'amc'],
                        'fps': 120},
                   26: {'desc': 'DefensiveMoveZigZag',
                        'files': ['tvd', 'c3d', 'amc'],
                        'fps': 120},
                   27: {'desc': 'DefensiveMoveSideToSide',
                        'files': ['tvd', 'c3d', 'amc'],
                        'fps': 120},
                   28: {'desc': 'DefensiveMoveSideToSide',
                        'files': ['tvd', 'c3d', 'amc'],
                        'fps': 120},
                   29: {'desc': 'Pivoting',
                        'files': ['tvd', 'c3d', 'amc'],
                        'fps': 120},
                   30: {'desc': 'SraightDriveFromStop',
                        'files': ['tvd', 'c3d', 'amc'],
                        'fps': 120},
                   31: {'desc': 'RightDrive (left then right)',
                        'files': ['tvd', 'c3d', 'amc'],
                        'fps': 120},
                   32: {'desc': 'LeftDrive (right then left)',
                        'files': ['tvd', 'c3d', 'amc'],
                        'fps': 120},
                   33: {'desc': 'RightTightTurn',
                        'files': ['tvd', 'c3d', 'amc'],
                        'fps': 120}}},
 103: {'desc': 'Charelston Dancing',
       'motions': {1: {'desc': '',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                   2: {'desc': 'rangeOfMotion_01',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                   3: {'desc': 'charleston_01',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                   4: {'desc': 'charleston_side_by_side_female',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                   5: {'desc': 'charleston_side_by_side_male',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                   6: {'desc': 'lindyHop2',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                   7: {'desc': 'Casual Walk',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                   8: {'desc': 'xtra fancY charleston',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120}}},
 104: {'desc': 'motion',
       'motions': {1: {'desc': 'JogThrough',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                   2: {'desc': 'neutral Male walk, exact footfalls',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                   3: {'desc': 'Frankenstein male walk, exact footfalls',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                   4: {'desc': 'JogThrough',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                   5: {'desc': '',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                   6: {'desc': 'StartJog',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                   7: {'desc': '',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                   8: {'desc': 'StartJog',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                   9: {'desc': 'JogStop',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                   10: {'desc': 'JogStop',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   11: {'desc': 'HappyGoLuckWalk',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   12: {'desc': 'ExcitedWalk',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   13: {'desc': 'StumbleWalk',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   14: {'desc': 'HappyStartWalk',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   15: {'desc': '',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   16: {'desc': 'SpasticWalk',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   17: {'desc': 'SpasticStop',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   18: {'desc': 'SpasticStop',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   19: {'desc': 'CasualWalk',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   20: {'desc': '',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   21: {'desc': '',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   22: {'desc': 'RegularWalk8',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   23: {'desc': '',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   24: {'desc': '',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   25: {'desc': '',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   26: {'desc': '',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   27: {'desc': 'RegularWalkRightAngleTurns',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   28: {'desc': 'SternWalk',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   29: {'desc': 'SternWalk',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   30: {'desc': 'SternWalk8',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   31: {'desc': '',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   32: {'desc': 'SternWalkRightAngleTurns',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   33: {'desc': '',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   34: {'desc': '',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   35: {'desc': 'SlowWalk',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   36: {'desc': 'SlowWalk8',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   37: {'desc': 'RunThrough',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   38: {'desc': '',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   39: {'desc': 'SlowWalkRightAngleTurns',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   40: {'desc': '',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   41: {'desc': 'ZombieWalk',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   42: {'desc': 'ZombieWalk8',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   43: {'desc': 'ZombieWalkRightAngleTurns',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   44: {'desc': 'AttitudeWalk',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   45: {'desc': 'AttitudeWalk8',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   46: {'desc': 'AttitudeWalkRightAngleTurns',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   47: {'desc': '',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   48: {'desc': 'RunThrough',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   49: {'desc': '',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   50: {'desc': '',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   51: {'desc': '',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   52: {'desc': '',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   53: {'desc': 'StartRun',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   54: {'desc': 'StartRun',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   55: {'desc': 'StartRun',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   56: {'desc': 'RunStop',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   57: {'desc': 'RunStop',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120}}},
 105: {'desc': 'motion',
       'motions': {1: {'desc': 'WalkDigital8',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                   2: {'desc': 'WalkStraight',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                   3: {'desc': 'Walk8',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                   4: {'desc': 'Digital8',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                   5: {'desc': 'mummyWalk',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                   6: {'desc': 'MotorCyclePose',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                   7: {'desc': 'mummy8',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                   8: {'desc': 'mummyDigital8',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                   9: {'desc': 'DrunkWalk',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                   10: {'desc': 'SlowWalk',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   11: {'desc': 'LavishWalk',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   12: {'desc': 'TooCoolWalk',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   13: {'desc': 'SadWalk',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   14: {'desc': 'DepressedWalk',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   15: {'desc': 'ClumsyWalk',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   16: {'desc': 'Limp',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   17: {'desc': 'QuickWalk',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   18: {'desc': 'CarefulWalk LookingAround',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   19: {'desc': 'March',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   20: {'desc': 'ShyWalk',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   21: {'desc': 'acheyWalk',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   22: {'desc': 'CasualQuickWalk',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   23: {'desc': 'CoolWalk',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   24: {'desc': 'HurtLegWalk',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   25: {'desc': 'DragBadLegWalk',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   26: {'desc': 'HurtStomachWalk',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   27: {'desc': 'SlowWalk',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   28: {'desc': 'GhettoWalk',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   29: {'desc': 'NormalWalk',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   30: {'desc': 'SexyWalk',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   31: {'desc': 'NormalWalk',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   32: {'desc': 'ScaredWalk',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   33: {'desc': 'MachoWalk',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   34: {'desc': 'NormalWalk',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   35: {'desc': 'TrafficWalk',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   36: {'desc': 'WalkStraight',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   37: {'desc': 'Forward',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   38: {'desc': 'SmallForward',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   39: {'desc': 'JumpForward',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   40: {'desc': 'JumpForward',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   41: {'desc': 'JumpForward',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   42: {'desc': 'JumpForward',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   43: {'desc': 'JumpSmallForward',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   44: {'desc': 'JumpSmallForward',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   45: {'desc': 'JumpForward',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   46: {'desc': 'Jump Turn',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   47: {'desc': 'Jump Turn',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   48: {'desc': 'JumpTurn',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   49: {'desc': 'Jump Turn',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   50: {'desc': 'JumpTurn',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   51: {'desc': 'FurtherJumpTurn',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   52: {'desc': 'SmallJumpTurn',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   53: {'desc': '180',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   54: {'desc': '180',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   55: {'desc': '180',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   56: {'desc': '90',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   57: {'desc': 'WalkForward',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   58: {'desc': '270',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   59: {'desc': '360 smallStumble',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   60: {'desc': '360',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   61: {'desc': '360',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   62: {'desc': 'walkFigure8',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120}}},
 106: {'desc': 'Female General Subject',
       'motions': {1: {'desc': 'clean',
                       'files': ['tvd', 'c3d', 'amc'],
                       'fps': 120},
                   2: {'desc': 'clean',
                       'files': ['tvd', 'c3d', 'amc'],
                       'fps': 120},
                   3: {'desc': 'clean',
                       'files': ['tvd', 'c3d', 'amc'],
                       'fps': 120},
                   4: {'desc': 'clean',
                       'files': ['tvd', 'c3d', 'amc'],
                       'fps': 120},
                   5: {'desc': 'clean',
                       'files': ['tvd', 'c3d', 'amc'],
                       'fps': 120},
                   6: {'desc': 'clean',
                       'files': ['tvd', 'c3d', 'amc'],
                       'fps': 120},
                   7: {'desc': 'clean',
                       'files': ['tvd', 'c3d', 'amc'],
                       'fps': 120},
                   8: {'desc': 'clean',
                       'files': ['tvd', 'c3d', 'amc'],
                       'fps': 120},
                   9: {'desc': 'clean',
                       'files': ['tvd', 'c3d', 'amc'],
                       'fps': 120},
                   10: {'desc': 'clean',
                        'files': ['tvd', 'c3d', 'amc'],
                        'fps': 120},
                   11: {'desc': 'clean',
                        'files': ['tvd', 'c3d', 'amc'],
                        'fps': 120},
                   12: {'desc': 'clean',
                        'files': ['tvd', 'c3d', 'amc'],
                        'fps': 120},
                   13: {'desc': 'clean',
                        'files': ['tvd', 'c3d', 'amc'],
                        'fps': 120},
                   14: {'desc': 'clean',
                        'files': ['tvd', 'c3d', 'amc'],
                        'fps': 120},
                   15: {'desc': '',
                        'files': ['tvd', 'c3d', 'amc'],
                        'fps': 120},
                   16: {'desc': 'clean',
                        'files': ['tvd', 'c3d', 'amc'],
                        'fps': 120},
                   17: {'desc': 'clean',
                        'files': ['tvd', 'c3d', 'amc'],
                        'fps': 120},
                   18: {'desc': 'clean',
                        'files': ['tvd', 'c3d', 'amc'],
                        'fps': 120},
                   19: {'desc': 'clean',
                        'files': ['tvd', 'c3d', 'amc'],
                        'fps': 120},
                   20: {'desc': 'clean',
                        'files': ['tvd', 'c3d', 'amc'],
                        'fps': 120},
                   21: {'desc': 'bad AMC',
                        'files': ['tvd', 'c3d', 'amc'],
                        'fps': 120},
                   22: {'desc': 'clean',
                        'files': ['tvd', 'c3d', 'amc'],
                        'fps': 120},
                   23: {'desc': 'clean',
                        'files': ['tvd', 'c3d', 'amc'],
                        'fps': 120},
                   24: {'desc': 'clean',
                        'files': ['tvd', 'c3d', 'amc'],
                        'fps': 120},
                   25: {'desc': 'clean',
                        'files': ['tvd', 'c3d', 'amc'],
                        'fps': 120},
                   26: {'desc': 'clean',
                        'files': ['tvd', 'c3d', 'amc'],
                        'fps': 120},
                   27: {'desc': 'clean',
                        'files': ['tvd', 'c3d', 'amc'],
                        'fps': 120},
                   28: {'desc': 'clean',
                        'files': ['tvd', 'c3d', 'amc'],
                        'fps': 120},
                   29: {'desc': 'clean',
                        'files': ['tvd', 'c3d', 'amc'],
                        'fps': 120},
                   30: {'desc': 'clean',
                        'files': ['tvd', 'c3d', 'amc'],
                        'fps': 120},
                   31: {'desc': 'clean',
                        'files': ['tvd', 'c3d', 'amc'],
                        'fps': 120},
                   32: {'desc': 'clean',
                        'files': ['tvd', 'c3d', 'amc'],
                        'fps': 120},
                   33: {'desc': 'clean',
                        'files': ['tvd', 'c3d', 'amc'],
                        'fps': 120},
                   34: {'desc': 'clean',
                        'files': ['tvd', 'c3d', 'amc'],
                        'fps': 120}}},
 107: {'desc': 'Walking with obstacles 1',
       'motions': {1: {'desc': '',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                   2: {'desc': '',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                   3: {'desc': '',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                   4: {'desc': '',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                   5: {'desc': '',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                   6: {'desc': '',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                   7: {'desc': '',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                   8: {'desc': '',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                   9: {'desc': '',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                   10: {'desc': '',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   11: {'desc': '',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   12: {'desc': '',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   13: {'desc': '',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   14: {'desc': '',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120}}},
 108: {'desc': 'Walking with obstacles 2',
       'motions': {1: {'desc': '',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   2: {'desc': '',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   3: {'desc': '',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   4: {'desc': '',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   5: {'desc': '',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   6: {'desc': '',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   7: {'desc': '',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   8: {'desc': '',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   9: {'desc': '',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   10: {'desc': '',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   11: {'desc': '',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   12: {'desc': '',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   13: {'desc': '',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   14: {'desc': '',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   15: {'desc': '',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   16: {'desc': '',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   17: {'desc': '',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   18: {'desc': '',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   19: {'desc': '',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   20: {'desc': '',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   21: {'desc': '',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   22: {'desc': '',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   23: {'desc': '',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   24: {'desc': '',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   25: {'desc': '',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   26: {'desc': '',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   27: {'desc': '',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   28: {'desc': '',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120}}},
 111: {'desc': 'Pregnant Woman',
       'motions': {1: {'desc': 'Walk backwards',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   2: {'desc': 'Bow',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   3: {'desc': 'Crawling',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   4: {'desc': 'Curtsey',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   5: {'desc': 'Dance',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   6: {'desc': 'Get up from floor',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   7: {'desc': 'Get up from floor',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   8: {'desc': 'Get up from floor',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   9: {'desc': 'Get up from chair',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   10: {'desc': 'get up from chair',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   11: {'desc': 'get up from chair',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   12: {'desc': 'Lay down',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   13: {'desc': 'March',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   14: {'desc': 'Mope',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   15: {'desc': 'Motorcycle',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   16: {'desc': 'Peekaboo',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   17: {'desc': 'Pick up',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   18: {'desc': 'Pick up',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   19: {'desc': 'Punch Kick',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   20: {'desc': 'Ring around the rosie',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   21: {'desc': 'Roll over',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   22: {'desc': 'Range of motion',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   23: {'desc': 'Run',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   24: {'desc': 'Run',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   25: {'desc': 'Shrug',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   26: {'desc': 'Walk sideways',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   27: {'desc': 'Walking up stairs',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   28: {'desc': 'Standing still',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   29: {'desc': 'Stepping over',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   30: {'desc': 'Stepping over',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   31: {'desc': 'Stepping up / stepping down',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   32: {'desc': 'Stretch and yawn',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   33: {'desc': 'Throwing',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   34: {'desc': 'Walk',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   35: {'desc': 'Walk',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   36: {'desc': 'Walk and carry',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   37: {'desc': 'Wave',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   38: {'desc': 'Yoga',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   39: {'desc': 'Yoga',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   40: {'desc': 'Yoga',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   41: {'desc': 'Yoga',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120}}},
 113: {'desc': 'Post pregnant woman',
       'motions': {1: {'desc': 'Walk backwards',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   2: {'desc': 'Bow',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   3: {'desc': 'Curtsey',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   4: {'desc': 'Dance',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   5: {'desc': 'Walk digital 8',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   6: {'desc': 'Walk figure 8',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   7: {'desc': 'Run',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   8: {'desc': 'Lay down and get up',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   9: {'desc': 'March',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   10: {'desc': 'Walk, mope around',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   11: {'desc': 'Motorcycle',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   12: {'desc': 'Peekaboo',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   13: {'desc': 'Punch and kick',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   14: {'desc': 'Ring around the rosie',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   15: {'desc': 'Sit in chair and get up',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   16: {'desc': 'Shrug',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   17: {'desc': 'Walk sideway',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   18: {'desc': 'Walk sideways',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   19: {'desc': 'Walking up and down stairs',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   20: {'desc': 'Walk up and down stairs',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   21: {'desc': 'Standing Still',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   22: {'desc': 'Step over',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   23: {'desc': 'Stretch and yawn',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   24: {'desc': 'Throw',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   25: {'desc': 'Walk',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   26: {'desc': 'Walk and carry',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   27: {'desc': 'Wave',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   28: {'desc': 'Yoga',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   29: {'desc': 'Yoga',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120}}},
 114: {'desc': 'Pregnant Woman',
       'motions': {1: {'desc': 'Motorcycle',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   2: {'desc': 'Getting up from laying down',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   3: {'desc': 'Range of motion',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   4: {'desc': 'Getting up from chair',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   5: {'desc': 'Sitting in chair',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   6: {'desc': 'Getting up from chair',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   7: {'desc': 'Walking up and down stairs',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   8: {'desc': 'Walking up and down stairs',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   9: {'desc': 'Walking up and down stairs',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   10: {'desc': 'Stretching',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   11: {'desc': 'Laying down and getting up',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   12: {'desc': 'Stretching',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   13: {'desc': 'Walk',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   14: {'desc': 'Walk',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   15: {'desc': 'Walk',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   16: {'desc': 'Sit down and stretch',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120}}},
 115: {'desc': 'Bending over',
       'motions': {1: {'desc': 'Pick up box, bend from waist',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   2: {'desc': 'Pick box up, bend from waist',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   3: {'desc': 'Pick box up, bend from waist',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   4: {'desc': 'Pick box up, bend from waist',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   5: {'desc': 'Pick box up, bend from waist',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   6: {'desc': 'Picking box up, bending knees',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   7: {'desc': 'Picking box up, bending knees',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   8: {'desc': 'Picking box up, bending knees',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   9: {'desc': 'Picking box up, bending knees',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   10: {'desc': 'Pick box up, bend from waist',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120}}},
 118: {'desc': 'Jumping',
       'motions': {1: {'desc': 'Jump',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   2: {'desc': 'Jump',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   3: {'desc': 'Jump',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   4: {'desc': 'Jump',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   5: {'desc': 'Jump',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   6: {'desc': 'Jump',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   7: {'desc': 'Jump',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   8: {'desc': 'Jump',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   9: {'desc': 'Jump',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   10: {'desc': 'Jump',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   11: {'desc': 'Jump',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   12: {'desc': 'Jump',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   13: {'desc': 'Jump',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   14: {'desc': 'Jump',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   15: {'desc': 'Jump',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   16: {'desc': 'Jump',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   17: {'desc': 'Jump',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   18: {'desc': 'Jump',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   19: {'desc': 'Jump',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   20: {'desc': 'Jump',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   21: {'desc': 'Jump',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   22: {'desc': 'Jump',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   23: {'desc': 'Jump',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   24: {'desc': 'Jump',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   25: {'desc': 'Jump',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   26: {'desc': 'Jump',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   27: {'desc': 'Jump',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   28: {'desc': 'Jump',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   29: {'desc': 'Jump',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   30: {'desc': 'Jump',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   31: {'desc': 'Motorcycle',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   32: {'desc': 'Range of motion',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120}}},
 120: {'desc': 'Various Style Walks',
       'motions': {1: {'desc': 'Alien Turn',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   2: {'desc': 'Gorilla',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   3: {'desc': 'Mickey cast spell',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   4: {'desc': 'Mickey Conducting',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   5: {'desc': 'Mickey Dance',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   6: {'desc': 'Mickey Dance',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   7: {'desc': 'Mickey Dance',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   8: {'desc': 'Mickey sneaky walk',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   9: {'desc': 'Mickey sneaking walk',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   10: {'desc': 'Mickey sneaking walk',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   11: {'desc': 'Mickey sneaking walk',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   12: {'desc': 'Mickey sneaking walk',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   13: {'desc': 'Mickey sneaking walk',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   14: {'desc': 'Mickey sneaking walk',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   15: {'desc': 'Mickey Surprised',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   16: {'desc': 'Mickey Surprised',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   17: {'desc': 'Mickey Walk',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   18: {'desc': 'Mickey Walk',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   19: {'desc': 'Walk slow',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   20: {'desc': 'Walk',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   21: {'desc': 'Robot',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   22: {'desc': 'Zombie',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120}}},
 122: {'desc': 'Varying Height and Length Steps',
       'motions': {1: {'desc': 'clean',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   2: {'desc': 'clean',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   3: {'desc': 'clean',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   4: {'desc': 'clean',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   5: {'desc': 'clean',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   6: {'desc': 'clean',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   7: {'desc': 'clean',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   8: {'desc': 'clean',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   9: {'desc': 'clean',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   10: {'desc': 'clean',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   11: {'desc': '',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   12: {'desc': 'clean',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   13: {'desc': 'clean',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   14: {'desc': 'clean',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   15: {'desc': 'clean',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   16: {'desc': 'clean',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   17: {'desc': 'clean',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   18: {'desc': 'clean',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   19: {'desc': 'clean',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   20: {'desc': 'clean',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   21: {'desc': 'clean',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   22: {'desc': 'clean',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   23: {'desc': 'clean',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   24: {'desc': 'clean',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   25: {'desc': 'clean',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   26: {'desc': 'clean',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   27: {'desc': 'clean',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   28: {'desc': 'clean',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   29: {'desc': 'clean',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   30: {'desc': 'clean',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   31: {'desc': 'clean',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   32: {'desc': 'clean',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   33: {'desc': 'clean',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   34: {'desc': 'clean',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   35: {'desc': 'clean',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   36: {'desc': 'clean',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   37: {'desc': 'clean',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   38: {'desc': 'clean',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   39: {'desc': 'clean',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   40: {'desc': 'clean',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   41: {'desc': 'clean',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   42: {'desc': 'clean',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   43: {'desc': 'clean',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   44: {'desc': 'clean',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   45: {'desc': 'clean',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   46: {'desc': 'clean',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   47: {'desc': 'clean',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   48: {'desc': 'clean',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   49: {'desc': 'clean',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   50: {'desc': 'clean',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   51: {'desc': 'clean',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   52: {'desc': 'clean',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   53: {'desc': 'clean',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   54: {'desc': 'clean',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   55: {'desc': 'clean',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   56: {'desc': 'clean',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   57: {'desc': 'clean',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   58: {'desc': 'cleaned',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   59: {'desc': 'clean',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   60: {'desc': 'clean',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   61: {'desc': 'clean',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   62: {'desc': 'clean',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   63: {'desc': 'clean',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   64: {'desc': 'clean',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   65: {'desc': 'clean',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   66: {'desc': 'clean',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   67: {'desc': 'clean',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   68: {'desc': 'clean',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120}}},
 123: {'desc': 'Carry Suitcase with Varying Weights',
       'motions': {1: {'desc': '15.5 lbs',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   2: {'desc': '15.5 lbs',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   3: {'desc': '19.5lb',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   4: {'desc': '19.5 lbs',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   5: {'desc': '19.5 lbs',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   6: {'desc': '19.5 lbs',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   7: {'desc': '12.5lb',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   8: {'desc': '12.5 lbs',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   9: {'desc': '12.5 lbs',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   10: {'desc': '12.5lb',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   11: {'desc': '15.5 lbs',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   12: {'desc': '15.5 lbs',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   13: {'desc': '15.5 lbs',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120}}},
 124: {'desc': 'Sports Related Motions',
       'motions': {1: {'desc': 'Baseball Pitch',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   2: {'desc': 'Baseball Pitch',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   3: {'desc': 'Basketball Shoot',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   4: {'desc': 'Basketball Free Throw',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   5: {'desc': 'Basketball Jump Shot',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   6: {'desc': 'Basketball Lay Up',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   7: {'desc': 'Baseball Swing',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   8: {'desc': 'Baseball Bunt',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   9: {'desc': 'Frisbee',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   10: {'desc': 'Motorcycle',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   11: {'desc': '2 Foot Jump',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   12: {'desc': 'Underhand Toss',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   13: {'desc': 'Underhand Fast Pitch',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120}}},
 125: {'desc': 'Swimming',
       'motions': {1: {'desc': 'Breast Stroke',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   2: {'desc': 'Breast Stroke',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   3: {'desc': 'Break Stroke',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   4: {'desc': 'Breast Stroke',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   5: {'desc': 'Butterfly',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   6: {'desc': 'Free Style',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   7: {'desc': 'Motorcycle',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120}}},
 126: {'desc': 'Swimming 2',
       'motions': {1: {'desc': 'Back Stroke',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   2: {'desc': 'Back Stroke',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   3: {'desc': 'Breast Stroke',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   4: {'desc': 'Breast Stroke',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   5: {'desc': 'Breast Stroke',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   6: {'desc': 'Fly Stroke',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   7: {'desc': 'Fly Stroke',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   8: {'desc': 'Fly Stroke',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   9: {'desc': 'Fly Stroke',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   10: {'desc': 'Free Style',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   11: {'desc': 'Free Style',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   12: {'desc': 'Free Style',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   13: {'desc': 'Motorcycle',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   14: {'desc': 'Range of Motion',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120}}},
 127: {'desc': 'Action Adventure Obstacles, running, jumping, ducking, rolling',
       'motions': {1: {'desc': 'Motorcycle',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   2: {'desc': 'Range of Motion',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   3: {'desc': 'Run',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   4: {'desc': 'Walk to Run',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   5: {'desc': 'Run to Quick Stop',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   6: {'desc': 'Run',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   7: {'desc': 'Run',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   8: {'desc': 'Run',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   9: {'desc': 'Run Right',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   10: {'desc': 'Run Right',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   11: {'desc': 'Run Left',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   12: {'desc': 'Run Left',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   13: {'desc': 'Run Side Step Left',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   14: {'desc': 'Run Side Step Right',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   15: {'desc': 'Run Turn Left',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   16: {'desc': 'Run Turn Right',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   17: {'desc': 'Run Stop Run',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   18: {'desc': 'Run Stop Run',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   19: {'desc': 'Run Quick Stop Run',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   20: {'desc': 'Run Quick Stop Run',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   21: {'desc': 'Run Jump Stop Run',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   22: {'desc': 'Run Jump Stop Run',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   23: {'desc': 'Run Dive Over Roll Run',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   24: {'desc': 'Run Dive Over Roll Run',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   25: {'desc': 'Run Jump Over',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   26: {'desc': 'Run Jump Over',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   27: {'desc': 'Run Jump Over',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   28: {'desc': 'Run Jump Over',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   29: {'desc': 'Run Duck Underneath',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   30: {'desc': 'Run Duck Underneath',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   31: {'desc': 'Run Duck Underneath',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   32: {'desc': 'Run Duck Underneath',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   33: {'desc': 'Run Over',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   34: {'desc': 'Run Over',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   35: {'desc': 'Run Over',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   36: {'desc': 'Run Over',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   37: {'desc': 'Run Duck Underneath',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   38: {'desc': 'Run Duck Underneath',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120}}},
 128: {'desc': 'Action Adventure Motions running, ducking, rolling, stopping',
       'motions': {1: {'desc': 'Motorcycle',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   2: {'desc': 'Run Left',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   3: {'desc': 'Run Right',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   4: {'desc': 'Run Duck Underneath',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   5: {'desc': 'Run Stop Run',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   6: {'desc': 'Run Stop Run',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   7: {'desc': 'Run Stop Run',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   8: {'desc': 'Run Stop Run',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   9: {'desc': 'Run Roll Underneath',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   10: {'desc': 'Run Dive Over Roll Run',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   11: {'desc': 'Run Dive Over Roll Run',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120}}},
 131: {'desc': 'Michael Jackson Styled Motions',
       'motions': {1: {'desc': 'Start Walk Stop',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   2: {'desc': 'Start Walk Stop',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   3: {'desc': 'Start Hop Stop',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   4: {'desc': 'Start Hop Stop',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   5: {'desc': 'Start Duck Underneath Stop',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   6: {'desc': 'Start Duck Underneath Stop',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   7: {'desc': 'Jump Stop',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   8: {'desc': 'Jump Stop',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   9: {'desc': 'Start Walk Left',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   10: {'desc': 'Start Walk Left',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   11: {'desc': 'Start Walk Left',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   12: {'desc': 'Start Walk Right',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   13: {'desc': 'Start Walk Right',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   14: {'desc': 'Start Walk Right',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120}}},
 132: {'desc': 'Varying Weird Walks',
       'motions': {1: {'desc': 'Walk With Arms Out,  balancing',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   2: {'desc': 'Walk With Arms Out,  balancing',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   3: {'desc': 'Walk With Arms Out,  balancing',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   4: {'desc': 'Walk With Arms Out,  balancing',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   5: {'desc': 'Walk With Arms Out,  balancing',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   6: {'desc': 'Walk With Arms Out,  balancing',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   7: {'desc': 'Walk With Arms Out,  balancing',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   8: {'desc': 'Walk With Arms Out,  balancing',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   9: {'desc': 'Walk With Arms Out,  balancing',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   10: {'desc': 'Walk With Arms Out,  balancing',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   11: {'desc': 'Walk With Arms Out,  balancing',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   12: {'desc': 'Walk With Arms Out,  balancing',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   13: {'desc': 'Walk Backwards',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   14: {'desc': 'Walk Duck Footed',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   15: {'desc': 'Walk With Knees Bent',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   16: {'desc': 'Walk Crossover',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   17: {'desc': 'Walk Fast',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   18: {'desc': 'Walk Fast',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   19: {'desc': 'Walk Fast',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   20: {'desc': 'Walk Fast',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   21: {'desc': 'Walk Fast',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   22: {'desc': 'Walk Fast',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   23: {'desc': 'Hop on left foot',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   24: {'desc': 'Hop on left foot',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   25: {'desc': 'Hop on left foot',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   26: {'desc': 'Hop on left foot',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   27: {'desc': 'Hop on left foot',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   28: {'desc': 'Hop on left foot',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   29: {'desc': 'Bouncy Walk',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   30: {'desc': 'Bouncy Walk',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   31: {'desc': 'Bouncy Walk',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   32: {'desc': 'Bouncy Walk',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   33: {'desc': 'Bouncy Walk',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   34: {'desc': 'Bouncy Walk',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   35: {'desc': 'Walk Leaning To The Right',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   36: {'desc': 'Walk Leaning To The Right',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   37: {'desc': 'Marching',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   38: {'desc': 'Motorcycle',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   39: {'desc': 'Pigeon Toed Walking',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   40: {'desc': 'Walk With Stiff Arms',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   41: {'desc': 'Walk With Stiff Arms',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   42: {'desc': 'Walk Swinging Shoulders',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   43: {'desc': 'Walk Swinging Shoulders',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   44: {'desc': 'Walk Swinging Shoulders',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   45: {'desc': 'Walk Slow',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   46: {'desc': 'Walk Slow',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   47: {'desc': 'Walk Slow',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   48: {'desc': 'Walk Slow',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   49: {'desc': 'Walk Slow',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   50: {'desc': 'Walk Slow',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   51: {'desc': 'Tpose',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   52: {'desc': 'Range of Motion',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   53: {'desc': 'Walk With Legs Apart',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   54: {'desc': 'Walk With Wild Arms',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   55: {'desc': 'Walk With Wild Legs',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   56: {'desc': 'Walk With Wild Legs',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120}}},
 133: {'desc': 'Baby Styled Walk',
       'motions': {1: {'desc': 'Walk Crawl',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   2: {'desc': 'Walk Crawl',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   3: {'desc': 'Walk Jump',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   4: {'desc': 'Walk Jump',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   5: {'desc': 'Walk Jump',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   6: {'desc': 'Walk Jump',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   7: {'desc': 'Walk Jump',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   8: {'desc': 'Stretch Walk',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   9: {'desc': 'Stretch Walk',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   10: {'desc': 'Stretch Walk',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   11: {'desc': 'Walk Stop Walk',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   12: {'desc': 'Walk Stop Walk',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   13: {'desc': 'Walk Stop Walk',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   14: {'desc': 'Walk Left',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   15: {'desc': 'Walk Left',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   16: {'desc': 'Walk Left',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   17: {'desc': 'Walk Right',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   18: {'desc': 'Walk Right',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   19: {'desc': 'Walk Right',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   20: {'desc': 'Walk Right',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   21: {'desc': 'Walk',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   22: {'desc': 'Walk',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   23: {'desc': 'Walk',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   24: {'desc': 'Walk ZigZag',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   25: {'desc': 'Motorcycle',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   26: {'desc': 'Range of Motion',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120}}},
 134: {'desc': 'Skateboard Motions',
       'motions': {1: {'desc': 'Duck Under',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   2: {'desc': 'Go Forward',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   3: {'desc': 'Lean Turn Right',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   4: {'desc': 'Motorcycle',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   5: {'desc': 'Pump Jump',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   6: {'desc': 'Push Turn Left',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   7: {'desc': 'Push Turn Left',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   8: {'desc': 'Push Turn Right',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   9: {'desc': 'Push Turn Right',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   10: {'desc': 'Start',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   11: {'desc': 'Start',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   12: {'desc': 'Stop and Go',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   13: {'desc': 'Stop and Go',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   14: {'desc': 'Stop ang Go',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   15: {'desc': 'Lean Turn Left',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120}}},
 135: {'desc': 'Martial Arts Walks',
       'motions': {1: {'desc': 'Bassai',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   2: {'desc': 'Empi',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   3: {'desc': 'Empi',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   4: {'desc': 'Front Kick',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   5: {'desc': 'Gedanbarai',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   6: {'desc': 'Heiansyodan',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   7: {'desc': 'Mawashigeri',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   8: {'desc': 'Motorcycle',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   9: {'desc': 'Oiduki',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   10: {'desc': 'Syutouuke',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   11: {'desc': 'Yokogeri',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120}}},
 136: {'desc': 'Weird Walks',
       'motions': {1: {'desc': 'Walk Bent Forward',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   2: {'desc': 'Walk Bent Forward',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   3: {'desc': 'Walk Backwards Bent Forward',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   4: {'desc': 'Walk Backwards Bent Forward',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   5: {'desc': 'Walk on Toes Bent Forward',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   6: {'desc': 'Walk on Toes Bent Forward',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   7: {'desc': 'Walk Backward on Toes Bent Forward',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   8: {'desc': 'Walk Backward on Toes Bent Forward',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   9: {'desc': 'Walk Crouched',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   10: {'desc': 'Walk Crouched',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   11: {'desc': 'Walk Backwards Crouched',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   12: {'desc': 'Walk Backwards Crouched',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   13: {'desc': 'Walk on Toes Crouched',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   14: {'desc': 'Walk on Toes Crouched',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   15: {'desc': 'Walk Backwards on Toes Crouched',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   16: {'desc': 'Walk Backwards on Toes Crouched',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   17: {'desc': 'Flamingo, lift legs high',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   18: {'desc': 'Flamingo, lift legs high',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   19: {'desc': 'Motorcycle',
                        'files': ['amc', 'avi'],
                        'fps': 60},
                   20: {'desc': 'Normal Walk',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   21: {'desc': 'Normal Walk',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   22: {'desc': 'Normal Walk',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   23: {'desc': 'Normal Walk',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   24: {'desc': 'Normal Walk',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   25: {'desc': 'Normal Walk Backwards',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   26: {'desc': 'Normal Walk Backwards',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   27: {'desc': 'Walk on Toes',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   28: {'desc': 'Walk on Toes',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   29: {'desc': 'Walk Backwards on Toes',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   30: {'desc': 'Walk Backwards on Toes',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   31: {'desc': 'Quail, quick little steps',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   32: {'desc': 'Quail, quick little steps',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   33: {'desc': 'Range of Motion',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120}}},
 137: {'desc': 'Stylized Motions',
       'motions': {1: {'desc': 'Cat Coffee Mug',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   2: {'desc': 'Cat Pick Up',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   3: {'desc': 'Cat Wait',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   4: {'desc': 'Cat Walk',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   5: {'desc': 'Chicken Coffee Mug',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   6: {'desc': 'Chicken Pick Up',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   7: {'desc': 'Chicken Wait',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   8: {'desc': 'Chicken Walk',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   9: {'desc': 'Dinosaur Coffee Mug',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   10: {'desc': 'Dinosaur Pick Up',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   11: {'desc': 'Dinosaur Wait',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   12: {'desc': 'Dinosaur Walk',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   13: {'desc': 'Drunk Coffee Mug',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   14: {'desc': 'Drunk Pick Up',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   15: {'desc': 'Drunk Wait',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   16: {'desc': 'Drunk Walk',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   17: {'desc': 'Gangly Teen Coffee Mug',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   18: {'desc': 'Gangly Teen Pick Up',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   19: {'desc': 'Gangly Teen Wait',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   20: {'desc': 'Gangly Teen Walk',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   21: {'desc': 'Graceful Lady Coffee Mug',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   22: {'desc': 'Graceful Lady Pick Up',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   23: {'desc': 'Graceful Lady Wait',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   24: {'desc': 'Graceful Lady Walk',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   25: {'desc': 'Motorcycle',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   26: {'desc': 'Normal Coffee Mug',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   27: {'desc': 'Normal Pick Up',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   28: {'desc': 'Normal Wait',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   29: {'desc': 'Normal Walk',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   30: {'desc': 'Old Man Coffee Mug',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   31: {'desc': 'Old Man Pick Up',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   32: {'desc': 'Old Man Wait',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   33: {'desc': 'Old Man Walk',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   34: {'desc': 'Range of Motion',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   35: {'desc': 'Sexy Lady Coffee Mug',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   36: {'desc': 'Sexy Lady Pick Up',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   37: {'desc': 'Sexy Lady Wait',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   38: {'desc': 'Sexy Lady Walk',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   39: {'desc': 'Strong Man Coffee Mug',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   40: {'desc': 'Strong Man Pick Up',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   41: {'desc': 'Strong Man Wait',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   42: {'desc': 'Strong Man Walk',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120}}},
 138: {'desc': 'Marching, Walking and Talking',
       'motions': {1: {'desc': 'Marching',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   2: {'desc': 'Marching',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   3: {'desc': 'Marching',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   4: {'desc': 'Marching',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   5: {'desc': 'Marching',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   6: {'desc': 'Marching',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   7: {'desc': 'Marching',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   8: {'desc': 'Marching',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   9: {'desc': 'Marching',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   10: {'desc': 'Marching',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   11: {'desc': 'Story',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   12: {'desc': 'Story',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   13: {'desc': 'Story',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   14: {'desc': 'Story',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   15: {'desc': 'Story',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   16: {'desc': 'Story',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   17: {'desc': 'Story',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   18: {'desc': 'Story',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   19: {'desc': 'Story',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   20: {'desc': 'Story',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   21: {'desc': 'Story',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   22: {'desc': 'Story',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   23: {'desc': 'Story',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   24: {'desc': 'Story',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   25: {'desc': 'Story',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   26: {'desc': 'Story',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   27: {'desc': 'Story',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   28: {'desc': 'Story',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   29: {'desc': 'Story',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   30: {'desc': 'Story',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   31: {'desc': 'Story',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   32: {'desc': 'Story',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   33: {'desc': 'Story',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   34: {'desc': 'Story',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   35: {'desc': 'Story',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   36: {'desc': 'Story',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   37: {'desc': 'Story',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   38: {'desc': 'Story',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   39: {'desc': 'Story',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   40: {'desc': 'Story',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   41: {'desc': 'Story',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   42: {'desc': 'Story',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   43: {'desc': 'Story',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   44: {'desc': 'Story',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   45: {'desc': 'Story',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   46: {'desc': 'Story',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   47: {'desc': 'Story',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   48: {'desc': 'Story',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   49: {'desc': 'Story',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   50: {'desc': 'Story',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   51: {'desc': 'Story',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   52: {'desc': 'Story',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   53: {'desc': 'Story',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   54: {'desc': 'Story',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   55: {'desc': 'Story',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120}}},
 139: {'desc': 'Action Walks, sneaking, wounded, looking around',
       'motions': {1: {'desc': 'Looking Around',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                   2: {'desc': 'Shifting Weight',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                   3: {'desc': 'Looking Around',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                   4: {'desc': 'Looking Around',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                   5: {'desc': 'Pulling a Gun',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                   6: {'desc': 'Poking Around On The Ground',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                   7: {'desc': 'Poking Around On The Ground',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                   8: {'desc': 'Poking Around On The Ground',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                   9: {'desc': 'Ducking',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                   10: {'desc': 'Run',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   11: {'desc': 'Run To Sneak',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   12: {'desc': 'Run in Circles',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   13: {'desc': 'Run in Circles',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   14: {'desc': 'Sneak Sideways',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   15: {'desc': 'Sneak Sideways',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   16: {'desc': 'Get Up From Ground',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   17: {'desc': 'Get Up From Ground',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   18: {'desc': 'Get Up From Ground Laying on Back',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   19: {'desc': 'Walk Wounded Leg',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   20: {'desc': 'Walk Wounded Leg',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   21: {'desc': 'Range Of Motion',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   22: {'desc': 'Walk Wounded Leg',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   23: {'desc': 'Walk Wounded Leg',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   24: {'desc': 'Walk Wounded Leg',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   25: {'desc': 'Giving Directions',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   26: {'desc': 'Looking Around',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   27: {'desc': 'Looking Around',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   28: {'desc': 'Walking',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   29: {'desc': 'Sneaking',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   30: {'desc': 'Walking',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   31: {'desc': 'Sneaking',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   32: {'desc': 'Sneaking',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   33: {'desc': 'Sneaking',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   34: {'desc': 'Sneaking',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120}}},
 140: {'desc': 'Getting Up From Ground',
       'motions': {1: {'desc': 'Get Up Face Down',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                   2: {'desc': 'Get Up Face Down',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                   3: {'desc': 'Get Up Laying on Side',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                   4: {'desc': 'Get Up Laying on Side',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                   5: {'desc': 'Motorcycle',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                   6: {'desc': 'Idle',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                   7: {'desc': 'Idle',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                   8: {'desc': 'Get Up From Ground Laying on Back',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                   9: {'desc': 'Get Up From Ground Laying on Back',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120}}},
 141: {'desc': 'General Subject Capture',
       'motions': {1: {'desc': 'Run',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                   2: {'desc': 'Run',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                   3: {'desc': 'Run',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                   4: {'desc': 'Jump Distances',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                   5: {'desc': 'Jump Sideways',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                   6: {'desc': 'Jump Twist',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                   7: {'desc': 'Walk Up and Over',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                   8: {'desc': 'Steop On Walk Down',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                   9: {'desc': 'Step Over',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                   10: {'desc': 'Toss and Catch',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   11: {'desc': 'Throw and Catch',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   12: {'desc': 'Dance, Twist',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   13: {'desc': 'Stretch and Yawn',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   14: {'desc': 'Punch and Kick',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   15: {'desc': 'Range of Motion',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   16: {'desc': 'Wave Hello',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   17: {'desc': 'Sit on Stool',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   18: {'desc': 'Peek a Boo',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   19: {'desc': 'Walk',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   20: {'desc': 'Waiting',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   21: {'desc': 'Shrug',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   22: {'desc': 'High Five',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   23: {'desc': 'Shake Hands',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   24: {'desc': 'Around the world High Five Low',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   25: {'desc': 'Walk',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   26: {'desc': 'Curtsey',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   27: {'desc': 'Mope',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   28: {'desc': 'Slap Hands, Throw it Back',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   29: {'desc': 'Random Walk',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   30: {'desc': 'Random Walk',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   31: {'desc': 'Walk Backwards',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   32: {'desc': 'Walk Sideways, Cross Legs',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   33: {'desc': 'Walk Sideways, Foot to Foot',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   34: {'desc': 'Run',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120}}},
 142: {'desc': 'Stylized Walks',
       'motions': {1: {'desc': 'Childish',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   2: {'desc': 'Clumsy',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   3: {'desc': 'Clumsy',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   4: {'desc': 'Cool',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   5: {'desc': 'Depressed',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   6: {'desc': 'Elated',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   7: {'desc': 'Elderlyman',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   8: {'desc': 'Happy',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   9: {'desc': 'Joy',
                       'files': ['c3d', 'amc', 'avi'],
                       'fps': 120},
                   10: {'desc': 'Lavish',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   11: {'desc': 'Marching',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   12: {'desc': 'Painfulleftknee',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   13: {'desc': 'Relaxed',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   14: {'desc': 'Rushed',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   15: {'desc': 'Sad',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   16: {'desc': 'Scared',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   17: {'desc': 'Scared',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   18: {'desc': 'Sexy',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   19: {'desc': 'Shy',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   20: {'desc': 'Singing in the rain jump',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   21: {'desc': 'Singing in the rain jump',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120},
                   22: {'desc': 'Sneaky',
                        'files': ['c3d', 'amc', 'avi'],
                        'fps': 120}}},
 143: {'desc': 'General Subject Capture',
       'motions': {1: {'desc': 'Run',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                   2: {'desc': 'Run to Stop',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                   3: {'desc': 'Start to Run',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                   4: {'desc': 'Run Figure 8',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                   5: {'desc': 'Jumping Distances',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                   6: {'desc': 'Jumping Heights',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                   7: {'desc': 'Jumping Sideways',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                   8: {'desc': 'Jumping Twists',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                   9: {'desc': 'Jumping Twists',
                       'files': ['tvd', 'c3d', 'amc', 'avi'],
                       'fps': 120},
                   10: {'desc': 'Walk And Pick up Tool Box',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   11: {'desc': 'Walk And Pick up Box',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   12: {'desc': 'Walk And Pick up Toolbox',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   13: {'desc': 'Walk and Pick up Laundry Basket',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   14: {'desc': 'Walk And Step Over',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   15: {'desc': 'Walk And Step Over',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   16: {'desc': 'Walk And Step Over',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   17: {'desc': 'Walk Up Stairs And Over',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   18: {'desc': 'Sit Down And Get Up',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   19: {'desc': 'Sit On Stool And Get Up',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   20: {'desc': 'Catch And Throw',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   21: {'desc': 'Range Of Motion',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   22: {'desc': 'Catch And Throw Football',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   23: {'desc': 'Punching',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   24: {'desc': 'Kicking',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   25: {'desc': 'Waving',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   26: {'desc': 'Washing Window',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   27: {'desc': 'Washing Window',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   28: {'desc': 'Sweeping, Push Broom',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   29: {'desc': 'Pacing',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   30: {'desc': 'Stretch And Yawn',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   31: {'desc': 'Hopscotch',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   32: {'desc': 'Walk',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   33: {'desc': 'Peek A Boo',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   34: {'desc': 'Chicken Dance',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   35: {'desc': 'Macarena Dance',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   36: {'desc': 'Airplane',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   37: {'desc': 'Climb Up And Down Ladder',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   38: {'desc': 'Walk Digital 8',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   39: {'desc': 'Walk Backwards',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   40: {'desc': 'Walk Sideways',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   41: {'desc': 'Sneak',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120},
                   42: {'desc': 'Run',
                        'files': ['tvd', 'c3d', 'amc', 'avi'],
                        'fps': 120}}},
 144: {'desc': 'punching female',
       'motions': {1: {'desc': 'Cartwheels',
                       'files': ['c3d', 'amc'],
                       'fps': 120},
                   2: {'desc': 'Cartwheels001',
                       'files': ['c3d', 'amc'],
                       'fps': 120},
                   3: {'desc': 'Figure8s',
                       'files': ['c3d', 'amc'],
                       'fps': 120},
                   4: {'desc': 'Figure8s001',
                       'files': ['c3d', 'amc'],
                       'fps': 120},
                   5: {'desc': 'Front_Kicking',
                       'files': ['c3d', 'amc'],
                       'fps': 120},
                   6: {'desc': 'Front_Kicking001',
                       'files': ['c3d', 'amc'],
                       'fps': 120},
                   7: {'desc': 'Left_Blocks',
                       'files': ['c3d', 'amc'],
                       'fps': 120},
                   8: {'desc': 'Left_Blocks001',
                       'files': ['c3d', 'amc'],
                       'fps': 120},
                   9: {'desc': 'Left_Front_Kicking',
                       'files': ['c3d', 'amc'],
                       'fps': 120},
                   10: {'desc': 'Left_Front_Kicking001',
                        'files': ['c3d', 'amc'],
                        'fps': 120},
                   11: {'desc': 'Left_Lunges',
                        'files': ['c3d', 'amc'],
                        'fps': 120},
                   12: {'desc': 'Left_Lunges001',
                        'files': ['c3d', 'amc'],
                        'fps': 120},
                   13: {'desc': 'Left_Punch_Sequence001',
                        'files': ['c3d', 'amc'],
                        'fps': 120},
                   14: {'desc': 'Left_Punch_Sequence002',
                        'files': ['c3d', 'amc'],
                        'fps': 120},
                   15: {'desc': 'Left_Spin_reach001',
                        'files': ['c3d', 'amc'],
                        'fps': 120},
                   16: {'desc': 'Left_Spin_reach002',
                        'files': ['c3d', 'amc'],
                        'fps': 120},
                   17: {'desc': 'Lunges',
                        'files': ['c3d', 'amc'],
                        'fps': 120},
                   18: {'desc': 'Lunges001',
                        'files': ['c3d', 'amc'],
                        'fps': 120},
                   19: {'desc': 'motorcycle pose',
                        'files': ['c3d', 'amc'],
                        'fps': 120},
                   20: {'desc': 'Punch_Sequence',
                        'files': ['c3d', 'amc'],
                        'fps': 120},
                   21: {'desc': 'Punch_Sequence001',
                        'files': ['c3d', 'amc'],
                        'fps': 120},
                   22: {'desc': 'Reach_Left001',
                        'files': ['c3d', 'amc'],
                        'fps': 120},
                   23: {'desc': 'Reach_Left002',
                        'files': ['c3d', 'amc'],
                        'fps': 120},
                   24: {'desc': 'Reach_Right',
                        'files': ['c3d', 'amc'],
                        'fps': 120},
                   25: {'desc': 'Reach_Right001',
                        'files': ['c3d', 'amc'],
                        'fps': 120},
                   26: {'desc': 'Right_Blocks',
                        'files': ['c3d', 'amc'],
                        'fps': 120},
                   27: {'desc': 'Right_Blocks001',
                        'files': ['c3d', 'amc'],
                        'fps': 120},
                   28: {'desc': 'Right_Spin_reach',
                        'files': ['c3d', 'amc'],
                        'fps': 120},
                   29: {'desc': 'Right_Spin_reach001',
                        'files': ['c3d', 'amc'],
                        'fps': 120},
                   30: {'desc': 'Sun Salutation',
                        'files': ['c3d', 'amc'],
                        'fps': 120},
                   31: {'desc': 'Sun Salutation001',
                        'files': ['c3d', 'amc'],
                        'fps': 120},
                   32: {'desc': 'Sun Salutation002',
                        'files': ['c3d', 'amc'],
                        'fps': 120},
                   33: {'desc': 'Walking',
                        'files': ['c3d', 'amc'],
                        'fps': 120},
                   34: {'desc': 'Walking001',
                        'files': ['c3d', 'amc'],
                        'fps': 120}}}}

# End of Mocap Library

if __name__ == '__main__':
    # The following is the code that compiled the data above.
    # If you execute this file it should output to stdout the exact same code.

    import re
    import os
    from pprint import pformat
    from urllib.request import urlopen

    subjects_re = re.compile(
        r"(?ms)909090.*?Subject\ \#(?P<subjno>\d+)\s+(?P<desc>[^<]*).*?"
        r"(?P<subjskel>http.*?asf).*?BGCOLOR(?P<motionBlock>.*?)/TR>\n")
    motions_re = re.compile(
        r"(?ms)<TD>(?P<motno>\d+)</TD><TD>(?P<desc>[^<].*?)"
        r"</TD>(?P<urls>.*?)<TD>(?P<fps>\d+)</TD>")
    urls_re = re.compile('(http.*?)(...)"')
    myself_re = re.compile(r"(?ms)(.*# Carnegie.*?\n).*?(# End of.*$)")

    subjects = {}
    if not os.path.exists("search.html"):
        src = urlopen(search_url)
        data = src.read()
        with open("search.html", 'wb') as out:
            out.write(data)
    for match in subjects_re.finditer(open("search.html", 'rt').read()):
        d = match.groupdict()
        sub = subjects.setdefault(int(d['subjno']), {})
        sub['desc'] = d['desc'][1:-2]
        assert(d['subjskel'] == skeleton_url.format(int(d['subjno'])))
        sub['motions'] = {}
        for m2 in motions_re.finditer(d['motionBlock']):
            d2 = m2.groupdict()
            mot = sub['motions'].setdefault(int(d2['motno']), {})
            mot['desc'] = d2['desc'].strip()
            mot['fps'] = int(d2['fps'])
            for u in urls_re.finditer(d2['urls']):
                murl = motion_url.format(int(d['subjno']), int(d2['motno']))
                assert(u.group(1) == murl)
                mot.setdefault('files', []).append(u.group(2))

    m = myself_re.match(open(__file__).read())
    print("{0}\nsubjects={1}\n\n{2}".format(
            m.group(1), pformat(subjects), m.group(2)), end='')
