/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.function;

import java.util.ArrayList;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.Iterator;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.wst.xml.xpath2.processor.DynamicContext;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import org.eclipse.wst.xml.xpath2.processor.internal.SeqType;
import org.eclipse.wst.xml.xpath2.processor.internal.function.Function;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDateTime;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDayTimeDuration;

public class FnAdjustDateTimeToTimeZone
extends Function {
    private static Collection _expected_args = null;
    private static final XSDayTimeDuration minDuration = new XSDayTimeDuration(0, 14, 0, 0.0, true);
    private static final XSDayTimeDuration maxDuration = new XSDayTimeDuration(0, 14, 0, 0.0, false);

    public FnAdjustDateTimeToTimeZone() {
        super(new QName("adjust-dateTime-to-timezone"), 1, 2);
    }

    @Override
    public ResultSequence evaluate(Collection args) throws DynamicError {
        return FnAdjustDateTimeToTimeZone.adjustdateTime(args, this.dynamic_context());
    }

    public static ResultSequence adjustdateTime(Collection args, DynamicContext dc) throws DynamicError {
        Collection cargs = Function.convert_arguments(args, FnAdjustDateTimeToTimeZone.expectedArgs());
        ResultSequence rs = ResultSequenceFactory.create_new();
        Iterator argiter = cargs.iterator();
        ResultSequence arg1 = (ResultSequence)argiter.next();
        if (arg1.empty()) {
            return rs;
        }
        ResultSequence arg2 = null;
        if (argiter.hasNext()) {
            arg2 = (ResultSequence)argiter.next();
        }
        XSDateTime dateTime = (XSDateTime)arg1.first();
        XSDayTimeDuration timezone = null;
        if (arg2 != null && arg2.empty()) {
            if (dateTime.timezoned()) {
                XSDateTime localized = new XSDateTime(dateTime.calendar(), null);
                rs.add(localized);
                return rs;
            }
            return arg1;
        }
        if (arg2 == null) {
            XSDateTime localized = new XSDateTime(dateTime.normalizeCalendar(dateTime.calendar(), dateTime.tz()), null);
            rs.add(localized);
            return rs;
        }
        timezone = (XSDayTimeDuration)arg2.first();
        if (timezone.lt(minDuration, dc) || timezone.gt(maxDuration, dc)) {
            throw DynamicError.invalidTimezone();
        }
        if (dateTime.tz() == null) {
            rs.add(new XSDateTime(dateTime.calendar(), timezone));
            return rs;
        }
        try {
            XMLGregorianCalendar xmlCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar((GregorianCalendar)dateTime.normalizeCalendar(dateTime.calendar(), dateTime.tz()));
            Duration duration = DatatypeFactory.newInstance().newDuration(timezone.string_value());
            xmlCalendar.add(duration);
            rs.add(new XSDateTime(xmlCalendar.toGregorianCalendar(), timezone));
        }
        catch (DatatypeConfigurationException e) {
            throw DynamicError.invalidTimezone();
        }
        return rs;
    }

    public static synchronized Collection expectedArgs() {
        if (_expected_args == null) {
            _expected_args = new ArrayList();
            _expected_args.add(new SeqType(new XSDateTime(), 3));
            _expected_args.add(new SeqType(new XSDayTimeDuration(), 3));
        }
        return _expected_args;
    }
}

