/**
 * @author Jorge Bay Gondra
 */
import * as t from './process/traversal.js';
import * as gt from './process/graph-traversal.js';
import * as strategiesModule from './process/traversal-strategy.js';
import * as graph from './structure/graph.js';
import * as gs from './structure/io/graph-serializer.js';
import * as rc from './driver/remote-connection.js';
import Bytecode from './process/bytecode.js';
import Translator from './process/translator.js';
import * as utils from './utils.js';
import DriverRemoteConnection from './driver/driver-remote-connection.js';
import ResponseError from './driver/response-error.js';
import Client from './driver/client.js';
import ResultSet from './driver/result-set.js';
import Authenticator from './driver/auth/authenticator.js';
import PlainTextSaslAuthenticator from './driver/auth/plain-text-sasl-authenticator.js';
import AnonymousTraversalSource from './process/anonymous-traversal.js';
export declare const driver: {
    RemoteConnection: typeof rc.RemoteConnection;
    RemoteStrategy: typeof rc.RemoteStrategy;
    RemoteTraversal: typeof rc.RemoteTraversal;
    ResponseError: typeof ResponseError;
    DriverRemoteConnection: typeof DriverRemoteConnection;
    Client: typeof Client;
    ResultSet: typeof ResultSet;
    auth: {
        Authenticator: typeof Authenticator;
        PlainTextSaslAuthenticator: typeof PlainTextSaslAuthenticator;
    };
};
export declare const process: {
    Bytecode: typeof Bytecode;
    EnumValue: typeof t.EnumValue;
    P: typeof t.P;
    TextP: typeof t.TextP;
    Traversal: typeof t.Traversal;
    TraversalSideEffects: typeof t.TraversalSideEffects;
    TraversalStrategies: typeof strategiesModule.TraversalStrategies;
    TraversalStrategy: typeof strategiesModule.TraversalStrategy;
    Traverser: typeof t.Traverser;
    barrier: Record<string, t.EnumValue>;
    cardinality: Record<string, t.EnumValue>;
    column: Record<string, t.EnumValue>;
    direction: Record<string, t.EnumValue>;
    dt: Record<string, t.EnumValue>;
    merge: Record<string, t.EnumValue>;
    operator: Record<string, t.EnumValue>;
    order: Record<string, t.EnumValue>;
    pick: Record<string, t.EnumValue>;
    pop: Record<string, t.EnumValue>;
    scope: Record<string, t.EnumValue>;
    t: Record<string, t.EnumValue>;
    GraphTraversal: typeof gt.GraphTraversal;
    GraphTraversalSource: typeof gt.GraphTraversalSource;
    statics: {
        E: (...args: any[]) => any;
        V: (...args: any[]) => any;
        addE: (...args: any[]) => any;
        addV: (...args: any[]) => any;
        aggregate: (...args: any[]) => any;
        all: (...args: any[]) => any;
        and: (...args: any[]) => any;
        any: (...args: any[]) => any;
        as: (...args: any[]) => any;
        asDate: (...args: any[]) => any;
        asString: (...args: any[]) => any;
        barrier: (...args: any[]) => any;
        both: (...args: any[]) => any;
        bothE: (...args: any[]) => any;
        bothV: (...args: any[]) => any;
        branch: (...args: any[]) => any;
        call: (...args: any[]) => any;
        cap: (...args: any[]) => any;
        choose: (...args: any[]) => any;
        coalesce: (...args: any[]) => any;
        coin: (...args: any[]) => any;
        concat: (...args: any[]) => any;
        constant: (...args: any[]) => any;
        count: (...args: any[]) => any;
        cyclicPath: (...args: any[]) => any;
        dateAdd: (...args: any[]) => any;
        dateDiff: (...args: any[]) => any;
        dedup: (...args: any[]) => any;
        drop: (...args: any[]) => any;
        element: (...args: any[]) => any;
        elementMap: (...args: any[]) => any;
        emit: (...args: any[]) => any;
        fail: (...args: any[]) => any;
        filter: (...args: any[]) => any;
        flatMap: (...args: any[]) => any;
        fold: (...args: any[]) => any;
        format: (...args: any[]) => any;
        group: (...args: any[]) => any;
        groupCount: (...args: any[]) => any;
        has: (...args: any[]) => any;
        hasId: (...args: any[]) => any;
        hasKey: (...args: any[]) => any;
        hasLabel: (...args: any[]) => any;
        hasNot: (...args: any[]) => any;
        hasValue: (...args: any[]) => any;
        id: (...args: any[]) => any;
        identity: (...args: any[]) => any;
        in_: (...args: any[]) => any;
        inE: (...args: any[]) => any;
        inV: (...args: any[]) => any;
        index: (...args: any[]) => any;
        inject: (...args: any[]) => any;
        is: (...args: any[]) => any;
        key: (...args: any[]) => any;
        label: (...args: any[]) => any;
        length: (...args: any[]) => any;
        limit: (...args: any[]) => any;
        local: (...args: any[]) => any;
        loops: (...args: any[]) => any;
        lTrim: (...args: any[]) => any;
        map: (...args: any[]) => any;
        match: (...args: any[]) => any;
        math: (...args: any[]) => any;
        max: (...args: any[]) => any;
        mean: (...args: any[]) => any;
        mergeE: (...args: any[]) => any;
        mergeV: (...args: any[]) => any;
        min: (...args: any[]) => any;
        not: (...args: any[]) => any;
        optional: (...args: any[]) => any;
        or: (...args: any[]) => any;
        order: (...args: any[]) => any;
        otherV: (...args: any[]) => any;
        out: (...args: any[]) => any;
        outE: (...args: any[]) => any;
        outV: (...args: any[]) => any;
        path: (...args: any[]) => any;
        project: (...args: any[]) => any;
        properties: (...args: any[]) => any;
        property: (...args: any[]) => any;
        propertyMap: (...args: any[]) => any;
        range: (...args: any[]) => any;
        repeat: (...args: any[]) => any;
        replace: (...args: any[]) => any;
        reverse: (...args: any[]) => any;
        rTrim: (...args: any[]) => any;
        sack: (...args: any[]) => any;
        sample: (...args: any[]) => any;
        select: (...args: any[]) => any;
        sideEffect: (...args: any[]) => any;
        simplePath: (...args: any[]) => any;
        skip: (...args: any[]) => any;
        split: (...args: any[]) => any;
        store: (...args: any[]) => any;
        subgraph: (...args: any[]) => any;
        substring: (...args: any[]) => any;
        sum: (...args: any[]) => any;
        tail: (...args: any[]) => any;
        timeLimit: (...args: any[]) => any;
        times: (...args: any[]) => any;
        to: (...args: any[]) => any;
        toE: (...args: any[]) => any;
        toLower: (...args: any[]) => any;
        toUpper: (...args: any[]) => any;
        toV: (...args: any[]) => any;
        tree: (...args: any[]) => any;
        trim: (...args: any[]) => any;
        unfold: (...args: any[]) => any;
        union: (...args: any[]) => any;
        until: (...args: any[]) => any;
        value: (...args: any[]) => any;
        valueMap: (...args: any[]) => any;
        values: (...args: any[]) => any;
        where: (...args: any[]) => any;
    };
    Translator: typeof Translator;
    traversal: typeof AnonymousTraversalSource.traversal;
    AnonymousTraversalSource: typeof AnonymousTraversalSource;
    withOptions: {
        tokens: string;
        none: number;
        ids: number;
        labels: number;
        keys: number;
        values: number;
        all: number;
        indexer: string;
        list: number;
        map: number;
    };
};
export declare const structure: {
    io: typeof gs;
    Edge: typeof graph.Edge;
    Graph: typeof graph.Graph;
    Path: typeof graph.Path;
    Property: typeof graph.Property;
    Vertex: typeof graph.Vertex;
    VertexProperty: typeof graph.VertexProperty;
    toLong: typeof utils.toLong;
};
