/// <reference types="node" resolution-mode="require"/>
/// <reference types="node" resolution-mode="require"/>
/**
 * @author Jorge Bay Gondra
 */
import { Buffer } from 'buffer';
import { EventEmitter } from 'eventemitter3';
import type { Agent } from 'node:http';
import Stream from 'readable-stream';
import Authenticator from './auth/authenticator.js';
declare const defaultMimeType = "application/vnd.gremlin-v3.0+json";
declare const graphSON2MimeType = "application/vnd.gremlin-v2.0+json";
declare const graphBinaryMimeType = "application/vnd.graphbinary-v1.0";
type MimeType = typeof defaultMimeType | typeof graphSON2MimeType | typeof graphBinaryMimeType;
export type ConnectionOptions = {
    ca?: string[];
    cert?: string | string[] | Buffer;
    mimeType?: MimeType;
    pfx?: string | Buffer;
    reader?: any;
    rejectUnauthorized?: boolean;
    traversalSource?: string;
    writer?: any;
    authenticator?: Authenticator;
    headers?: Record<string, string | string[]>;
    enableUserAgentOnConnect?: boolean;
    agent?: Agent;
};
/**
 * Represents a single connection to a Gremlin Server.
 */
export default class Connection extends EventEmitter {
    #private;
    readonly url: string;
    readonly options: ConnectionOptions;
    private _ws;
    readonly mimeType: MimeType;
    private readonly _responseHandlers;
    private readonly _reader;
    private readonly _writer;
    private _openPromise;
    private _openCallback;
    private _closePromise;
    private _closeCallback;
    private readonly _header;
    private readonly _header_buf;
    isOpen: boolean;
    traversalSource: string;
    private readonly _authenticator;
    private readonly _enableUserAgentOnConnect;
    /**
     * Creates a new instance of {@link Connection}.
     * @param {String} url The resource uri.
     * @param {Object} [options] The connection options.
     * @param {Array} [options.ca] Trusted certificates.
     * @param {String|Array|Buffer} [options.cert] The certificate key.
     * @param {String} [options.mimeType] The mime type to use.
     * @param {String|Buffer} [options.pfx] The private key, certificate, and CA certs.
     * @param {GraphSONReader} [options.reader] The reader to use.
     * @param {Boolean} [options.rejectUnauthorized] Determines whether to verify or not the server certificate.
     * @param {String} [options.traversalSource] The traversal source. Defaults to: 'g'.
     * @param {GraphSONWriter} [options.writer] The writer to use.
     * @param {Authenticator} [options.authenticator] The authentication handler to use.
     * @param {Object} [options.headers] An associative array containing the additional header key/values for the initial request.
     * @param {Boolean} [options.enableUserAgentOnConnect] Determines if a user agent will be sent during connection handshake. Defaults to: true
     * @param {http.Agent} [options.agent] The http.Agent implementation to use.
     * @constructor
     */
    constructor(url: string, options?: ConnectionOptions);
    /**
     * Opens the connection, if its not already opened.
     * @returns {Promise}
     */
    open(): Promise<void>;
    /** @override */
    submit(processor: string | undefined, op: string, args: any, requestId?: string | null): Promise<unknown>;
    /** @override */
    stream(processor: string, op: string, args: any, requestId?: string): Stream.Readable;
    /**
     * Closes the Connection.
     * @return {Promise}
     */
    close(): Promise<void>;
}
export {};
