/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.tinkerpop.gremlin.process.remote.traversal;

import org.apache.tinkerpop.gremlin.process.remote.EmbeddedRemoteConnection;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;

/**
 * Generated by the {@link EmbeddedRemoteConnection} to help simulate a remote traversal execution within the same JVM.
 *
 * @author Stephen Mallette (http://stephen.genoprime.com)
 */
public class EmbeddedRemoteTraversal<S,E> extends AbstractRemoteTraversal<S,E> {
    private final Traversal<S, E> t;

    public EmbeddedRemoteTraversal(final Traversal<S,E> t) {
        this.t = t;
    }

    @Override
    public Traverser.Admin<E> nextTraverser() {
        return t.asAdmin().nextTraverser();
    }

    @Override
    public boolean hasNext() {
        return t.hasNext();
    }

    @Override
    public E next() {
        return t.next();
    }
}
