/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Merge;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.process.traversal.lambda.ConstantTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.MergeStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.event.Event;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.EventStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalUtil;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.Attachable;
import org.apache.tinkerpop.gremlin.structure.util.CloseableIterator;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public class MergeEdgeStep<S>
extends MergeStep<S, Edge, Object> {
    private static final Set allowedTokens = new LinkedHashSet<Enum>(Arrays.asList(new Enum[]{T.id, T.label, Direction.IN, Direction.OUT}));
    private Traversal.Admin<S, Object> outVTraversal = null;
    private Traversal.Admin<S, Object> inVTraversal = null;

    public static void validateMapInput(Map map, boolean ignoreTokens) {
        MergeStep.validate(map, ignoreTokens, allowedTokens, "mergeE");
    }

    public MergeEdgeStep(Traversal.Admin traversal, boolean isStart) {
        super(traversal, isStart);
    }

    public MergeEdgeStep(Traversal.Admin traversal, boolean isStart, Map merge) {
        super(traversal, isStart, merge);
    }

    public MergeEdgeStep(Traversal.Admin traversal, boolean isStart, Traversal.Admin<S, Map> mergeTraversal) {
        super(traversal, isStart, mergeTraversal);
    }

    public Traversal.Admin<S, Object> getOutVTraversal() {
        return this.outVTraversal;
    }

    public Traversal.Admin<S, Object> getInVTraversal() {
        return this.inVTraversal;
    }

    @Override
    public void addChildOption(Merge token, Traversal.Admin<S, Object> traversalOption) {
        if (token == Merge.outV) {
            this.outVTraversal = this.integrateChild(traversalOption);
        } else if (token == Merge.inV) {
            this.inVTraversal = this.integrateChild(traversalOption);
        } else {
            super.addChildOption(token, traversalOption);
        }
    }

    @Override
    public <S, C> List<Traversal.Admin<S, C>> getLocalChildren() {
        List children = super.getLocalChildren();
        if (this.outVTraversal != null) {
            children.add(this.outVTraversal);
        }
        if (this.inVTraversal != null) {
            children.add(this.inVTraversal);
        }
        return children;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        if (this.outVTraversal != null) {
            result ^= this.outVTraversal.hashCode();
        }
        if (this.inVTraversal != null) {
            result ^= this.inVTraversal.hashCode();
        }
        return result;
    }

    @Override
    public void reset() {
        super.reset();
        if (this.outVTraversal != null) {
            this.outVTraversal.reset();
        }
        if (this.inVTraversal != null) {
            this.inVTraversal.reset();
        }
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, this.mergeTraversal, this.onCreateTraversal, this.onMatchTraversal, this.outVTraversal, this.inVTraversal);
    }

    @Override
    public void setTraversal(Traversal.Admin<?, ?> parentTraversal) {
        super.setTraversal(parentTraversal);
        this.integrateChild(this.outVTraversal);
        this.integrateChild(this.inVTraversal);
    }

    @Override
    public MergeEdgeStep<S> clone() {
        MergeEdgeStep clone = (MergeEdgeStep)super.clone();
        clone.outVTraversal = this.outVTraversal != null ? this.outVTraversal.clone() : null;
        clone.inVTraversal = this.inVTraversal != null ? this.inVTraversal.clone() : null;
        return clone;
    }

    @Override
    protected Set getAllowedTokens() {
        return allowedTokens;
    }

    protected CloseableIterator<Edge> searchEdges(Map search) {
        GraphTraversal<Element, Element> t;
        if (search == null) {
            return CloseableIterator.empty();
        }
        Graph graph = this.getGraph();
        Object edgeId = search.get(T.id);
        String edgeLabel = (String)search.get(T.label);
        Object fromId = search.get((Object)Direction.OUT);
        Object toId = search.get((Object)Direction.IN);
        if (edgeId != null) {
            t = graph.traversal().E(edgeId);
            if (edgeLabel != null) {
                t = t.hasLabel(edgeLabel, new String[0]);
            }
            if (fromId != null) {
                t = t.where(__.outV().hasId(fromId, new Object[0]));
            }
            if (toId != null) {
                t = t.where(__.inV().hasId(toId, new Object[0]));
            }
        } else if (fromId != null) {
            t = graph.traversal().V(fromId);
            t = edgeLabel != null ? t.outE(edgeLabel) : t.outE(new String[0]);
            if (toId != null) {
                t = t.where(__.inV().hasId(toId, new Object[0]));
            }
        } else if (toId != null) {
            t = graph.traversal().V(toId);
            t = edgeLabel != null ? t.inE(edgeLabel) : t.inE(new String[0]);
        } else {
            t = graph.traversal().E(new Object[0]);
            if (edgeLabel != null) {
                t = t.hasLabel(edgeLabel, new String[0]);
            }
        }
        for (Map.Entry e : search.entrySet()) {
            Object k = e.getKey();
            if (!(k instanceof String)) continue;
            t = t.has((String)k, e.getValue());
        }
        return CloseableIterator.of(t);
    }

    protected Map<?, ?> resolveVertices(Map map, Traverser.Admin<S> traverser) {
        this.resolveVertex(Merge.outV, Direction.OUT, map, traverser, this.outVTraversal);
        this.resolveVertex(Merge.inV, Direction.IN, map, traverser, this.inVTraversal);
        return map;
    }

    protected void resolveVertex(Merge token, Direction direction, Map map, Traverser.Admin<S> traverser, Traversal.Admin<S, Object> traversal) {
        if (!map.containsKey((Object)direction)) {
            return;
        }
        Object value = map.get((Object)direction);
        if (Objects.equals((Object)token, value)) {
            if (traversal == null) {
                throw new IllegalArgumentException(String.format("option(%s) must be specified if it is used for %s", new Object[]{token, direction}));
            }
            Vertex vertex = this.resolveVertex(traverser, traversal);
            if (vertex == null) {
                throw new IllegalArgumentException(String.format("Could not resolve vertex for option(%s)", new Object[]{token}));
            }
            map.put(direction, vertex.id());
        } else if (value instanceof Vertex) {
            map.put(direction, ((Vertex)value).id());
        }
    }

    @Override
    protected Iterator<Edge> flatMap(Traverser.Admin<S> traverser) {
        Map unresolvedMergeMap = this.materializeMap(traverser, this.mergeTraversal);
        MergeEdgeStep.validateMapInput(unresolvedMergeMap, false);
        Map<?, ?> mergeMap = this.resolveVertices(new LinkedHashMap(unresolvedMergeMap), traverser);
        Iterator<Edge> edges = this.searchEdges(mergeMap);
        if (this.onMatchTraversal != null) {
            if (this.onMatchTraversal instanceof ConstantTraversal) {
                Map matchMap = (Map)this.onMatchTraversal.next();
                MergeEdgeStep.validateMapInput(matchMap, true);
            }
            edges = IteratorUtils.peek(edges, e -> {
                if (this.isStart) {
                    traverser.set(e);
                }
                Map onMatchMap = this.materializeMap(traverser, this.onMatchTraversal);
                MergeEdgeStep.validateMapInput(onMatchMap, true);
                onMatchMap.forEach((key, value) -> {
                    if (this.callbackRegistry != null && !this.callbackRegistry.getCallbacks().isEmpty()) {
                        EventStrategy eventStrategy = this.getTraversal().getStrategies().getStrategy(EventStrategy.class).get();
                        Property p = e.property((String)key);
                        Property oldValue = p.isPresent() ? eventStrategy.detach(e.property((String)key)) : null;
                        Event.EdgePropertyChangedEvent vpce = new Event.EdgePropertyChangedEvent(eventStrategy.detach(e), oldValue, value);
                        this.callbackRegistry.getCallbacks().forEach(c -> c.accept(vpce));
                    }
                    e.property((String)key, value);
                });
            });
        }
        if (edges.hasNext()) {
            return edges;
        }
        CloseableIterator.closeIterator(edges);
        Map onCreateMap = this.onCreateMap(traverser, unresolvedMergeMap, mergeMap);
        if (!onCreateMap.containsKey((Object)Direction.OUT)) {
            throw new IllegalArgumentException("Out Vertex not specified in onCreate - edge cannot be created");
        }
        if (!onCreateMap.containsKey((Object)Direction.IN)) {
            throw new IllegalArgumentException("In Vertex not specified in onCreate - edge cannot be created");
        }
        Vertex fromV = this.resolveVertex(onCreateMap.get((Object)Direction.OUT));
        Vertex toV = this.resolveVertex(onCreateMap.get((Object)Direction.IN));
        String label = onCreateMap.getOrDefault(T.label, "edge");
        ArrayList<Object> properties = new ArrayList<Object>();
        for (Map.Entry e2 : onCreateMap.entrySet()) {
            Object k = e2.getKey();
            if (k.equals((Object)Direction.OUT) || k.equals((Object)Direction.IN) || k.equals(T.label)) continue;
            properties.add(k);
            properties.add(e2.getValue());
        }
        Edge edge = fromV.addEdge(label, toV, properties.toArray());
        if (this.callbackRegistry != null && !this.callbackRegistry.getCallbacks().isEmpty()) {
            EventStrategy eventStrategy = this.getTraversal().getStrategies().getStrategy(EventStrategy.class).get();
            Event.EdgeAddedEvent vae = new Event.EdgeAddedEvent(eventStrategy.detach(edge));
            this.callbackRegistry.getCallbacks().forEach(c -> c.accept(vae));
        }
        return IteratorUtils.of(edge);
    }

    protected Map onCreateMap(Traverser.Admin<S> traverser, Map unresolvedMergeMap, Map mergeMap) {
        if (this.onCreateTraversal == null) {
            return mergeMap;
        }
        Map onCreateMap = this.materializeMap(traverser, this.onCreateTraversal);
        if (onCreateMap == null || onCreateMap.size() == 0) {
            return mergeMap;
        }
        MergeEdgeStep.validateMapInput(onCreateMap, false);
        this.validateNoOverrides(unresolvedMergeMap, onCreateMap);
        HashMap combinedMap = new HashMap(onCreateMap.size() + mergeMap.size());
        combinedMap.putAll(onCreateMap);
        combinedMap.putAll(mergeMap);
        this.resolveVertices(combinedMap, traverser);
        return combinedMap;
    }

    protected Vertex resolveVertex(Traverser.Admin<S> traverser, Traversal.Admin<S, Object> traversal) {
        Object o = TraversalUtil.apply(traverser, traversal);
        if (o instanceof Vertex) {
            return (Vertex)o;
        }
        if (o instanceof Map) {
            Map search = (Map)o;
            Vertex v = IteratorUtils.findFirst(this.searchVertices(search)).get();
            return this.tryAttachVertex(v);
        }
        throw new IllegalArgumentException(String.format("Vertex could not be resolved from mergeE: %s", o));
    }

    protected Vertex resolveVertex(Object arg) {
        if (arg instanceof Vertex) {
            return this.tryAttachVertex((Vertex)arg);
        }
        try (CloseableIterator<Vertex> it = CloseableIterator.of(this.getGraph().vertices(arg));){
            if (!it.hasNext()) {
                throw new IllegalArgumentException(String.format("Vertex id could not be resolved from mergeE: %s", arg));
            }
            Vertex vertex = (Vertex)it.next();
            return vertex;
        }
    }

    protected Vertex tryAttachVertex(Vertex v) {
        if (v instanceof Attachable) {
            try {
                return (Vertex)((Attachable)((Object)v)).attach(Attachable.Method.get(this.getGraph()));
            }
            catch (IllegalStateException ise) {
                throw new IllegalArgumentException(String.format("Vertex could not be resolved from mergeE: %s", v));
            }
        }
        return v;
    }
}

