---
layout: global
title: SystemML Algorithms Reference
description: SystemML Algorithms Reference
displayTitle: SystemML Algorithms Reference
---
<!--
{% comment %}
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to you under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
{% endcomment %}
-->

* [Descriptive Statistics](algorithms-descriptive-statistics.html)
  * [Univariate Statistics](algorithms-descriptive-statistics.html#univariate-statistics)
  * [Bivariate Statistics](algorithms-descriptive-statistics.html#bivariate-statistics)
  * [Stratified Bivariate Statistics](algorithms-descriptive-statistics.html#stratified-bivariate-statistics)
  
* [Classification](algorithms-classification.html)
  * [Multinomial Logistic Regression](algorithms-classification.html#multinomial-logistic-regression)
  * [Support Vector Machines](algorithms-classification.html#support-vector-machines)
    * [Binary-Class Support Vector Machines](algorithms-classification.html#binary-class-support-vector-machines)
    * [Multi-Class Support Vector Machines](algorithms-classification.html#multi-class-support-vector-machines)
  * [Naive Bayes](algorithms-classification.html#naive-bayes)
  * [Decision Trees](algorithms-classification.html#decision-trees)
  * [Random Forests](algorithms-classification.html#random-forests)
  
* [Clustering](algorithms-clustering.html)
  * [K-Means Clustering](algorithms-clustering.html#k-means-clustering)

* [Regression](algorithms-regression.html)
  * [Linear Regression](algorithms-regression.html#linear-regression)
  * [Stepwise Linear Regression](algorithms-regression.html#stepwise-linear-regression)
  * [Generalized Linear Models](algorithms-regression.html#generalized-linear-models)
  * [Stepwise Generalized Linear Regression](algorithms-regression.html#stepwise-generalized-linear-regression)
  * [Regression Scoring and Prediction](algorithms-regression.html#regression-scoring-and-prediction)
  
* [Matrix Factorization](algorithms-matrix-factorization.html)
  * [Principal Component Analysis](algorithms-matrix-factorization.html#principal-component-analysis)
  * [Matrix Completion via Alternating Minimizations](algorithms-matrix-factorization.html#matrix-completion-via-alternating-minimizations)

* [Survival Analysis](algorithms-survival-analysis.html)
  * [Kaplan-Meier Survival Analysis](algorithms-survival-analysis.html#kaplan-meier-survival-analysis)
  * [Cox Proportional Hazard Regression Model](algorithms-survival-analysis.html#cox-proportional-hazard-regression-model)

* [Bibliography](algorithms-bibliography.html)

