/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.lops;

import org.apache.sysml.lops.Aggregate;
import org.apache.sysml.lops.Binary;
import org.apache.sysml.lops.Lop;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.lops.PartialAggregate;
import org.apache.sysml.lops.compile.JobType;
import org.apache.sysml.parser.Expression;

public class BinaryUAggChain
extends Lop {
    public static final String OPCODE = "binuaggchain";
    private Binary.OperationTypes _binOp = null;
    private Aggregate.OperationTypes _uaggOp = null;
    private PartialAggregate.DirectionTypes _uaggDir = null;

    public BinaryUAggChain(Lop input1, Binary.OperationTypes bop, Aggregate.OperationTypes uaop, PartialAggregate.DirectionTypes uadir, Expression.DataType dt, Expression.ValueType vt, LopProperties.ExecType et) {
        super(Lop.Type.BinUaggChain, dt, vt);
        this.addInput(input1);
        input1.addOutput(this);
        this._binOp = bop;
        this._uaggOp = uaop;
        this._uaggDir = uadir;
        if (et == LopProperties.ExecType.MR) {
            boolean breaksAlignment = false;
            boolean aligner = false;
            boolean definesMRJob = false;
            this.lps.addCompatibility(JobType.GMR);
            this.lps.addCompatibility(JobType.DATAGEN);
            this.lps.addCompatibility(JobType.REBLOCK);
            this.lps.addCompatibility(JobType.CSV_REBLOCK);
            this.lps.addCompatibility(JobType.MMCJ);
            this.lps.addCompatibility(JobType.MMRJ);
            this.lps.setProperties(this.inputs, LopProperties.ExecType.MR, LopProperties.ExecLocation.MapOrReduce, breaksAlignment, aligner, definesMRJob);
        } else {
            boolean breaksAlignment = false;
            boolean aligner = false;
            boolean definesMRJob = false;
            this.lps.addCompatibility(JobType.INVALID);
            this.lps.setProperties(this.inputs, et, LopProperties.ExecLocation.ControlProgram, breaksAlignment, aligner, definesMRJob);
        }
    }

    @Override
    public String toString() {
        return "Operation = BinUaggChain";
    }

    @Override
    public String getInstructions(int input_index1, int output_index) {
        return this.getInstructions(String.valueOf(input_index1), String.valueOf(output_index));
    }

    @Override
    public String getInstructions(String input1, String output) {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append(OPCODE);
        sb.append("\u00b0");
        sb.append(Binary.getOpcode(this._binOp));
        sb.append("\u00b0");
        sb.append(PartialAggregate.getOpcode(this._uaggOp, this._uaggDir));
        sb.append("\u00b0");
        sb.append(this.getInputs().get(0).prepInputOperand(input1));
        sb.append("\u00b0");
        sb.append(this.prepOutputOperand(output));
        return sb.toString();
    }
}

