/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.junit.rules;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.sling.testing.clients.SlingClient;
import org.apache.sling.testing.clients.SlingHttpResponse;
import org.apache.sling.testing.clients.interceptors.TestDescriptionHolder;
import org.apache.sling.testing.clients.util.URLParameterBuilder;
import org.apache.sling.testing.junit.rules.instance.Instance;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteLogDumperRule
extends TestWatcher {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteLogDumperRule.class);
    static final String SERVLET_PATH = "/system/sling/testlog";
    private SlingClient slingClient = null;
    private Instance instance = null;

    public RemoteLogDumperRule() {
    }

    public RemoteLogDumperRule(Instance instance) {
        this.instance = instance;
    }

    public RemoteLogDumperRule(SlingClient slingClient) {
        this.slingClient = slingClient;
    }

    public RemoteLogDumperRule setSlingClient(SlingClient slingClient) {
        this.slingClient = slingClient;
        return this;
    }

    public RemoteLogDumperRule setInstance(Instance instance) {
        this.instance = instance;
        return this;
    }

    public Statement apply(Statement base, Description description) {
        return super.apply(base, description);
    }

    protected void finished(Description description) {
        TestDescriptionHolder.removeClassName();
        TestDescriptionHolder.removeMethodName();
    }

    protected void starting(Description description) {
        if (null == this.slingClient && null != this.instance) {
            this.slingClient = this.instance.getAdminClient();
        }
        TestDescriptionHolder.setClassName((String)description.getClassName());
        TestDescriptionHolder.setMethodName((String)description.getMethodName());
    }

    protected void failed(Throwable e, Description description) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        if (this.slingClient != null) {
            try {
                SlingHttpResponse response = this.slingClient.doGet(SERVLET_PATH, URLParameterBuilder.create().add("X-Sling-TestClass", description.getClassName()).add("X-Sling-TestName", description.getMethodName()).getList(), new int[]{200});
                String msg = response.getSlingMessage();
                if (msg != null) {
                    pw.println(msg);
                }
                LOG.info("=============== Logs from server {} for {}===================\n{}", new Object[]{this.slingClient.getUrl(), description.getMethodName(), response.getContent()});
                LOG.info("========================================================");
            }
            catch (Throwable t) {
                LOG.debug("Error occurred while fetching test logs from server [{}]: {}", (Object)this.slingClient.getUrl(), (Object)t);
            }
        } else {
            LOG.debug("No SlingClient configured with the rule");
        }
    }
}

