/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.models.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.script.Bindings;
import javax.servlet.ServletRequest;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.commons.classloader.DynamicClassLoaderManager;
import org.apache.sling.models.factory.ModelFactory;
import org.apache.sling.scripting.sightly.render.RenderContext;
import org.apache.sling.scripting.sightly.use.ProviderOutcome;
import org.apache.sling.scripting.sightly.use.UseProvider;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={UseProvider.class}, configurationPid={"org.apache.sling.scripting.sightly.models.impl.SlingModelsUseProvider"}, property={"service.ranking:Integer=95"})
public class SlingModelsUseProvider
implements UseProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(SlingModelsUseProvider.class);
    private static final Pattern JAVA_PATTERN = Pattern.compile("([[\\p{L}&&[^\\p{Lu}]]_$][\\p{L}\\p{N}_$]*\\.)*[\\p{Lu}_$][\\p{L}\\p{N}_$]*");
    @Reference
    private ModelFactory modelFactory = null;
    @Reference
    private DynamicClassLoaderManager dynamicClassLoaderManager = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProviderOutcome provide(String identifier, RenderContext renderContext, Bindings arguments) {
        Class<?> cls;
        if (!JAVA_PATTERN.matcher(identifier).matches()) {
            LOGGER.debug("Identifier {} does not match a Java class name pattern.", (Object)identifier);
            return ProviderOutcome.failure();
        }
        try {
            cls = this.dynamicClassLoaderManager.getDynamicClassLoader().loadClass(identifier);
        }
        catch (ClassNotFoundException e) {
            LOGGER.debug("Could not find class with the given name {}.", (Object)identifier);
            return ProviderOutcome.failure();
        }
        if (!this.modelFactory.isModelClass(cls)) {
            LOGGER.debug("{} is not a Sling Model.");
            return ProviderOutcome.failure();
        }
        Bindings globalBindings = renderContext.getBindings();
        SlingHttpServletRequest request = (SlingHttpServletRequest)globalBindings.get("request");
        if (request == null) {
            return ProviderOutcome.failure((Throwable)new IllegalStateException("Could not get request from bindings."));
        }
        Map<String, Object> overrides = this.setRequestAttributes((ServletRequest)request, arguments);
        try {
            if (this.modelFactory.canCreateFromAdaptable((Object)request, cls)) {
                LOGGER.debug("Trying to instantiate class {} as Sling Model from request.", cls);
                ProviderOutcome providerOutcome = ProviderOutcome.notNullOrFailure((Object)this.modelFactory.createModel((Object)request, cls));
                return providerOutcome;
            }
            Resource resource = (Resource)globalBindings.get("resource");
            if (resource == null) {
                LOGGER.debug("Could not get resource from bindings.");
                ProviderOutcome providerOutcome = ProviderOutcome.failure((Throwable)new IllegalStateException("Could not get resource from bindings."));
                return providerOutcome;
            }
            if (this.modelFactory.canCreateFromAdaptable((Object)resource, cls)) {
                LOGGER.debug("Trying to instantiate class {} as Sling Model from resource.", cls);
                ProviderOutcome providerOutcome = ProviderOutcome.notNullOrFailure((Object)this.modelFactory.createModel((Object)resource, cls));
                return providerOutcome;
            }
            ProviderOutcome providerOutcome = ProviderOutcome.failure((Throwable)new IllegalStateException("Could not adapt the given Sling Model from neither request nor resource: " + cls));
            return providerOutcome;
        }
        catch (Throwable e) {
            ProviderOutcome providerOutcome = ProviderOutcome.failure((Throwable)e);
            return providerOutcome;
        }
        finally {
            this.resetRequestAttribute((ServletRequest)request, overrides);
        }
    }

    private Map<String, Object> setRequestAttributes(ServletRequest request, Bindings arguments) {
        HashMap<String, Object> overrides = new HashMap<String, Object>();
        for (Map.Entry entry : arguments.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            Object oldValue = request.getAttribute(key);
            if (oldValue != null) {
                overrides.put(key, oldValue);
            } else {
                overrides.put(key, null);
            }
            request.setAttribute(key, value);
        }
        return overrides;
    }

    private void resetRequestAttribute(ServletRequest request, Map<String, Object> overrides) {
        for (Map.Entry<String, Object> entry : overrides.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value == null) {
                request.removeAttribute(key);
                continue;
            }
            request.setAttribute(key, value);
        }
    }

    static @interface Configuration {
        @AttributeDefinition(name="Service Ranking", description="The Service Ranking value acts as the priority with which this Use Provider is queried to return an Use-object. A higher value represents a higher priority.")
        public int service_ranking() default 95;
    }
}

