/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.query.impl.selector.parser;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.sling.query.impl.selector.parser.Attribute;
import org.apache.sling.query.impl.selector.parser.Modifier;
import org.apache.sling.query.impl.selector.parser.ParserContext;

public class SelectorSegment {
    private final String type;
    private final String name;
    private final List<Attribute> attributes;
    private final List<Modifier> modifiers;
    private final char hierarchyOperator;

    public SelectorSegment(ParserContext context, boolean firstSegment) {
        this.type = context.getType();
        this.name = context.getName();
        this.attributes = new ArrayList<Attribute>(context.getAttributes());
        this.modifiers = new ArrayList<Modifier>(context.getModifiers());
        this.hierarchyOperator = firstSegment ? (char)'\u0000' : context.getHierarchyOperator();
    }

    SelectorSegment(String type, String name, List<Attribute> attributes, List<Modifier> modifiers, char hierarchyOperator) {
        this.type = type;
        this.name = name;
        this.attributes = attributes;
        this.modifiers = modifiers;
        this.hierarchyOperator = hierarchyOperator;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    public char getHierarchyOperator() {
        return this.hierarchyOperator;
    }

    public List<Modifier> getModifiers() {
        return this.modifiers;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        SelectorSegment rhs = (SelectorSegment)obj;
        return new EqualsBuilder().append((Object)this.type, (Object)rhs.type).append(this.attributes, rhs.attributes).append(this.modifiers, rhs.modifiers).append(this.hierarchyOperator, rhs.hierarchyOperator).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.type).append(this.attributes).append(this.modifiers).append(this.hierarchyOperator).toHashCode();
    }

    public String toString() {
        return String.format("SelectorSegment[%s,%s,%s,%s]", this.type, this.attributes, this.modifiers, Character.valueOf(this.hierarchyOperator));
    }
}

